<?php
// INITIALIZE DIVI MODULES

class pcpp_divi_modules {

    // DEEFINE MODULES
    // module slug => php files slug
    private $modules = array(
        'pcpp_change_plan'          => 'change_plan',
        'pcpp_user_plan'            => 'user_plan',
        'pcpp_subscr_expir'         => 'subscr_expir',
        'pcpp_user_orders_history'  => 'user_orders_history',
        'pcpp_plan_chooser'         => 'plan_chooser',
    );
    
    
    
    /* 
     * static method to render elements from both builder and frontend 
     *
     * @param (string) $module_slug
     * @param (array) $vals = values passed by the builder
     */
    public static function front_shortcode_render($module_slug, $vals) {
        switch($module_slug) {
           
            case 'pcpp_change_plan' :
                $shortcode = '[pcpp-change-plan '. self::vals_to_sc_params($module_slug, $vals) .']';
                break;
                
                
            case 'pcpp_user_plan' :
                $shortcode = '[pcpp-user-plan '. self::vals_to_sc_params($module_slug, $vals) .']';
                break;
                
                
            case 'pcpp_subscr_expir' :
                $shortcode = '[pcpp-subscr-expir '. self::vals_to_sc_params($module_slug, $vals) .']';
                break;
                
                
            case 'pcpp_user_orders_history' :
                $shortcode = '[pcpp-user-orders-history '. self::vals_to_sc_params($module_slug, $vals) .']';
                break;    
            
                
            case 'pcpp_plan_chooser' :
                $shortcode = '[pcpp-plan-chooser '. self::vals_to_sc_params($module_slug, $vals) .']';
                break;    
                
                
            default :
                return $module_slug .' module not found';  
        }    
        
        //echo $shortcode;
        return do_shortcode($shortcode);
    }
    
    
    
    /* insert here custom actions upon initialization (eg. to create global variable containing galleries array) */
    private function custom_actions() {
        //$GLOBALS['pc_divi_icon_path'] = PC_DIR .'/builders_integration/divi_modules/icon.svg';

    }
    
    
    
    

    ####################################################################################################
    ## Common methods
    
    
    function __construct() {
        // initialize modules
        add_action('divi_extensions_init', array($this, 'init_modules'));
        
        // ajax handlers
        foreach($this->modules as $key => $name) {
            add_action('wp_ajax_'. $key .'_for_divi', array($this, 'ajax_handler'));
        }
    }
    
    
    /* include divi integration files */
    public function init_modules() {   
        $this->custom_actions();
        
        foreach($this->modules as $module) {
            include_once(__DIR__ .'/divi_modules/'. $module .'/includes/register.php');
        }  
    } 
    
    
    
    public function ajax_handler() {
        if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
            wp_die('Cheating?');
        };
        
        if(!isset($_POST['module'])) {
            die('module not found');    
        }
        
        $params = (isset($_POST['params'])) ? $_POST['params'] : array();
        
        echo self::front_shortcode_render($_POST['module'], $params);
        die();
    }
    
    
    
    /* 
     * Static method compiling shortcode attributes from values array. Also strips out useless Divi values 
     * @param (array) $exception_indexes = array of extra indexes to save (eg. width and height) 
     */
    private static function vals_to_sc_params($module_slug, $vals, $exception_indexes = array()) {
       
        // strip useless parameters
        if(isset($GLOBALS[$module_slug .'_divi_field_indexes'])) {
            foreach($vals as $key => $val) {
                if(!in_array($key, $GLOBALS[$module_slug .'_divi_field_indexes']) && !in_array($key, (array)$exception_indexes)) {
                    unset($vals[$key]);    
                }
            }
        }
        
        // atts string creator
        $params = '';
        foreach($vals as $key => $val) {
            if($val === 'on' || $val === __('Yes')) {
                $val = 1;
            }
            elseif($val === 'off' || $val === __('No')) {
                $val = 0;
            }
            elseif($val === 'unset') {
                $val = '';
            }

            $params .= $key.'="'. esc_attr((string)$val) .'" ';
        }    
        
        return $params;
    }
}
new pcpp_divi_modules();


