<?php
// DEFINING MODULE STRUCTURE AND FIELDS


class pcpp_plan_chooser_divi_module extends ET_Builder_Module {

	public $slug       = 'pcpp_plan_chooser';
	public $vb_support = 'on';
    public $ml_key     = PCPP_ML;
    
    
	protected $module_credits = array(
        'module_uri' => 'https://lcweb.it/privatecontent/premium-plans-add-on',
        'author'     => 'LCweb',
        'author_uri' => 'https://lcweb.it/',
	);

    
    public function get_advanced_fields_config() {
        return unserialize(LC_DIVI_DEF_OPTS_OVERRIDE);
	}

    
	public function init() {
		$this->name               = 'PCPP - '. esc_html__("Plans Chooser Box", $this->ml_key);
		$this->icon_path          =  $GLOBALS['pc_divi_icon_path'];
		$this->main_css_element   = '%%order_class%%';	
        
        $this->settings_modal_toggles  = array(
			'general'  => array(
				'toggles' => array(
					'main'     => esc_html__('Main Options', $this->ml_key),
                    'styling'  => esc_html__('Styling', $this->ml_key),
				),
			),
		);
	}
 
    
	public function get_fields() {
        global $pcpp_subscr;
        $plans = array('' => __('none', $this->ml_key)) + $pcpp_subscr->get_plans();
        
        $fields = array(
            'form_id' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Focused plan', $this->ml_key),
				'type'            => 'select',
				'default'         => current(array_keys($plans)),
				'default_on_front'=> current(array_keys($plans)),					
				'options'         => $plans
			),
        );
        
        
        $GLOBALS[ $this->slug .'_divi_field_indexes'] = array_keys($fields);
        return $fields;
	}


    
    public function render($attrs, $content = null, $render_slug = null) {
        return pcpp_divi_modules::front_shortcode_render($this->slug, $this->props);  
	}
}

new pcpp_plan_chooser_divi_module;
