<?php
// DEFINING MODULE STRUCTURE AND FIELDS


class pcpp_user_orders_history_divi_module extends ET_Builder_Module {

	public $slug       = 'pcpp_user_orders_history';
	public $vb_support = 'off';
    public $ml_key     = PCPP_ML;
    
    
	protected $module_credits = array(
        'module_uri' => 'https://lcweb.it/privatecontent/premium-plans-add-on',
        'author'     => 'LCweb',
        'author_uri' => 'https://lcweb.it/',
	);

    
    public function get_advanced_fields_config() {
        return unserialize(LC_DIVI_DEF_OPTS_OVERRIDE);
	}

    
	public function init() {
		$this->name               = 'PCPP - '. esc_html__("User subscription orders history", $this->ml_key);
		$this->icon_path          =  $GLOBALS['pc_divi_icon_path'];
		$this->main_css_element   = '%%order_class%%';	
        
        $this->settings_modal_toggles  = array(
			'general'  => array(
				'toggles' => array(
					'main'     => esc_html__('Main Options', $this->ml_key),
                    'styling'  => esc_html__('Styling', $this->ml_key),
				),
			),
		);
	}
 
    
	public function get_fields() {
        
        $fields = array(
            'date_format' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Custom date format', $this->ml_key),
				'type'            => 'text',
                'default'         => '',
				'default_on_front'=> '',
                'description'     => esc_html__('Use PHP date() format', $this->ml_key),
			),
        );
        
        
        $GLOBALS[ $this->slug .'_divi_field_indexes'] = array_keys($fields);
        return $fields;
	}


    
    public function render($attrs, $content = null, $render_slug = null) {
        return pcpp_divi_modules::front_shortcode_render($this->slug, $this->props);  
	}
}

new pcpp_user_orders_history_divi_module;
