<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class pcpp_plan_chooser_on_elementor extends Widget_Base {
	
	 public function get_icon() {
      return 'emtr_lcweb_icon';
   }
	
	public function get_name() {
		return 'pcpp-plan-chooser';
	}

	public function get_categories() {
		return array('privatecontent');
	}

   public function get_title() {
      return 'PCPP - '. esc_html__("Plans Chooser Box", 'pcpp_ml');
   }



    protected function register_controls() {
        global $pcpp_subscr;
        $plans = array('' => __('none', 'pcpp_ml')) + $pcpp_subscr->get_plans();



        $this->start_controls_section(
            'main',
            array(
                'label' => esc_html__('Main Parameters', 'pcpp_ml'),
            )
        );

        $this->add_control(
            'focused_plan',
            array(
                'label' 	=> __("Focused plan", 'pcpp_ml'),
                'type' 	=> \Elementor\Controls_Manager::SELECT2,
                'multiple'=> false,
                'default' => current(array_keys($plans)),
                'options' => $plans
            )
        );


        $this->end_controls_section();
    }


	
	////////////////////////



	protected function render() {
     	$vals = $this->get_settings();
		//var_dump($vals);

		$parts = array('focused_plan');
		$params = '';
		
		foreach($parts as $part) {
			$params .= $part.'="';
			
			if(!isset($vals[$part])) {$vals[$part] = '';}
			$params .= $vals[$part].'" ';		
		}
        
		echo do_shortcode('[pcpp-plan-chooser '. $params .']');
	}
}
