<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class pcpp_subscr_expir_on_elementor extends Widget_Base {

    public function get_icon() {
        return 'emtr_lcweb_icon';
    }

    public function get_name() {
        return 'pcpp-subscr-expir';
    }

    public function get_categories() {
        return array('privatecontent');
    }

    public function get_title() {
        return 'PCPP - '. esc_html__("User's subscription expiration", 'pcpp_ml');
    }



    protected function register_controls() {

        $this->start_controls_section(
            'main',
            array(
                'label' => esc_html__('Main Parameters', 'pcpp_ml'),
            )
        );

        $this->add_control(
            'type',
            array(
                'label' 	=> __("Output type", 'pcpp_ml'),
                'type' 	=> Controls_Manager::SELECT,
                'multiple'=> false,
                'default' => 'date',
                'options' => array(
                    'date'      => esc_html__("date", 'pcpp_ml'),
                    'countdown' => esc_html__("countdown", 'pcpp_ml')
                )
            )
        );

        $this->add_control(
            'date_format',
            array(
                'label' 		=> __('Custom date format', 'pcpp_ml'),
                'description' 	=> __('Use PHP date() format', 'pcpp_ml'),
                'default' 		=> '',
                'type' 			=> Controls_Manager::TEXT,

                'condition' => array(
                    'type' => 'date',
                ),
            )
        );


        $this->end_controls_section();
    }



    ////////////////////////



    protected function render() {
        $vals = $this->get_settings();
        //var_dump($vals);

        $parts = array('type', 'date_format');
        $params = '';

        foreach($parts as $part) {
            $params .= $part.'="';

            if(!isset($vals[$part])) {$vals[$part] = '';}
            $params .= $vals[$part].'" ';	
        }

        
        echo (!isset($GLOBALS['pc_user_id']) && $GLOBALS['lcwp_is_elementor_builder']) ? 
            '[PrivateContent '. __('subscription expiration date - login to see it', PCPP_ML) .']' : 
            do_shortcode('[pcpp-subscr-expir '. $params .']');
    }
}
