<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class pcpp_user_orders_history_on_elementor extends Widget_Base {
	
	 public function get_icon() {
      return 'emtr_lcweb_icon';
   }
	
	public function get_name() {
		return 'pcpp-user-orders-history';
	}

	public function get_categories() {
		return array('privatecontent');
    }

    public function get_title() {
        return 'PCPP - '. esc_html__("User's subscription orders history", 'pcpp_ml');
    }



    protected function register_controls() {

        $this->start_controls_section(
            'main',
            array(
                'label' => esc_html__('Main Parameters', 'pcpp_ml'),
            )
        );

        $this->add_control(
            'date_format',
            array(
                'label' 		=> __('Custom date format', 'pcpp_ml'),
                'description' 	=> __('Use PHP date() format', 'pcpp_ml'),
                'default' 		=> '',
				'type' 			=> Controls_Manager::TEXT,
            )
		);
       
       
		$this->end_controls_section();
   }


	
	////////////////////////



	protected function render() {
     	$vals = $this->get_settings();
		//var_dump($vals);

		$parts = array('date_format');
		$params = '';
		
		foreach($parts as $part) {
			$params .= $part.'="';
			
			if(!isset($vals[$part])) {$vals[$part] = '';}
			$params .= $vals[$part].'" ';	
		}
		
        
        echo (!isset($GLOBALS['pc_user_id']) && $GLOBALS['lcwp_is_elementor_builder']) ? 
            '[PrivateContent '. __('user orders history - login to see it', PCPP_ML) .']' : 
            do_shortcode('[pcpp-user-orders-history '. $params .']');
	}
}
