<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class pcpp_user_plan_on_elementor extends Widget_Base {
	
	 public function get_icon() {
      return 'emtr_lcweb_icon';
   }
	
	public function get_name() {
		return 'pcpp-user-plan';
	}

	public function get_categories() {
		return array('privatecontent');
	}

   public function get_title() {
      return 'PCPP - '. esc_html__("User's plan name", 'pcpp_ml');
   }



   protected function register_controls() {

		$this->start_controls_section(
			'main',
			array(
				'label' => esc_html__('No Parameters', 'pcpp_ml'),
			)
		);
  
		$this->end_controls_section();
   }


	
	////////////////////////



	protected function render() {
     	$vals = $this->get_settings();
		//var_dump($vals);

		$parts = array();
		$params = '';
		
		foreach($parts as $part) {
			$params .= $part.'="';
			
			if(!isset($vals[$part])) {$vals[$part] = '';}
			$params .= $vals[$part].'" ';	
		}
        
        
        echo (!isset($GLOBALS['pc_user_id']) && $GLOBALS['lcwp_is_elementor_builder']) ? 
            '[PrivateContent '. __('user subscription plan - login to see it', PCPP_ML) .']' : 
            do_shortcode('[pcpp-user-plan '. $params .']');
	}
}
