<?php
// INITIALIZE GUTEN BLOCKS AND DEFINE HANDLERS




// register blocks
function pcpp_guten_register() {
	if(!function_exists('register_block_type')) {
        return;
    }
    
    //////// not for WP 5.8 widgets.. for now
    if($_SERVER["REQUEST_URI"] == '/wp-admin/widgets.php') {
        return;
    }
    ////////
	
	$shortcodes = array(
		'change-plan/change-plan',
        'user-plan/user-plan',
        'subscr-expir/subscr-expir',
        'user-orders-history/user-orders-history',
        'plan-chooser/plan-chooser',
	);
		
	foreach($shortcodes as $ch) {
		include_once(PCPP_DIR .'/builders_integration/guten_elements/'. $ch .'.php');	
	}
}
add_action('init', 'pcpp_guten_register');






// enqueue scripts in gutenberg 
function pcpp_guten_scripts() {
	global $current_screen;

    //////// not for WP 5.8 widgets.. for now
    if($_SERVER["REQUEST_URI"] == '/wp-admin/widgets.php') {
        return;
    }
    ////////
    
    $deps = array(
        'wp-blocks',
        'wp-i18n',
        'wp-element',
    );  
    if($current_screen->base != 'widgets') {
        $deps[] = 'wp-editor';     
    }
    
    $shortcodes = array(
		'pcpp-change-plan'          => 'change-plan/change-plan',
        'pcpp-user-plan'            => 'user-plan/user-plan',
        'pcpp-subscr-expir'         => 'subscr-expir/subscr-expir',
        'pcpp-user-orders-history'  => 'user-orders-history/user-orders-history',
        'pcpp-plan-chooser'         => 'plan-chooser/plan-chooser',
	);
	
	foreach($shortcodes as $key => $script_name) {
		wp_enqueue_script(
			'lcweb/'. $key,
			PCPP_URL .'/builders_integration/guten_elements/'. $script_name .'.js',
			$deps,
			PCPP_VER, 
			true
		);
	}
}
add_action('enqueue_block_editor_assets', 'pcpp_guten_scripts');





///////////////////////////////////////////////////////////






function pcpp_change_plan_guten_handler($atts) {
	$code = pc_guten_handler_common();
	return $code . do_shortcode('[pcpp-change-plan '. pc_guten_atts_compile($atts) .']');
}


function pcpp_user_plan_guten_handler($atts) {
	$code = pc_guten_handler_common();
	return $code . do_shortcode('[pcpp-user-plan '. pc_guten_atts_compile($atts) .']');
}


function pcpp_subscr_expir_guten_handler($atts) {
	$code = pc_guten_handler_common();
	return $code . do_shortcode('[pcpp-subscr-expir '. pc_guten_atts_compile($atts) .']');
}


function pcpp_user_orders_history_guten_handler($atts) {
	$code = pc_guten_handler_common();
	return $code . do_shortcode('[pcpp-user-orders-history '. pc_guten_atts_compile($atts) .']');
}


function pcpp_plan_chooser_guten_handler($atts) {
	$code = pc_guten_handler_common();
	return $code . do_shortcode('[pcpp-plan-chooser '. pc_guten_atts_compile($atts) .']');
}

