<?php
//  visual composer integration


function pcpp_on_visual_composer() {
    global $pcpp_subscr;
    
	
	#########################################
	##### PLAN CHANE/RENEW FORM #############
	#########################################
	
	// compile
	vc_map(
        array(
            'name' 			=> 'PCPP - '. esc_html__("Subscription Change/renew Form", PCPP_ML),
			'description'	=> esc_html__("Subscription's change or renew form, visible only by logged users", PCPP_ML),
            'base' 			=> 'pcpp-change-plan',
            'category' 		=> "PrivateContent",
			'icon'			=> PC_URL .'/img/vc_icon.png',
			'admin_enqueue_css'	 => '',
            'params' 		=> array(),
        )
    );

    
    
    
    
    #########################################
	##### LOGGED USER'S PLAN NAME ###########
	#########################################
	
	// compile
	vc_map(
        array(
            'name' 			=> 'PCPP - '. esc_html__("User's plan name", PCPP_ML),
			'description'	=> esc_html__("Displays currently logged user subscription plan's name", PCPP_ML),
            'base' 			=> 'pcpp-user-plan',
            'category' 		=> "PrivateContent",
			'icon'			=> PC_URL .'/img/vc_icon.png',
			'admin_enqueue_css'	 => '',
            'params' 		=> array(),
        )
    );
    
    
    
    
    
    #########################################
	##### LOGGED USER'S PLAN EXPIRATION #####
	#########################################
	
    $params = array(
        array(
			'type' 			=> 'dropdown',
			'heading' 		=> __("Output type", PCPP_ML),
			'param_name' 	=> 'type',
			'admin_label' 	=> true,
			'value' 		=> pc_vc_invert_arr_keys(array(
                'date'      => esc_html__("date", PCPP_ML),
                'countdown' => esc_html__("countdown", PCPP_ML)
            )),
		),
        array(
			'type' 			=> 'textfield',
			'heading' 		=> __('Custom date format - use PHP date() format', PCPP_ML),
			'param_name' 	=> 'date_format',
			'value' 		=> '',
		),
    );
    
    
	// compile
	vc_map(
        array(
            'name' 			=> 'PCPP - '. esc_html__("User's subscription expiration", PCPP_ML),
			'description'	=> esc_html__("Currently logged user subscription expiration date or countdown", PCPP_ML),
            'base' 			=> 'pcpp-subscr-expir',
            'category' 		=> "PrivateContent",
			'icon'			=> PC_URL .'/img/vc_icon.png',
			'admin_enqueue_css'	 => '',
            'params' 		=> $params,
        )
    );
     
    
    
    
    
    ######################################
	##### USER ORDERS HISTORY ############
	######################################
	
    $params = array(
        array(
			'type' 			=> 'textfield',
			'heading' 		=> __('Custom date format - use PHP date() format', PCPP_ML),
			'param_name' 	=> 'date_format',
			'value' 		=> '',
		),
    );
    
    
	// compile
	vc_map(
        array(
            'name' 			=> 'PCPP - '. esc_html__("User's subscription orders history", PCPP_ML),
			'description'	=> esc_html__("Displays currently logged user subscription history details", PCPP_ML),
            'base' 			=> 'pcpp-user-orders-history',
            'category' 		=> "PrivateContent",
			'icon'			=> PC_URL .'/img/vc_icon.png',
			'admin_enqueue_css'	 => '',
            'params' 		=> $params,
        )
    );
    
    
    
    
    
    ######################################
	##### PLANS CHOOSER BOX ##############
	######################################
	
    $params = array(
        array(
			'type' 			=> 'dropdown',
			'heading' 		=> __("Focused plan", PCPP_ML),
			'param_name' 	=> 'focused_plan',
			'admin_label' 	=> true,
			'value' 		=> pc_vc_invert_arr_keys(
                array('' => __('none', PCPP_ML)) + $pcpp_subscr->get_plans()
            ),
		),
    );
    
    
	// compile
	vc_map(
        array(
            'name' 			=> 'PCPP - '. esc_html__("Plans Chooser Box", PCPP_ML),
			'description'	=> esc_html__("Displays a box listing subscription plans", PCPP_ML),
            'base' 			=> 'pcpp-plan-chooser',
            'category' 		=> "PrivateContent",
			'icon'			=> PC_URL .'/img/vc_icon.png',
			'admin_enqueue_css'	 => '',
            'params' 		=> $params,
        )
    );
    
    
}
add_action('vc_before_init', 'pcpp_on_visual_composer');


