<?php
// CLASS AIMING UNIQUELY TO PREPARE THE FRONT PLAN CHOOSER FOR REGISTRATIONS AND RENEWALS

class pcpp_front_plan_choser {
	
    public $form_type; // (string)
    public $is_rnw_chng_form; // (bool) shortcut flag knowing if is a renewal or change form
    public $plans; // (array)
    public $date_format; // (string)
    public $plan_change_behav; // (string)
    
    private $user_id; // (int)
    private $user_actual_plan = false; // (false|int)
    private $user_actual_exp; // (false|int)
    private $user_has_pending_dur_ext = false; // (bool) flag to know whether user has got a pending duration extension order in change forms
    

        
    /*
     * @param (string) $form_type = defines which form type to prepare the block to 
        registr = registration
        renewal = renewal 
        change  = plan's change (for logged user)
        chooser = plans chooser shortcode
     */    
    public function __construct($form_type, $user_id = false) {
        $this->form_type = $form_type;
        $this->user_id = $user_id;   
        
        $this->date_format = get_option('pcpp_order_change_date_format', get_option('date_format'));
        $this->plan_change_behav = get_option('pcpp_order_change_behav', 'no_change');
        
        $this->is_rnw_chng_form = (in_array($this->form_type, array('renewal', 'change'))) ? true : false;
    }
    
    
    
    
    /* RETURNS THE FRONT BLOCK HTML CODE 
     * @param (bool|int) plan selected by default    
     */
    public function get_code($def_selection = false) {
        global $pc_meta, $pcpp_subscr;
        
        $strip_no_registr = (!$this->is_rnw_chng_form) ? true : false; 
        $strip_no_renewal = ($this->is_rnw_chng_form) ? true : false;
        
        $this->plans = $pcpp_subscr->get_plans($strip_no_registr, $strip_no_renewal);
        $plans_to_choose_from = $this->plans; 
        
        
        $curr_plan_box = $this->curr_plan_box(); // sets user data up
        
        // current plan is always shown on top - remove it from choices
        if($this->is_rnw_chng_form && isset($plans_to_choose_from[ $this->user_actual_plan ])) {
            unset( $plans_to_choose_from[ $this->user_actual_plan ] );      
        }
        

        // global used to control special registration prices
        if(!$this->is_rnw_chng_form) {
            $GLOBALS['pcpp_initial_registr'] = true;    
        }

        
        $code = '';
        
        // separator first - use disclaimer's wrap code
        if($this->form_type == 'registr') {
            $code .= '<section class="pc_disclaimer_f_sep pcpp_field_top_sep pc_fullw_field"></section>';           
        }

        
        // plans code
        $code .= '
        <section class="pc_form_field pcpp_field pcpp_plan_choice_wrap pc_fullw_field">';

        
        // only one plan: just print plan's specifications
        if(count($plans_to_choose_from) <= 1) {
            if($this->form_type == 'registr') {
                $code .= '<label id="pcpp_plan_dd_label">'. get_option('pcpp_pre_plans_label', __('Choose your plan:', PCPP_ML)) .'</label>';       
            }

            $code .= 
            $curr_plan_box .
            $this->trial_box();
            
            if(!$this->is_rnw_chng_form || $this->plan_change_behav != 'no_change') {  
                $code .= 
                $this->discount_box();
                
                $keys = array_keys($plans_to_choose_from);
                $plan_id = $keys[0];

                $vals = array_values($plans_to_choose_from);
                $plan_name = $vals[0];

                $data = $pcpp_subscr->get_plan_data($plan_id);
                $chosen_class = ($this->form_type == 'registr') ? 'pcpp_chosen' : ''; 
                
                $is_subscr_class = (pcpp_woo_subscr_static::plan_is_subscr($plan_id)) ? 'pcpp_is_subscr' : '';
                
                $code .= '
                <ul class="pcpp_plan_ul pc_plan_dd_single">
                    <li class="pcpp_plan_'. $plan_id .' pcpp_plan_block '. $chosen_class .' '. $is_subscr_class .'" data-plan-id="'. $plan_id .'">'. $this->plan_form_txt($data, $plan_name) .'</li>
                </ul>'.
                $this->active_plan_change_warn();
                
                // real field - select (must have a value on registration)
                if($this->form_type == 'registr') {
                    $code .= '<input type="hidden" name="pcpp_plan" value="'. $plan_id .'" />';    
                }
                elseif($this->is_rnw_chng_form) {
                    $code .= '<input type="checkbox" name="pcpp_plan" value="'. $plan_id .'" class="pcpp_plan_input" autocomplete="off" />';        
                }
            }
            
            if($this->is_rnw_chng_form) {
                $code .= '<input type="checkbox" name="pcpp_plan" value="'. $this->user_actual_plan .'" class="pcpp_plan_input" autocomplete="off" />';        
            }
        }

        
        // multiple plans available
        else {
            $def_effm_val = (get_option('pcpp_bold_fluid_layout')) ? 'bold' : ''; // retrocompatibility
            switch(get_option('pcpp_extra_fluid_form_mode', $def_effm_val)) {
                default :
                    $extra_fluid_class = '';
                    break;

                case 'bold' :
                    $extra_fluid_class = 'pcpp_bold_fluid_layout';
                    break;

                case 'compact' :
                    $extra_fluid_class = 'pcpp_compact_fluid_layout';
                    break;
            }
            if($this->form_type == 'chooser') {
                $extra_fluid_class = 'pcpp_bold_fluid_layout';        
            }

            // pre-plans label
            if($this->form_type == 'registr') {
                $code .= '<label id="pcpp_plan_dd_label" class="'. $extra_fluid_class .'">'. get_option('pcpp_pre_plans_label', __('Choose your plan:', PCPP_ML)) .'<i></i></label>';       
            }

            // selected one
            $sel_to_match = ($def_selection && isset($plans_to_choose_from[ (int)$def_selection ])) ? (int)$def_selection : (int)get_option('pcpp_default_plan');
            
            // special class for chooser form
            $chooser_no_sel_class = ($this->form_type == 'chooser' && !$def_selection) ? 'pcpp_pcf_no_sel' : '';
            if($chooser_no_sel_class) {
                $sel_to_match = false;    
            }
            

            // plans list
            $code .= 
            $curr_plan_box .  
            $this->trial_box();
            
            // plan change - user already has a pendingg order
            if($this->user_has_pending_dur_ext) {
                return $code . '
                </section>';        
            }
            
            
            // normal plan options display 
            if(count($plans_to_choose_from) && (!$this->is_rnw_chng_form || $this->plan_change_behav != 'no_change')) {
                $code .=
                $this->discount_box() .'
                    
                <ul class="pcpp_plan_ul '. $extra_fluid_class .' '. $chooser_no_sel_class .'">';

                    $sel_plan = '';
                    $a = 0;
                    foreach($plans_to_choose_from as $plan_id => $plan_name) {
                        if($this->form_type == 'change' && $plan_id == $this->user_actual_plan) {
                            continue;        
                        }

                        $data = $pcpp_subscr->get_plan_data($plan_id);
 
                        $sel = ($plan_id == $sel_to_match || ($this->form_type != 'chooser' && !$sel_to_match && !$a)) ? 'pcpp_chosen' : '';
                        if(!empty($sel)) {
                            $sel_plan = $plan_id;
                        }

                        // no pre-selection if is "change" form
                        if($this->form_type == 'change') {
                            $sel = '';        
                        }
                        
                        $is_subscr_class = (pcpp_woo_subscr_static::plan_is_subscr($plan_id)) ? 'pcpp_is_subscr' : '';

                        $code .= '
                        <li class="pcpp_plan_block '. $sel .' '. $is_subscr_class .'" data-plan-id="'. $plan_id .'">
                            '. $this->plan_tag_code($plan_id) .'
                            '. $this->plan_form_txt($data, $plan_name) .'
                        </li>';

                        $a++;
                    }
                
                $code .= '
                </ul>'.
                    
                $this->active_plan_change_warn();
            }

            
            // real field - select (must have a value on registration)
            if($this->form_type == 'registr') {
                $code .= '
                <select name="pcpp_plan" class="pcpp_plan_dd" autocomplete="off">';

                foreach($this->plans as $plan_id => $plan_name) {
                    $sel = ($plan_id == $sel_plan) ? 'selected="selected"' : '';
                    $code .= '<option value="'. $plan_id .'" '.$sel.'>'. $plan_name .'</option>';	
                }

                $code .= '
                </select>';
            }
            
            // renew/update - must choose the option
            elseif($this->is_rnw_chng_form) {
                
                foreach($this->plans as $plan_id => $plan_name) {
                    $code .= '<input type="checkbox" name="pcpp_plan" value="'. $plan_id .'" class="pcpp_plan_input" autocomplete="off" />';
                }        
            }
        }


        // allow coupon usage?
        if(get_option('pcpp_use_coupon') && $this->form_type != 'chooser') {

            $coupon_label = __('Got a coupon to use?', PCPP_ML);

            // fields icon
            $coupon_icon_class 	= (get_option('pcpp_coupon_field_icon')) ? 'pc_field_w_icon' : '';
            $coupon_icon 		= ($coupon_icon_class) ? '<span class="pc_field_icon" title="'. esc_attr($coupon_label) .'"><i class="'. esc_attr( pc_static::fontawesome_v4_retrocomp(get_option('pcpp_coupon_field_icon')) ) .'"></i></span>' : '';

            // placeholders only if no-label is active
            $coupon_placeh = (get_option('pg_nolabel')) ? 'placeholder="'. esc_attr($coupon_label) .'"' : '';

            $code .= '
            </section>

            <section class="pc_form_field pcpp_coupon_wrap '. $coupon_icon_class .'">
                <div class="pcpp_coupon_box">
                    <label>'. $coupon_label .'</label>

                    <div class="pc_field_container">
                        '. $coupon_icon .'
                        <input class="pcpp_coupon" name="pcpp_coupon" value="" maxlength="30" '. $coupon_placeh .' autocomplete="off" type="text" />

                        <i class="fas fa-chevron-right pcpp_try_coupon" title="'. esc_attr__('Apply coupon', PCPP_ML) .'"></i>
                    </div>
                </div>';	
        }


        // add code to change submit button value
        if($this->form_type == 'registr') {
            $custom_btn_val = get_option('pcpp_reg_form_btn_text');
            
            if(!empty($custom_btn_val)) {
                $code .= '
                <script type="text/javascript">
                (function($) { 
                    "use strict";  

                    $(document).ready(function() {
                        $(".pc_reg_btn").attr("value", "'. esc_attr($custom_btn_val) .'");
                    });
                })(jQuery);
                </script>';
            }
        }
        
        // add code to toggle discount box
        elseif($this->form_type == 'change') {
            $code .= '
            <script type="text/javascript">
            (function($) { 
                "use strict";  

                $(document).ready(function() {

                    const toggle_discount_box = function() {
                        $(".pcpp_change_plan_form").each(function() {
                            if(!$(this).find(".pcpp_discount_box").length) {
                                return true;
                            }

                            const $db = $(this).find(".pcpp_discount_box");
                            ($(this).find(".pcpp_chosen.pcpp_is_subscr").length) ? $db.hide() : $db.show();
                        });
                    };

                    toggle_discount_box();

                    $(document).on("click", ".pcpp_change_plan_form .pcpp_plan_block, .pcpp_change_plan_form .pcpp_plan_dur_ext_block", function() {
                        toggle_discount_box();    
                    });
                });
            })(jQuery);
            </script>';
        }

        if(isset($GLOBALS['pcpp_initial_registr'])) {
            unset($GLOBALS['pcpp_initial_registr']);    
        }
        
        return $code . '
        </section>';
    }
    
    
    
    
    // returns user's current plan box where user can purchase duration extensions
    private function curr_plan_box() {
        global $pc_users, $pcpp_subscr;
        
        if(!$this->is_rnw_chng_form) {
            return '';    
        }
        
        // admin preview
        if(isset($GLOBALS['pcpp_admin_is_previewing'])) {
            return '
            <div class="pcpp_user_actual_plan">
                <span>'. __('Your actual plan is', PCPP_ML) .' <strong>XYZ</strong></span>
            </div>';
        }
        
        
        // normal view
        $args = array(
            'to_get' => array('pcpp_plan', 'pcpp_subscr_end', 'pcpp_recurr_subscr'),
        );
        $user_data = $pc_users->get_user($this->user_id, $args);
        $this->user_actual_plan = $user_data['pcpp_plan'];
        
        $plan_data = $pcpp_subscr->get_plan_data($this->user_actual_plan);
        if(!$plan_data) {
            return '';    
        }
        $expires = ($user_data['pcpp_subscr_end'] == 'unlimited') ? false : true;
        
        
        // current plan expiration text
        if($this->form_type == 'renewal') {
            if($user_data['pcpp_subscr_end'] > current_time('timestamp')) {
                $curr_subscr_expir = __('is expired', PCPP_ML);    
            } 
            else {
                if($plan_data['recurr_pay'] && !empty($user_data['pcpp_recurr_subscr'])) {
                    $woo_subscr = wc_get_order($user_data['pcpp_recurr_subscr']);
                    $curr_subscr_expir = ', '. __('expired on', PCPP_ML) .' '. date_i18n($this->date_format, $woo_subscr->get_time('end', 'site'));    
                }
                else {
                    $curr_subscr_expir = ', '. __('expired on', PCPP_ML) .' '. date_i18n($this->date_format, $user_data['pcpp_subscr_end']);   
                }
            }
        }
        
        else {
            if($plan_data['recurr_pay'] && function_exists('wcs_get_subscription')) {
                $curr_subscr_expir = __('renewing every', PCPP_ML) .' '. $plan_data['duration_txt'] .'</strong>
                <br/><small>('. __('next due date', PCPP_ML) .' '. pcpp_woo_subscr_static::next_due_date($user_data['pcpp_recurr_subscr']) .')</small><strong>';             
            }
            else {
                $curr_subscr_expir = (!$expires) ? 
                    __('and has no expiration', PCPP_ML) : 
                    ', '. __('expiring in', PCPP_ML) .' <time title="'. esc_attr(date_i18n($this->date_format, $user_data['pcpp_subscr_end'])) .'">'. pcpp_static::get_countdown_txt($user_data['pcpp_subscr_end']) .'</time>';   
            }
            
            if($expires && !$plan_data['recurr_pay']) {
                $this->user_actual_exp = $user_data['pcpp_subscr_end'];    
            }
        }

        
        $upde_warn = '';
        if($this->form_type == 'change') {
            $upde = pcpp_user_subscr_static::has_pending_expir_ext_order($this->user_id, true);
            
            if($upde) {
                $this->user_has_pending_dur_ext = true;
                $upde_warn = '
                <div class="pc_warn_box pcpp_user_has_pending_dur_ext_warn">
                    '. __('There is already a subscription extension order waiting for payment', PCPP_ML) .'
                    
                    <div class="pc_warn_box_btn_wrap">
                        <a href="'. esc_attr($pcpp_subscr->checkout_url($upde)) .'">
                            <span class="pc_warn_box_btn">'. __('Go to checkout', PCPP_ML) .'</span>
                        </a>
                    </div>
                </div>
                <style>
                .pcpp_change_plan_btn, 
                .pcpp_form_message {
                    display: none;
                }
                </style>';
            }
        }
        
        
        $code = '
        <div class="pcpp_user_actual_plan" data-plan-id="'. (int)$this->user_actual_plan .'">
            <span>'. __('Your actual plan is', PCPP_ML) .' <strong>"'. $plan_data['title'] .'"</strong> <strong>'. $curr_subscr_expir .'</strong></span>
        ';
        
            // allow extension only if not "unlimited" and plan allow renew
            if(!$this->user_has_pending_dur_ext && $expires && isset($this->plans[ $this->user_actual_plan ])) {
                $code .= $this->plan_dur_ext_code($this->user_actual_plan, $plan_data);
            }
        
        return $code .= '
        </div>'.
        $upde_warn;
    }
    
    
    
    
    // returns trial period box
    private function trial_box() {
        global $pcpp_subscr;
        $trial_box = '';
        
        if($pcpp_subscr->is_trial_enabled() && $this->form_type != 'renewal') {
            $trial_txt = get_option('pcpp_trial_txt');
            
            if(empty($trial_txt)) {
                $trial_txt = $pcpp_subscr->trial_duration.' '. pcpp_static::sing_plur_switch($pcpp_subscr->trial_dur_type, $pcpp_subscr->trial_duration) .' '. __('free trial', PCPP_ML);
            }

            $trial_box = '
            <div class="pcpp_trial_box">
                <i class="fas fa-star pcpp_trial_box_icon"></i>
                <span>'. $trial_txt .'</span>
            </div>';	
        }
        
        return $trial_box;
    }
    
    
    
    
    // returns discount amount box
    private function discount_box() {
        global $pcpp_subscr, $pc_users;
        
        if(!$this->user_id || $this->form_type != 'change' || $this->plan_change_behav != 'discount') {
            return '';    
        }
        
        $args = array(
            'to_get' => array('pcpp_plan', 'pcpp_active_order', 'pcpp_subscr_end', 'pcpp_subscr_status'),
        );
        $user_data = $pc_users->get_user($this->user_id, $args);
        
        if($user_data['pcpp_subscr_status'] == 'trial') {
            return '';    
        }
        
        $amount = $pcpp_subscr->plan_change_discount($user_data['pcpp_active_order'], $user_data['pcpp_plan'], $user_data['pcpp_subscr_end']);
        if(!$amount) {
            return '';        
        }

        if(PCPP_ECOMMERCE == 'woocomm') {
            $amount = '<strong>'. wc_price($amount) .'</strong>';
        }

        $disc_box = '
        <div class="pcpp_trial_box pcpp_discount_box">
            <i class="fas fa-star pcpp_trial_box_icon"></i>
            <span>'. sprintf(esc_html__("You have %s credit related to your subscription's time left. Will be used choosing a new option", PCPP_ML), $amount) .'</span>
        </div>';	

        return $disc_box;
    }
    
    
    
    
    // compose plan text to be shown in form
    public function plan_form_txt($plan_data, $plan_name) {
        $is_free 	= ((float)$plan_data['price']) ? false : true;
        $has_period = (empty($plan_data['duration_secs'])) ? false : true;

        $parts = array(
            '<span class="pcpp_plan_name">'.$plan_name,'</span>',
            '<span class="pcpp_plan_price_wrap">'
        );

        // price
        $price_txt 		= ($is_free) ? __('free', PCPP_ML) : $plan_data['currency_price'];
        $is_free_class	= ($is_free) ? 'pcpp_is_free' : '';

        $parts[] = '<strong class="pcpp_plan_price '. $is_free_class .'">'. $price_txt .'</strong>';

        // subscription duration
        $conjunction = ($plan_data['recurr_pay']) ? __('every', PCPP_ML) : __('for', PCPP_ML);
        $parts[] = ($has_period) ? 
            '<span class="pcpp_plan_dur">'. $conjunction .' <strong>'. $plan_data['duration_txt'] .'</strong></span>' : 
            '<strong class="pcpp_plan_dur">'. __('one-time fee', PCPP_ML) .'</strong>';

        // end price block
        $parts[] = '</span>';

        // plan description
        if(trim(strip_tags($plan_data['txt']))) {
            // security trick - strip registration form shortcode support
            global $shortcode_tags;

            $backup = $shortcode_tags;
            $shortcode_tags = array('pc-registration-form' => 1);
            
            $parts[] = '<div class="pcpp_plan_descr">'. do_shortcode(wpautop($plan_data['txt'])) .'</div>';	
            
            $shortcode_tags = $backup;
        }
        
        // duration extension block
        if($has_period && !$plan_data['recurr_pay']) {
            $parts[] = $this->plan_dur_ext_code($plan_data['id']);
        }
            
        // plan's chooser block - button 
        if($this->form_type == 'chooser') {
            $parts[] = '<span class="pcpp_pcf_btn">'. get_option('pcpp_pcf_btn_txt', __('Subscribe', PCPP_ML)) .'</span>';            
        }
        
        return implode(' ', $parts);	
    }
    
    
    
    
    // given a plan ID, returns the eventual tag HTML code
    public function plan_tag_code($plan_id) {
        $tag_txt    = get_post_meta($plan_id, 'pcpp_tag_txt', true);
        $tag_color  = get_post_meta($plan_id, 'pcpp_tag_col', true);
        $tag_bg     = get_post_meta($plan_id, 'pcpp_tag_bg', true); 
        
        if(empty($tag_txt)) {
            return '';    
        }
        
        return '
        <div class="pcpp_plan_tag_wrap">
            <sup class="pcpp_plan_tag" style="background: '. esc_attr($tag_bg) .';">
                <span style="color: '. esc_attr($tag_color) .';">'. $tag_txt .'</span>
            </sup>
        </div>';
    }
    
    
    
    
    /* 
    * given a plan ID, returns the eventual tag HTML code
    * @param (false|array) $plan_data = plan data array. Highlights the current user plan block in renewal forms
    */
    public function plan_dur_ext_code($plan_id, $plan_data = false) {
        $use_dur_ext = get_option('pcpp_use_duration_ext', 'always');
        
        if(
            $use_dur_ext == 'no' || 
            $this->form_type == 'chooser' ||
            !is_array($plan_data) ||
            ($plan_data['recurr_pay'] && $this->form_type == 'change')
        ) {
            return '';    
        }
        
        // blocking extensions in renew/change forms - start with empty array
        $dur_ext = ($this->is_rnw_chng_form && $use_dur_ext == 'registr' || $plan_data['recurr_pay']) ? array() : pcpp_dur_ext_static::get_plan_dur_exts($plan_id);
        
        // plan's renew/change form - user's actual plan - prepend box to re-choose the same plan
        if($plan_data && $this->is_rnw_chng_form) {
            $dur_ext = array_merge(array(
                $plan_id => array(
                    'db_id'         => $plan_id,
                    'duration'      => $plan_data['duration'],
                    'dur_type'      => $plan_data['duration_type'],
                    'price'         => $plan_data['price'],
                    'note'          => '',
                    'is_user_plan'  => true,
                )
            ), $dur_ext);            
        }
        
        if(empty($dur_ext)) {
            return '';    
        }
        
        $code = '
        <ul class="pcpp_plan_dur_ext_block pc_manag_check">';
            
            foreach($dur_ext as $de_id => $de_data) {
                $is_user_plan_renew = (isset($de_data['is_user_plan'])) ? true : false;
                $iupn_class = ($is_user_plan_renew) ? 'pcpp_user_actual_plan_check' : '';
                
                $price = (float)$de_data['price'];
                if($plan_data && !$is_user_plan_renew) {
                    $price = $price + (float)$plan_data['price'];    
                }
                
                // formatted price + currency
                if(PCPP_ECOMMERCE == 'woocomm') {
                    $price = strip_tags(wc_price($price));
                }
                
                $note = '';
                if(!empty($de_data['note'])) {
                    $note = ' - <strong>'. $de_data['note'] .'</strong>';     
                }
  
                
                // duration text switch - show different text if is the actual user plan
                if($is_user_plan_renew) {
                    if($plan_data['recurr_pay']) {
                        $init_part = __('renew it', PCPP_ML) .' ('. __('recurring every', PCPP_ML) .' '. $plan_data['duration_txt'] .')';
                    }
                    else {
                        $start_date = ($this->form_type == 'renewal') ? 'now' : $this->user_actual_exp; 
                        $date = date_i18n($this->date_format, pcpp_static::period_to_timestamp($de_data['duration'], $de_data['dur_type'], $start_date));

                        $init_part = __('extend until', PCPP_ML) .' '. $date;   
                    }
                }
                else {
                    if(!$plan_data) {
                        $init_part = '+ '. $de_data['duration'] .' '. pcpp_static::sing_plur_switch($de_data['dur_type'], $de_data['duration']);        
                    } 
                    else {
                        $start_date = ($this->form_type == 'renewal') ? 'now' : $this->user_actual_exp; 
                        $plan_exp_timestamp = pcpp_static::period_to_timestamp($plan_data['duration'], $plan_data['duration_type'], $start_date);
                        
                        $ext_date = date_i18n($this->date_format, pcpp_static::period_to_timestamp($de_data['duration'], $de_data['dur_type'], $plan_exp_timestamp)); 

                        $init_part = __('extend until', PCPP_ML) .' '. $ext_date;          
                    }
                }
                
                // compose
                $code .= '
                <li class="'. $iupn_class .'" data-pde-id="'. (int)$de_data['db_id'] .'">
                    <input type="checkbox" name="pcpp_plan_dur_ext" value="'. (int)$de_data['db_id'] .'" autocomplete="off" />
                    <span>'.
                        $init_part.' '. __('for', PCPP_ML) .' 
                        <span class="pcpp_pde_price">'. $price .'</span>'.
                        $note .'
                    </span>
                </li>';    
            }
        
        $code .= '
        </ul>';
        
        return $code;
    }
    
    
    
    
    // returns the HTML code for active plan change warning
    public function active_plan_change_warn() {     
        $code = '<div class="pc_warn_box pcpp_act_plan_change_warn pc_displaynone">'. __('Changing plan, your subscription will be set on pending status until new order is completed', PCPP_ML) .'</div>';
        
        return ($this->form_type == 'change') ? $code : '';
    }
    
}
