<?php
// STATIC METHODS MANAGING PLANS DURATION EXTENSIONS
class pcpp_dur_ext_static {
     
    
    /* 
     * get all duration extensions related to a plan, already sorted. Returns an associative array
     * @param (string) $key = 'pde_id' | 'db_id' dependin on what comes handier
     */
    public static function get_plan_dur_exts($plan_id, $key = 'pde_id') {
        $variations = array();
        $stored_order = (array)get_post_meta($plan_id, 'pcpp_dur_ext_order', true);
        
        if(PCPP_ECOMMERCE == 'woocomm') {
            $args = array(
                'post_type'     => 'product_variation', 
                'post_status'   => 'publish', 
                'post_parent'   => (int)$plan_id,
                'posts_per_page'=> -1, 
            );
            $query = new WP_Query($args);
            $query = $query->posts;

            foreach($stored_order as $ext_id) {
                foreach($query as $query_key => $v) {
                    
                    if($v->post_excerpt == $ext_id) {
                        $arr_key = ($key == 'pcpp_pde_id') ? $ext_id : $v->ID; 
                        
                        $variations[$arr_key] = array_merge(
                            array(
                                'db_id' => $v->ID
                            ),
                            (array)unserialize($v->post_content)
                        );
                        
                        unset($query[$query_key]);
                    }
                }
            }
            
            // there are variations left? append
            if(count($query)) {
                foreach($query as $v) {
                    $arr_key = ($key == 'pcpp_pde_id') ? $ext_id : $v->ID; 
                    
                    $variations[$arr_key] = array_merge(
                        array(
                            'db_id' => $v->ID
                        ),
                        (array)unserialize($v->post_content)
                    );
                }        
            }
        }

        return $variations;
    }
    
    
    
    // save duration extensions for a plan by syncing values with the DB (create/update/delete)
    public static function save_plan_dur_ext($plan_id, $extensions_data = array()) {
        if(isset($GLOBALS['pcpp_saving_dur_ext'])) {
            return true;        
        }
        $GLOBALS['pcpp_saving_dur_ext'] = true;
        
        $defaults = array(
            'id'        => array(),
            'duration'  => array(),
            'dur_type'  => array(),
            'price'     => array(),
            'note'      => array(),
        );
        $extensions_data = array_merge($defaults, (array)$extensions_data);    
        $ed = $extensions_data;
        
        // be sure each key has got the same elements number
        $count = count($ed['id']);
        foreach($ed as $key => $vals) {
            
            if(!is_array($vals) || $count != count((array)$vals)) {
                trigger_error("Premium Plans add-on - Plan duration extensions - wrong number of elements");
                return false;
            }
        }
 
        $to_save = array();
        for($i=0; $i < $count; $i++) {
            $data = array(
                'duration'  => ((int)$ed['duration'][$i]) ? (int)$ed['duration'][$i] : 1,
                'dur_type'  => (pcpp_static::periods($ed['dur_type'][$i])) ? $ed['dur_type'][$i] : 'month',
                'price'     => ((float)$ed['price'][$i]) ? (float)$ed['price'][$i] : 1,
                'note'      => $ed['note'][$i],
            );
            
            $to_save[ $ed['id'][$i] ] = $data;
        }
        $order = array_keys($to_save); 

        // get existing extensions
        $existing = self::get_plan_dur_exts($plan_id);  
        foreach($existing as $eeid => $edata) {
            
            if(PCPP_ECOMMERCE == 'woocomm') {
            
                // to delete
                if(!isset($to_save[$eeid])) {
                    wp_delete_post($edata['db_id'], true);    
                }

                // to update
                else {
                    $ext_data = $to_save[ $eeid ];
                    $variation = wc_get_product($edata['db_id']);  

                    $variation->set_regular_price($ext_data['price']);
                    $variation->set_price($ext_data['price']);

                    $variation->save();
                    $variation_id = $variation->get_id();
                    
                    // update specific fields into the DB
                    wp_update_post(array(
                        'ID' => $variation->get_id(),
                        'post_title'    => self::get_ext_title($variation_id, $plan_id, $ext_data),
                        'post_content'  => serialize($ext_data),
                        'post_excerpt'  => $eeid,
                    ));
                }
            }
            
            unset($to_save[ $eeid ]);
        }
        
        
        // to create
        foreach($to_save as $ext_id => $ext_data) { 
            
            if(PCPP_ECOMMERCE == 'woocomm') {
                
                $variation = new WC_Product_Variation();
                $variation->set_parent_id($plan_id);
                $variation->set_status('publish');
                $variation->set_price($ext_data['price']);
                $variation->set_regular_price($ext_data['price']);
                $variation->set_stock_status();
                $variation->save();

                $variation_id = $variation->get_id();
                
                // update specific fields into the DB
                wp_update_post(array(
                    'ID' => $variation_id,
                    'post_title'   => self::get_ext_title($variation_id, $plan_id, $ext_data),
                    'post_content' => serialize($ext_data),
                    'post_excerpt' => $ext_id,
                ));
                
                $product = wc_get_product($plan_id);
                $product->save();  
            }
        }
        
        update_post_meta($plan_id, 'pcpp_dur_ext_order', $order); 
        return true;
    }

    
    
    
    /* 
     * get single extension data
     * @param (string) $search_by = 'pde_id' | 'db_id' dependin on what comes handier
     * @return (array|false)
     */ 
    public static function get_ext_data($ext_id, $plan_id, $search_by = 'pde_id') {
        $dur_ext = self::get_plan_dur_exts($plan_id, $search_by);
        if(!is_array($dur_ext)) {
            $dur_ext = array();    
        }   
        
        return (isset($dur_ext[ (int)$ext_id ])) ? (array)$dur_ext[ (int)$ext_id ] : false;
    }
    
    
    
    
    /* returns duration extension title */
    public static function get_ext_title($ext_db_id, $plan_id, $ext_data = false) {
        if(!$ext_data) {
            $ext_data  = self::get_ext_data($ext_db_id, $plan_id);   
            
            if(!$ext_data) {
                return false;    
            }
        }
        
        $ext_period = $ext_data['duration'] .' '. pcpp_static::sing_plur_switch($ext_data['dur_type'], $ext_data['duration']);
        return get_the_title($plan_id) .' - '. sprintf(esc_html__('%s extension', PCPP_ML), $ext_period);        
    }
    
    
    
    
    /* returns duration extension in seconds */
    public static function get_ext_duration($ext_db_id) {
        $ext_data_raw = get_post_field('post_content', $ext_db_id);
        if(empty($ext_data_raw)) {
            return 0;    
        }

        $ext_data = unserialize($ext_data_raw); 
        return (int)$ext_data['duration'] * pcpp_static::periods_to_sec($ext_data['dur_type']);    
    }
    
    
    
    
    // prints plan's duration extension table
    public static function plan_dur_ext_table($plan_id, $currency_symbol) {
        $dur_ext = (get_post_meta($plan_id, '_is_pvtcontent_plan', true) == 'yes') ? self::get_plan_dur_exts($plan_id) : array();
        $visibility = (count($dur_ext)) ? '' : 'pc_displaynone';
        
        $code = '
        <table class="pcpp_pde_table  '. $visibility .'">
            <thead>
                <tr>
                    <th></th>
                    <th></th>
                    <th>ID</th>
                    <th>'. __('Additional period', PCPP_ML) .'</th>
                    <th>'. __('Additional amount', PCPP_ML) .' ('. $currency_symbol .')</th>
                    <th>'. __('Extra note (optional)', PCPP_ML) .'</th>
                </tr>
            </thead> 
            <tbody>';
        
            foreach($dur_ext as $de_id => $de_data) {
                $code .= self::plan_dur_ext_table_row($de_id, $de_data);    
            }
        
       $code .= '
            </tbody>
        </table>';
        
        return $code;
    }


    
    // plan's duration extension table
    public static function plan_dur_ext_table_row($ext_id = false, $ext_data = array()) {
        $defaults = array(
            'db_id'     => '',
            'duration'  => '',
            'dur_type'  => '',
            'price'     => '',
            'note'      => '',
        );
        $ext_data = array_merge($defaults, (array)$ext_data);
        
        $code = '
        <tr>
            <td>
                <span class="pcpp_pde_del pc_del_field dashicons dashicons-no-alt" title="'. esc_attr__('remove option', PCPP_ML) .'"></span>
            </td>
            <td>
                <span class="pcpp_pde_move pc_move_field dashicons dashicons-move" title="'. esc_attr__('sort option', PCPP_ML) .'"></span>
            </td>
            <td>'. $ext_data['db_id'] .'</td>
            <td>
                <input type="hidden" name="pcpp_pde_id[]" value="'. esc_attr($ext_id) .'" class="pcpp_pde_id" />
                <input class="input-text" size="6" type="number" name="pcpp_pde_duration[]" value="'. esc_attr($ext_data['duration']) .'" autocomplete="off" min="0" step="1" required />

                <select name="pcpp_pde_dur_type[]" autocomplete="off">';
                    
                    foreach(pcpp_static::periods() as $type => $name) {
                        $sel = ($type == $ext_data['dur_type']) ? 'selected="selected"' : ''; 
                        $code .= '<option value="'. esc_attr($type) .'" '.$sel.'>'. esc_html($name) .'</option>';	
                    }

        $code .= '
                </select>              
            </td>
            <td>
                <input type="number" class="short wc_input_price" name="pcpp_pde_price[]" value="'. esc_attr($ext_data['price']) .'" autocomplete="off" min="0" step="0.1" required />
            </td>
            <td>
                <input type="text" name="pcpp_pde_note[]" value="'. esc_attr($ext_data['note']) .'" autocomplete="off" maxlength="50" placeholder="'. esc_attr__('eg. 50% off!', PCPP_ML) .'" />
            </td>
        </tr>';

        return $code;
    }
 
}
