<?php
// GENERIC PLUGIN STATIC METHODS
class pcpp_static {
	
    // periods types
    public static function periods($sel = false) {
        $per = array(
            'day' 	=> __('days', PCPP_ML),
            'week' 	=> __('weeks', PCPP_ML),
            'month' => __('months', PCPP_ML),
            'year' 	=> __('years', PCPP_ML),
        );

        if(!$sel) {
            return $per;	
        } else {
            return (isset($per[$sel])) ? $per[$sel] : false;		
        }	
    }

    

    // periods - return related seconds
    public static function periods_to_sec($dur) {
        $secs = array(
            'day' 	=> 86400,
            'week' 	=> 604800,
            'month' => 2592000,
            'year' 	=> 31536000,
        );	

        return (isset($secs[$dur])) ? $secs[$dur] : $secs['day'];
    }

    
    

    // switch for singular/plural time formats
    public static function sing_plur_switch($subj, $val) {
        switch($subj) {
            case 'day':
            default:
                $period = ($val > 1) ? self::periods($subj) : __('day', PCPP_ML); 
                break;

            case 'week':
                $period = ($val > 1) ? self::periods($subj) : __('week', PCPP_ML); 
                break;

            case 'month':
                $period = ($val > 1) ? self::periods($subj) : __('month', PCPP_ML); 
                break;		

            case 'year':
                $period = ($val > 1) ? self::periods($subj) : __('year', PCPP_ML); 
                break;			
        }
        return $period;
    }

    

    // subscription statuses list
    public static function subscr_statuses($status = false) {
        $statuses = array(
            'trial'         => __('Trial period', PCPP_ML),
            'unpaid'        => __('Unpaid', PCPP_ML),
            'no_act_order'	=> __('No Active Orders', PCPP_ML),
            'expired'       => __('Expired', PCPP_ML),
            'active'        => __('Active', PCPP_ML),
            'suspended'     => __('Recurring Payment Suspended', PCPP_ML),
            'inherit'       => 'Inherit',
        );

        if($status && !isset($statuses[$status])) {
            return (string)$status;    
        }
        return ($status) ? $statuses[$status] : $statuses;	
    }

    
    
    
    // convert datetime value into 'Y-m-d H:i:s' format
    public static function datetime_to_mysql($val) {
        $date = new DateTime();
        $date->setTimestamp($val);

        return $date->format('Y-m-d H:i:s');    
    }
    
    
    
    
    // given a period value and type, returns the related actual timestamp + that period. Accepts a cstom starting timestamp
    public static function period_to_timestamp($period, $period_type, $starting_from = 'now') {
        $base = ($starting_from == 'now') ? current_time('timestamp') : (int)$starting_from; 
        return $base + ((int)$period * self::periods_to_sec($period_type));  
    }
    
    
    

    // given order ID - return its ecommerce status for admin orders list
    public static function get_order_ecomm_status($order_id) {
        if(PCPP_ECOMMERCE == 'woocomm') {
            $statuses = wc_get_order_statuses();
            $raw_status = get_post_status($order_id);

            // if completed - print date
            if($raw_status == 'wc-completed') {
                return $statuses[$raw_status] .' '. self::order_id_to_paydate_html($order_id);	
            } else {
                return (isset($statuses[$raw_status])) ? $statuses[$raw_status] : '';	
            }
        }

        return '';	
    }

    

    // given order ID - return its final amount
    public static function get_order_amount($order_id) {
        if(PCPP_ECOMMERCE == 'woocomm') {
            $order = wc_get_order($order_id);
            if(!$order) {
                trigger_error('PCPP - WooCommerce - Order not found');
                return false;    
            }
            
            $total = (float)$order->get_total();

            return (empty($total)) ? __('free', PCPP_ML) : get_woocommerce_currency_symbol() . $total;
        }

        return '';	
    }


    
    // plan details - to be used in admin dropdowns
    public static function dd_plan_details($plan_id) {
        global $pcpp_subscr;	
        $p_data = $pcpp_subscr->get_plan_data($plan_id);

        $conjunction = ($p_data['recurr_pay']) ? __('every', PCPP_ML) : __('for', PCPP_ML);
        $duration = empty($p_data['duration']) ? __('one-time fee', PCPP_ML) : $conjunction .' '. $p_data['duration'] .' '. self::sing_plur_switch($p_data['duration_type'], $p_data['duration']);

        return ' - '.$p_data['currency_price'].' '. $duration;
    }



    // WPML - get original language object ID
    public static function wpml_get_orig_id($subj_id, $post_type = 'product') {
        if(function_exists('icl_object_id')) {
            global $sitepress;
            $subj_id = icl_object_id($subj_id, $post_type, true, $sitepress->get_default_language());	
        }	
        return $subj_id;
    }

    

    // WPML & Polylang - get translation object ID for plans
    public static function wpml_get_trans_id($subj_id) {

        // WPML
        if(function_exists('icl_object_id')) {
            switch(PCPP_ECOMMERCE) {
                case 'woocomm' : 
                    $post_type = 'product'; 
                    break;
                    
                default	: 
                    $post_type = ''; 
                    break;	
            }

            $subj_id = icl_object_id($subj_id, $post_type, true);	
        }	

        // Polylang
        if(function_exists('pll_get_post')) {
            $subj_id = pll_get_post($subj_id);	
        } 	

        return $subj_id;
    }



    /* 
     * Given duration and duration subject - returns ending date in timestamp or mysql formats
     * @param (int) $period
     * @param (string) $period_subj
     * @param (string) $to_get - "time" for timstamp (int) or "mysql" for 'Y-m-d H:i:s'
     * @param (false|string) $starting_date - eventually set a custom starting period in 'Y-m-d H:i:s' format. By default is now
     *
     * @return (string|int) datetime or date string
     */
    public static function get_ending_date($period, $period_subj, $to_get = 'time', $starting_date = false) {

        // no period - return current data
        if(!$period){
            return ($to_get == 'time') ? current_time('timestamp') : current_time('mysql');	
        }

        // sanitize subject	
        if(!in_array($period_subj, array('day', 'week', 'month', 'year'))) {
            $period_subj = 'day';	
        }

        // starting date
        if(!$starting_date) {
            $starting_date = current_time('mysql');
        }
        
        // compile
        $date = new DateTime($starting_date);
        $date->modify('+'. (int)$period .' '.$period_subj);

        return ($to_get == 'time') ? $date->format('U') : $date->format('Y-m-d H:i:s');	
    }

    

    // given time value (seconds) - returns the date
    public static function time_to_date_html($time, $show_time_format = false) {
        if($time == 'unlimited') {
            return __('Unlimited Plan', PCPP_ML);
        }
        $date_format    = get_option('date_format');
        $time_format    = get_option('time_format');
        $to_output      = ($show_time_format) ? date_i18n($date_format, $time) .' '. __('at') .' '. date_i18n($time_format, $time) : date_i18n($date_format, $time);
        
        return '<time title="'. date_i18n($date_format .' - '. $time_format, $time) .' '. get_option('timezone_string') .' timezone">'. $to_output .'</time>';	
    }


    
    // given order ID - return HTML code with icon showing payment date
    public static function order_id_to_paydate_html($order_id) {
        $paydate = get_post_meta($order_id, 'pcpp_payment_date', true);
        if(empty($paydate)) {
            return '';
        }

        $date_format = get_option('date_format');

        return '<span class="dashicons dashicons-clock pcpp_order_paydate" title="'. esc_attr(__('Paid on', PCPP_ML) .': '. date_i18n(get_option('date_format') .' - '. get_option('time_format'), strtotime($paydate) ) .'
         '. get_option('timezone_string')) .' timezone"></span>';	
    }


    
    // e-commerce systems that can be used by the add-on
    public static function avail_ecomm($get_first = false) {
        $avail = array();

        if(is_plugin_active('woocommerce/woocommerce.php')) {
            $avail['woocomm'] = 'WooCommerce';

            // set woocomm version into a constant
            if(!defined('PCPP_WC_VER')) {
                $plugin_folder = get_plugins( '/' . 'woocommerce' );
                $plugin_file = 'woocommerce.php';

                $ver = (isset( $plugin_folder[$plugin_file]['Version'])) ? $plugin_folder[$plugin_file]['Version'] : '2.9'; // fake - but still v2
                define('PCPP_WC_VER', $ver);
            }
        }


        if(!empty($avail) && $get_first) {
            $keys = array_keys($avail);
            return $keys[0];
        } else {
            return $avail;
        }
    }



    // edit expiration date code
    public static function edit_exp_date_code($exp_date) {
        if(empty($exp_date) || $exp_date == 'unlimited') {
            $date = '';
            $hour = '';
            $min = '';	
        } 
        else {
            if(filter_var($exp_date, FILTER_VALIDATE_INT)) {
                $exp_date = date('Y-m-d H:i:s', $exp_date);
            }

            $obj = new DateTime($exp_date);
            $date = $obj->format('Y-m-d');
            $hour = $obj->format('H');
            $min = $obj->format('i');
        }

        $disabled = ($exp_date == 'unlimited') ? 'disabled="disabled"' : '';

        $code = '
        <input type="date" id="pcpp_edit_exp_date" value="'.$date.'" min="'. date('Y-m-d') .'" '. $disabled .' autocomplete="off" /> '. __('at', PCPP_ML) .' 
        <select name="pcpp_edit_exp_hour" id="pcpp_edit_exp_hour" '. $disabled .' autocomplete="off">';

            for($a=0; $a<=23; $a++) {
                $val = ($a < 10) ? '0'.$a : $a;
                $code .= '<option value="'. $val .'" '. selected($val, $hour, false) .'>'. $val .'</option>';		
            }

        $code .= '
        </select> : 
        <select name="pcpp_edit_exp_min" id="pcpp_edit_exp_min" '. $disabled .' autocomplete="off">';

            for($a=0; $a<=60; $a++) {
                $val = ($a < 10) ? '0'.$a : $a;
                $sel = ($val == $min) ? 'selected="selected"' : '';
                $code .= '<option value="'. $val .'" '. selected($val, $min, false) .'>'.$val.'</option>';		
            }

        $code .= '
        </select>';

        return $code;
    }
    
    
    
    
    // given a timestamp, returns a human readable countdown
    public static function get_countdown_txt($timestamp) {
        $time_diff = (int)$timestamp - current_time('timestamp');
	
		//create multi-array with seconds and define values
		$values = array(
			12*30*24*60*60  =>  'year',
			30*24*60*60     =>  'month',
			24*60*60        =>  'day',
			60*60           =>  'hour',
			60              =>  'minute',
		);
	
		// loop over the array
		foreach ($values as $secs => $point){
			$res = floor($time_diff / $secs);
			
			// translatable strings
			switch($point) {
				case 'year' : $txt = ($res > 1) ? __('years', PCPP_ML) : __('year', PCPP_ML); break; 
				case 'month': $txt = ($res > 1) ? __('months', PCPP_ML) : __('month', PCPP_ML); break;
				case 'day'  : $txt = ($res > 1) ? __('days', PCPP_ML) : __('day', PCPP_ML); break;	
				case 'hour' : $txt = ($res > 1) ? __('hours', PCPP_ML) : __('hour', PCPP_ML); break;	
				case'minute': $txt = ($res > 1) ? __('minutes', PCPP_ML) : __('minute', PCPP_ML); break;	
			}
			
			$txt = $res. ' ' .$txt;
			if($res >= 1) {
				break;	
			} 
        }
        
        return $txt;
    }
    
    
}
