<?php
// STATIC METHODS MANAGING USER SUBSCRIPTION

class pcpp_user_subscr_static {
    
	
	/* SETUP TRIAL PERIOD META - given user ID set trial metas if there's any
	 * @param (int) $user_id 
	 * @return (bool)
	 */
	public static function setup_trial_meta($user_id, $plan_id) {
		global $pcpp_subscr, $pc_meta;
		
		if($pcpp_subscr->is_trial_enabled()) {
			$pc_meta->update_meta($user_id, 'pcpp_subscr_status', 'trial');	
			$pc_meta->update_meta($user_id, 'pcpp_trial_ending', pcpp_static::get_ending_date($pcpp_subscr->trial_duration, $pcpp_subscr->trial_dur_type) );
            
            // PCPP-ACTION - triggered as soon as a new trial period is set for a user
            do_action('pcpp_user_started_trial', $user_id, $plan_id);
		}	
		return true;
	}
    
    

	
	
	
	/* MANAGE USER ORDERS - add or remove orders related to a user
	 * @param (int) $user_id = privateContent user id
	 * @param (int) $order_id = order ID to add or remove
	 * @param (string) $action = could be "add" or "remove"
     * @paramm (bool) $recurr_renewal = whether operation is the result of a recurring payment renewal 
	 *
	 * @return (bool) true if operation was successful - otherwise false
	 */ 
	public static function manag_orders($user_id, $order_id, $action, $recurr_renewal = false) {
		if(!in_array($action, array('add', 'remove'))) {
            return false;
        }
		global $pc_meta;
		
		// get meta
		$db_val = $pc_meta->get_meta($user_id, 'pcpp_orders');
		if(empty($db_val) || !is_array($db_val)) {
			$db_val	= array();
		}
        
		// add
		if($action == 'add') {
			$db_val[] = (int)$order_id;
			asort($db_val);
			$new_val = $db_val;
			
			self::set_main_order($user_id, $order_id, $recurr_renewal);
		}
		
        
		// remove
		else {
			$new_val = array();
			foreach($db_val as $db_order_id) {
				if($db_order_id != $order_id) {
                    $new_val[] = $db_order_id;
                }	
			}
			
			if(count($new_val)) {
				asort($new_val);

				if($order_id == $pc_meta->get_meta($user_id, 'pcpp_active_order')) {
					self::set_main_order($user_id, end($new_val));
				}
			}
			else {
				// no orders left - set no_act_order status
				$pc_meta->update_meta($user_id, 'pcpp_subscr_status', 'no_act_order');	
				$pc_meta->update_meta($user_id, 'pcpp_plan','');
				$pc_meta->update_meta($user_id, 'pcpp_subscr_end', '');
			}
		}
		
		$result = (bool)$pc_meta->update_meta($user_id, 'pcpp_orders', $new_val);
		return $result; 
	}


    
    
	 
	/* SET USER MAIN ORDER - will be taken into consideration to manage subscription expiration and subscription status
	 * @param (int) $user_id
	 * @param (int) $order_id - new main order ID
     * @paramm (bool) $recurr_renewal = whether operation is the result of a recurring payment renewal 
	 */
	public static function set_main_order($user_id, $order_id, $recurr_renewal = false) {
		global $pcpp_subscr, $pc_meta;
		
        // set initial meta		
        $pc_meta->update_meta($user_id, 'pcpp_active_order', $order_id);
        
        
        // set elaborated metas
        if(!$recurr_renewal) {
            $linked_to_subscr = pcpp_woo_subscr_static::get_order_subscr($order_id);
            $target_for_status = ($linked_to_subscr) ? $linked_to_subscr->get_id() : $order_id;
            
            $status   = (string)$pcpp_subscr->get_order_status($target_for_status); // get order status
            $plan_id  = $pcpp_subscr->get_order_plan_id($order_id); // associated plan

            // security check
            if(!is_numeric($plan_id) || $plan_id < 2) {
                return false;    
            }
            
            if(PCPP_ECOMMERCE == 'woocomm') {
                $expiration = $pcpp_subscr->order_plan_expiration($order_id); // ending date
            }


            // plan extension order? expiration is valid only if paid
            if($pcpp_subscr->is_plan_expir_ext_order($order_id) && $status != 'active') {
                $status = 'inherit'; 
            }
            else {

                // check if already expired	
                if($expiration != 'unlimited' && $expiration < current_time('timestamp'))	{
                    $status = 'expired';	
                }
            }

            $pc_meta->update_meta($user_id, 'pcpp_plan', $plan_id);
            $pc_meta->update_meta($user_id, 'pcpp_subscr_end', $expiration);
            $pc_meta->update_meta($user_id, 'pcpp_subscr_status', $status);
            
            $pc_meta->update_meta($user_id, 'pcpp_recurr_subscr', (string)pcpp_woo_subscr_static::get_order_subscr_id($order_id) );
        }

        // PCPP-ACTION - allow extra operations when new user main order changed
        do_action('pcpp_new_user_main_order', $user_id, $order_id, $recurr_renewal); 	
        
		return true;
	}
    
    
	
    
	
	/* CHECK USER'S SUBSCRIPTION EXPIRATION DATE 
	 * if expired, update status 
	 * checks also trial - if expired set to unpaid and setup pcpp_expired_trial global
	 *
	 * @param (int) $user_id
     * @param (array|false) if you already have user data, why performing another query? 
	 * @return (bool/string) 
	 	- true if not associated to PCPP
		- status string
	 */
	public static function check_subscr_expir($user_id, $user_data = false) {
		global $pcpp_subscr, $pc_users, $pc_meta;
        
		// get user meta
        if(is_array($user_data)) {
            $ud = $user_data;    
        }
        else {
            $to_get = array('pcpp_plan', 'pcpp_active_order', 'pcpp_subscr_status', 'pcpp_trial_ending', 'pcpp_subscr_end', 'pcpp_orders', 'pcpp_recurr_subscr');
            $ud = $pc_users->get_user($user_id, array('to_get' => $to_get));
        }
		$is_in_trial = ($ud['pcpp_subscr_status'] == 'trial') ? true : false;
        
        
		// if no related order - grant access
		if(empty($ud['pcpp_plan']) || empty($ud['pcpp_orders'])) {
			return true;
		}
		
		
		// expired or pending payment
		if(in_array($ud['pcpp_subscr_status'], array('unpaid', 'no_act_order', 'expired'))) {
			return $ud['pcpp_subscr_status'];
		}
		
		// trial period - check expiration and eventually set new status
		elseif($ud['pcpp_subscr_status'] == 'trial') {
			if((int)$ud['pcpp_trial_ending'] <= (int)current_time('timestamp')) {
				
				// get user active order and set its status or no order found - set to expired to allow new order creation
				$new_status = (empty($ud['pcpp_active_order'])) ? 'expired' : $pcpp_subscr->get_order_status($ud['pcpp_active_order']);
				$pc_meta->update_meta($user_id, 'pcpp_subscr_status', $new_status);

				if($new_status == 'expired') {
					// remove expired plan's notification flag
					$pc_meta->delete_meta($user_id, 'pcpp_expire_subscr_notified');	
				}
				$GLOBALS['pcpp_expired_trial'] = true; 

                // PCPP-ACTION - allow extra operations when trial period ended and user did not pay yet for the subscription
                do_action('pcpp_trial_ended', $user_id, $ud['pcpp_plan']);
                
				return $new_status;		
			}
			else {
                if(isset($GLOBALS['pcpp_expired_trial'])) {
                    unset($GLOBALS['pcpp_expired_trial']);    
                }
                
				return 'trial';
			}	
		}
		
        // inherit (plan duration extension) - refer to previous order
        elseif($ud['pcpp_subscr_status'] == 'inherit') {
            if(count($ud['pcpp_orders']) < 2) {
                return false;    
            }
            
            $user_orders = $ud['pcpp_orders'];
            asort($user_orders);
            
            $target_order_id = (int)array_values(array_reverse($user_orders))[1];        
            $order_expir = $pcpp_subscr->order_plan_expiration($target_order_id);
            
            $status = ($pcpp_subscr->get_order_status($target_order_id) == 'active' && (!is_numeric($order_expir) || $order_expir > current_time('timestamp'))) ? 'active' : 'expired';
            return $status;
        }
        
        // suspended (recurring subscription) - be sure its last order is still valid otherwise mark as expired
        elseif($ud['pcpp_subscr_status'] == 'suspended' && !empty($ud['pcpp_recurr_subscr'])) {
            
            // be sure suspended status is still valid instead of "unpaid"
            pcpp_wc_order_status_change($ud['pcpp_recurr_subscr'], 'foo', 'on-hold');

            if($pc_meta->get_meta($user_id, 'pcpp_subscr_status') == 'suspended') {
                return pcpp_woo_subscr_static::suspended_subscr_is_still_valid($ud['pcpp_recurr_subscr'], $user_id, $ud);
            } else {
                return 'unpaid';    
            }
        }
        
		// active - check expiration
		elseif($ud['pcpp_subscr_status'] == 'active') {
            
            // woo subscr will autonomously change status
			if(empty($ud['pcpp_recurr_subscr']) && $ud['pcpp_subscr_end'] != 'unlimited' && (int)$ud['pcpp_subscr_end'] <= (int)current_time('timestamp')) {
				
				$pc_meta->update_meta($user_id, 'pcpp_subscr_status', 'expired'); // update status to expired
				$pc_meta->delete_meta($user_id, 'pcpp_expire_subscr_notified');	// remove expired plan's notification flag
				
                self::clean_pending_expir_ext_order($user_id);
                
				// PCPP-ACTION - allow extra operations when user subscription expired
				do_action('pcpp_expired_subscription', $user_id, $ud['pcpp_plan'], $is_in_trial); 
				
				return 'expired';
			}	
			else {
				return 'active';
			}
		}
		
		return false;
	}
	
    
    
    
    
    /* 
     * CHECK WHETHER USER MAY ACCESS PvtContent BASING ON STATUS AND RELATED DATA
     * @return (bool) 
     */
	public static function may_access($user_id) {
        global $pc_users, $pcpp_subscr;
        
        $to_get = array('status', 'pcpp_plan', 'pcpp_active_order', 'pcpp_subscr_status', 'pcpp_trial_ending', 'pcpp_subscr_end', 'pcpp_orders', 'pcpp_recurr_subscr');
		$ud = $pc_users->get_user($user_id, array('to_get' => $to_get));
        
        // as first - check for subscription status changes
        $status = self::check_subscr_expir($user_id, $ud);
        if(is_bool($status) === true) {
            return $status;    
        }
        
        
        // statuses not requiring further investigations
        if(in_array($status, array('no_act_order', 'trial', 'active'))) {
            return true;    
        }
        elseif(in_array($status, array('unpaid', 'expired'))) {
            return false;        
        }
        
        
        // woo subscr - suspended means it still has active plan
        elseif($status == 'suspended' && !empty($ud['pcpp_recurr_subscr']) && pcpp_woo_subscr_static::supports_woo_subscr()) {
            return true;    
        }
    
        return false; // fallback
    }
    
    
    
    
    
    /* 
     * KNOW WHETHER USER HAS GOT A PENDING ORDER RELATED TO A PLAN CHANGE OR DURATION EXTENSION 
     * @return (false|int) - false or order ID
     */
	public static function has_pending_expir_ext_order($user_id, $consider_unpaid = false) {
        global $pcpp_subscr, $pc_meta;
        
		$user_orders = $pc_meta->get_meta($user_id, 'pcpp_orders');
		if(empty($user_orders) || !is_array($user_orders)) {
			return false;
		}
        
        asort($user_orders);
        $user_orders = array_reverse($user_orders);
        
        $last_order_id = array_values($user_orders)[0];	
        
        $to_consider = array('inherit');
        if($consider_unpaid) {
            $to_consider[] = 'unpaid';    
        }
        
        return ($pcpp_subscr->is_plan_expir_ext_order($last_order_id) && in_array($pcpp_subscr->get_order_status($last_order_id), $to_consider)) ? $last_order_id : false;
	}
    
    

    
    /* CLEAN UNPAID DURATION-EXTENSION / PLAN-CHANGE ORDER FOR SPECIFIC USER */
	public static function clean_pending_expir_ext_order($user_id, $consider_unpaid = true) {
        global $pcpp_subscr; 
        
        $order_id = self::has_pending_expir_ext_order($user_id, $consider_unpaid);
        if(!$order_id) {
            return false;    
        }
        
        self::manag_user_orders($user_id, $order_id, 'remove'); 
        wp_delete_post($order_id, true);   
        
        return true;
	}
    

    
}
