<?php
// STATIC METHODS MANAGING INTERACTIONS WITH WOOCOMMERCE SUBSCRIPTIONS ADD-ON
class pcpp_woo_subscr_static {
    
    
    // know whether WP user sync is enabled, required and 
    public static function supports_woo_subscr() {
        return (
            get_option('pg_wp_user_sync') && get_option('pg_require_wps_registration') &&
            get_option('pg_require_wps_registration') && is_plugin_active('woocommerce-subscriptions/woocommerce-subscriptions.php')
        ) ? true : false;    
    }
    
    
    
    
    /* know whether a order ID is related to a subscription */
    public static function order_is_subscr($order_id) {
        return (get_post_type($order_id) == 'shop_subscription' && get_post_meta($order_id, 'is_pvtcontent_subscr', true)) ? true : false;
    }
    
    
    
    
    /* know whether a normal order belongs to a pvtConten subscription by checking its item */
    public static function order_belongs_to_subscr($order_id) {
        global $pcpp_subscr;
        $products = $pcpp_subscr->get_order_products($order_id);

        if(!isset($products['plan_id'])) {
            return false;    
        }
        
        return self::plan_is_subscr($products['plan_id']); 
    }
    
    
    
    
    /* know whether a plan ID is a subscription */
    public static function plan_is_subscr($plan_id) {
        return (WC_Product_Factory::get_product_type($plan_id) == 'subscription' && get_post_meta($plan_id, '_is_pvtcontent_plan', true) == 'yes') ? true : false;    
    }
    
    
    
    
    /* given an order ID, returns the related subscription object */
    public static function get_order_subscr($order_id) {
        if(!function_exists('wcs_get_subscriptions_for_order')) {
            return false;    
        }
        
        $rel_woo_subscr = wcs_get_subscriptions_for_order($order_id, array('order_type' => array('parent', 'renewal')));
        return (!empty($rel_woo_subscr)) ? array_values($rel_woo_subscr)[0] : false;    
    }
    
    
    
    
    /* given an order ID, returns the related subscription ID */
    public static function get_order_subscr_id($order_id) {
        $rel_woo_subscr = self::get_order_subscr($order_id); 
        return (!empty($rel_woo_subscr)) ? $rel_woo_subscr->get_id() : false; 
    }
    
    
    
    
    /* know if we are actually in the woocommerce checkout page and paying for a PCPP subscription */
    public static function is_pcpp_woo_subscr_checkout() {
        if(PCPP_ECOMMERCE != 'woocomm' || !self::supports_woo_subscr() || !is_checkout() || !WC_Subscriptions_Cart::cart_contains_subscription()) {
            return false;    
        }

        $items = array_values(WC()->cart->get_cart());
        $product_id = $items[0]['data']->get_id();

        return self::plan_is_subscr($product_id);   
    }
    
    
    
    
    /* 
     * Create WooCommerce subscription linked to initial order and sets up related user meta
     * @return (wp_error|object) new subscription's post object or a WP error object
     */
    public static function create_subscr($order_id, $plan_id, $wp_user_id, $user_id) {
        global $pcpp_subscr, $pc_meta;
        $plan_data = $pcpp_subscr->get_plan_data($plan_id);
        
        $args = array(
            'status'           => 'pending',
            'order_id'         => $order_id,
            'customer_id'      => (int)$wp_user_id,
            'billing_period'   => $plan_data['duration_type'],
            'billing_interval' => $plan_data['duration']
        );
        $new_subscription = wcs_create_subscription($args);  
        
        
        // be sure product is attached to subscription if first payment was free
        if(!is_wp_error($new_subscription) && empty($new_subscription->get_items())) {
            $product_obj = wc_get_product($plan_id);
            $new_subscription->add_product($product_obj);
            
            $new_subscription->set_address($GLOBALS['pcpp_woo_billing_data'], 'billing');
            
            // there is a trial involved - start subscription at the end of it
            if(isset($GLOBALS['pcpp_initial_registr']) && $pc_meta->get_meta($user_id, 'pcpp_subscr_status') == 'trial') {
                $trial_end_time = (int)$pc_meta->get_meta($user_id, 'pcpp_trial_ending');
                
                $prod_data = $pcpp_subscr->get_plan_data($plan_id);
                $end_date = (int)$prod_data['duration_secs'] + $trial_end_time;
                
                $dates = array(
                    'start'         => wp_date('Y-m-d H:i:s', current_time('timestamp')),
                    //'trial_end'     => wp_date('Y-m-d H:i:s', $trial_end_time),
                    'next_payment'  => wp_date('Y-m-d H:i:s', $end_date),
                    'end'           => wp_date('Y-m-d H:i:s', ($end_date + 10)),
                );
                $new_subscription->update_dates($dates);
            }
            
            $new_subscription->calculate_totals();
        }
        
        return $new_subscription;
    }
    
    
    
    
    /* Given the subscription ID, returns the next payment due date in timestamp or human format (no GMT) */
    public static function next_due_date($subscr_id, $human_format = true) {
        if(!function_exists('wcs_get_subscription') || !$subscr_id) {
            return false;    
        }

        $woo_subscr_obj = wcs_get_subscription($subscr_id);

        $due_date = get_date_from_gmt( $woo_subscr_obj->calculate_date('next_payment'));
        return ($human_format) ? pcpp_static::time_to_date_html(strtotime($due_date)) : strtotime($due_date);
    }
    
    
    
    
    /* 
     * Passing a suspended order ID, checks its last order validity and eventually sets subscription as expired
     * @param (array) $user_data = array('pcpp_plan', 'pcpp_active_order', 'pcpp_subscr_status', 'pcpp_trial_ending', 'pcpp_subscr_end', 'pcpp_orders', 'pcpp_recurr_subscr')
     * @return (string) active or expired
     */
    public static function suspended_subscr_is_still_valid($subscr_id, $user_id, $user_data) {
        global $pcpp_subscr;
        
        $order_id = (int)$user_data['pcpp_active_order'];
        $order = wc_get_order($order_id);
        if(!is_object($order) || !in_array($order->get_status(), array('processing', 'completed'))) {
            return 'expired';    
        }
        
        
        $order_exp = $pcpp_subscr->order_plan_expiration($order_id);
        if(is_numeric($order_exp) && $order_exp < current_time('timestamp')) { // expired

            $subscr = wc_get_order($subscr_id);
            
            if(is_object($subscr)) {
                $subscr->update_status('expired');
            }
            return 'expired';
        }

        return 'active';
    }
} 