<?php

//////////////////////////////////////////////////////
//////////////// COUPON CHECK ////////////////////////
//////////////////////////////////////////////////////

function pcpp_coupon_check() {
	if(!$GLOBALS['pcpp_enabled'] || !isset($_POST['type']) || $_POST['type'] != 'pcpp_coupon_check') {
        return false;
    }
	global $pcpp_subscr;
	
	// check coupon existence
	if(!isset($_POST['pcpp_coupon']) || empty($_POST['pcpp_coupon'])) {
		die(json_encode(array(
            'status' => 'error',
            'mess' => __('Please insert a valid coupon', PCPP_ML)
        )));
	}
	$coupon = (string)$_POST['pcpp_coupon'];
	
    // is on registration form?
    $is_reg_form = (isset($_POST['is_reg_form']) && (int)$_POST['is_reg_form']) ? true: false;    
    if($is_reg_form) {
        $GLOBALS['pcpp_initial_registr'] = true;    
    }
     
    $curr_user_plan = (isset($_POST['curr_user_plan']) && (int)$_POST['curr_user_plan']) ? (int)$_POST['curr_user_plan'] : false;
    
    
	// match coupon against plans
	if(PCPP_ECOMMERCE == 'woocomm') {
		$coupon_inst = new WC_Coupon($coupon);
		$coup_amount = $coupon_inst->get_amount();
		
		if(empty($coup_amount)) {
			die(json_encode(array(
                'status' => 'error',
                'mess' => __('Coupon not found', PCPP_ML)
            )));	
		}
		
		// calculate new prices for each plan (and duration extensions)
		$new_prices = array();
        $dur_ext    = array();
        
		foreach( $pcpp_subscr->get_plans(false) as $plan_id => $name) {
			$product = new WC_Product($plan_id);
			$price = $product->get_price();
            $new_plan_price = $price;
            
			if(
                $coupon_inst->is_valid_for_product($product) && 
                $price >= $coupon_inst->get_minimum_amount() && 
                (!$coupon_inst->get_maximum_amount() || $price <= $coupon_inst->get_maximum_amount())
            ) {
				$discount_amount = $coupon_inst->get_discount_amount($price, null, true);
				$new_plan_price = round($price - $discount_amount, 2);
                
				// 100% discount?
				if($new_plan_price <= 0) {
					$new_prices[$plan_id] = __('free', PCPP_ML);
				} else {
					$new_prices[$plan_id] = strip_tags(wc_price($price - $discount_amount));	
				}
			}
            
            
            // duration extensions for product
            if(get_option('pcpp_use_duration_ext', 'always') != 'no') {
                $plan_dur_exts = pcpp_dur_ext_static::get_plan_dur_exts($plan_id, 'db_id');

                if(!empty($plan_dur_exts)) {
                    foreach($plan_dur_exts as $pde_id => $pde_data) {
                        $de_price = $pde_data['price'];

                        if(
                            $de_price >= $coupon_inst->get_minimum_amount() && 
                            (!$coupon_inst->get_maximum_amount() || $de_price <= $coupon_inst->get_maximum_amount())
                        ) {
                            $discount_amount = $coupon_inst->get_discount_amount($de_price, null, true);
                            $discounted_amount = round($de_price - $discount_amount, 2);
                            
                            // current user plan + renewal/change form = add plan price
                            if($curr_user_plan == $plan_id) {
                                $discounted_amount = $discounted_amount + $new_plan_price;            
                            }

                            // 100% discount?
                            if($discounted_amount <= 0) {
                                $dur_ext[$pde_id] = __('free', PCPP_ML);
                            } else {
                                $dur_ext[$pde_id] = strip_tags(wc_price($discounted_amount));	
                            }  
                        }
                    }
                }
            }
		}
		
        
		
		// no discount available
		if(empty($new_prices) && empty($dur_ext)) {
			die(json_encode(array(
                'status' => 'error', 
                'mess' => __("Sorry, this coupon isn't valid for these subscriptions", PCPP_ML)
            )));		
		}
		else {
			// there's at least one subscription, ok
			die(json_encode( array(
                'status'    => 'success', 
                'prices'    => $new_prices,
                'dur_ext'   => $dur_ext
            )));		
		}
	}
	
	die();
}
add_action('wp', 'pcpp_coupon_check', 2); // use this hook to allow constants setup







/////////////////////////////////////////////////////////////
// RENEW/CHANGE SUBSCRIPTION - OPTIONALLY SPECIFY NEW PLAN //
/////////////////////////////////////////////////////////////

function pcpp_ajax_renew_subscription() {
	if(!$GLOBALS['pcpp_enabled'] || !isset($_POST['type']) || $_POST['type'] != 'pcpp_renew_order') {
        return false;
    }
	global $pc_users, $pc_meta, $pcpp_subscr;
	
    // available plans
    $avail_plans = $pcpp_subscr->get_plans(false, true);
    
    
    // plan sanitization
    if(!isset($_POST['pcpp_sel_plan']) || !isset($avail_plans[ $_POST['pcpp_sel_plan'] ])) {
        die( json_encode(array(
			'status' => 'error', 
			'error' => __('Missing or forbidden plan ID', PCPP_ML)
		)));	        
    }
    $new_plan_id = (int)$_POST['pcpp_sel_plan'];
    
    
    // duration extension?
    $dur_ext = false;
    if(get_option('pcpp_use_duration_ext', 'always') == 'always' && isset($_POST['pcpp_dur_ext'])) {
        $dur_ext = (int)$_POST['pcpp_dur_ext'];            
        $de_data = pcpp_dur_ext_static::get_ext_data($dur_ext, $new_plan_id, 'db_id');
        
        if(!$de_data) {
            die( json_encode(array(
                'status' => 'error', 
                'error' => __('Wrong plan extension ID', PCPP_ML)
            )));	         
        }
    }
    
    
    // user ID sanitization
    if(!isset($GLOBALS['pc_user_id']) && !isset($_POST['pcpp_uid'])) {
        die( json_encode(array(
			'status' => 'error', 
			'error' => __('Wrong or missing user ID', PCPP_ML)
		)));	
    }
    $is_renewal = (isset($GLOBALS['pc_user_id'])) ? false : true;
    $user_id = (isset($GLOBALS['pc_user_id'])) ? $GLOBALS['pc_user_id'] : (int)$_POST['pcpp_uid'];

    
    // security key check
    if(!isset($_POST['pcpp_key']) || !wp_check_password($user_id, stripslashes($_POST['pcpp_key']))) {
        die( json_encode(array(
			'status' => 'error', 
			'error' => 'Wrong security key'
		)));	        
    }
    
    
    // be sure user is enabled (and exists) and already fetch order data
    $args = array(
        'to_get' => array('status', 'pcpp_plan', 'pcpp_subscr_status', 'pcpp_active_order', 'pcpp_subscr_end', 'pcpp_recurr_subscr'),
    );
    $user_data = $pc_users->get_user($user_id, $args);
    
    if(!$user_data || $user_data['status'] !== '1') {
        die( json_encode(array(
            'status' => 'error', 
            'error' => __('User not enabled', PCPP_ML)
        )));	          
    }
    
    
    // is just a subscription duration extension?
    $is_subscr_dur_ext = ((int)$user_data['pcpp_plan'] === $new_plan_id && $user_data['pcpp_subscr_status'] == 'active') ? true : false;
    
    // plan change behavior
    $order_change_behav = get_option('pcpp_order_change_behav', 'no_change'); 
    
    
    // if no plan change is allowed
    if($order_change_behav == 'no_change' && (int)$user_data['pcpp_plan'] !== $new_plan_id) {
        die( json_encode(array(
			'status' => 'error', 
			'error' => __('Forbidden plan ID', PCPP_ML)
		)));	               
    }
    
    
    // changing plan? user has got a discount?
    $fees = array();
    if($order_change_behav == 'discount' && (int)$user_data['pcpp_plan'] !== $new_plan_id && $user_data['pcpp_subscr_status'] == 'active') {
        $discount_amount = $pcpp_subscr->plan_change_discount($user_data['pcpp_active_order'], $user_data['pcpp_plan'], $user_data['pcpp_subscr_end']);   
        
        if($discount_amount) {
            $fees[] = array(
                __('Current subscription credit'),
                $discount_amount * -1
            );    
        }
    }
    
    
    // if user has already got a plan change/extension order - remove it
    pcpp_user_subscr_static::clean_pending_expir_ext_order($user_id);
            
    
    // cancel eventual past recurring payments
    if(class_exists('WC_Subscriptions_Manager') && !empty($user_data['pcpp_recurr_subscr'])) {
        WC_Subscriptions_Manager::maybe_cancel_subscription( (int)$user_data['pcpp_recurr_subscr'] );        
    }
    
    
	// create order
    $plan_to_pass = ($dur_ext) ? array($new_plan_id, $dur_ext) : $new_plan_id; 
    $coupon = (isset($_POST['pcpp_coupon']) && !empty($_POST['pcpp_coupon'])) ? (string)$_POST['pcpp_coupon'] : false;
    
    $order_obj = $pcpp_subscr->create_order($user_id, $plan_to_pass, array(), $fees, $coupon);
    $order_id = $pcpp_subscr->order_obj_to_id($order_obj);	

    if(!$order_id) {
        die( json_encode(array(
			'status' => 'error', 
			'error' => __('Error creating new order - contact site administrator', PCPP_ML)
		)));	
    }
    
    
    // is extending an active subscription? add meta with actual user expiration in 'Y-m-d H:i:s' format
    if(!$is_renewal && (int)$user_data['pcpp_plan'] === $new_plan_id) {
        update_post_meta($order_id, 'pcpp_is_expir_ext', date('Y-m-d H:i:s', $user_data['pcpp_subscr_end']));
    }

    
    // set new main order and manage access metas
    pcpp_user_subscr_static::manag_orders($user_id, $order_id, 'add');	

    // remove expired plan's notification flag
    $pc_meta->delete_meta($user_id, 'pcpp_expire_subscr_notified');
	
	
    // redirect url
    $redirect = $pcpp_subscr->checkout_url($order_id);
    if($pcpp_subscr->order_is_free($order_id, $order_obj)) {
        $redirect = ($is_subscr_dur_ext) ? 'none' : 'refresh';    
    }
    
    // succcess message
    $mess = __('Order successfully created!', PCPP_ML);
    
    if($pcpp_subscr->order_is_free($order_id, $order_obj)) {
        $mess = ($is_subscr_dur_ext) ? __('Subscription successfully extended!', PCPP_ML) : __('Subscription successfully changed!', PCPP_ML);    
    }
    
    // not free be sure user is in "unpaid" status (on woo subscr it is set as expired somehow) 
    else {
        $pc_meta->update_meta($user_id, 'pcpp_subscr_status', 'unpaid');	        
    }
        
 
	// json to return
    echo json_encode(array(
        'status'    => 'success',
        'url'       => $redirect,
        'mess'      => $mess,
    ));	
    die();
}
add_action('wp', 'pcpp_ajax_renew_subscription', 2); // use this hook to allow constants setup
