<?php
// PRIVATECONTENT INTEGRATIONS - FRONT SIDE


// USER PERMISSIONS - check if allowed categories are associated to plans and match with user
// overrides pvtContent checks if a plan is involved in allows or blocks
function pcpp_extra_user_check($to_return, $user_cats, $allowed, $blocked) {
	global $pc_meta, $pcpp_subscr;
    if(!isset($GLOBALS['pc_user_id'])) {
        return $to_return;    
    }
    
	$user_id = $GLOBALS['pc_user_id'];
		
	// if pcpp disabled - do nothing
	if(!$GLOBALS['pcpp_enabled']) {
        return $to_return;
    }

	
	// allow involves also PCPP?
	$allowed_pcpp = array();
	foreach($allowed as $cat) {
		if(strpos($cat, 'PCPP_') !== false) {
			$allowed_pcpp[] = str_replace('PCPP_', '', $cat);	
		}
	}
	
	// block involves also PCPP?
	$blocked_pcpp = array();
	foreach($blocked as $cat) {
		if(strpos($cat, 'PCPP_') !== false) {
			$blocked_pcpp[] = str_replace('PCPP_', '', $cat);	
		}
	}
	
	// not involved - skip check
	if(empty($allowed_pcpp) && empty($blocked_pcpp)) {
        return $to_return;
    }
	

	// get meta and cache it to avoid multi calls
	if(isset($GLOBALS['pcpp_euc_user_plan'])) {
		$user_plan = $GLOBALS['pcpp_euc_user_plan']; 	
	} else {
		$user_plan = $pc_meta->get_meta($user_id, 'pcpp_plan');
		$GLOBALS['pcpp_euc_user_plan'] = $user_plan;	
	}
	
	/////
	
	// filter allows
	if(!empty($allowed_pcpp)) {
		$to_return = (in_array($user_plan, array_unique($allowed_pcpp))) ? 1 : 2;		
	}
	
	// filter blocks
	if(!empty($blocked_pcpp) && in_array($user_plan, array_unique($blocked_pcpp)) ) {
		$to_return = 2;		
	}
	
	return $to_return;
}
add_filter('pc_extra_user_check', 'pcpp_extra_user_check', 10, 4);





// PERSISTENT LOGGED USERS CHECK - every 15 minutes
function pcpp_logged_check_cron() {
	if(!is_admin() && $GLOBALS['pcpp_enabled'] && !isset($GLOBALS['pcpp_already_checked_login']) && pc_user_logged(false)) {
		global $pc_meta, $pcpp_subscr;
		$user_id = $GLOBALS['pc_user_id'];
		
        // not if user can still login if is not active
        if(get_option('pcpp_dont_logout_user', false)) {
            return true;        
        }
        
		// only for users associated with plans
		if(!$pc_meta->get_meta($user_id, 'pcpp_plan')) {
            return true;
        }

		// control last check date
		$last_check = (int)$pc_meta->get_meta($user_id, 'pcpp_last_check'); 
		$curr_time = (int)current_time('timestamp');

		if(($curr_time - $last_check) > (60) ) {
			if(!pcpp_user_subscr_static::may_access($user_id)) {
                
                /* PCPP-FILTER - allow control over logout of users not having valid PCPP subscription: true to process - false to abort  */
                $clearance = apply_filters('pcpp_logged_check_logout_clearance', true, $user_id);
                
                if($clearance) {
				    pc_logout(); 
                }
			}
			
			$pc_meta->update_meta($user_id, 'pcpp_last_check', $curr_time); 
		}
	}
}
add_action('wp', 'pcpp_logged_check_cron', 100); // low priority to let PC doing its works and PCPP constant setup





// LOGIN CHECK - subscription checks
function pcpp_login_check($cust_mess, $user_id) {
	global $post, $pc_users, $pc_meta, $pc_wp_user, $pcpp_subscr;

	// if there's already a message - return it
	if(!empty($cust_mess)) {
        return $cust_mess;
    }
	
	// if pcpp disabled - allow
	if(!$GLOBALS['pcpp_enabled']) {
        return false;
    }
    
    // if user can still login if is not active - allow
    if(get_option('pcpp_dont_logout_user', false)) {
        return false;        
    }
	
	// global to avoid persistent logged user check
	$GLOBALS['pcpp_already_checked_login'] = true;
	
	// check subscription
	if(pcpp_user_subscr_static::may_access($user_id)) {
        return $cust_mess;
    }
    
    
    // get user active order
    $active_order  = (int)$pc_meta->get_meta($user_id, 'pcpp_active_order');
	$user_plan     = (int)$pc_meta->get_meta($user_id, 'pcpp_plan');
    $subscr_status = pcpp_user_subscr_static::check_subscr_expir($user_id);
    
    
    // Woo subscr - setup a special cookie to guarantee user already used right credentials before logging its WP synced mirror
    if(in_array($subscr_status, array('unpaid', 'expired')) && pcpp_woo_subscr_static::supports_woo_subscr() && $pc_meta->get_meta($user_id, 'pcpp_recurr_subscr')) {
        $wp_user_id = $pc_wp_user->pvtc_is_synced($user_id, true);    
        
        if($wp_user_id) {
            $meta_key   = 'pcpp_woo_subscr_login_trick_token';
            $token      = md5(time());
            
            update_user_meta($wp_user_id, $meta_key, $token);
            pc_static::setcookie($meta_key, $token, (60 * 60 * 30) + time()); // 30 mins
        }
        
        // in checkout page? return only the link
        if(get_permalink( wc_get_page_id('checkout')) == pc_static::curr_url()) {
            return sprintf(__('Thanks for confirming your credentials, please click %s this link', PCPP_ML), '<a href="'. $pcpp_subscr->checkout_url($active_order) .'">') . '</a>';    
        }
    }
    

	// UNPAID - default or expired trial mess
	if($subscr_status == 'unpaid') {
		$GLOBALS['pc_skip_antibruteforce'] = true;
        $checkout_url = ($active_order) ? $pcpp_subscr->checkout_url($active_order) : '';
		
		if(isset($GLOBALS['pcpp_expired_trial'])) { // expired trial
			$exp_trial_mess = get_option('pcpp_exp_trial_mex');
            
			if(empty($exp_trial_mess)) {
                $exp_trial_mess = __('Hello, your trial period ended', PCPP_ML);
            }
			return $exp_trial_mess .'<br/><a href="'.$checkout_url.'">'. __('pay now', PCPP_ML) .'</a>';
		} 
		else {
			$unpaid_mess = get_option('pcpp_unpaid_mex');
            
			if(empty($unpaid_mess)) {
                $unpaid_mess = __('Hello, your subscription is unpaid', PCPP_ML);
            }
			return $unpaid_mess .'<br/><a href="'. $checkout_url .'">'. __('pay now', PCPP_ML) .'</a>';
		}
	}

    
    // EXPIRED
	elseif($subscr_status == 'expired') {
        $GLOBALS['pc_skip_antibruteforce'] = true;
        
        $renew_pag = pc_static::wpml_translated_pag_id( get_option('pcpp_order_renew_page'));
        $avail_renew_plans = $pcpp_subscr->get_plans(false, true);
        
        // base message
        $exp_plan_mess = get_option('pcpp_expired_mex');
		if(empty($exp_plan_mess)) {
			$exp_plan_mess = __('Hello, your subscription expired', PCPP_ML);
		}
        
        
        // be sure user can renew its subscription
        if(($user_plan && get_post_meta($user_plan, 'pcpp_no_renewal', true)) || !count($avail_renew_plans)) {
            return $exp_plan_mess;
        }

        
		//// if allow to change plan, link to specific page - otherwise inform and add code for JS handler to create order
		// code for handler
		if(empty($renew_pag)) {
			$link_url = 'javascript:void(0)'; 
			$link_params = 'class="pcpp_renew_plan_btn" data-uid="'. (int)$user_id .'" data-pid="'. $user_plan .'" data-key="'. esc_attr(wp_hash_password($user_id)) .'"';
		}
		
        
		// link to change plan page
		else {
			$link_url = add_query_arg(array(
                    'pcpp_action'  => 'renew_subscr',
					'pcpp_renew'   => wp_hash_password($user_id),
					'uid'          => $user_id,
				), 
				get_permalink($renew_pag)
			);	
			$link_params = '';
		}

        return $exp_plan_mess .'<br/><a href="'. esc_attr($link_url) .'" '. $link_params .'>'. __('renew it', PCPP_ML) .'</a>';
	}
	
    // fallback
	return $cust_mess;
}
add_filter('pc_login_custom_check', 'pcpp_login_check', 999, 2);





////////////////////////////////////////////////////////////////////////





// add custom field with custom field type
function pcpp_add_reg_field($fields) {
	
	$fields['pcpp_plan'] = array(
		'label' 	=> 'PCPP - '. __('Subscription plan', PCPP_ML),
		'type' 		=> 'pcpp_plan_block',
		'sys_req' 	=> true,
	); 
	return $fields;
}
add_filter('pc_form_fields_filter', 'pcpp_add_reg_field');



// declare forbidden field indexes
function pcpp_forbidden_field_indexes($fields) {
	return array_merge($fields, array('pcpp_plan', 'pcpp_coupon'));
}
add_filter('pc_forbidden_field_indexes', 'pcpp_forbidden_field_indexes');


// field must not be used in wizards
function pcpp_subscr_field_no_wizard($fields) {
	return array_merge($fields, array('pcpp_plan'));
}
add_filter('pc_no_wizard_indexes', 'pcpp_subscr_field_no_wizard');



// User data add-on filter - injecting default plan selected - to innteract with conditional fields
function pcpp_pcud_all_user_data_vals($vals, $user_id) {
    if(!$GLOBALS['pcpp_enabled']) {
        return $vals;    
    }

    $sel = (int)get_option('pcpp_default_plan');
    if(isset($_REQUEST['pcpp_plan'])) {
        $sel = (int)$_REQUEST['pcpp_plan'];     
    }
    elseif(isset($GLOBALS['pcpp_plans_chooser_form'])) {
        $sel = (int)$GLOBALS['pcpp_plans_chooser_form'];             
    }

    $vals['pcpp_plan'] = $sel;
    return $vals;
}
add_filter('pcud_all_user_data_vals', 'pcpp_pcud_all_user_data_vals', 10, 2);



// add field type
function pcpp_reg_field_code($code, $type, $field_id, $field_data, $is_required, $user_id) {
	if(!$GLOBALS['pcpp_enabled'] || $type != 'pcpp_plan_block') {
        return $code;
    }
    include_once(PCPP_DIR .'/classes/front_plan_chooser.php');
    
    // form type 
    $form_type = 'registr';
    if(isset($GLOBALS['pcpp_renewal_form'])) {
        $form_type = 'renewal';    
    }
    elseif(isset($GLOBALS['pcpp_pchange_form'])) {
        $form_type = 'change';    
    }
    elseif(isset($GLOBALS['pcpp_plans_chooser_form'])) {
        $form_type = 'chooser';    
    }
    
    $fpc = new pcpp_front_plan_choser($form_type, $user_id);
    
    
    // selected plan
    $sel = false;
    if(isset($_REQUEST['pcpp_plan'])) {
        $sel = (int)$_REQUEST['pcpp_plan'];     
    }
    elseif(isset($GLOBALS['pcpp_plans_chooser_form'])) {
        $sel = (int)$GLOBALS['pcpp_plans_chooser_form'];             
    }
    
    return $fpc->get_code($sel);
}
add_filter('pc_custom_field_type', 'pcpp_reg_field_code', 10, 6); 




// always add into registration form
function pcpp_add_field_into_reg_forms($structure, $form_id) {
    if(!get_option('pcpp_enabled', false)) { 
        return $structure; // constant hasn't been declared at this point
    } 

	$structure['include'][] = 'pcpp_plan';
    $structure['require'][] = 'pcpp_plan';
    
    return $structure;
}
add_filter('pc_registration_form', 'pcpp_add_field_into_reg_forms', 9999, 2); 





////////////////////////////////////////////////////////////////////////////////////





// REGISTRATION PROCESSES

// registration validation - check field value
function pcpp_reg_form_check_val($errors, $fdata) {
	if(!get_option('pcpp_enabled', false)) {
        return $errors; // constant hasn't been declared at this point
    } 
	$plan_error_thrown = false;
    
    // subscription plan check
	if(isset($fdata['pcpp_plan']) && !empty($fdata['pcpp_plan'])) {
		global $pcpp_subscr;
		
		$allowed_plans = (is_admin()) ? array_keys($pcpp_subscr->get_plans(false)) : array_keys($pcpp_subscr->get_plans());
		
		// allow "no_plan" for admin insertion and import 
		if(strpos($_SERVER["REQUEST_URI"], '?page=pc_user_dashboard') === false || strpos($_SERVER["REQUEST_URI"], '?page=pc_import_export') === false) {
			$allowed_plans[] = 'no_plan';	
		}

		if( !in_array((string)$fdata['pcpp_plan'], $allowed_plans) ) {
			$errors[] = __('Please select a valid subscription plan', PCPP_ML);	
            $plan_error_thrown = true;
		}
        
        
        // duration extensions check
        if(isset($_POST['pcpp_plan_dur_ext']) && !$plan_error_thrown) {
            $dur_ext = (int)$_POST['pcpp_plan_dur_ext'];

            if(!pcpp_dur_ext_static::get_ext_data($dur_ext, $fdata['pcpp_plan'])) {
                $errors[] = __('Invalid plan extension chosen', PCPP_ML);	        
            }
        }
	}

	return $errors;
}
add_filter('pc_form_valid_errors', 'pcpp_reg_form_check_val', 10, 2);





// create order or just setup metas for trial periods
add_action('pc_user_added', function($use_id) {
    $GLOBALS['pcpp_initial_registr'] = true;
});


function pcpp_reg_to_subscr($error_mess, $user_id) {
	global $pc_users, $pc_meta, $pcpp_subscr;
	$metas = array();
	
	if(!get_option('pcpp_enabled', false)) {
        return $error_mess; // constant hasn't been declared at this point
    }

	// get user data to perform actions
	$user_data = $pc_users->get_user($user_id, $args = array('to_get' => array('name', 'surname', 'username', 'email', 'tel', 'wp_user_id', 'pcpp_plan')));
	
	// get plan specifications
	$plan_data = $pcpp_subscr->get_plan_data($user_data['pcpp_plan']); // plan is saved through normal registration
	
	// prepare order - extra duration?
    $fees = array();
    if(
        get_option('pcpp_use_duration_ext', 'always') != 'no' && 
        isset($_POST['pcpp_plan_dur_ext']) && 
        pcpp_dur_ext_static::get_ext_data($_POST['pcpp_plan_dur_ext'], $user_data['pcpp_plan'])
    ) {
        $user_data['pcpp_plan'] = array($user_data['pcpp_plan'], (int)$_POST['pcpp_plan_dur_ext']);
    }
    
    // create order
	$coupon = (isset($_POST['pcpp_coupon']) && !empty($_POST['pcpp_coupon'])) ? (string)$_POST['pcpp_coupon'] : false;
	$order_obj = $pcpp_subscr->create_order($user_id, $user_data['pcpp_plan'], $user_data, $fees, $coupon);	
	
    $order_id = $pcpp_subscr->order_obj_to_id($order_obj);
    $order_amount = $pcpp_subscr->order_obj_to_amount($order_obj);

    unset($GLOBALS['pcpp_initial_registr']);
    if(!$order_id) {

		// error creating the order - flag to customize successful message 	
		return (empty($pcpp_subscr->order_error)) ? __('Error creating your subscription order. Please contact the site admin', PCPP_ML) : $pcpp_subscr->order_error;
	}
		

	// set new main order and manage access metas
	pcpp_user_subscr_static::manag_orders($user_id, $order_id, 'add');
	
	// eventually setup trial
	pcpp_user_subscr_static::setup_trial_meta($user_id, $user_data['pcpp_plan']);
	
	// NOT-FREE AND NOT TRIAL - customize redirect and message
	if(!$pcpp_subscr->is_trial_enabled() && !empty($order_amount)) {
		$GLOBALS['pcpp_mess_customizer'] = 'registr_order_ok';
		$GLOBALS['pcpp_redir_customizer'] = 'registr_order_ok';
		$GLOBALS['pcpp_redirect_to_use'] = $pcpp_subscr->checkout_url($order_id);
        
        // customize form message
        add_filter('pc_customize_message', 'pcpp_customize_pc_mess', 999, 2);
        
		// customize form redirect
		add_filter('pc_custom_redirect_url', 'pcpp_customize_pc_redirect', 999, 2);	
	}		
	
	
	// dunno why, but using a 100% coupon the password isn't properlys stored - force it!
	if(empty($order_amount)) {
		$pc_users->update_user($user_id, array('psw' => $_POST['psw']));
	}
	
	return $error_mess;
}
add_filter('pc_after_user_registr_error', 'pcpp_reg_to_subscr', 1, 2); 





////////////////////////////////////////////////////////////////////////////////////





//// function used to customize privateContent messages - 
// called by different hooks and return string depending on pcpp_mess_customizer global
function pcpp_customize_pc_mess($mess, $subj) {
	if(!isset($GLOBALS['pcpp_mess_customizer'])) {
        return $mess;
    }
	$pcpp_subj = $GLOBALS['pcpp_mess_customizer'];
	
	// registration
	if($subj == 'pc_default_sr_mex') {
		if($pcpp_subj == 'registr_order_ok') {
			 $mess = get_option('pcpp_registr_mex');	
			 if(empty($mess)) {
                 $mess = __('Successful registration! Now you will be moved to checkout page', PCPP_ML);
             }
		}
	}

	return $mess;	
}


//// function used to customize privateContent redirects - 
// called by different hooks and return string depending on pcpp_redir_customizer global
function pcpp_customize_pc_redirect($url, $key) {
	if(!isset($GLOBALS['pcpp_redir_customizer'])) {return $url;}
	$pcpp_subj = $GLOBALS['pcpp_redir_customizer'];
	
	// registration
	if($key == 'pc_registered_user_redirect') {
		if($pcpp_subj == 'registr_order_ok') {
			 $url = $GLOBALS['pcpp_redirect_to_use'];
		}
	}
	
	return $url;	
}





////////////////////////////////////////////////////////////////////////////////////





// remove landing pages from complete site lock
function pcpp_complete_lock_exceptions($excluded_pages) {
	if(!$GLOBALS['pcpp_enabled']) {return $excluded_pages;}
	
	$exceptions = array();
	
	// TODO - exclude e-commerce operational system ??
	
	// pcpp landing pages
	$exceptions[] = (int)get_option('pcpp_order_ok_page');
	$exceptions[] = (int)get_option('pcpp_order_del_page');
	$exceptions[] = (int)get_option('pcpp_order_renew_page');
	
	return (is_array($excluded_pages)) ? array_merge($excluded_pages, $exceptions) : $exceptions;
}
add_filter('pc_complete_lock_exceptions', 'pcpp_complete_lock_exceptions', 10);





////////////////////////////////////////////////////////////////////////////////////





// if WP user ls logged because of Woo Subscr add-on trick - do not login into PvtContent
function pcpp_abort_log_user_if_synced_is_logged($bool, $user_id, $wp_user_id) {
    if($bool) {
        return $bool;    
    }
    
    $meta = get_user_meta($wp_user_id, 'pcpp_woo_subscr_login_trick', true);
    if($meta) {
        return true;            
    }
    
    return $bool;
}
add_filter('pc_abort_log_user_if_synced_is_logged', 'pcpp_abort_log_user_if_synced_is_logged', 100, 3);





////////////////////////////////////////////////////////////////////////////////////





// body classes related to user subscription
add_action('pvtcont_init', function() {
    add_filter('body_class', function($classes) {
        global $pc_users;
        
        if(!$GLOBALS['pcpp_enabled']) {
            return $classes;
        }
        
        $udata = pc_user_logged(array('pcpp_plan', 'pcpp_subscr_status'));
        if(!$udata || empty($udata['pcpp_plan'])) {
            return $classes;    
        }
        
        if($udata['pcpp_subscr_status'] == 'trial') {
            $classes[] = 'pcpp_trial_period';    
        }
        $classes[] = 'pcpp_plan_'. (int)$udata['pcpp_plan'];
        
        return $classes;
    }, 15);
}, 1);
