(function($) { 
    "use strict"; 

    const dike_slug = (pc_vars.dike_slug == 'pcbp') ? pc_vars.dike_slug : 'pcpp';
    
    if(typeof(window.dike_plc) != 'undefined' && !window.dike_plc('lcweb', dike_slug)) {
        console.error('PvtContent Premium Plans add-on - validate the license');
        return false;    
    }
    
    
    let pcpp_is_acting = false;
    
    
    
    // columnization on fluid forms - on page's opening clone what PC set
    document.querySelectorAll('.pc_fluid_form_columnized').forEach($form => {
        if(!$form.querySelector('.pcpp_plan_ul')) {
            return;    
        }
        
        const cols = parseInt($form.getAttribute('data-col'), 10); 
        $form.querySelector('.pcpp_plan_ul').style.gridTemplateColumns = 'repeat('+ cols +', 1fr)';
    });
    
    // on page resize
    document.addEventListener("pc_form_columnized", function(e) {
        if(!e.detail.form.querySelector('.pcpp_plan_ul')) {
            return;    
        }
        e.detail.form.querySelector('.pcpp_plan_ul').style.gridTemplateColumns = 'repeat('+ e.detail.cols +', 1fr)';
    });
    
    
    
    
    //////////////////////////////////////////////////////////
    
    
    
    // login form - renewal order creation link - create renew order and redirect (no plan change)
    $(document).on('click', 'a.pcpp_renew_plan_btn', function() {
        if(pcpp_is_acting) {
            return false;
        }
        pcpp_is_acting = true;

        const $subj = $(this),
              txt_backup = $subj.html();
              
        $subj.html(pcpp_vars.rpb_is_acting);

        let data = {
            type            : 'pcpp_renew_order', 
            pcpp_uid        : $subj.data('uid'),
            pcpp_sel_plan   : $subj.data('pid'),
            pcpp_key        : $subj.data('key'),
        };
        $.ajax({
            type    : "POST",
            url     : (window.location.href.indexOf('wp-login.php') != - 1) ? pcpp_vars.pcpp_siteurl : window.location.href,
            dataType: "json",
            data    : data,
            success : function(response) {
                if(response.status == 'success') {
                    $subj.html(pcpp_vars.renew_ok);
                    window.location.href = response.url;
                } 
                else {
                    $subj.html(response.error);	
                }
            }
        })
        .fail(function(e) {
            if(e.status) {
                console.error('pcpp renew plan btn error', e);
                alert(pcpp_vars.failed_renew);
                $subj.html(txt_backup);
            }
        })
        .always(function() {
            pcpp_is_acting = false;    
        });
    });

    
    
    
    // plan change/renew - select current user plan by selecting its checks
    $(document).on('click', '.pcpp_user_actual_plan .pcpp_plan_dur_ext_block', function(e) {
        if(pcpp_is_acting) {
            return false;   
        }
        
        const $wrap         = $(this).parents('.pcpp_change_plan_form'),
              user_plan_id  = $(this).parents('.pcpp_user_actual_plan').data('plan-id');
        
        $wrap.find('.pcpp_chosen').removeClass('pcpp_chosen');
            
        $wrap.find('.pcpp_plan_input').removeAttr('checked');
        $wrap.find('.pcpp_plan_input[value="'+ user_plan_id +'"]')[0].checked = true;
        
        // change plan form - hide warning
        $wrap.find('.pcpp_act_plan_change_warn').addClass('pc_displaynone');
    });
    
    
    
    // plan change/renew - deselect current user plan when it is unchecked
    $(document).on('click', '.pcpp_user_actual_plan .pc_checked', function() {
        if(pcpp_is_acting) {
            return false;   
        }
        
        const $wrap         = $(this).parents('.pcpp_change_plan_form'),
              user_plan_id  = $wrap.find('.pcpp_user_actual_plan').data('plan-id');     
        
        setTimeout(function() {
            if(!$('.pcpp_user_actual_plan .pc_checked').length) {
                $wrap.find('.pcpp_plan_input[value="'+ user_plan_id +'"]')[0].checked = false;
            }
        }, 50);
    });
        

    
    // create renew order and redirect (with plan change)
    $(document).on('click', '.pcpp_change_plan_btn', function() {
        if(pcpp_is_acting) {
            return false;
        }

        const $form = $(this).parents('form'),
              $btn  = $(this);

        // be sure at least one option is selected
        let sel_plan;
        $form.find('.pcpp_plan_input').each(function() {
            if(this.checked) {
                sel_plan = parseInt($(this).val(), 10);
                return false;
            }
        });
        if(!sel_plan) {
            $form.find('.pcpp_form_message').html('<span class="pc_error_mess">' + pcpp_vars.no_sel_opt + '</span>');	
            return false;    
        }
        
        // duration extension?
        let dur_ext; 
        $form.find('.pcpp_plan_dur_ext_block li:not(.pcpp_user_actual_plan_check) input').each(function() {
            if(this.checked) {
                dur_ext = parseInt($(this).val(), 10);
                return false;
            }
        });
        
        
        // ajax call
        $btn.addClass('pc_spinner_btn');
        $form.find('.pcpp_form_message').empty();

        pcpp_is_acting = true;
        
        let data = {
            type            : 'pcpp_renew_order', 
            pcpp_uid        : $form.find('input[name=pcpp_uid]').val(),
            pcpp_sel_plan   : sel_plan,
            pcpp_dur_ext    : dur_ext,
            pcpp_coupon     : ($form.find('.pcpp_hidden_coupon_field').length) ? $form.find('.pcpp_hidden_coupon_field').val() : '',
            pcpp_key        : $form.find('input[name=pcpp_key]').val(),
        };
        $.ajax({
            type    : "POST",
            url     : window.location.href,
            dataType: "json",
            data    : data,

            success: function(response){
                if(response.status == 'success') {
                    $form.find('.pcpp_form_message').html('<span class="pc_success_mess">'+ response.mess +'</span>');
                    
                    setTimeout(function() {
                        if(response.url == 'refresh') {
                            window.location.reload();        
                        }
                        else if(response.url != 'none') {
                            window.location.href = response.url;        
                        }
                    }, 1300);  
                } 
                else {
                    $form.find('.pcpp_form_message').html('<span class="pc_error_mess">'+ response.error +'</span>');	
                }
            }
        })
        .fail(function(e) {
            if(e.status) {
                console.error('pcpp renew order error', e);
                $form.find('.pcpp_form_message').html('<span class="pc_error_mess">'+ pc_vars.ajax_failed_mess +'</span>');
            }
        })
        .always(function() {
            $btn.removeClass('pc_spinner_btn');
            pcpp_is_acting = false;    
        });
    });


    
    
    //////////////////////////////////////////////////////////
    
    
    
    
    // manage plan switch
    $(document).on('click', '.pvtcont_form:not(.pcpp_plan_choser_form) .pcpp_plan_block:not(.pcpp_chosen)', function(e) {
        if(pcpp_is_acting) {
            return false;   
        }
        
        const $subj     = $(this).parents('form'),
              new_val   = $(this).data('plan-id');

        // deactivate old one
        $subj.find('.pcpp_plan_ul li.pcpp_chosen').removeClass('pcpp_chosen');
        $(this).addClass('pcpp_chosen');
        
        // deactivate eventual duration extensions
        $subj.find('.pcpp_plan_dur_ext_block .pcpp_plan_block:not([data-plan-id="'+ new_val +'"]) .pc_checked').trigger('click');

        // set dropdown
        if($subj.find('.pcpp_plan_dd').length) {
            $subj.find('.pcpp_plan_dd option').removeAttr('selected');
            $subj.find('.pcpp_plan_dd option[value="'+ new_val +'"]')[0].selected = true;
        }
        else if($subj.find('.pcpp_plan_input').length) {
            $subj.find('.pcpp_plan_input').removeAttr('checked');
            $subj.find('.pcpp_plan_input[value="'+ new_val +'"]')[0].checked = true;
        }
        
        // remove expanded mode in case
        if($subj.find('.pcpp_dd_expanded').length) {
            $subj.find('#pcpp_plan_dd_label i').trigger('click');	
        }
        
        // change plan form - show warning
        $subj.find('.pcpp_act_plan_change_warn').removeClass('pc_displaynone');
        
        if(typeof(window.pcud_cond_f_check) != 'undefined') {
            window.pcud_cond_f_check(e);
        }
    });

    

    // dropdown simulation for 1-col and compact
    $(document).on('click', '#pcpp_plan_dd_label i', function() {
        var $subj = $(this).parents('.pcpp_plan_choice_wrap');

        if($subj.hasClass('pcpp_dd_expanded')) {
            $subj.removeClass('pcpp_dd_expanded');
        }
        else {
            $subj.addClass('pcpp_dd_expanded');	
        }
    });


    
    
    //////////////////////////////////////////////////////////

    
    

    // coupon check
    const submit_coupon = function($input) {
        if(!$input.val() || pcpp_is_acting) {
            return false;
        }

        pcpp_is_acting = true;
        
        const $form = $input.parents('form');
        $input.parents('.pcpp_coupon_wrap').find('.pc_field_container > *').fadeTo(200, 0.7);

        // renewal/change form - current user plan
        const curr_user_plan = ($form.find('.pcpp_user_actual_plan').length) ? $form.find('.pcpp_user_actual_plan').data('plan-id') : false;
        
        var data = {
            type            : 'pcpp_coupon_check', 
            pcpp_coupon     : $input.val(),
            is_reg_form     : ($form.hasClass('pc_registration_form')) ? 1 : 0, 
            curr_user_plan  : curr_user_plan,  
        };
        $.ajax({
            type: "POST",
            url: window.location.href,
            dataType: "json",
            data: data,
            
            success: function(response) {		
                if(response.status == 'success') {
                    
                    const $plans_wrap = $input.parents('form').find('.pcpp_plan_ul, .pcpp_user_actual_plan');
                    
                    // replace plan prices
                    $.each(response.prices, function(plan_id, new_price) {
                        let $price_tag, old_price;
                        
                        // plan printed as dur ext in renewal forms
                        if(plan_id == curr_user_plan) {
                            $price_tag    = $plans_wrap.find('.pcpp_plan_dur_ext_block li[data-pde-id="'+ plan_id +'"] .pcpp_pde_price'),
                            old_price     = $price_tag.html();

                            if($price_tag.hasClass('pcpp_is_free')) {
                                return true;	
                            }
                            $price_tag.html('<mark class="pcpp_old_price">'+ old_price +'</mark>'+ new_price);             
                        }
                        
                        else {
                            $price_tag    = $plans_wrap.find('.pcpp_plan_block[data-plan-id="'+ plan_id +'"] .pcpp_plan_price'),
                            old_price     = $price_tag.html();

                            if($price_tag.hasClass('pcpp_is_free')) {
                                return true;	
                            }
                            $price_tag.html('<mark class="pcpp_old_price">'+ old_price +'</mark>'+ new_price); 
                        }
                    });
                    
                    
                    // replace duration extension prices
                    $.each(response.dur_ext, function(pde_id, new_price) {
                        const $price_tag    = $plans_wrap.find('.pcpp_plan_dur_ext_block li[data-pde-id="'+ pde_id +'"] .pcpp_pde_price'),
                              old_price     = $price_tag.html();
                        
                        $price_tag.html('<mark class="pcpp_old_price">'+ old_price +'</mark>'+ new_price); 
                    });
                    
                    var $clone = $input.clone();
                    $clone.insertBefore($input);

                    $clone.attr('disabled', 'disabled');
                    $input.addClass('pcpp_hidden_coupon_field').attr('type', 'hidden');
                    $input.next('.pcpp_try_coupon').addClass('pcpp_remove_coupon');
                } 
                
                else {
                    $input.parents('section').prepend('<div class="pc_field_error">'+ response.mess +'</div>');		
                }
            },
        })
        .fail(function(e) {
            if(e.status) {
                console.error('coupon check error', e);
                $input.parents('section').prepend('<div class="pc_field_error">'+ pc_vars.ajax_failed_mess +'</div>');
            }
        })
        .always(function() {
            pcpp_is_acting = false;  
            $input.parents('.pcpp_coupon_wrap').find('.pc_field_container > *').fadeTo(200, 1);
        });
    };


    
    // submit coupon clicking icon
    $(document).on('click', '.pcpp_try_coupon:not(.pcpp_remove_coupon)', function() {
        submit_coupon($(this).parents('.pcpp_coupon_wrap').find('input'));
    });

    // submit coupon with enter key
    $(document).on('keyup', 'input[name="pcpp_coupon"]', function() {
        if(event.keyCode === 13){ // enter key
            event.preventDefault();
            submit_coupon($(this));
            return false;
        }
    });
        
    
    
    // remove coupon
    $(document).on('click', '.pcpp_remove_coupon', function() {
        $(this).removeClass('pcpp_remove_coupon');
        $('.pcpp_hidden_coupon_field').remove();

        // reset field
        $(this).prev('.pcpp_coupon').removeAttr('disabled').val('');

        
        // reset plan prices
        const $plans_wrap = $(this).parents('form').find('.pcpp_plan_ul');
        $plans_wrap.find('li .pcpp_plan_price').each(function() {
            
            if($(this).find('mark').length) {
                $(this).html( $(this).find('mark').html() );   
            }
        });
        
        
        // reset duration extension prices
        const $pde_wrap = $(this).parents('form').find('.pcpp_plan_dur_ext_block');
        $pde_wrap.find('li .pcpp_pde_price').each(function() {
            
            if($(this).find('mark').length) {
                $(this).html( $(this).find('mark').html() );   
            }
        });
    });

    
    
    
    //////////////////////////////////////////////////////////
    
    
    
    // plans duration extension - only 1 active option per form
    $(document).on('click', '.pcpp_plan_dur_ext_block .pc_checkbox:not(.pc_checked)', function() {
        const $wrap = $(this).parents('.pcpp_plan_choice_wrap');
        
        // do NOT use click to avoid interferences
        $wrap.find('.pc_checked').not(this).each(function() {
            $(this).parents('li').first().find('input[type="checkbox"]')[0].checked = false;
            $(this).removeClass('pc_checked');        
        });
    });
    
    
    
    // plans duration extension - disable on not-selected plans
    $(document).on('click', '.pcpp_plan_block, .pcpp_user_actual_plan', function(e) {
        const $wrap = $(this).parents('.pcpp_plan_choice_wrap');

        // do NOT use click to avoid interferences
        $wrap.find('.pcpp_plan_block, .pcpp_user_actual_plan').not(this).find('.pcpp_plan_dur_ext_block .pc_checked').each(function() {
            $(this).parents('li').first().find('input[type="checkbox"]')[0].checked = false;
            $(this).removeClass('pc_checked');
        });
    });
    
    
    
    // plans duration extension - check click on label click
    $(document).on('mousedown touchend', '.pcpp_plan_dur_ext_block > li > span', function() {
        const $wrap = $(this).parents('li').first();
        $wrap.find('.pc_checkbox').trigger('click');
    });
    
    
    
    
    //////////////////////////////////////////////////////////
    
    
    

    // plan's chooser block - lightbox behavior
    $(document).on('click', '.pcpp_plan_choser_form[data-behav="lightbox"] .pcpp_plan_ul > li', function() {
        
        const plan_id   = ($(this).hasClass('pcpp_plan_block')) ? $(this).data('plan-id') : $(this).parents('.pcpp_plan_block').data('plan-id'),
              lb_id     = $(this).parents('.pcpp_plan_choser_form').data('lb');    
        
        if(!$('.pc_lb_trig_'+lb_id).length) {
            $('<span class="pc_lb_trig_'+ lb_id +'"></span>').appendTo('body');        
        }
        $('.pc_lb_trig_'+lb_id).trigger('click');
        
        setTimeout(function() {
            $('.mfp-wrap.pc_lightbox .pcpp_plan_block[data-plan-id="'+ plan_id +'"]').trigger('click');            
        }, 150);
    
    });
    
    
    
    // plan's chooser block - redirect behavior
    $(document).on('click', '.pcpp_plan_choser_form[data-behav="redirect"] .pcpp_plan_ul > li', function() {
        
        const plan_id = ($(this).hasClass('pcpp_plan_block')) ? $(this).data('plan-id') : $(this).parents('.pcpp_plan_block').data('plan-id');
        let url = $(this).parents('.pcpp_plan_choser_form').data('url');    
        
        // append suggested plan parameter
        url = (url.indexOf('?') === -1) ? url+'?pcpp_plan='+plan_id : url+'&pcpp_plan='+plan_id; 
        
        window.location.href = url;
    });
    
    
})(jQuery); 