<?php
// HANDLING AND MANAGING ORDER SUCCESSFUL/CANCELLED/RENEW PAGES




// disable direct opening for pcpp landing pages
function pcpp_no_direct_access_pages() {
	if((is_single() || is_page()) && $GLOBALS['pcpp_enabled']) {		
        global $wp_query, $pcpp_subscr;
    
        $GLOBALS['pcpp_no_wpml_integration'] = true; // get current language IDs
        $matches        = array_keys((array)$pcpp_subscr->get_plans(false));
        
        $curr_pag_id    = get_the_ID();
        $renewal_pag    = pc_static::wpml_translated_pag_id( (int)get_option('pcpp_order_renew_page'));
            
        
        // allow page preview by admins
        if(!current_user_can('edit_pages')) {
            $matches[] = pc_static::wpml_translated_pag_id( (int)get_option('pcpp_order_ok_page'));
            $matches[] = pc_static::wpml_translated_pag_id( (int)get_option('pcpp_order_del_page'));
            $matches[] = $renewal_pag;
        }
        elseif(!isset($GLOBALS['pc_user_id'])) {
            
            // not for user renewal page used by expired user
            if($curr_pag_id != $renewal_pag || (!isset($_GET['pcpp_renew']) && !isset($_GET['uid']))) {
                $GLOBALS['pcpp_admin_is_previewing'] = true;
            }
        }

		foreach($matches as $pag_id) {
            if(!empty($pag_id) && $curr_pag_id == $pag_id && !isset($_GET['pcpp_action'])) {
                wp_redirect(get_home_url());
                die();		
            }
		}
	}
}
add_action('template_redirect', 'pcpp_no_direct_access_pages');






// MANAGE ENDPOINTS TO CUSTOMIZE LANDING PAGES
function pcpp_wc_cust_land_pages() {
	if(!$GLOBALS['pcpp_enabled']) {
        return false;
    }
	global $pcpp_subscr;

    
    if(PCPP_ECOMMERCE == 'woocomm') {
    
        // successful checkout
        if(is_order_received_page() && isset($_REQUEST['key'])) {
            $order_id = wc_get_order_id_by_order_key($_REQUEST['key']);

            if($pcpp_subscr->is_pvtcontent_order( $order_id)) {

                // change status to complete if it's status is processing
                $order = $pcpp_subscr->get_order($order_id);
                if($order->get_status() == 'processing') {
                    $order->update_status('completed', __('Subscrption paid', PCPP_ML).' -', true);
                }


                // eventually perform custom redirect
                $redir = get_option('pcpp_order_ok_page', false);
                if(!empty($redir)) {
                    $redir = pc_static::wpml_translated_pag_id($redir);
                    wp_redirect( add_query_arg('pcpp_action', 'order_ok', get_permalink((int)$redir)) );
                    die();           
                } 
                else {
                    add_action('wp_head', 'pcpp_wc_hide_order_again_btn', 999);	
                }
            }
        }

        // cancelled order
        elseif(isset($_REQUEST['cancel_order']) && isset($_REQUEST['order']) && isset($_REQUEST['order_id'])) {
            $order_id = (int)$_REQUEST['order_id'];

            if( $pcpp_subscr->is_pvtcontent_order($order_id)) {

                // set order status as cancelled
                $order = $pcpp_subscr->get_order($order_id);
                $order->update_status('cancelled', __('Aborted payment', PCPP_ML).' -', true);

                // eventually perform custom redirect
                $redir = get_option('pcpp_order_del_page', false);
                if(!empty($redir)) {
                    $redir = pc_static::wpml_translated_pag_id($redir);
                    wp_redirect( add_query_arg('pcpp_action', 'del_order', get_permalink((int)$redir)) );	
                    die();
                }
            }
        }
    }
}
add_action('template_redirect', 'pcpp_wc_cust_land_pages', 1);



// utility to prevent "order again" button in default WooCommerce order received page
function pcpp_wc_hide_order_again_btn() {
	?>
    <style type="text/css">.order-again {display: none !important;}</style>
    <?php
}






// REMOVE LANDING PAGES FROM WP_QUERY
function pcpp_remove_page_from_queries($query) {
    if(is_admin() || !$GLOBALS['pcpp_enabled'] || isset($GLOBALS['pcpp_is_querying plans'])) {
        return $query;
    }
    global $wp_query, $pcpp_subscr;
    
    $GLOBALS['pcpp_no_wpml_integration'] = true; // get current language IDs
    $to_remove = array_keys((array)$pcpp_subscr->get_plans(false));
    
    if(!current_user_can('edit_pages')) {
        $to_remove[] = (int)pc_static::wpml_translated_pag_id('pcpp_order_ok_page');
        $to_remove[] = (int)pc_static::wpml_translated_pag_id('pcpp_order_del_page');
        $to_remove[] = (int)pc_static::wpml_translated_pag_id('pcpp_order_renew_page');
    }
    
    foreach($to_remove as $key => $tr) {
        if(empty($tr)) {
            unset($to_remove[$key]);    
        }
    }
    if(empty($to_remove)) {
        return $query;    
    }
    
    
    if(
        is_object($wp_query) && is_object($wp_query->queried_object) && 
        property_exists($wp_query->queried_object, 'ID') && in_array($wp_query->queried_object->ID, $to_remove)
    ) {
        
        // exception - renew page with rewal parameters
        if(
            $wp_query->queried_object->ID == (int)pc_static::wpml_translated_pag_id('pcpp_order_renew_page') && 
            isset($_GET['pcpp_action']) && $_GET['pcpp_action'] == 'renew_subscr' && isset($_GET['pcpp_renew'])
        ) {
            return $query;    
        }
        
        if(isset($query->query_vars['post__not_in'])) { 
            $to_remove = array_merge((array)$query->query_vars['post__not_in'], $to_remove); 
        }
        $query->set('post__not_in', $to_remove);
    }
    return $query;
}
add_filter('pre_get_posts', 'pcpp_remove_page_from_queries');







// CUSTOM LABELS IN PAGES LIST TO HELP ORIENTATING
function pcpp_custom_display_post_states($states, $post) {
    if(!isset($GLOBALS['pcpp_enabled']) || !$GLOBALS['pcpp_enabled']) {
        return $states;    
    }
    
    // Woocommerce - add label to mark plans
    if(PCPP_ECOMMERCE == 'woocomm' && $post->post_type == 'product' && get_post_meta($post->ID, '_is_pvtcontent_plan', true) == 'yes') {
        $states['pcpp_plan'] = esc_html__('Subscription Plan', PCPP_ML);      
    }
    
    elseif($post->ID == get_option('pcpp_order_ok_page')) {
        $states['pcpp_order_ok_page'] = esc_html__('Successful Order Page', PCPP_ML);          
    }
    elseif($post->ID == get_option('pcpp_order_del_page')) {
        $states['pcpp_order_del_page'] = esc_html__('Cancelled Order Page', PCPP_ML);          
    }
    elseif($post->ID == get_option('pcpp_order_renew_page')) {
        $states['pcpp_order_renew_page'] = esc_html__('Renew Order Page', PCPP_ML);          
    }
    
    return $states;
}
add_filter('display_post_states', 'pcpp_custom_display_post_states', 10, 2);
