<?php
/* 
Plugin Name: PrivateContent - Premium Plans Add-on 
Plugin URI: https://lcweb.it/privatecontent/premium-plans-add-on
Description: Extend PrivateContent implementing pay and time limited subscriptions, also extend restriction engine basing on plans. Everthing simply taking advantage of WooCommerce
Author: Luca Montanari (LCweb)
Version: 2.2.0
Author URI: https://lcweb.it/
*/  



/////////////////////////////////////////////
/////// MAIN DEFINES ////////////////////////
/////////////////////////////////////////////

// plugin path
$wp_plugin_dir = substr(plugin_dir_path(__FILE__), 0, -1);
define('PCPP_DIR', $wp_plugin_dir );

// plugin url
$wp_plugin_url = substr(plugin_dir_url(__FILE__), 0, -1);
define('PCPP_URL', $wp_plugin_url );


// plugin version
define('PCPP_VER', '2.2.0');

// multilanguage id
define('PCPP_ML', 'pcpp_ml');






//////////////////////////////////////////////////////////
// CHECK IF PRIVATECONTENT AND E-COMM SYSTEM ARE ACTIVE //
//////////////////////////////////////////////////////////

include_once(ABSPATH . 'wp-admin/includes/plugin.php');
include_once(PCPP_DIR .'/classes/pcpp_static.php');



if(!is_plugin_active('private-content/private_content.php') && !defined('PC_VERS')) {
	function pcpp_no_plugin_warning() {
		echo '
		<div class="error">
		   <p>'. __('Please activate PrivateContent plugin to use the "Premium Plans" add-on', PCPP_ML) .'</p>
		</div>';
	}
	add_action('admin_notices', 'pcpp_no_plugin_warning');
}



// check available e-comm systems and require at least one - actually only woocomm
elseif(pcpp_static::avail_ecomm() === array()) {
	function pcpp_no_plugin_warning() {
		global $current_screen;

		// message only in pvtContent settings if is bundle
		if(isset($GLOBALS['is_pc_bundle']) && $current_screen->base == 'privatecontent_page_pc_settings') {
		
			echo '
			<div class="error">
			   <p>'. __('Please activate <a href="https://wordpress.org/plugins/woocommerce/" target="_blank">WooCommerce</a> plugin to use PrivateContent "Premium Plans" add-on', PCPP_ML) .'</p>
			</div>';
		}
	}
	add_action('admin_notices', 'pcpp_no_plugin_warning');
}



else {
    ////////////////////////////////////////////////
	// ADD-ON-IS-INTEGRATED CONSTANT
	$GLOBALS['pcpp_enabled'] = get_option('pcpp_enabled', false); // global to be overrided and to be ready in any hook
    
    
    
	/////////////////////////////////////////////
	/////// MULTILANGUAGE SUPPORT ///////////////
	/////////////////////////////////////////////
	
	function pcpp_multilanguage() {
		$param_array = explode(DIRECTORY_SEPARATOR, PCPP_DIR);
		$folder_name = end($param_array);
	  	
		load_plugin_textdomain(PCPP_ML, false, $folder_name . '/languages');
	}
	add_action('init', 'pcpp_multilanguage', 1);
	
	
    
    
	
	//////////////////////////////////
	// SCRIPT ENQUEUING
	function pcpp_global_scripts() { 
		$is_admin = is_admin();
		
        // admin
		if($is_admin) {
			global $current_screen;
            if(!$current_screen) {
                return;    
            }
            
            wp_enqueue_style('pcpp_admin', PCPP_URL .'/css/admin.css', 800, PCPP_VER);
            wp_enqueue_script('jquery-ui-sortable');
            
            
            if($current_screen->id == 'product') {
                wp_enqueue_script('lc-color-picker', PC_URL .'/js/lc-color-picker/lc_color_picker.min.js', 200, '1.1.1', true);
            }
		}	
        
		     
        // front
		if(!$is_admin || isset($GLOBALS['lc_guten_scripts'])) {
            wp_enqueue_script('jquery');
			wp_enqueue_script('pcpp_frontend', PCPP_URL .'/js/frontend.min.js', array('jquery', 'pc_frontend'), PCPP_VER, true);
			wp_enqueue_style('pcpp_frontend', PCPP_URL .'/css/frontend.min.css', 'pc_frontend', PCPP_VER);	
            
            if(class_exists('DiviExtension')) {
                wp_enqueue_style('pcpp-divi-frontend', PCPP_URL .'/css/frontend.min_for_divi.css', 'pc_frontend', PCPP_VER);	     
            }
            
            // dynamic JS vars
            $array = array(
                'pcpp_siteurl'  => site_url(),
                'rpb_is_acting' => '<em>'. esc_attr__('Creating order', PCPP_ML) .'..</em>',
                'failed_renew'  => esc_attr__('Problem creating order, try again', PCPP_ML),
                'no_sel_opt'    => esc_attr__('Please select one option', PCPP_ML),
            );
            wp_localize_script('pcpp_frontend', 'pcpp_vars', $array);
		}
	}
	add_action('wp_enqueue_scripts', 'pcpp_global_scripts');
	add_action('admin_enqueue_scripts', 'pcpp_global_scripts');
    add_action('login_enqueue_scripts', 'pcpp_global_scripts');
	add_action('lc_guten_scripts', 'pcpp_global_scripts');


	
    
    
	////////////////////////////////////////////////
	// SET E-COMM TO USE IN A CONSTANT
	function pcpp_ecomm_to_use() {
		$to_use = false;
		$ecomm_to_use = get_option('pcpp_ecomm_to_use', false);
		$available = pcpp_static::avail_ecomm();
		
		if(count($available) == 1) {
			$keys = array_keys($available);
			define('PCPP_ECOMMERCE', $keys[0]);	
		}
		else {	
			foreach($available as $key => $name) {
				if($ecomm_to_use == $key) {
					$to_use = $key;	
				}
			}
			define('PCPP_ECOMMERCE', $to_use);
		}
	}
	add_action('init', 'pcpp_ecomm_to_use', 1);

	
    
    
    
	////////////////////////////////////////////////
	// TRIGGER ACTION WHENEVER USER SUBSCR STATUS CHANGES
	function pcpp_action_on_subscr_status_change($value, $user_id, $meta_name) {
		if($meta_name == 'pcpp_subscr_status') {
            
            // PCPP-ACTION - user status is about to change
            do_action('pcpp_subscr_status_changed', $user_id, $value);    
        }
        
        return $value;
	}
	add_filter('pc_meta_val_filter', 'pcpp_action_on_subscr_status_change', 200, 3);
	
	
    
    
    ///////////////////////////////////////////////////////////////
    // ADD "PCPP PLAN" LABEL IN CUSTOM POST TYPES TO HELP ORIENTATING
    function pcpp_plan_post_states($states, $post) {
        global $pcpp_subscr;
        $avail_plans = $pcpp_subscr->get_plans(false);
        
        if(isset($avail_plans[ $post->ID ])) {
            $states['is_pcpp_plan'] = esc_html__('Premium Plans Plan', PC_ML);        
        }
        
        return $states;
    }
    add_filter('display_post_states', 'pcpp_plan_post_states', 10, 2);
    
    
    
    
	////////////////////////////////////////////////////////
	
    
    
    
    // USER SUBSCRIPTION STATIC CLASS
    include_once(PCPP_DIR .'/classes/pcpp_user_subscr_static.php');
    
    // PLANS DURATION EXTENSION STATIC CLASS
    include_once(PCPP_DIR .'/classes/pcpp_dur_ext_static.php');
    
    // WOOCOMMERCE SUBSCRIPTIONS ADD-ON INTEGRATIONS STATIC CLASS
    include_once(PCPP_DIR .'/classes/woo_subscr_static.php');
    
	// SUBSCRIPTION MANAGEMENT CLASS
	include_once(PCPP_DIR .'/classes/subscription_manag.php');
	
	// PRIVATECONTENT ADMIN INTEGRATIONS
	include_once(PCPP_DIR . '/admin_integrations.php');
	
	// ADMIN AJAX
	include_once(PCPP_DIR . '/admin_ajax.php');
	
	// FRONT AJAX
	include_once(PCPP_DIR . '/front_ajax.php');
	
    // LANDING PAGES MANAGEMENT
	include_once(PCPP_DIR . '/landing_pages.php');
    
	// PRIVATECONTENT FRONTEND INTEGRATIONS
	include_once(PCPP_DIR . '/front_integrations.php');
	
	// WOOCOMMERCE INTEGRATIONS
	include_once(PCPP_DIR . '/woocom_integrations.php');
	
	// TINYMCE WIZARD INTEGRATIONS
	include_once(PCPP_DIR . '/tinymce_integration.php');
	
	// SHORTCODES
	include_once(PCPP_DIR . '/shortcodes.php');
	
	// SETTINGS
	include_once(PCPP_DIR . '/settings.php');

	// FRONT DYNAMIC STYLES
	include_once(PCPP_DIR . '/styling.php');
    
    // USER ACTIVITIES ADD-ON INTEGRATION
	include_once(PCPP_DIR . '/pcua_integration.php');
	
    
	
    
    
    // gutenberg integration - not for WP 5.8 widgets.. for now
    if($_SERVER["REQUEST_URI"] != '/wp-admin/widgets.php') {
        include_once(PCPP_DIR . '/builders_integration/gutenberg.php');
    }
    
    // visual composer integration
    include_once(PCPP_DIR . '/builders_integration/visual_composer.php');

    // elementor integration
    include_once(PCPP_DIR . '/builders_integration/elementor.php');

    // divi integration
    include_once(PCPP_DIR . '/builders_integration/divi.php');
    
    
    
    
    
    
    ////////////
    // DIKE WP DASHBOARD

    $pcpp_dike_slug = (isset($GLOBALS['is_pc_bundle'])) ? 'pcbp' : 'pcpp';
    define('PCPP_DIKE_SLUG', $pcpp_dike_slug);
    
    function pcpp_dike_updater_data($data) {
        $data['pcpp'] = array(
            'callback' => 'pcpp_on_activation',
            'no_files_del' => false,
        );
        return $data;
    }
    add_filter('dike_lcweb_updater', 'pcpp_dike_updater_data');

    function pcpp_dike_plc_sc($sc) {
        if(!isset($sc[PCPP_DIKE_SLUG])) {
            $sc[PCPP_DIKE_SLUG] = array();    
        }

        $sc[PCPP_DIKE_SLUG] = array_merge($sc[PCPP_DIKE_SLUG], array('pcpp-change-plan', 'pcpp-user-plan', 'pcpp-subscr-expir', 'pcpp-user-orders-history', 'pcpp-plan-chooser', 'pcpp-reg-form-txt', 'pcpp-chg-form-txt'));
        return $sc;
    }
    add_filter('dike_lcweb_sc', 'pcpp_dike_plc_sc');
    
    ////////////
    
    
    
    
    
    
    //////////////////////////////////////////////////
    // ACTIONS ON ADD-ON ACTIVATION //////////////////
    //////////////////////////////////////////////////

    function pcpp_on_activation($networkwide = false) {
        global $wpdb;
        
        // inject styles
        if(class_exists('pc_static') && method_exists('pc_static', 'create_custom_style')) {
            pc_static::create_custom_style();
        }
        
        
        // v2 update - Woo products plan now have a meta instead of term. Turn them into "simple"
        $args = array(
            'post_type' 		=> 'product',
            'post_status' 		=> 'any',
            'posts_per_page' 	=> 100,
            'tax_query' 		=> array(
                array(
                    'taxonomy' => 'product_type',
                    'field'    => 'slug',
                    'terms'    => 'pvtcontent_plan', 
                ),
            ),
        );

        $query = new WP_Query($args);
        foreach($query->posts as $post) {
            wp_set_object_terms($post->ID, 'simple', 'product_type');
            update_post_meta($post->ID, '_is_pvtcontent_plan', 'yes');
        } 
        
        
        // v2 update - chage "pvtcontent_order" meta name into "is_pvtcontent_order"
        $wpdb->query("UPDATE ". $wpdb->postmeta ." SET meta_key = 'is_pvtcontent_order' WHERE meta_key = 'pvtcontent_order'");
    }
    register_activation_hook(__FILE__, 'pcpp_on_activation');
    
    
    // direct v2 Woo products conversion call
    if(isset($_GET['pcpp_v2_update'])) {
        pcpp_on_activation();        
    }
}





// REQUIRE RIGHT CORE PLUGIN VERSION
function pcpp_requirements_check() {
	$req_v = '8.8.0';
    
    if(!defined('PC_VERS') || version_compare(PC_VERS, $req_v, '<')) {
		deactivate_plugins( plugin_basename( __FILE__ ) );
        
        $btn = '<br/><a href="'. esc_attr(network_admin_url('plugins.php')) .'">'. esc_html__('Return to plugins page', PCPP_ML) .'</a>';
		wp_die('Premium Plans add-on '. __('requires at least', PCPP_ML) .' PrivateContent v'. $req_v .' '. __('installed', PCPP_ML) .'!'. $btn);
	}
}
register_activation_hook(__FILE__, 'pcpp_requirements_check');
add_action('admin_init', 'pcpp_requirements_check', 1);





/*
//// meta keys

// pcpp_plan 			=> plan linked to user
// pcpp_subscr_end 		=> timestamp with ending subscription period or "unlimited" (for changes, check bit.ly/20qlAvU)
// pcpp_subscr_status	=> string reporting the subscription status (trial|unpaid|no_act_order|expired|active|suspended|inherit)
// pcpp_trial_ending	=> contains trial ending timestamp or nothing if there was no trial period on registration
// pcpp_active_order 	=> last order associated to user - useful to bind changes from order
// pcpp_recurr_subscr 	=> ID of the active recurring-payment subscription linked to the user (requires Woo Subscriptions)
// pcpp_orders 			=> array containing user orders 
// pcpp_last_check		=> timestamp reporting last date when logged user has been checked 

*/
