<?php
// PCMA INTEGRATION - REMINDERS PHP ENDPOINT


//////////////////////////////////////////////////////////////
// load WP functions

if(!isset($_REQUEST['abspath'])) {
	$curr_path = dirname(__FILE__);
	$curr_path_arr = explode(DIRECTORY_SEPARATOR, $curr_path);
	
	$true_path_arr = array();
	foreach($curr_path_arr as $part) {
		if($part == 'wp-content') {break;}
		$true_path_arr[] = $part;
	}	
	$true_path = implode('/', $true_path_arr);
}
else {
    $true_path = urldecode($_REQUEST['abspath']);
}

// main functions
if(!file_exists($true_path . '/wp-load.php')) {
    die('<p>wordpress - wp-load.php file not found</p>');
}
else {
    require_once($true_path .'/wp-load.php');
}
	


if(!function_exists('get_filesystem_method')) {
	// wp-admin/includes/file.php - for wp_filesys
	if(!file_exists(ABSPATH . 'wp-admin/includes/file.php')) {
        die('<p>wordpress - file.php file not found</p>');
    }
	else {
        require_once(ABSPATH . 'wp-admin/includes/file.php');
    }	
}
/////////////////////////////////////////////////////////////////////////////////////




// be sure Mail Actions add-on is active
if(!defined('PCMA_DIR')) {
	die('Mail Actions add-on not found');	
}
include_once(PCMA_DIR .'/helpers.php');



// is Premium Plans enabled?
if(!get_option('pcpp_enabled', false)) {
    die('Premium Plans add-onn integration is currently disabled');
}




// include PC globals
global $pc_users, $pc_meta, $pcpp_subscr;



/////////////////////////////////////////////
//// EXPIRED SUBSCRIPTIONS REMINDER /////////
/////////////////////////////////////////////

if(get_option('pcpp_pcma_see_enble') || !get_option('pcpp_bte_title')) { // retrocompatibility - target new reminder texts existence
    echo '<h2>EXPIRED SUBSCRIPTIONS REMINDER</h2>';
    
    // get users with expired subscription
    $args = array(
        'limit'		=> -1,
        'status'	=> 1,
        'to_get'	=> array('id', 'name', 'surname', 'username', 'email', 'tel', 'categories', 'pcpp_subscr_status', 'pcpp_active_order'),
        'search'	=> array(
            array(
                'relation' => 'AND',
                array(
                    'key' 		=> 'email',
                    'operator'	=> '!=', 
                    'val'		=> ''
                ),
                array(
                    'key' 		=> 'pcpp_subscr_status',
                    'operator'	=> 'IN', 
                    'val'		=> array('expired', 'active')
                ),
                array(
                    'key'       => 'pcpp_expire_subscr_notified',
                    'operator'  => 'NOT EXISTS',
                ),
                array(
                    'key' 		=> 'pcpp_subscr_end',
                    'operator'	=> 'NOT IN', 
                    'val'		=> array('', 'unlimited'),
                ),
                array(
                    'key' 		=> 'pcpp_subscr_end',
                    'operator'	=> '<', 
                    'val'		=> ((int)current_time('timestamp') + 60*60)
                ),
            ),
        )
    );
    $users = $pc_users->get_users($args);
    
    
    
    if(empty($users)) {
        echo 'No users to notify';	
    }
    else {
        // mail texts
        $raw_title = get_option('pcpp_see_title');
        $raw_txt = get_option('pcud_see_txt');

        // is there renew link?
        if(strpos($raw_txt, '%RENEW-LINK%') !== false) {

            $renew_pag = get_permalink(get_option('pcpp_order_renew_page'));
            if(empty($renew_pag)) {
                die('No renew page specified');	
            }	
        }

        // send reminders
        $report = array();

        foreach($users as $data) {
            $uid = $data['id'];

            // check expiration date if is marked as active
            if($data['pcpp_subscr_status'] == 'active') {
                $data['pcpp_subscr_status'] = pcpp_user_subscr_static::check_subscr_expir($uid);	
            }
            if($data['pcpp_subscr_status'] != 'expired') {
                continue;
            }


            // send	
            $title = pcma_replace_placeholders($uid, $raw_title, $data);
            $txt = pcma_replace_placeholders($uid, $raw_txt, $data);

            if(isset($renew_pag)) {		
                $link_url = add_query_arg(array(
                        'pcpp_action'  => 'renew_subscr',
                        'pcpp_renew'   => wp_hash_password($uid),
                        'uid'          => $uid,
                    ), 
                    $renew_pag
                );
                $txt = str_replace('%RENEW-LINK%', '<a href="'. $link_url .'">'. $link_url .'</a>', $txt);
            }

            $mail_sent = pcma_send_mail($data['username'], $data['email'], $title, $txt);


            $pc_meta->add_meta($uid, 'pcpp_expire_subscr_notified', current_time('mysql'));
            $report[$uid] = $data['username'];
        }

        // write report
        echo '<p><strong>'. count($report) .' NOTIFIED USERS:</strong> '. implode(', ', $report) .'</p>';
    }
}





/////////////////////////////////////////////
//// EXPIRING TRIALS REMINDER ///////////////
/////////////////////////////////////////////
    

if(get_option('pcpp_pcma_bte_enble')) { // retrocompatibility - target new reminder texts existence
    echo '<h2>TRIAL PERIOD EXPIRATION FOREWARNING</h2>';
    
    // get trial subscriptions in the right forewarn time span
    // TODO - create field and calculate seconds
    
    $args = array(
        'limit'		=> -1,
        'status'	=> 1,
        'to_get'	=> array('id', 'name', 'surname', 'username', 'email', 'tel', 'categories', 'pcpp_subscr_status'),
        'search'	=> array(
            array(
                'relation' => 'AND',
                array(
                    'key' 		=> 'email',
                    'operator'	=> '!=', 
                    'val'		=> ''
                ),
                array(
                    'key' 		=> 'pcpp_subscr_status',
                    'operator'	=> '=', 
                    'val'		=> 'trial'
                ),
                array(
                    'key'       => 'pcpp_trial_exp_forewarned', // TODO - delete meta once trial period expired or subscription has been made
                    'operator'  => 'NOT EXISTS',
                ),
                array(
                    'key'       => 'pcpp_trial_ending',
                    'operator'  => 'EXISTS',
                ),
                array(
                    'key' 		=> 'pcpp_trial_ending',
                    'operator'	=> '<', 
                    'val'		=> ((int)current_time('timestamp') + (60*60*24* (int)get_option('pcpp_pcma_bte_forewarn', 1) ))
                ),
            ),
        )
    );
    $users = $pc_users->get_users($args);
    
    if(empty($users)) {
        die('No users to notify');	
    }

    // mail texts
    $raw_title = get_option('pcpp_bte_title');
    $raw_txt = get_option('pcud_bte_txt');
    
    // send reminders
    $report = array();
    
    foreach($users as $data) {
        $uid = $data['id'];

        // check if is still in trial
        pcpp_user_subscr_static::check_subscr_expir($uid);	
        if(isset($GLOBALS['pcpp_expired_trial'])) {
            continue;
        }

        // send	
        $title = pcma_replace_placeholders($uid, $raw_title, $data);
        $txt = pcma_replace_placeholders($uid, $raw_txt, $data);

        $mail_sent = pcma_send_mail($data['username'], $data['email'], $title, $txt);

        $pc_meta->add_meta($uid, 'pcpp_trial_exp_forewarned', current_time('mysql'));
        $report[$uid] = $data['username'];
    }

    // write report
    echo '<p><strong>'. count($report) .' NOTIFIED USERS:</strong> '. implode(', ', $report) .'</p>';
}


