<?php
// PRIVATECONTENT USER ACTIVITIES ADD-ON INTEGRATION


// INJECT ACTIVITY TYPE GROUP
function pcpp_pcua_act_type_groups($groups) {
    $groups['pcpp'] = __('Premium Plans add-on', PCPP_ML);
    return $groups;
}
add_filter('pcua_act_type_groups', 'pcpp_pcua_act_type_groups'); 





// ACTIVITY TYPES
function pcpp_pcua_act_types($at) {
    $ml_key = PCPP_ML;

    if(!function_exists('get_woocommerce_currency_symbol')) {
        return $at;   
    }
    $currency = html_entity_decode(get_woocommerce_currency_symbol());
    
    
    // user paid for a subscription
    $at['pcpp_order_paid'] = array(
        'name'  => __('Subscription order paid', $ml_key),
        'helper'=> __('Reporting whenever user subscription payment has been processed', $ml_key),
        'group' => 'pcpp',
        'metas' => array(
            'order_id' => array(
                'name'      => __('Order ID', $ml_key),
                'data_type' => 'mixed',
                'num_unit'  => '',
                'helper'    => '',
            ),
            'order_amount' => array(
                'name'      => __('Order amount', $ml_key),
                'data_type' => 'num',
                'num_unit'  => $currency,
                'helper'    => '',
            ),
            'plan_id' => array(
                'name'      => __('Plan ID', $ml_key),
                'data_type' => 'mixed',
                'num_unit'  => '',
                'helper'    => __('Subscription plan ID', $ml_key),
            ),
            'plan_name' => array(
                'name'      => __('Plan name', $ml_key),
                'data_type' => 'mixed',
                'num_unit'  => '',
                'helper'    => __('Subscription plan name', $ml_key),
            ),
        ),
    );
    
    
    // user started trial period
    $at['pcpp_trial_started'] = array(
        'name'  => __('User subscription trial started', $ml_key),
        'helper'=> __('Reporting whenever a user starts subscription trial', $ml_key),
        'group' => 'pcpp',
        'metas' => array(
            'plan_id' => array(
                'name'      => __('Plan ID', $ml_key),
                'data_type' => 'mixed',
                'num_unit'  => '',
                'helper'    => __('Subscription plan ID', $ml_key),
            ),
            'plan_name' => array(
                'name'      => __('Plan name', $ml_key),
                'data_type' => 'mixed',
                'num_unit'  => '',
                'helper'    => __('Subscription plan name', $ml_key),
            ),
        ),
    );
    
    
    // user trial period ended
    $at['pcpp_trial_ended'] = array(
        'name'  => __('User subscription trial ended', $ml_key),
        'helper'=> __('Reporting whenever a user subscription trial ended and user did not pay yet', $ml_key),
        'group' => 'pcpp',
        'metas' => array(
            'plan_id' => array(
                'name'      => __('Plan ID', $ml_key),
                'data_type' => 'mixed',
                'num_unit'  => '',
                'helper'    => __('Subscription plan ID', $ml_key),
            ),
            'plan_name' => array(
                'name'      => __('Plan name', $ml_key),
                'data_type' => 'mixed',
                'num_unit'  => '',
                'helper'    => __('Subscription plan name', $ml_key),
            ),
        ),
    );
    
    
    // user subscription expired
    $at['pcpp_subscr_expired'] = array(
        'name'  => __('User subscription expired', $ml_key),
        'helper'=> __('Reporting whenever an active user subscription expires', $ml_key),
        'group' => 'pcpp',
        'metas' => array(
            'plan_id' => array(
                'name'      => __('Plan ID', $ml_key),
                'data_type' => 'mixed',
                'num_unit'  => '',
                'helper'    => __('Subscription plan ID', $ml_key),
            ),
            'plan_name' => array(
                'name'      => __('Plan name', $ml_key),
                'data_type' => 'mixed',
                'num_unit'  => '',
                'helper'    => __('Subscription plan name', $ml_key),
            ),
            'was_trial' => array(
                'name'      => __('Was trial period?', $ml_key),
                'data_type' => 'mixed',
                'num_unit'  => '',
                'helper'    => __('Knowing whether user was in its trial period (1 = yes, 0 = no)', $ml_key),
            ),
        ),
    );
    
    return $at;
}
add_filter('pcua_act_types', 'pcpp_pcua_act_types');








// ACTIVITY TRIGGERS
/*
array(
    'trigger_slug' => array(
        'act_type' => activity_slug,
        'trig_type' => wp_hook || js_event
        'helper' =>,
        'js_event' => array(
            'selector' =>,
            'event' =>,
            'is_jquery' => 1|0,
            'once_per_page' => 1|0,
        ),
        'wp_hook' => array(
            'type' => action || filter,
            'name' => ,
        ),
        'meta_assoc'=> array(
            'type_meta_slug'   => JS code returning a value (if js_event)
            'type_meta_slug'   => e.attr_name (if js_event > e is event object)
            'type_meta_slug'   => (int) jquery custom param num (if jquery js_event)

            'type_meta_slug'   => (int) hook param num (if wp_hook)
            'type_meta_slug'   => (string) PHP function name (if wp_hook)
        )
    )
) 
*/
function pcpp_pcua_act_triggers($atrig) {
    $ml_key = PCPP_ML;
    
    if(!$GLOBALS['pcpp_enabled'] || !function_exists('get_woocommerce_currency_symbol')) {
        return $atrig;   
    }
    
    
    // user paid for a subscription
    $atrig['pcpp_order_paid'] = array(
        'act_type'  => 'pcpp_order_paid',
        'trig_type' => 'wp_hook',
        'helper'    => __('Official way to track Premium Plans add-on subscription payments', $ml_key),
        
        'wp_hook' => array(
            'type' => 'action',
            'name' => 'pcpp_woo_order_completed',
        ),
        'meta_assoc'=> array(
            'order_id'      => 1,
            'order_amount'  => 1,
            'plan_id'   => 1,
            'plan_name' => 1,
        )
    );
    
    
    // user started trial period
    $atrig['pcpp_trial_started'] = array(
        'act_type'  => 'pcpp_trial_started',
        'trig_type' => 'wp_hook',
        'helper'    => __('Official way to track Premium Plans add-on subscription trials start', $ml_key),
        
        'wp_hook' => array(
            'type' => 'action',
            'name' => 'pcpp_user_started_trial',
        ),
        'meta_assoc'=> array(
            'plan_id'   => 2,
            'plan_name' => 2,
        )
    );
    
    
    // user trial period ended
    $atrig['pcpp_trial_ended'] = array(
        'act_type'  => 'pcpp_trial_ended',
        'trig_type' => 'wp_hook',
        'helper'    => __('Official way to track Premium Plans add-on subscription trials end', $ml_key),
        
        'wp_hook' => array(
            'type' => 'action',
            'name' => 'pcpp_trial_ended',
        ),
        'meta_assoc'=> array(
            'plan_id'   => 2,
            'plan_name' => 2,
        )
    );
    
    
    // user subscription expired
    $atrig['pcpp_subscr_expired'] = array(
        'act_type'  => 'pcpp_subscr_expired',
        'trig_type' => 'wp_hook',
        'helper'    => __('Official way to track Premium Plans add-on subscriptions expiration', $ml_key),
        
        'wp_hook' => array(
            'type' => 'action',
            'name' => 'pcpp_expired_subscription',
        ),
        'meta_assoc'=> array(
            'plan_id'   => 2,
            'plan_name' => 2,
            'was_trial' => 3
        )
    );
    
    return $atrig;
}
add_filter('pcua_act_triggers', 'pcpp_pcua_act_triggers');







// set user ID for pcpp_order_paid, pcpp_subscr_expired, pcpp_trial_ended and pcpp_trial_started activities
function pcpp_acts_set_uid($uid, $act_slug, $hook_vars, $act_params, $act_metas) {
    if(in_array($act_slug, array('pcpp_subscr_expired', 'pcpp_trial_started', 'pcpp_trial_ended'))) {
        return $hook_vars[0];
    }
    elseif($act_slug == 'pcpp_order_paid') {
        return $hook_vars[1];
    }
    
    return $uid;
}
add_filter('pcua_add_act_from_trigger_uid', 'pcpp_acts_set_uid', 10, 5);




// set meta values for pcpp_order_paid activity
function pcpp_set_pcpp_order_paid_metas($metas, $act_slug, $params) {
    if($act_slug != 'pcpp_order_paid') {
        return $metas;
    }
    
    global $pcpp_subscr;
    $order_id = $metas['order_id'];
    $order = $pcpp_subscr->get_order($order_id);
    
    $metas['order_amount']  = (PCPP_ECOMMERCE == 'woocomm') ? (float)$order->get_total() : false;
    $metas['plan_id']       = $pcpp_subscr->get_order_plan_id($order_id);
    $metas['plan_name']     = get_the_title($metas['plan_id']);
    
    return $metas;
}
add_filter('pcua_add_act_metas', 'pcpp_set_pcpp_order_paid_metas', 10, 3);




// set plan name for pcpp_subscr_expired, pcpp_trial_ended and pcpp_trial_started activities 
function pcpp_set_plan_name_meta($metas, $act_slug, $params) {
    if(!in_array($act_slug, array('pcpp_subscr_expired', 'pcpp_trial_started', 'pcpp_trial_ended'))) {
        return $metas;    
    }
    
    $metas['plan_name'] = get_the_title($metas['plan_name']);
    return $metas;
}
add_filter('pcua_add_act_metas', 'pcpp_set_plan_name_meta', 10, 3);
