<?php
// ADD-ON SETTINGS - INTEGRATED IN PVTCONTENT ONES


// COUPON FIELD - ADD CUSTOM ICON
function pcpp_coupon_details_field($field_id, $field, $value, $all_vals) {
    dike_lc('lcweb', PCPP_DIKE_SLUG, true);
    
	$icon 	= get_option('pcpp_coupon_field_icon');
	?>
    <tr class="pc_<?php echo $field_id ?>_tr">
		<td class="lcwp_sf_label">
        	<label>Premium Plan add-on - <?php _e("Coupon field's icon", PCPP_ML) ?></label>
        </td>
		<td class="lcwp_sf_field">
			
            <div class="pc_field_icon_trigger">
            	<i class="<?php echo esc_attr( pc_static::fontawesome_v4_retrocomp($icon)) ?>" title="<?php esc_attr_e('set icon', PCPP_ML) ?>"></i>
                <input type="hidden" name="pcpp_coupon_field_icon" value="<?php echo esc_attr($icon) ?>" /> 
            </div>
		</td>
	</tr>
    <?php
}
function pcpp_coupon_details($structure) {
	$structure['styling']['fix_field_details']['fields']['pcpp_coupon_field_icon'] = array(
		'type'		=> 'custom',
		'callback'	=> 'pcpp_coupon_details_field',
		'validation'=> array(
			array('index' => 'pcpp_coupon_field_icon', 'label' => "Premium Plans add-on - Coupon field's icon"),
		)
	);
	return $structure;
}
add_filter('pc_settings_structure', 'pcpp_coupon_details');




// STYLING OPTIONS FIELD CUSTOM ICON
function pcpp_styling_settings($structure) {

	// styling
	$to_edit = $structure['styling'];
	$to_add = array(
		'pcpp_styling' => array(
			'sect_name'	=> 'Premium Plans add-on - '. __("form fields", PCPP_ML),
			'fields' 	=> array(
				
				'pcpp_plan_bg' => array(
					'label' => __("Plan box background - default state", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#fbfbfb',
                    'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
					'note'	=> '',
				),
				'pcpp_plan_border_col' => array(
					'label' => __("Plan box border color - default state", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#e8e8e8',
                    'extra_modes' => array('alpha'),
					'note'	=> '',
				),
				'pcpp_plan_txt_col' => array(
					'label' => __("Plan box text color - default state", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#373737',
                    'extra_modes' => array(),
					'note'	=> '',
				),
				'pcpp_plan_flap_h' => array(
					'label' => __("Plan left flap color - hover state", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#ececec',
                    'extra_modes' => array('alpha'),
					'note'	=> '',
				),
				'spcr2' => array(
					'type' => 'spacer',
				),
				'pcpp_plan_bg_sel' => array(
					'label' => __("Plan box background - selected state", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#ffffff',
                    'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
					'note'	=> '',
				),
                'pcpp_plan_border_col_sel' => array(
					'label' => __("Plan box border color - selected state", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#e8e8e8',
                    'extra_modes' => array('alpha'),
					'note'	=> '',
				),
				'pcpp_plan_txt_col_sel' => array(
					'label' => __("Plan box text color - selected state", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#373737',
                    'extra_modes' => array(),
					'note'	=> '',
				),
				'pcpp_plan_flap_sel' => array(
					'label' => __("Plan left flap color - selected state", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#d2d2d2',
                    'extra_modes' => array('alpha'),
					'note'	=> '',
				),
				'spcr3' => array(
					'type' => 'spacer',
				),
                'pcpp_extra_fluid_form_mode' => array(
					'label' => __('Extra layout for fluid forms', PCPP_ML),
					'type'	=> 'select',
					'val' 	=> array(
                        ''          => __('none', PCPP_ML),
                        'bold'      => __('bold', PCPP_ML),
                        'compact'   => __('compact', PCPP_ML)
                    ),
                    'def'   => (get_option('pcpp_bold_fluid_layout')) ? 'bold' : false,
				), 
                'pcpp_bfl_title_bord_rad' => array(
					'label' 	=> __("Bold layout title - border radius", PCPP_ML),
					'type'		=> 'slider',
					'min_val'	=> 0,
					'max_val'	=> 30,	
					'step'		=> 1,
					'value'		=> 'px',
					'def'		=> 1,
					'note'		=> '',
                    'respect_limits' => false,
                    
                    'js_vis'	=> array(
                        'linked_field' 	=> 'pcpp_extra_fluid_form_mode',
                        'condition'		=> 'bold' 
                    )
				),
				'pcpp_bfl_title_col' => array(
					'label' => __("Bold layout title color - default state", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#444444',
                    'extra_modes' => array(),
					'note'	=> '',
                    
                    'js_vis'	=> array(
                        'linked_field' 	=> 'pcpp_extra_fluid_form_mode',
                        'condition'		=> 'bold' 
                    )
				),
				'pcpp_bfl_title_bg' => array(
					'label' => __("Bold layout title background - default state", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#eeeeee',
                    'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
					'note'	=> '',
                    
                    'js_vis'	=> array(
                        'linked_field' 	=> 'pcpp_extra_fluid_form_mode',
                        'condition'		=> 'bold' 
                    )
				),
				'spcr4' => array(
					'type' => 'spacer',
                    
                    'js_vis'	=> array(
                        'linked_field' 	=> 'pcpp_extra_fluid_form_mode',
                        'condition'		=> 'bold' 
                    )
				),
				'pcpp_bfl_title_col_sel' => array(
					'label' => __("Bold layout title color - selected state", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#555555',
                    'extra_modes' => array(),
					'note'	=> '',
                    
                    'js_vis'	=> array(
                        'linked_field' 	=> 'pcpp_extra_fluid_form_mode',
                        'condition'		=> 'bold' 
                    )
				),
				'pcpp_bfl_title_bg_sel' => array(
					'label' => __("Bold layout title background - selected state", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#dddddd',
                    'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
					'note'	=> '',
                    
                    'js_vis'	=> array(
                        'linked_field' 	=> 'pcpp_extra_fluid_form_mode',
                        'condition'		=> 'bold' 
                    )
				),
				'spcr5' => array(
					'type' => 'spacer',
				),
				'pcpp_trial_bg' => array(
					'label' => __("Trial period box - background", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#f5f5f5',
                    'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
					'note'	=> '',
				),
				'pcpp_trial_txt_col' => array(
					'label' => __("Trial period box - text color", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#373737',
                    'extra_modes' => array(),
					'note'	=> '',
				),
				'pcpp_trial_border_w' => array(
					'label' 	=> __("Trial period box - border width", PCPP_ML),
					'type'		=> 'slider',
					'min_val'	=> 0,
					'max_val'	=> 6,	
					'step'		=> 1,
					'value'		=> 'px',
					'def'		=> 0,
					'note'		=> '',
                    'respect_limits' => false,
				),
				'pcpp_trial_border_col' => array(
					'label' => __("Trial period box - border color", PCPP_ML),
					'type'	=> 'color',
					'def'	=> '#d2d2d2',
                    'extra_modes' => array('alpha'),
					'note'	=> '',
				),
			),
		),
	);
	
    include_once(PC_DIR .'/settings/settings_engine.php');
	$structure['styling'] = pc_settings_engine::inject_array_elem($to_add, $to_edit, 'colors');
	return $structure;	
}
add_filter('pc_settings_structure', 'pcpp_styling_settings');








// PCPP OPTIONS - ADD TAB
function pcpp_settings_tab($tabs) {
	$tabs['pcpp_setting'] = 'Premium Plans';
	return $tabs;
}
add_filter('pc_settings_tabs', 'pcpp_settings_tab');




// PCPP OPTIONS - CUSTOM FIELDS

// trial period
function pcpp_trial_preriod_field($field_id, $field, $value, $all_vals) {
	echo '	
	<tr class="pc_'. $field_id .'">
		<td class="lcwp_sf_label"><label>'. __('Trial period', PCPP_ML) .'</label></td>
		<td class="lcwp_sf_field">
			<input type="number" name="pcpp_trial_duration" value="'. (int)$all_vals['pcpp_trial_duration'] .'" autocomplete="off" maxlength="3">
			<select name="pcpp_trial_type" autocomplete="off">';

				foreach(pcpp_static::periods() as $type => $name) {
					echo '<option value="'. esc_attr($type) .'" '.selected($all_vals['pcpp_trial_type'], $type).'>'. esc_html($name) .'</option>';	
				}

	echo '
			</select>
		</td>
		<td><span class="lcwp_sf_note">'. __("Set a trial period for subscribers. Use zero to discard the feature", PCPP_ML) .'</span></td>
	</tr>';
}


// existing users association
function pcpp_eua_field($field_id, $field, $value, $all_vals) {
	global $pc_users, $pcpp_subscr;
	?>
	<table class="widefat lcwp_settings_table pc_settings_block pcpp_exist_users_assoc_table">
      <tbody>
        <tr>
          <td class="lcwp_sf_label"><?php _e('Which plan to associate?', PCPP_ML) ?></td>
          <td class="lcwp_sf_field">
             <select name="pcpp_no_plan_set" id="pcpp_no_plan_set" class="pc_lc_select" data-placeholder="<?php esc_attr_e('Select plan', PCPP_ML) ?> .." autocomplete="off">
             <?php
             foreach($pcpp_subscr->get_plans(false) as $plan_id => $plan_name) {
                  echo '<option value="'. $plan_id .'">'. esc_html($plan_name . pcpp_static::dd_plan_details($plan_id)) .'</option>';   
             }
             ?>
             </select>
          </td>
          <td <?php if((int)$all_vals['pcpp_trial_duration']) {echo 'rowspan="2"';} ?> class="pcpp_no_plan_set_btn_wrap">
              <input type="button" value=" <?php esc_attr_e('Apply', PCPP_ML) ?> " class="button-secondary" id="pcpp_no_plan_set_btn" />
              <span></span>
          </td>
        </tr>
        
        <?php if($all_vals['pcpp_trial_duration']) : ?>
            <tr>
              <td class="lcwp_sf_label">
                  <?php _e('Apply trial period?', PCPP_ML) ?> (<?php echo $all_vals['pcpp_trial_duration'].' '.pcpp_static::sing_plur_switch($all_vals['pcpp_trial_type'], $all_vals['pcpp_trial_duration']); ?>)
              </td>
              <td class="lcwp_sf_field">
                  <input type="checkbox" name="pcpp_apply_trial"  id="pcpp_apply_trial" value="1" autocomplete="off" class="lcwp_sf_check" />
              </td>
            </tr>
        <?php endif; ?>
        
      </tbody>
    </table>	
    <?php
}





// PCPP OPTIONS - fields
function pcpp_settings($structure) {
	include_once(PC_DIR .'/classes/pc_form_framework.php');

	global $pc_users, $pcpp_subscr;
	$f_fw = new pc_form;
	
	$avail_ecomm = pcpp_static::avail_ecomm();
	$pages = get_pages(); 
	
	// available plans
	$form_plans = array();
	foreach($pcpp_subscr->get_plans() as $plan_id => $name) {
		$form_plans[$plan_id] = $name . pcpp_static::dd_plan_details($plan_id);	
	}
	
	// custom fields for billing association
	$cust_fields = array('' => __('Do not associate fields', PCPP_ML));
	foreach($f_fw->fields as $f_index => $f_data) {
		if(!in_array($f_index, array_merge($pc_users->fixed_fields, array('pc_disclaimer', 'pcpp_plan')) )) {
			$cust_fields[$f_index] = $f_data['label'];	
		}
	}
	
    // available registration forms
    $reg_forms_raw = get_terms('pc_reg_form', 'hide_empty=0&orderby=name&order=ASC');
    $reg_forms = array();
    foreach($reg_forms_raw as $rf) {
        $reg_forms[ $rf->term_id ] = $rf->name;    
    }
    
    
	// message if trying to enable but have no plans
	if(isset($GLOBALS['pcpp_no_implement_warn'])) {
		echo '<div class="error"><p>Premium Plans add-on - '. __('integration disabled. No plans found', PCPP_ML) .'</p></div>';	
	}
	
	
	$opts = array(
		'pcpp_main_settings' => array(
			'sect_name'	=>  __('Main settings', PCPP_ML),
			'fields' 	=> array(
	
                'pcpp_enabled' => array(
					'label' => __('Enable add-on integration?', PCPP_ML),
					'type'	=> 'checkbox',
					'note'	=> __('If checked, enables frontend integration, requiring a subscription plan selection to register', PCPP_ML),
				),
                'spcr1' => array(
					'type' => 'spacer',
				),
				'pcpp_ecomm_to_use' => array(
					'label' => __('Which e-commerce system to use?', PCPP_ML),
					'type'	=> 'select',
					'val' 	=> $avail_ecomm,
					'hide'	=> (count($avail_ecomm) < 2) ? true : false,
					'note'	=> __('Choose which e-commerce plugin to use to manage purchases', PCPP_ML), 
				), 
				'pcpp_default_plan' => array(
					'label' => __('Default plan', PCPP_ML),
					'type'	=> 'select',
					'val' 	=> $form_plans,
					'fullwidth' => true,
					'note'	=> __('Choose which plan will be suggested and selected by default in registration forms', PCPP_ML), 
				),
                'pcpp_use_duration_ext' => array(
                    'label' => __('Use plans duration extension?', PCPP_ML),
                    'type'	=> 'select',
                    'val' 	=> array(
                        'always'    => __('yes - in every form', PCPP_ML),
                        'registr'   => __('yes - only in registration forms', PCPP_ML),
                        'no'        => __('no'),
                    ),
                    'note'	=> '', 
                ), 
				'pcpp_use_coupon' => array(
					'label' => __('Enable coupons integration?', PCPP_ML),
					'type'	=> 'checkbox',
					'note'	=> __('If checked, allows users to enter discount coupons on registration', PCPP_ML),
				),
				'pcpp_trial_preriod_field' => array(
					'type'		=> 'custom',
					'callback'	=> 'pcpp_trial_preriod_field',
					'validation'=> array(
						array('index' => 'pcpp_trial_duration', 'label' => __('Trial period', PCPP_ML), 'required' => true, 'type' => 'int'),
						array('index' => 'pcpp_trial_type', 'label' => 'Trial period type'),
					)
				), 
				'pcpp_trial_txt' => array(
					'label' => __('Trial period - custom text', PCPP_ML),
					'type'	=> 'text',
					'fullwidth' => true,
					'note'	=> __('By default is "&lt;strong&gt;X PERIOD-TYPE free trial!&lt;/strong&gt;"', PCPP_ML),
				),
			),
		), 
	);
		
		
	$opts['pcpp_checkout'] = array(
		'sect_name'	=>  __('Checkout integration', PCPP_ML),
		'fields' 	=> array(

			'pcpp_order_ok_page' => array(
				'label' => __('Successful order redirect', PCPP_ML),
				'type'	=> 'select',
				'val' 	=> array('0' => '['. __('Use default page', PCPP_ML) .']') + pc_static::get_pages(),
				'note'	=> __("Choose where to redirect users after successful checkout", PCPP_ML) .'. <br/><strong class="lcwp_settings_rednote">'. __('Using custom page, be sure it is brand new. By default will redirect to homepage', PCPP_ML) .'</strong>', 
			), 
			'pcpp_order_del_page' => array(
				'label' => __('Cancelled order redirect', PCPP_ML),
				'type'	=> 'select',
				'val' 	=> pc_static::get_pages(),
				'note'	=> __("Landing page used to delete user orders", PCPP_ML) .'. <br/><strong class="lcwp_settings_rednote">'. __('Use a new page, by default will redirect to homepage', PCPP_ML) .'</strong>', 
			), 
		),
	);
	
	
    
    $woo_subscr_cant_discount_warn = (pcpp_woo_subscr_static::supports_woo_subscr()) ? '.<br/><strong>'. __("NB: WooCommerce recurring payments CANNOT use the discount", PCPP_ML) .'</strong>' : '';
    
	$opts['pcpp_renew'] = array(
		'sect_name'	=>  __('Subscription Plan Change / Renew', PCPP_ML),
		'fields' 	=> array(

			'pcpp_order_change_behav' => array(
				'label' => __("Plan's change for active logged users", PCPP_ML),
				'type'	=> 'select',
				'val' 	=> array(
                    'no_change' => __('avoid plan change (only extension)', PCPP_ML),
                    'discount'  => __('discount remaining subscription amount paid', PCPP_ML),
                    'full_price'=> __('no discount', PCPP_ML),
                ),
				'note'	=> __("Choose whether active users can change their active plan or only extend its duration", PCPP_ML) . $woo_subscr_cant_discount_warn, 
			), 
            'pcpp_order_change_date_format' => array(
				'label' 	=> __("Date format", PCPP_ML),
				'type'		=> 'text',
				'maxlen'	=> 20,
                'def'       => get_option('date_format'),
				'note'		=> __('Define which date representation format is used in forms. Use the <strong><a href="https://www.w3schools.com/php/func_date_date.asp" target="_blank">PHP format</a></strong><br/>By default is:', PCPP_ML) .' '. get_option('date_format'),
			),
			'pcpp_order_renew_page' => array(
				'label' => __('Renew order page', PCPP_ML),
				'type'	=> 'select',
				'val' 	=> array('0' => '['. __('Avoid subscriptions renewal', PCPP_ML) .']') + pc_static::get_pages(),
				'note'	=> __("Page used to let users change their subscription plan. By default avoid changes, simply creating a new order. To show plan's selection form use <strong>[pcpp-renew-plan]</strong> shortcode", PCPP_ML) .'. <br/><strong class="lcwp_settings_rednote">'. __('Using custom page, be sure it is brand new. By default will redirect to homepage', PCPP_ML) .'</strong>', 
			),
		),
	);
	

	if(!empty($cust_fields)) {
		$opts['billing_fields'] = array(
			'sect_name'	=>  __('Billing fields association', PCPP_ML),
			'fields' 	=> array(
	
				'pcpp_bill_company_f' => array(
					'label' => __('Company field', PCPP_ML),
					'type'	=> 'select',
					'val' 	=> $cust_fields,
					'note'	=> __("Choose which form field to associate for company", PCPP_ML),
				), 
				'pcpp_bill_address_f' => array(
					'label' => __('Address field', PCPP_ML),
					'type'	=> 'select',
					'val' 	=> $cust_fields,
					'note'	=> __("Choose which form field to associate for address", PCPP_ML),
				), 
                'pcpp_bill_address2_f' => array(
					'label' => __('Second address field', PCPP_ML),
					'type'	=> 'select',
					'val' 	=> $cust_fields,
					'note'	=> __("Choose which form field to associate forthe second  address", PCPP_ML),
				),
				'pcpp_bill_city_f' => array(
					'label' => __('City field', PCPP_ML),
					'type'	=> 'select',
					'val' 	=> $cust_fields,
					'note'	=> __("Choose which form field to associate for city", PCPP_ML),
				), 
				'pcpp_bill_postcode_f' => array(
					'label' => __('Postcode field', PCPP_ML),
					'type'	=> 'select',
					'val' 	=> $cust_fields,
					'note'	=> __("Choose which form field to associate for postcode", PCPP_ML),
				),
				'pcpp_bill_state_f' => array(
					'label' => __('State field', PCPP_ML),
					'type'	=> 'select',
					'val' 	=> $cust_fields,
					'note'	=> __("Choose which form field to associate for state", PCPP_ML),
				),
				'pcpp_bill_country_f' => array(
					'label' => __('Country field', PCPP_ML),
					'type'	=> 'select',
					'val' 	=> $cust_fields,
					'note'	=> __("Choose which form field to associate for country", PCPP_ML) .'. <strong><span class="lcwp_settings_rednote">'. __("It must be a dropdown field containing proper values.<br/>The quickest way to achieve it is using User Data add-on and its automated options composition.", PCPP_ML) .'</span></strong>',
				),
			),
		);
	}
	
	
	$opts['pcpp_messages'] = array(
		'sect_name'	=>  __('Messages', PCPP_ML),
		'fields' 	=> array(
			
			'pcpp_registr_mex' => array(
				'label' 	=> __('Default message for registered users', PCPP_ML),
				'type'		=> 'text',
				'maxlen'	=> 250,
				'fullwidth'	=> true,
				'note'		=> __('By default is "Successful registration! Now you will be moved to checkout page"', PCPP_ML).' <strong>('. __('Used only if there is no trial period', PCPP_ML) .')</strong>',
			),
			'pcpp_unpaid_mex' => array(
				'label' 	=> __('Unpaid subscriptions login message (checkout link is appended)', PCPP_ML),
				'type'		=> 'text',
				'maxlen'	=> 250,
				'fullwidth'	=> true,
				'note'		=> __('By default is "Hello, you have an unpaid subscription"', PCPP_ML),
			),
			'pcpp_exp_trial_mex' => array(
				'label' 	=> __('Expired trial period login message (checkout link is appended)', PCPP_ML),
				'type'		=> 'text',
				'maxlen'	=> 250,
				'fullwidth'	=> true,
				'note'		=> __('By default is "Hello, your trial period ended"', PCPP_ML),
			),
			'pcpp_expired_mex' => array(
				'label' 	=> __('Expired subscriptions login message (link to renew is appended)', PCPP_ML),
				'type'		=> 'text',
				'maxlen'	=> 250,
				'fullwidth'	=> true,
				'note'		=> __('By default is "Hello, your subscription has expired"', PCPP_ML),
			),
		),
	);
	
	
	$opts['pcpp_pcf_opts'] = array(
		'sect_name'	=>  __("Plan's Chooser Block", PCPP_ML),
		'fields' 	=> array(
			
            'pcpp_pcf_behav' => array(
                'label' => __('Boxes behavior on click', PCPP_ML),
                'type'	=> 'select',
                'val' 	=> array(
                    'lightbox'  => __('open lightbox', PCPP_ML),
                    'redirect'  => __('redirect to page', PCPP_ML),
                ),
            ), 
            'pcpp_pcf_redirect_behav' => array(
				'label' => __('Redirect page', PCPP_ML),
				'type'	=> 'select',
				'val' 	=> pc_static::get_pages(),
				'note'	=> __("Select the page where to move users on plan's choice", PCPP_ML), 
                
                'js_vis'	=> array(
                    'linked_field' 	=> 'pcpp_pcf_behav',
                    'condition'		=> 'redirect' 
                )
			), 
            'pcpp_pcf_lightbox_behav' => array(
				'label' => __('Lightbox to open', PCPP_ML),
				'type'	=> 'select',
				'val' 	=> pc_static::get_lb_instances(),
				'note'	=> __("Select the lightbox instance to open on plan's choice. Be sure to have a registration form in it!", PCPP_ML), 
                
                'js_vis'	=> array(
                    'linked_field' 	=> 'pcpp_pcf_behav',
                    'condition'		=> 'lightbox' 
                )
			), 
			'pcpp_pcf_btn_txt' => array(
				'label' 	=> __("Button's text", PCPP_ML),
				'type'		=> 'text',
				'maxlen'	=> 50,
                'def'       => __('Subscribe', PCPP_ML),
				'note'		=> __('By default is "Subscribe"', PCPP_ML),
			),
		),
	);
    
	
	$opts['pcpp_extra'] = array(
		'sect_name'	=>  __('Extra', PCPP_ML),
		'fields' 	=> array(
			
			'pcpp_enable_pending_after_checkout' => array(
				'label' => __('Enable pending user after checkout?', PC_ML),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, automatically enables pending user after successful checkout", PC_ML),
			), 
			'pcpp_del_orders_on_user_del' => array(
				'label' => __('Delete orders on user deletion?', PC_ML),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, will remove orders on user deletion", PC_ML),
			), 
            'pcpp_dont_logout_user' => array(
				'label' => __('Do NOT logout user if subscription is not active?', PC_ML),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, the add-on won't logout users not having an active subscription. Plans-based restrictions will still work normally", PC_ML),
			), 
            'pcpp_pre_plans_label' => array(
				'label' 	=> __('Custom pre-plans label in forms', PCPP_ML),
				'type'		=> 'text',
                'def'       => __('Choose your plan:', PCPP_ML),
				'fullwidth'	=> true,
				'note'		=> __('Set a custom value for the label appearing before plans list, by default is "Choose your plan:"', PCPP_ML),
			),
			'pcpp_reg_form_btn_text' => array(
				'label' 	=> __('Custom registration form button text', PCPP_ML),
				'type'		=> 'text',
				'maxlen'	=> 50,
                'fullwidth'	=> true,
				'note'		=> __('Set a custom value for registration form button. Leave empty to use the default one', PCPP_ML),
			),
		),
	);
	
	
	$opts['pcpp_eua'] = array(
		'sect_name'	=>  __('Existing users association', PCPP_ML),
		'fields' 	=> array(
			
			'pcpp_eua_field' => array(
				'type'		=> 'custom',
				'callback'	=> 'pcpp_eua_field',
			), 
		),
	);
	

	$structure['pcpp_setting'] = $opts;
	return $structure;
}
add_filter('pc_settings_structure', 'pcpp_settings');




// PCPP OPTIONS - extra codes
function pcpp_settings_js() {
	?>
    <script type="text/javascript">
    (function($) { 
        "use strict"; 

        let pcpp_is_acting = false;

        $(document).on('click', '#pcpp_no_plan_set_btn', function() {
            if(pcpp_is_acting) {
                return false;
            }

            if(!confirm("<?php esc_attr_e("This will be applied to EVERY user without an associated plan. Confirm?", PCPP_ML) ?>")) {
                return false;    
            }
            pcpp_is_acting = true;
            
            const $subj = $(this).parent();
            $subj.find('span').html('<div class="pc_spinner pc_spinner_inline"></div>');

            let data = {
                action      : 'pcpp_bulk_no_plan_assoc',
                plan_id     : $('#pcpp_no_plan_set').val(),
                use_trial   : ($('#pcpp_apply_trial').length && $('#pcpp_apply_trial').is(':checked')) ? 1 : 0,
                pcpp_nonce  : '<?php echo wp_create_nonce('lcwp_ajax') ?>'
            };

            $.post(ajaxurl, data, function(response) {
                let resp = $.trim(response);

                if(resp != 'success') {
                    lc_wp_popup_message('error', response);
                } else {
                    lc_wp_popup_message('success', "<?php esc_attr_e('Plan associated successfully!', PCPP_ML) ?>");
                }
            })
            .fail(function(e) {
                if(e.status) {
                    console.error(e);
                    lc_wp_popup_message('error', "<?php esc_attr_e('Error associating plan', PCPP_ML) ?>");
                }
            })
            .always(function() {
                $subj.find('span').empty();
                pcpp_is_acting = false;
            });
        });
    })(jQuery);
	</script>
    <?php	
}
add_action('pc_settings_extra_code', 'pcpp_settings_js');





// trick to avoid add-on implementation if no products are set up 
function pcpp_settings_save($fdata) {
	
	if((!isset($fdata['pcpp_default_plan']) || empty($fdata['pcpp_default_plan'])) && isset($fdata['pcpp_enabled']) && $fdata['pcpp_enabled']) {
		$fdata['pcpp_enabled'] = false;
		$GLOBALS['pcpp_no_implement_warn'] = true;	
	}
	
	return $fdata;
}
add_filter('pc_before_save_settings', 'pcpp_settings_save');
