<?php
////////// SHORCODES LIST


// [pcpp-change-plan] 
//// form allowing subscription renewal and plan extension/change

function pcpp_change_plan_sc($atts, $content = null) {
	include_once(PC_DIR .'/classes/pc_form_framework.php');

	global $pc_users, $pc_meta, $pcpp_subscr;
	
	if(!$GLOBALS['pcpp_enabled']) {
        return false;
    }
	if(!isset($GLOBALS['pc_user_id']) && !isset($_GET['uid']) && !isset($GLOBALS['pcpp_admin_is_previewing'])) {
        return '';
    }
    
    
    // expired subscriptions renwal
    if(isset($GLOBALS['pcpp_admin_is_previewing'])) {
        $user_id = 0;    
        $GLOBALS['pcpp_renewal_form'] = true;
    }
    elseif(!isset($GLOBALS['pc_user_id'])) {
        $user_id = (int)$_REQUEST['uid'];    

        // check parameters validity
        if(!isset($_GET['pcpp_renew']) || !wp_check_password($user_id, $_GET['pcpp_renew'])) {
            return __("Security token missing or wrong", PCPP_ML);
        }
        
        if($pc_meta->get_meta($user_id, 'pcpp_subscr_status') != 'expired') {
            return __("Your subscription isn't expired", PCPP_ML);       
        }
        
        $GLOBALS['pcpp_renewal_form'] = true;
    }
    
    // plan change for active users
    else {
        $user_id = $GLOBALS['pc_user_id'];
        $GLOBALS['pcpp_pchange_form'] = true;
    }
    
    
	// form code 
	$form = '
	<form class="pvtcont_form pcpp_change_plan_form pc_fluid_form">
		<input type="hidden" name="pcpp_uid" value="'. $user_id .'" />
        <input type="hidden" name="pcpp_key" value="'. wp_hash_password($user_id) .'" />';
		
		$f_fw = new pc_form;
		$form .= $f_fw->form_code(
			array(
				'include' => array('pcpp_plan'), 
				'require' => array()
			), 
			$custom_fields = false, $user_id
		);

    
        if(!isset($GLOBALS['pcpp_admin_is_previewing'])) {   
            $btn_label = (!isset($GLOBALS['pc_user_id'])) ? esc_attr__('Renew Subscription', PCPP_ML) : esc_attr__('Update Subscription', PCPP_ML);
            $form .= '
            <div class="pc_form_response pcpp_form_message"></div>

            <button class="pcpp_change_plan_btn" type="button">
                <span class="pc_inner_btn">'. $btn_label .'</span>
            </button>';
        }
        else {
            $form .= '<div class="pc_warn_box pcpp_safp_warn">'. __("Site administrator's form preview", PCPP_ML) .'</div>';        
        }
    
        $form .= '
	</form>
    
    <script type="text/javascript">
    (function() { 
        "use strict";  

        const intval = setInterval(() => {
            if(typeof(jQuery) == "undefined" || typeof(pc_fluid_form_columnizer) == "undefined") {
                return true;
            }
            else {
                clearTimeout(intval);
                pc_fluid_form_columnizer();
            }
        }, 50);
    })();
    </script>';
	
    unset($GLOBALS['pcpp_renewal_form']);
	return str_replace(array("\r", "\n", "\t", "\v"), '', $form);
}
add_shortcode('pcpp-change-plan', 'pcpp_change_plan_sc');









// [pcpp-user-plan] 
//// retrieve current user's plan name

function pcpp_user_plan_sc($atts, $content = null) {
	$user_plan = pc_user_logged(array('pcpp_plan'));
	return (empty($user_plan)) ? false : get_the_title($user_plan); 
}
add_shortcode('pcpp-user-plan', 'pcpp_user_plan_sc');









// [pcpp-subscr-expir] 
//// retrieve current user subscription's expiration date shown as date or countdown

function pcpp_subscr_expir_sc($atts, $content = null) {
	if(!$GLOBALS['pcpp_enabled']) {
        return false;
    }
    
	extract( shortcode_atts( array(
		'type' 			=> 'date',
		'date_format' 	=> get_option('date_format', 'j F Y'),
	), $atts ) );

	$user_data = pc_user_logged(array('pcpp_plan', 'pcpp_subscr_end', 'pcpp_recurr_subscr', 'pcpp_subscr_status', 'pcpp_trial_ending'));

	// be sure current user has got a valid subscription
	if(empty($user_data['pcpp_plan'])) {
		return false;	
	}

    
    // in trial?
    if($user_data['pcpp_subscr_status'] == 'trial') {
        $title = date_i18n(get_option('date_format').' - '. get_option('time_format'), $user_data['pcpp_trial_ending']);
        $txt = ($type == 'date') ? date_i18n($date_format, $user_data['pcpp_trial_ending']) : pcpp_static::get_countdown_txt($user_data['pcpp_trial_ending']);
    }
    
    else {
        // unlimited plan?
        if($user_data['pcpp_subscr_end'] == 'unlimited') {
            return __('no expiration', PCPP_ML);
        }
        
        // recurring payment or classic plan?
        if(!empty($user_data['pcpp_recurr_subscr'])) {
            $due_date = pcpp_woo_subscr_static::next_due_date($user_data['pcpp_recurr_subscr'], false);

            $title = date_i18n(get_option('date_format').' - '. get_option('time_format'), $due_date);
            $txt = ($type == 'date') ? date_i18n($date_format, $due_date) : pcpp_static::get_countdown_txt($due_date);          
        }
        else {
            $title = date_i18n(get_option('date_format').' - '. get_option('time_format'), $user_data['pcpp_subscr_end']);
            $txt = ($type == 'date') ? date_i18n($date_format, $user_data['pcpp_subscr_end']) : pcpp_static::get_countdown_txt($user_data['pcpp_subscr_end']);        
        }
    }
    
	return '<time title="'. esc_attr($title) .'">'. $txt .'</time>'; 
}
add_shortcode('pcpp-subscr-expir', 'pcpp_subscr_expir_sc');









// [pcpp-user-orders-history] 
//// return currently logged user orders history
function pcpp_user_order_history_sc($atts, $content = null) {
    global $pcpp_subscr;
	
	if(!$GLOBALS['pcpp_enabled']) {
        return false;
    }
    
    extract( shortcode_atts( array(
		'date_format' => get_option('date_format', 'j F Y'),
	), $atts ) );
    
    
    $user_data = pc_user_logged(array('id', 'pcpp_orders'));
    
	// be sure current user has got subscriptions
	if(!$user_data || !is_array($user_data['pcpp_orders']) || empty($user_data['pcpp_orders'])) {
		return false;	
	}
    
    $plans_list = $pcpp_subscr->get_plans(false);
    $orders     = $user_data['pcpp_orders'];
    $user_id    = $user_data['id'];
    
    $code = '
    <table class="pcpp_user_orders_history">
        <thead>
            <tr>
                <th>'. __('Order ID', PCPP_ML) .'</th>
                <th>'. __('Submission date', PCPP_ML) .'</th>
                <th>'. __('Related Plan', PCPP_ML) .'</th>
                <th>'. __('Amount', PCPP_ML) .'</th>
                <th>'. __('Order Status', PCPP_ML) .'</th>';
    
            if($pcpp_subscr->invoicing_system_exists()) {
                $code .= '<th></th>';        
            }
    
    $code .= '
            </tr>
        </thead>
        <tbody>';
    
            $a = 0;
            foreach(array_reverse($orders) as $order_id) {

                // check if exists - otherwise remove
                if(get_post_status($order_id) === false) {
                    pcpp_user_subscr_static::manag_orders($user_id, $order_id, 'remove');
                    continue;
                }

                // WPML & Polylang compatibility - plan name 
                if(!isset($plans_list[ $pcpp_subscr->get_order_plan_id($order_id) ])) { 
                    $ol_plan_name = (isset($plans_list[ pcpp_static::wpml_get_trans_id($pcpp_subscr->get_order_plan_id($order_id)) ])) ? 
                        $plans_list[ pcpp_static::wpml_get_trans_id($pcpp_subscr->get_order_plan_id($order_id)) ] :
                        '<em>['. __('plan not found', PCPP_ML) .']</em>';
                } else {
                    $ol_plan_name =	$plans_list[ $pcpp_subscr->get_order_plan_id($order_id) ];
                }

                $is_expir_ext = ($pcpp_subscr->is_plan_expir_ext_order($order_id)) ? ' <em>('. __('duration extension', PCPP_ML) .')</em>' : '';
                
                // linked to woo subscription tag
                $rel_woo_subscr = '';
                if(pcpp_woo_subscr_static::order_belongs_to_subscr($order_id)) {
                    $rel_woo_subscr = pcpp_woo_subscr_static::get_order_subscr($order_id);
                    
                    if($rel_woo_subscr) {
                        $rws_link = wc_get_endpoint_url('view-subscription', $rel_woo_subscr->get_id(), wc_get_page_permalink('myaccount'));
                        $rel_woo_subscr = ' <em>(<a href="'. $rws_link .'">'. __('subscription', PCPP_ML) .' #'. $rel_woo_subscr->get_id() .'</a>)</em>';        
                    }
                }

                $ee_checkout_link = (in_array($pcpp_subscr->get_order_status($order_id), array('unpaid', 'inherit')) ) ? 
                    ' <a href="'. esc_attr($pcpp_subscr->checkout_url($order_id)) .'" title="'. esc_attr__('go to checkout', PCPP_ML) .'" class="pcpp_uoh_link"><i class="fas fa-external-link-alt"></i></a>' : 
                    ''; 
                
                $code .= '
                <tr>
                    <td>
                        <a href="'. untrailingslashit(wc_get_page_permalink('myaccount')) .'/view-order/'. $order_id .'/">#'. $order_id .'</a>
                    </td>
                    <td>'. get_the_date($date_format, $order_id) .'</td>
                    <td>'. $ol_plan_name . $is_expir_ext . $rel_woo_subscr .'</td>
                    <td>'. pcpp_static::get_order_amount($order_id) .'</td>
                    <td>'. pcpp_static::get_order_ecomm_status($order_id) . $ee_checkout_link .'</td>';
                    
                    if($pcpp_subscr->invoicing_system_exists()) {
                        $code .= '<td>'. $pcpp_subscr->get_invoice_html_link($order_id) .'</td>';        
                    }
                
                $code .= '
                </tr>'; 

                $a++;
            }
    
    $code .= '
        </tbody>
    </table>';
    
	return str_replace(array("\r", "\n", "\t", "\v"), '', $code);
}
add_shortcode('pcpp-user-orders-history', 'pcpp_user_order_history_sc');









// [pcpp-plan-chooser] 
//// returns a fullwidth block where plans are listed with a button leading to a registration form
function pcpp_plan_choser_sc($atts, $content = null) {
    include_once(PC_DIR .'/classes/pc_form_framework.php');
    global $pcpp_subscr;
	
	if(!$GLOBALS['pcpp_enabled']) {
        return false;
    }
    
    extract( shortcode_atts( array(
        'focused_plan' => '',
	), $atts ) );
    
    
    $GLOBALS['pcpp_plans_chooser_form'] = $focused_plan;
    
    
    // behaviors
    $behav = get_option('pcpp_pcf_behav', 'form');
    $behav_params = 'data-behav="'. esc_attr($behav) .'" ';
    
    if($behav == 'lightbox') {
        $lightbox_id = get_option('pcpp_pcf_lightbox_behav');
        $behav_params .= 'data-lb="'. esc_attr($lightbox_id) .'"';    
        
        pc_static::enqueue_lb($lightbox_id);
    }
    elseif($behav == 'redirect') {
        $page = pc_static::wpml_translated_pag_id(get_option('pcpp_pcf_redirect_behav'));
        $behav_params .= 'data-url="'. esc_attr(get_permalink($page)) .'"';    
    }
    
    
    // form code 
	$form = '
	<form class="pvtcont_form pcpp_plan_choser_form pc_fluid_form" '. $behav_params .'>';
    
		$f_fw = new pc_form;
		$form .= $f_fw->form_code(
			array(
				'include' => array('pcpp_plan'), 
				'require' => array()
			), 
			$custom_fields = false, false
		);

    $form .= '
	</form>
    
    <script type="text/javascript">
    (function() { 
        "use strict";  

        const intval = setInterval(() => {
            if(typeof(jQuery) == "undefined" || typeof(pc_fluid_form_columnizer) == "undefined") {
                return true;
            }
            else {
                clearTimeout(intval);
                pc_fluid_form_columnizer();
            }
        }, 50);
    })();
    </script>';
    

    unset($GLOBALS['pcpp_plans_chooser_form']);
	return str_replace(array("\r", "\n", "\t", "\v"), '', $form);
}
add_shortcode('pcpp-plan-chooser', 'pcpp_plan_choser_sc');







// [pcpp-is-trial check_opposite="0"][/pcpp-is-trial] 
//// display contents within only if logged user is in trial period

function pcpp_is_trial_sc($atts, $content = null) {
	if(!$GLOBALS['pcpp_enabled']) {
        return false;
    }
    
    extract( shortcode_atts( array(
        'check_opposite' => 0,
	), $atts ) );
    
    
    $user_status = pc_user_logged(array('pcpp_subscr_status'));
    if(empty($user_status)) {
        return '';   
    }
    
    if(empty($check_opposite)) {
        return ($user_status == 'trial') ? $content : '';
    } else {
        return ($user_status == 'trial') ? '' : $content;
    }
}
add_shortcode('pcpp-is-trial', 'pcpp_is_trial_sc');



// [pcpp-is-not-trial][/pcpp-is-not-trial] 
//// display contents within only if logged user is in trial period

function pcpp_is_not_trial_sc($atts, $content = null) {
	return do_shortcode('[pcpp-is-trial check_opposite="1"]'. $content .'[/pcpp-is-trial]');
}
add_shortcode('pcpp-is-not-trial', 'pcpp_is_not_trial_sc');







// [pcpp-reg-form-txt][/pcpp-reg-form-txt] 
//// display contents only if shown into the registration form (or plan's chooser box)

function pcpp_reg_form_txt_sc($atts, $content = null) {
	return (isset($GLOBALS['pcpp_initial_registr'])) ? do_shortcode($content) : false; 
}
add_shortcode('pcpp-reg-form-txt', 'pcpp_reg_form_txt_sc');



// [pcpp-chg-form-txt][/pcpp-chg-form-txt] 
//// display contents only if shown into the plan's change form (or renewal form)

function pcpp_chg_form_txt_sc($atts, $content = null) {
	return (!isset($GLOBALS['pcpp_initial_registr'])) ? do_shortcode($content) : false; 
}
add_shortcode('pcpp-chg-form-txt', 'pcpp_chg_form_txt_sc');
