<?php
// FRONTEND CSS - ATTACHED TO PVTCONTENT STYLE


function pcpp_preset_styles_data($styles) {
    $pcpp_styles = array();
    $pcpp_styles['minimal'] = array(
        'pcpp_plan_bg'         => '#f9f9f9',
        'pcpp_plan_border_col' => '#e7e7e7',
        'pcpp_plan_txt_col'    => '#3b3b3b',
        'pcpp_plan_flap_h'     => '#ececec',

        'pcpp_plan_bg_sel'         => '#ffffff',
        'pcpp_plan_border_col_sel' => '#dddddd', 
        'pcpp_plan_txt_col_sel'    => '#373737',
        'pcpp_plan_flap_sel'       => '#d2d2d2',

        'pcpp_bfl_title_bord_rad'  => 0,
        'pcpp_bfl_title_col'       => '#444444',
        'pcpp_bfl_title_bg'        => '#ebebeb',
        'pcpp_bfl_title_col_sel'   => '#373737',
        'pcpp_bfl_title_bg_sel'    => '#e4e4e4',
        
        'pcpp_trial_bg'        => '#f1f1f1',
        'pcpp_trial_txt_col'   => '#373737',
        'pcpp_trial_border_w'  => 0,
        'pcpp_trial_border_col'=> '#d2d2d2',
    );
    
    
    $pcpp_styles['light'] = array(
        'pcpp_plan_bg'         => '#f7f7f7',
        'pcpp_plan_border_col' => '#d5d5d5',
        'pcpp_plan_txt_col'    => '#3b3b3b',
        'pcpp_plan_flap_h'     => '#d9d9d9',

        'pcpp_plan_bg_sel'         => '#ffffff',
        'pcpp_plan_border_col_sel' => '#999999', 
        'pcpp_plan_txt_col_sel'    => '#333333',
        'pcpp_plan_flap_sel'       => '#999999',

        'pcpp_bfl_title_bord_rad'  => 3,
        'pcpp_bfl_title_col'       => '#444444',
        'pcpp_bfl_title_bg'        => '#e8e8e8',
        'pcpp_bfl_title_col_sel'   => '#ffffff',
        'pcpp_bfl_title_bg_sel'    => '#949494',
        
        'pcpp_trial_bg'        => '#949494',
        'pcpp_trial_txt_col'   => '#ffffff',
        'pcpp_trial_border_w'  => 0,
        'pcpp_trial_border_col'=> '#aaaaaa',
    );
    
    
    $pcpp_styles['dark'] = array(
        'pcpp_plan_bg'         => '#454545',
        'pcpp_plan_border_col' => '#787878',
        'pcpp_plan_txt_col'    => '#cfcfcf',
        'pcpp_plan_flap_h'     => '#888888',

        'pcpp_plan_bg_sel'         => '#373737',
        'pcpp_plan_border_col_sel' => '#8a8a8a', 
        'pcpp_plan_txt_col_sel'    => '#eeeeee',
        'pcpp_plan_flap_sel'       => '#cccccc',

        'pcpp_bfl_title_bord_rad'  => 3,
        'pcpp_bfl_title_col'       => '#e3e3e3',
        'pcpp_bfl_title_bg'        => '#353535',
        'pcpp_bfl_title_col_sel'   => '#fafafa',
        'pcpp_bfl_title_bg_sel'    => '#4f4f4f',
        
        'pcpp_trial_bg'        => '#373737',
        'pcpp_trial_txt_col'   => '#fafafa',
        'pcpp_trial_border_w'  => 0,
        'pcpp_trial_border_col'=> '#555555',
    );
    
    
    // merge and return
    foreach($pcpp_styles as $s_key => $s_vals) {
        if(isset($styles[$s_key])) {
            $styles[ $s_key ] = array_merge($styles[ $s_key ], $s_vals);         
        }
    }
    return $styles;
}
add_filter('pc_preset_styles_data', 'pcpp_preset_styles_data');







// shortcut function
function pcppgofc($opt_name, $echo = true) {
    return pc_static::get_opt_for_css($opt_name, $echo);
}


// inject styles
function pcpp_front_styles() {
    $fields_gap = (array)pcppgofc('pg_reg_fblock_gap', false);
?>

/*** REGISRATION FORM FIELD ***/
.pcpp_trial_box {
	background: <?php pcppgofc('pcpp_trial_bg') ?>;
	border: <?php pcppgofc('pcpp_trial_border_w') ?>px solid <?php pcppgofc('pcpp_trial_border_col') ?>;
}
.pcpp_trial_box,
.pcpp_trial_box * {
	color: <?php pcppgofc('pcpp_trial_txt_col') ?>;	
}
.pcpp_trial_box,
.pcpp_plan_ul {
	margin: <?php echo $fields_gap[0] ?>px 0 0;
}
.pcpp_plan_ul > li {
	background: <?php pcppgofc('pcpp_plan_bg') ?>;
    border: <?php pcppgofc('pg_field_border_w') ?>px solid <?php pcppgofc('pcpp_plan_border_col') ?>;
}
.pcpp_plan_dur_ext_block {
    border-color: <?php pcppgofc('pcpp_plan_border_col') ?>;
}
.pcpp_plan_ul > li:before {
	border-left: 0px solid <?php pcppgofc('pcpp_plan_flap_h') ?>;
    top: -<?php pcppgofc('pg_field_border_w') ?>px;
    bottom: -<?php pcppgofc('pg_field_border_w') ?>px;
}
.pcpp_plan_ul li.pcpp_chosen,
.pcpp_plan_ul li.pcpp_chosen .pcpp_plan_dur_ext_block,
.pcpp_plan_choser_form .pcpp_plan_ul > li:hover {
	background: <?php pcppgofc('pcpp_plan_bg_sel') ?>;
    border-color: <?php pcppgofc('pcpp_plan_border_col_sel') ?>;
}
.pcpp_plan_ul li.pcpp_chosen:before,
.pcpp_plan_choser_form .pcpp_plan_ul > li:hover:before {
	border-left-color: <?php pcppgofc('pcpp_plan_flap_sel') ?>;
}
.pcpp_plan_ul * {
	color: <?php pcppgofc('pcpp_plan_txt_col') ?>;	
}
.pcpp_plan_ul .pcpp_chosen *,
.pcpp_plan_choser_form .pcpp_plan_ul > li:hover {
    color: <?php pcppgofc('pcpp_plan_txt_col_sel') ?>;	
}
.pc_fluid_form:not([data-col="1"]) .pcpp_plan_ul:not(.pcpp_compact_fluid_layout) > li,
.pcpp_plan_choser_form .pcpp_plan_ul:not(.pcpp_compact_fluid_layout) > li,
.pcpp_trial_box {
    border-radius: <?php pcppgofc('pg_field_border_radius') ?>px;
}
.pcpp_coupon_box label,
.pcpp_trial_box {
    font-size: <?php echo (float)pcppgofc('pg_labels_font_size', false) . get_option('pg_labels_font_size_type', 'px') ?>;
}
.pcpp_try_coupon {
    color: <?php pcppgofc('pg_fields_txt_col') ?>;	
}
.pc_field_container:hover .pcpp_try_coupon,
.pcpp_coupon_wrap .pc_field_container.pc_focused_field .pcpp_try_coupon {
    color: <?php pcppgofc('pg_fields_txt_col_h') ?>;
}


/* dropdown trigger */
#pcpp_plan_dd_label i {
    border: <?php pcppgofc('pg_field_border_w') ?>px solid <?php pcppgofc('pg_fields_border_col') ?>;
}
#pcpp_plan_dd_label i:before {
	border-color: <?php pcppgofc('pg_label_col') ?>;
}


/* multi-col layout */
.pc_fluid_form .pcpp_plan_ul:not(.pcpp_compact_fluid_layout) {
    grid-gap: <?php echo $fields_gap[0] ?>px <?php echo $fields_gap[1] ?>px;
}


/* multicol - bold layout */
.pc_fluid_form:not([data-col="1"]) .pcpp_bold_fluid_layout .pcpp_plan_name,
.pcpp_plan_choser_form .pcpp_bold_fluid_layout .pcpp_plan_name,
.pcpp_pcf_btn {
	background: <?php pcppgofc('pcpp_bfl_title_bg') ?>;
	color: <?php pcppgofc('pcpp_bfl_title_col') ?>;	
    border-radius: <?php pcppgofc('pcpp_bfl_title_bord_rad') ?>px;
}
.pc_fluid_form:not([data-col="1"]) .pcpp_bold_fluid_layout li.pcpp_chosen .pcpp_plan_name,
.pcpp_plan_choser_form .pcpp_bold_fluid_layout li.pcpp_chosen .pcpp_plan_name,
.pcpp_plan_choser_form .pcpp_plan_ul > li:hover .pcpp_plan_name,
li.pcpp_chosen .pcpp_pcf_btn,
.pcpp_plan_choser_form .pcpp_plan_ul > li:hover .pcpp_pcf_btn {
	background: <?php pcppgofc('pcpp_bfl_title_bg_sel') ?>;
	color: <?php pcppgofc('pcpp_bfl_title_col_sel') ?>;	
}


/* list styling in plans description */
.pcpp_plan_descr ul li {
	border-color: <?php pcppgofc('pcpp_plan_border_col') ?>;
}
.pcpp_chosen .pcpp_plan_descr ul li,
.pcpp_plan_choser_form .pcpp_plan_ul > li:hover .pcpp_plan_descr ul li {
	border-color: <?php pcppgofc('pcpp_plan_border_col_sel') ?>;
}


/* plans chooser block */
<?php 
$btn_padding = pcppgofc('pg_buttons_padding', false);
?>
.pcpp_pcf_btn {
    padding: <?php echo (int)$btn_padding[0] ?>px <?php echo (int)$btn_padding[1] ?>px;
    font-size: <?php echo (float)pcppgofc('pg_btns_font_size', false) . get_option('pg_btns_font_size_type', 'px') ?>;
    border-radius: <?php pcppgofc('pg_btn_border_radius') ?>px !important;
}


<?php
}
add_action('pc_custom_style_css', 'pcpp_front_styles');


