<?php
// PRIVATECONTENT INTEGRATIONS - SHOTRCODES


add_filter('pc_tinymce_tabs', 'pcpp_tinymce_tabs');

function pcpp_tinymce_tabs($tabs) {
	global $pcpp_subscr;
    
    // subscription details
	$contents = '
	<li class="pc_scw_field pc_scw_field">
		<label>'. __('What to display', PCPP_ML) .'</label>

		<select name="pcpp_wtd" class="pc_lc_select f_type" data-placeholder="'. __('Select an option', PCPP_ML) .' .." autocomplete="off">
			<option value="plan_name">'. esc_html__("Plan's name", PCPP_ML) .'</option>
			<option value="plan_expir_date">'. esc_html__("Plan's expiration date", PCPP_ML) .'</option>
			<option value="plan_expir_cdown">'. esc_html__("Plan's expiration countdown", PCPP_ML) .'</option>
            <option value="orders_history">'. esc_html__("Orders history table", PCPP_ML) .'</option>
		</select>
	</li>
	<li class="pc_scw_field pc_scw_field pcpp_date_format_f pc_displaynone">
		<label>'. __('Date format', PCPP_ML) .'</label>

		<input type="text" name="pcpp_plan_date_format" placeholder="'. get_option('date_format') .'" autocomplete="off" />
		
		<p>'. __('Please refer to <a href="http://php.net/manual/en/function.date.php" target="_blank">PHP date guide</a> to know what to insert. <br/>Leave blank to use the default website date format.', PCPP_ML) .'</p>
	</li>
	<li class="pc_scw_field pc_scw_field">
		<input type="button" class="button-primary pcpp-subscr-data-submit" value="'. esc_attr__('Insert', PCPP_ML) .'" name="submit" />
	</li>';
	
	
	$tabs['pcpp_subscr_data'] = array(
		'name' 		=> 'PCPP - '. __("Subscription Details", PCPP_ML),
		'contents'	=> '<ul>'. $contents .'</ul>'
	);
    
    
    
    // renewal/change form
	$contents = '
	<li class="pc_scw_field pc_scw_field">
		<input type="button" class="button-primary pcpp-plan-change-form-submit" value="'. esc_attr__('Insert', PCPP_ML) .'" name="submit" />
	</li>';
	
	
	$tabs['pcpp_plan_chane_form'] = array(
		'name' 		=> 'PCPP - '. __("Subscription Change/renew Form", PCPP_ML),
		'contents'	=> '<ul>'. $contents .'</ul>'
	);
    
    
    
    // plan's chooser box
	$contents = '
    <li class="pc_scw_field pc_scw_field">
		<label>'. __('Focused plan', PCPP_ML) .'</label>

		<select name="pcpp_focused_plan" class="pc_lc_select f_type" data-placeholder="'. __('Select an option', PCPP_ML) .' .." autocomplete="off">
			<option value="">'. __("none") .'</option>';
    
            foreach($pcpp_subscr->get_plans() as $pid => $pname) {
                $contents .= '<option value="'. (int)$pid .'">'. esc_html($pname) .'</option>';    
            }
                
    $contents .= '           
		</select>
	</li>
	<li class="pc_scw_field pc_scw_field">
		<input type="button" class="button-primary pcpp-plan-chooser-submit" value="'. esc_attr__('Insert', PCPP_ML) .'" name="submit" />
	</li>';
	
	
	$tabs['pcpp_plan_chooser'] = array(
		'name' 		=> 'PCPP - '. __("Plans Chooser Box", PCPP_ML),
		'contents'	=> '<ul>'. $contents .'</ul>'
	);
    

    
	$GLOBALS['pcpp_print_tinymce_js'] = true;
	return $tabs;
}




// add javascript code in footer
function pcpp_tinymce_js() {
	if(!isset($GLOBALS['pcpp_print_tinymce_js'])) {
        return true;
    }
	?>
	<script type="text/javascript">
	(function($) { 
        "use strict";
		
        
        // SUBSCRIPTION DETAILS
        
		// date format field toggle
		$(document).on('change', '.pc_sc_wizard_lb [name="pcpp_wtd"]', function() {
			($(this).val() == 'plan_expir_date' || $(this).val() == 'orders_history') ?	
                $('.pc_sc_wizard_lb .pcpp_date_format_f').show() : 
                $('.pc_sc_wizard_lb .pcpp_date_format_f').hide();
		});
		
        
		// insert
		$(document).on('click', '.pc_sc_wizard_lb .pcpp-subscr-data-submit', function() {
			const wts = $('.pc_sc_wizard_lb [name=pcpp_wtd]').val(),
                  date_format = ($.trim( $('.pc_sc_wizard_lb [name="pcpp_plan_date_format"]').val())) ? 'date_format="'+ $('.pc_sc_wizard_lb [name=pcpp_plan_date_format]').val() +'"' : '';
			
            let sc = '';
		
			// plan's name
			if(wts == 'plan_name') {
				sc = '[pcpp-user-plan]';	
			}
		
			// plan's expiration date
			else if(wts == 'plan_expir_date') {
				sc = '[pcpp-subscr-expir '+ date_format +']';
			}
			
			// plan's expiration countdown
			else if(wts == 'plan_expir_cdown') {
				sc = '[pcpp-subscr-expir type="cdown"]';	
			}
            
            // orders history table
			else if(wts == 'orders_history') {
				sc = '[pcpp-user-orders-history '+ date_format +']';
			}
		
		
			tinyMCE.activeEditor.execCommand("mceInsertContent", 0, sc);
			$.magnificPopup.close();	
		});
		
        
        
        // CHANGE/RENEWAL FORM
        $(document).on('click', '.pc_sc_wizard_lb .pcpp-plan-change-form-submit', function() {
            let sc = '[pcpp-change-plan]';

			tinyMCE.activeEditor.execCommand("mceInsertContent", 0, sc);
			$.magnificPopup.close();	
		});
        
        
        
        // PLANS CHOOSER BOX
        $(document).on('click', '.pc_sc_wizard_lb .pcpp-plan-chooser-submit', function() {
            let focused_plan = $('.pc_sc_wizard_lb [name="pcpp_focused_plan"]').val(),
                sc = '[pcpp-plan-chooser';

            if(focused_plan) {
                sc += ' focused_plan="'+ focused_plan +'"';    
            }
            
			tinyMCE.activeEditor.execCommand("mceInsertContent", 0, sc + ']');
			$.magnificPopup.close();	
		});
        
	})(jQuery); 
	</script>
    <?php
}
add_action('admin_footer', 'pcpp_tinymce_js', 100); // PC acts on priority 1
