<?php
// WOOCOMMERCE INTEGRATION - ADMIN FIELDS - CHECKOUT REDIRECTS 


/*************************************
********** ADMIN FIELDS **************
*************************************/


// add privatecontent plan as product type option
function pcpp_wc_add_item_type_option($product_type_options) {
    $product_type_options['is_pvtcontent_plan'] = array(
        'id'            => '_is_pvtcontent_plan',
        'wrapper_class' => 'show_if_simple show_if_subscription',
        'label'         => __('PrivateContent Plan', PCPP_ML),
        'description'   => __('Check to turn it into a PrivateContent Plan', PCPP_ML),
        'default'       => 'no'
    );
    return $product_type_options;
}
add_filter('product_type_options', 'pcpp_wc_add_item_type_option');






// add codes into GENERAL options
function pcpp_general_opts_code() {
	if(PCPP_ECOMMERCE != 'woocomm') {
        return false;
    }
    dike_lc('lcweb', PCPP_DIKE_SLUG, true);
	global $post;

    $init_price 	= get_post_meta($post->ID, 'pcpp_init_price', true);
	$plan_duration 	= (int)get_post_meta($post->ID, 'pcpp_plan_duration', true);
	$plan_dur_type  = get_post_meta($post->ID, 'pcpp_plan_dur_type', true);
	
	$not_in_forms	= get_post_meta($post->ID, 'pcpp_not_in_forms', true);
	$not_in_renewal	= get_post_meta($post->ID, 'pcpp_not_in_renew', true);
	$no_renewal		= get_post_meta($post->ID, 'pcpp_no_renewal', true);
    
    $tag_txt        = get_post_meta($post->ID, 'pcpp_tag_txt', true);
    $tag_color      = get_post_meta($post->ID, 'pcpp_tag_col', true);
    $tag_bg         = get_post_meta($post->ID, 'pcpp_tag_bg', true);
	?>
    
    <div class="options_group pcpp_wc_fields show_if_pvtcontent_plan pcpp_init_price_wrap <?php if($not_in_renewal || $no_renewal) echo 'pc_displaynone' ?>">
        <p class="form-field pcpp_init_price">
            <label><?php _e('Initial Price', PCPP_ML) ?> (<?php echo get_woocommerce_currency_symbol() ?>)</label>
            <input type="number" class="short wc_input_price" name="pcpp_init_price" value="<?php echo esc_attr($init_price) ?>" autocomplete="off" placeholder="<?php esc_attr_e('leave empty to use the original price', PCPP_ML) ?>" step="0.1" />
            <?php echo wc_help_tip( __('This price replaces the regular one in registration forms. On renewal regular one will be applied', PCPP_ML)); ?>
        </p>
    </div>   

    <div class="options_group pcpp_wc_fields show_if_pvtcontent_plan">
        <p class="form-field dimensions_field">
            <label><?php _e('Subscription period', PCPP_ML) ?></label>
            <span class="wrap">
                <input class="input-text" size="6" type="number" name="pcpp_plan_duration" value="<?php echo $plan_duration ?>" autocomplete="off" min="0" step="1" />
                
                <select name="pcpp_plan_dur_type" autocomplete="off">
                    <?php
                    foreach(pcpp_static::periods() as $type => $name) {
                        $sel = ($type == $plan_dur_type) ? 'selected="selected"' : ''; 
                        echo '<option value="'. esc_attr($type) .'" '.$sel.'>'. esc_html($name) .'</option>';	
                    }
                    ?>
                </select>              
            </span>
            <?php echo wc_help_tip( __('Insert a value or use zero to guaratee unlimited membership', PCPP_ML)); ?>
        </p>
        
        <div class="pcpp_woo_dur_ext_f <?php if(empty($plan_duration)) echo 'pc_displaynone' ?>">
            <p class="form-field">
                <label><?php _e('Extended subscription periods', PCPP_ML) ?></label>
                <input type="button" value="<?php esc_attr_e('add option', PCPP_ML) ?>" class="button-secondary pcpp_add_dur_ext" />
                <?php echo wc_help_tip( __("Extensions will appear as additional product in invoices and their price will be added to the product's one", PCPP_ML)); ?>
            </p>

            <?php 
            echo pcpp_dur_ext_static::plan_dur_ext_table($post->ID, get_woocommerce_currency_symbol());
            ?>
        </div>
    </div>   

    <div class="options_group pcpp_wc_fields show_if_pvtcontent_plan">
        <p class="form-field">
            <label><?php _e('Hide in registation forms?', PCPP_ML) ?></label>
            <input class="checkbox" type="checkbox" value="1" <?php checked($not_in_forms, 1) ?> name="pcpp_not_in_forms" autocomplete="off" />
            <span class="description"><?php _e('Check to disable this product in registration forms', PCPP_ML) ?></span>
        </p>
        <p class="form-field">
            <label><?php _e('Hide in renewal/change forms?', PCPP_ML) ?></label>
            <input class="checkbox" type="checkbox" value="1" <?php checked($not_in_renewal, 1) ?> name="pcpp_not_in_renew" autocomplete="off" />
            <span class="description"><?php _e('Check to disable this product in renewal/plan-change forms', PCPP_ML) ?></span>
        </p>
        <p class="form-field pcpp_no_renewal_f">
            <label><?php _e('Avoid renewal?', PCPP_ML) ?></label>
            <input class="checkbox" type="checkbox" value="1" <?php checked($no_renewal, 1) ?> name="pcpp_no_renewal" autocomplete="off" />
            <span class="description"><?php _e('If checked, customers will end their subscription at the end of the plan', PCPP_ML) ?></span>
        </p>
        
        <?php
        // PCPP-ACTION - allow custom fields injection into WooCommerce product page
        do_action('pcpp_wc_inject_fields', $post->ID);            
        ?>
    </div>

    <div class="options_group pcpp_wc_fields show_if_pvtcontent_plan">
        <p class="form-field">
            <label><?php _e('Tag text', PCPP_ML) ?></label>
            <input type="text" class="short" name="pcpp_tag_txt" value="<?php echo esc_attr($tag_txt) ?>" autocomplete="off" />
            <?php echo wc_help_tip( __('leave empty to discard', PCPP_ML)); ?>
        </p>    
        <p class="form-field">
            <label><?php _e('Tag text color', PCPP_ML) ?></label>
            <input type="text" class="short" name="pcpp_tag_col" value="<?php echo esc_attr($tag_color) ?>" autocomplete="off" />
        </p>
        <p class="form-field">
            <label><?php _e('Tag background', PCPP_ML) ?></label>
            <input type="text" class="short" name="pcpp_tag_bg" value="<?php echo esc_attr($tag_bg) ?>" autocomplete="off" />
        </p>
    </div>

    <?php // security nonce ?>
    <input type="hidden" name="pcpp_nonce" value="<?php echo wp_create_nonce('lcwp_nonce') ?>" />
    <?php	
}
add_action('woocommerce_product_options_general_product_data', 'pcpp_general_opts_code');




// manage everything on javascript to be faster
function pcpp_wc_admin_item_tweak() {
    if(PCPP_ECOMMERCE != 'woocomm' || get_post_type() !== 'product') {
        return false;
    }
	global $post;
	?>
	<script type='text/javascript'>
    (function($) { 
        "use strict";
        
        let could_be_a_plan;
        
        const could_be_a_plan_func = function() {
            if(!document.getElementById('product-type')) {
                return false;    
            }
            
            const val = document.getElementById('product-type').value; 
            could_be_a_plan = (['simple', 'subscription'].includes(val)) ? true : false; 
            
            if(!could_be_a_plan && document.getElementById('_is_pvtcontent_plan').checked) {
                $(document).ready(function() {
                    $('#_is_pvtcontent_plan').trigger('click');        
                });
            }
        };
        could_be_a_plan_func();
        
        
        // toggle product fields if is a plan or not
        const toggle_fields = function() {
            if(document.getElementById('_is_pvtcontent_plan').checked && could_be_a_plan) {
                
                $('.show_if_pvtcontent_plan, .options_group.pricing').show();
                $('.product_data_tabs.wc-tabs li:not(.general_options), #pcpp_wc_fields_wrap, label[for="_downloadable"], label[for="_virtual"], ._subscription_sign_up_fee_field, #_subscription_period_interval, #_subscription_period').hide();

                $('#_virtual, #_sold_individually').prop('checked', 'checked');
                $('#_manage_stock').removeAttr('checked');

                $('#_stock_status option').removeAttr('selected');
                $('#_stock_status option[value=instock]').attr('selected', 'selected');  
                
                $('#_visibility_hidden').trigger('click');
            }
            
            else {
                $('.product_data_tabs.wc-tabs li').removeAttr('style');
                $('.show_if_pvtcontent_plan, #pcpp_wc_fields_wrap').hide();    
                $('#_virtual, label[for="_downloadable"], label[for="_virtual"], ._subscription_sign_up_fee_field, #_subscription_period_interval, #_subscription_period').show();
            }
        };
        
        $(document).ready(function() {
            toggle_fields();        
        });
        $(document).on('input click', '#_is_pvtcontent_plan', function() {
            toggle_fields();
        });
        
        
        
        
        // toggle inner fields product fields if is a normal plan or a recurring subscription
        const toggle_inner_fields = function() {
            const val = document.getElementById('product-type').value;     
            
            if(!could_be_a_plan) {
                return false;    
            }
            
            if(val == 'subscription' && document.getElementById('_is_pvtcontent_plan').checked) {
                $('#_subscription_period_interval, #_subscription_period, #sale-price-period, ._subscription_trial_length_field, ._subscription_length_field, .pcpp_woo_dur_ext_f, .pcpp_no_renewal_f').hide();    
            }
            else {
                $('#_subscription_period_interval, #_subscription_period, ._subscription_trial_length_field, ._subscription_length_field, .pcpp_no_renewal_f').show();
                
                if(parseInt($('input[name="pcpp_plan_duration"]').val(), 10)) {
                    $('.pcpp_woo_dur_ext_f').show();        
                }
            }
        };
        
        $(document).ready(function() {
            toggle_inner_fields();        
        });
        
        
        // pvtContent plan only for targeted product types
        $(document).on('change', '#product-type', function() {
            could_be_a_plan_func();
            toggle_fields();
            toggle_inner_fields();
        });
        
        
        
        
            
        const duration_ext_row = `<?php echo pcpp_dur_ext_static::plan_dur_ext_table_row() ?>`;
        
        // add duration extension row
        $(document).on('click', '.pcpp_add_dur_ext', function() {
            $('.pcpp_pde_table').show();
            
            $('.pcpp_pde_table tbody').append(duration_ext_row);
            
            // create and apply a new ID
            $('.pcpp_pde_table .pcpp_pde_id').last().val( new Date().getTime() );
            
            pde_sortable_table();
        });
        
        
        
        // delete duration extension row
        $(document).on('click', '.pcpp_pde_del', function() {
            if(!confirm("<?php esc_attr_e('Do you really want to remove this duration extension?', PCPP_ML) ?>")) {
                return false;    
            }
            $(this).parents('tr').first().remove();
        });
        
        
        
        // custom restrictions - sortable
        const pde_sortable_table = function() {
            $(".pcpp_pde_table tbody").sortable({ 
                items   : 'tr',
                handle  : '.pcpp_pde_move',
                axis    : "y" 
            });
            $(".pcpp_pde_table .pcpp_pde_move").disableSelection();        
        };
        $(document).ready(function() {
            pde_sortable_table();    
        });
        
        

        // duration extension toggle
        let ppd_tout;
        $(document).on('input keyup', 'input[name="pcpp_plan_duration"]', function() {
            if(ppd_tout) {
                clearTimeout(ppd_tout);    
            }
            const $this = $(this);
            
            ppd_tout = setTimeout(function() {
                ( parseInt($this.val(), 10) <= 0 || !could_be_a_plan) ? 
                    $('.pcpp_woo_dur_ext_f').addClass('pc_displaynone') : 
                    $('.pcpp_woo_dur_ext_f').removeClass('pc_displaynone');  
            }, 400);
        });
        
        
        
        // renewal price toggle
        $(document).on('input', 'input[name="pcpp_not_in_renew"], input[name="pcpp_no_renewal"]', function() {
            let show = true;
            $('input[name="pcpp_not_in_renew"], input[name="pcpp_no_renewal"]').each(function(){
                if(this.checked) {
                    show = false;    
                }
            });
            
            (show) ? $('.pcpp_renew_price_field').removeClass('pc_displaynone') : $('.pcpp_renew_price_field').addClass('pc_displaynone');
        });
        
        
        
        // tag colorpicker
        $(document).ready(function() {
            new lc_color_picker('input[name="pcpp_tag_col"]', {
                modes           : ['solid'],
                transparency    : true,
                no_input_mode   : false,
                wrap_width      : '80%',
                fallback_colors : ['#333333', 'linear-gradient(90deg, #ffffff 0%, #000000 100%)'],
                preview_style   : {
                    input_padding   : 40,
                    side            : 'right',
                    width           : 35,
                },
            });   
            
            new lc_color_picker('input[name="pcpp_tag_bg"]', {
                modes           : ['solid', 'linear-gradient', 'radial-gradient'],
                transparency    : true,
                no_input_mode   : false,
                wrap_width      : '80%',
                fallback_colors : ['#FF8C00', 'linear-gradient(90deg, #ffffff 0%, #000000 100%)'],
                preview_style   : {
                    input_padding   : 40,
                    side            : 'right',
                    width           : 35,
                },
            });
        });
    })(jQuery); 
	</script>
	<?php
}
add_action('admin_footer', 'pcpp_wc_admin_item_tweak');




// Save custom fields
function pcpp_wc_meta_save($post_id) {
	if(!defined('PCPP_ECOMMERCE') || PCPP_ECOMMERCE != 'woocomm' || isset($_POST['pcpp_nonce'])) {
		global $pcpp;
        
        // authentication checks
		if (!wp_verify_nonce($_POST['pcpp_nonce'], 'lcwp_nonce') || $_POST['post_type'] != 'product') {
            return $post_id;
        }
		include_once(PC_DIR .'/classes/simple_form_validator.php');

        if(!isset($_POST['_is_pvtcontent_plan'])) {
            delete_post_meta($post_id, '_is_pvtcontent_plan');
            return true;    
        }
        update_post_meta($post_id, '_is_pvtcontent_plan', 'yes'); 
        
        
        $product = wc_get_product($post_id);
        if(!$product) {
            return false;    
        }
        
        $prod_type = $product->get_type();
        
        if(!in_array($prod_type, array('simple', 'subscription'))) {
            return true;    
        }
        
        
		$validator = new simple_fv;
		$indexes = array();
        
        $indexes[] = array('index'=>'pcpp_init_price', 'label'=>'Initial subscription price');
		$indexes[] = array('index'=>'pcpp_plan_duration', 'label'=>'Subscription period');
		$indexes[] = array('index'=>'pcpp_plan_dur_type', 'label'=>'Subscription period type');
        
        $indexes[] = array('index'=>'pcpp_pde_id', 'label'=>'Plan duration extension ids');
        $indexes[] = array('index'=>'pcpp_pde_price', 'label'=>'Plan duration extension prices');
        $indexes[] = array('index'=>'pcpp_pde_duration', 'label'=>'Plan duration extension durations');
        $indexes[] = array('index'=>'pcpp_pde_dur_type', 'label'=>'Plan duration extension type');
        $indexes[] = array('index'=>'pcpp_pde_note', 'label'=>'Plan duration extension note');

		$indexes[] = array('index'=>'pcpp_not_in_forms', 'label'=>'not in frontend forms');
		$indexes[] = array('index'=>'pcpp_not_in_renew', 'label'=>'not in renewal form');
		$indexes[] = array('index'=>'pcpp_no_renewal', 'label'=>'no renewal');
        
        $indexes[] = array('index'=>'pcpp_tag_txt', 'label'=>'tag text');
		$indexes[] = array('index'=>'pcpp_tag_col', 'label'=>'tag text color');
		$indexes[] = array('index'=>'pcpp_tag_bg', 'label'=>'tag background');
        
		$validator->formHandle($indexes);
		
		$fdata = $validator->form_val;
		$error = $validator->getErrors();

		// clean data
		foreach($fdata as $key=>$val) {
			if(!is_array($val)) {
				$fdata[$key] = stripslashes($val);
			}
			else {
				$fdata[$key] = array();
				foreach($val as $arr_val) {
                    $fdata[$key][] = stripslashes($arr_val);
                }
			}
		}
        
        
        // validate and eventually correcct targeted fields
        if($prod_type == 'subscription' && (int)$fdata['pcpp_plan_duration'] <= 0) {
            $fdata['pcpp_plan_duration'] = 1;    
        }
        

		// save data
		foreach($fdata as $key => $val) {
            
            // skip extra durations fields
            if(strpos($key, '_pde_') !== false) {
                continue;    
            }
            
			update_post_meta($post_id, $key, $fdata[$key]); 
		}
        
        
        // save duration extensions
        if($prod_type != 'subscription' && is_array($fdata['pcpp_pde_id']) && count($fdata['pcpp_pde_id'])) {
            pcpp_dur_ext_static::save_plan_dur_ext($post_id, array(
                'id'        => $fdata['pcpp_pde_id'],
                'duration'  => $fdata['pcpp_pde_duration'],
                'dur_type'  => $fdata['pcpp_pde_dur_type'],
                'price'     => $fdata['pcpp_pde_price'],
                'note'      => $fdata['pcpp_pde_note'],
            ));        
        }
        
        
        // recurring subscription - replace woocommerce metas
        if($prod_type == 'subscription') {
            update_post_meta($post_id, '_subscription_period_interval', (int)$fdata['pcpp_plan_duration']); 
            update_post_meta($post_id, '_subscription_period', $fdata['pcpp_plan_dur_type']); 
            update_post_meta($post_id, '_subscription_sign_up_fee', 0); 
            update_post_meta($post_id, '_subscription_trial_length', 0);
            update_post_meta($post_id, '_subscription_limit', 'no');
        }
	}

    return $post_id;
}
add_action('save_post', 'pcpp_wc_meta_save', 200); // run after Woo to override its metas




// add text and link to PvtContent user if is a plan order
// manage everything on javascript to be faster
function pcpp_wc_admin_order_flags() {
	if(PCPP_ECOMMERCE != 'woocomm' || get_post_type() !== 'shop_order') {
        return false;
    }
	if(!isset($_GET['action']) || $_GET['action'] != 'edit') {
        return false;
    }
	global $post, $pc_users, $pcpp_subscr;

	// know if is a pvtcontent order
	$user_id = (int)get_post_meta((int)$_GET['post'], 'pvtcontent_user_id', true);
	if(empty($user_id)) {
        return false;
    }
	
	?>
	<script type='text/javascript'>
    (function($) { 
        "use strict";    
        
        $(document).ready( function() {
            $('#order_data > h2').after('<p class="order_number pcpp_is_pcpp_order_flag"><strong><?php esc_attr_e('PrivateContent subscription order', PCPP_ML) ?></strong></p>');

            $('#s2id_customer_user').css('visibiilty', 'hidden').css('opacity', 0);

            $('label[for=customer_user]').append("<a href='<?php echo admin_url('admin.php?page=pc_user_dashboard&user='. $user_id) ?>' target='_blank' class='pcpp_is_pcpp_order_user'><?php echo esc_attr($pc_users->get_user_field($user_id, 'username')) ?></span>");
        });
    })(jQuery); 
	</script>
    <?php
}
add_action('admin_footer', 'pcpp_wc_admin_order_flags');




// PrivateContent pland can't actually be on discounted sale!
function pcpp_wc_no_sale_price($on_sale, $product_obj) {
	if($product_obj->get_type() == 'pvtcontent_plan') {
		return false;	
	}
	
	return $on_sale;
}
add_filter('woocommerce_product_is_on_sale', 'pcpp_wc_no_sale_price', 999, 2);




// Woo Subscription - if PvtContent is not ready, show warning
function woo_subscr_pcpp_not_ready_warn() {
    global $current_screen, $post;
    
    if($current_screen->base != 'post' || $current_screen->parent_base != 'edit' || $current_screen->post_type != 'product') {
        return false;
    }
    if(!pcpp_woo_subscr_static::plan_is_subscr($post->ID) || pcpp_woo_subscr_static::supports_woo_subscr()) {
        return false;    
    }
    
    echo '
    <div class="notice notice-error"><p><strong>'.
        __('To use recurring payments in Premium Plans add-on you must have WP User Sync system enabled and require the sync on registration!', PCPP_ML) .
    '</strong></p></div>';
};
add_action('admin_notices', 'woo_subscr_pcpp_not_ready_warn');








/******************************************
**** WC v3 - ALSO UNLOGGED CAN CHECKOUT ***
*******************************************/

// override WC filter
function pcpp_wc_customer_has_capability($allcaps, $caps, $args) {
	global $pcpp_subscr;
	
	if(isset( $caps[0]) && version_compare(PHP_VERSION, '3.0.0', '>=')) {
		switch ( $caps[0] ) {
			case 'pay_for_order' :
				$user_id  = $args[1];
				$order_id = isset( $args[2] ) ? $args[2] : null;
				
				// only if is a pcpp order
				if($pcpp_subscr->is_pvtcontent_order($order_id)) {
					$allcaps['pay_for_order'] = true;
				}
			break;
		}
	}
	return $allcaps;
}
add_filter('user_has_cap', 'pcpp_wc_customer_has_capability', 999, 3);





/*************************************
***** HANDLE ORDER STATUS CHANGE *****
*************************************/

function pcpp_wc_order_status_change($order_id, $old_status, $new_status) {
	global $pc_users, $pc_meta, $pcpp_subscr;

	if(!$GLOBALS['pcpp_enabled'] || PCPP_ECOMMERCE != 'woocomm') {
        return false;
    }
	if($old_status == $new_status) {
        return false;
    }
    
	// search if user has got this order/subscription as main one 
    $search_key = (pcpp_woo_subscr_static::order_is_subscr($order_id)) ? 'pcpp_recurr_subscr' : 'pcpp_active_order'; // is a woo subscription status change? 
	$args = array(
		'to_get' => array('id', 'pcpp_active_order', 'pcpp_orders', 'status', 'pcpp_user_exp_date', 'pcpp_recurr_subscr'),
		'search' => array(
			array('key' => $search_key, 'operator' => '=', 'val' => $order_id)
		)
	);
	$result = $pc_users->get_users($args);
    
	if(!empty($result)) {
		$ud = $result[0];
        
        // be sure right metas are set between subscr and orders
        if(is_plugin_active('woocommerce-subscriptions/woocommerce-subscriptions.php')) {
            if($search_key == 'pcpp_active_order') {
                update_post_meta($order_id, 'is_pvtcontent_order', 1);
                delete_post_meta($order_id, 'is_pvtcontent_subscr');
            }
            else {
                update_post_meta($order_id, 'is_pvtcontent_subscr', 1);
                delete_post_meta($order_id, 'is_pvtcontent_order');        
            }
            
            update_post_meta($order_id, 'pvtcontent_user_id', $ud['id']);
        }
        
        
        // if is changing order status while user has active subscription - skip (subscription status dominates)
        if($search_key == 'pcpp_active_order' && !empty($ud['pcpp_recurr_subscr'])) {
            return false;        
        }
        
        
        // elaborate
		if(in_array($new_status, array('cancelled', 'pending-cancel', 'refunded', 'expired', 'failed'))) {
			$new_pcpp_order_status = 'expired';
            $pc_meta->update_meta($ud['id'], 'pcpp_subscr_end', '');
		}
           
		elseif(in_array($new_status, array('completed', 'processing', 'active'))) {
			$new_pcpp_order_status = 'active';	
 
			// update plan's ending - starts from now
            $ending_date = $pcpp_subscr->order_plan_expiration($order_id, 'now');  
			$pc_meta->update_meta($ud['id'], 'pcpp_subscr_end', $ending_date);
			
			// if enable pending user
			if(get_option('pcpp_enable_pending_after_checkout')) {
				if($ud['status'] == 3) {
					$pc_users->change_status($ud['id'], 1);	
				}
			}
		}
        elseif($new_status == 'on-hold') { // woo active subscription temporary suspension or payment required
            
            if(empty($ud['pcpp_active_order'])) {
                trigger_error('pcpp user has no active order');
                return false;
            }
            
            $target_order = wc_get_order($ud['pcpp_active_order']); 
            $to_set = (in_array($target_order->get_status(), array('completed', 'processing', 'active'))) ? 'suspended' : 'unpaid';  
            
            $new_pcpp_order_status = $to_set;     
        }
		else {
            $else_status = ($pcpp_subscr->is_plan_expir_ext_order($order_id)) ? 'inherit' : 'unpaid';
			$new_pcpp_order_status = $else_status;
		}
		
        
        // update status
        $pc_meta->update_meta($ud['id'], 'pcpp_subscr_status', $new_pcpp_order_status);
        
        
		// if completed - set payment date in metas
		if($new_status == 'completed') {
			add_post_meta($order_id, 'pcpp_payment_date', current_time('mysql'), true);

            // PCPP-ACTION - whenever a WooCommerce order status changes - passes order ID and user ID
            do_action('pcpp_woo_order_completed', $order_id, $ud['id']);
		}
        
        // PCPP-ACTION - whenever a WooCommerce order status changes - passes order ID, user ID, new Woo order status, new PCPP subscr status and old Woo status
        do_action('pcpp_woo_order_status_changed', $order_id, $ud['id'], $new_status, $new_pcpp_order_status, $old_status);
	}
}
add_action('woocommerce_order_status_changed', 'pcpp_wc_order_status_change', 10, 3); 
add_action('woocommerce_subscription_status_changed', 'pcpp_wc_order_status_change', 10, 3);






/*************************************
***** INITIAL PLAN PRICE FILTER ******
*************************************/

function pcpp_filter_initial_price($price, $product) {
    
    // specifying custom price for specific checkouts
    if(isset($GLOBALS['pcpp_custom_prices'])) {
        foreach($GLOBALS['pcpp_custom_prices'] as $product_id => $price) {
            if($product->get_id() == (int)$product_id) {
                return (float)$price;        
            }
        }
    }
    
    // custom prices for registration form
    if(isset($GLOBALS['pcpp_initial_registr'])) {
        $init_price = (float)get_post_meta($product->get_id(), 'pcpp_init_price', true);

        if($init_price) {
            return (float)$init_price;    
        }
    }

    return $price;
}
add_filter('woocommerce_product_get_price', 'pcpp_filter_initial_price', 100, 2);







/********************************************
** NO "You are paying for a guest" MESSAGE **
********************************************/

function pcpp_no_wc_guest_warning($message) {
    if($message == 'You are paying for a guest order. Please continue with payment only if you recognize this order.') {
        global $wp, $pcpp_subscr;
        $order_id = $wp->query_vars['order-pay'];
        
        if($pcpp_subscr->is_pvtcontent_order($order_id)) {
            $message = '<span id="pcpp_no_wc_error"></span>';  
            $GLOBALS['pcpp_no_wc_error'] = true;
        }
    }
    return $message;
}
add_filter('woocommerce_add_error', 'pcpp_no_wc_guest_warning', 900);


function pcpp_no_wc_guest_warning_js() {
    ?>
    <script type="text/javascript">
    (function($) { 
        "use strict";
        
        if(document.getElementById('pcpp_no_wc_error')) {
            if(document.querySelectorAll('.woocommerce-error > li').length === 1) {
                document.querySelector('.woocommerce-error').remove();
                document.querySelector('.woocommerce-notices-wrapper').remove();
            }
            else {
                document.getElementById('pcpp_no_wc_error').parentNode.remove();            
            }
        }
    })();     
    </script>
    <?php
}
add_action('wp_footer', 'pcpp_no_wc_guest_warning_js', 1);






/******************************************
**** MARK PvtCont WOO ORDER AND SUBSCR ****
*******************************************/

function pcpp_mark_woo_orders_head($columns) {
    if(!isset($GLOBALS['pcpp_enabled']) || !$GLOBALS['pcpp_enabled'] || PCPP_ECOMMERCE != 'woocomm') {
        return $columns;    
    }
    
    global $current_screen;
    $position = ($current_screen->post_type == 'shop_order') ? 2 : 3;

    if(!isset($columns['is_pcpp_subscr'])) {
        
        $columns =  array_slice($columns, 0, $position, true) +
                    array('is_pcpp_subscr' => '') +
                    array_slice($columns, $position, count($columns) - $position, true);
    }
    return $columns;
}

function pcpp_mark_woo_orders_txt($column, $post_id) {
    global $pcpp_subscr;
    
    if($column != 'is_pcpp_subscr' || (!$pcpp_subscr->is_pvtcontent_order($post_id) && !pcpp_woo_subscr_static::order_is_subscr($post_id))) {
        return false;
    }
    echo '<img src="'. PC_URL .'/img/users_icon.png" alt="PCPP" title="'. esc_attr__('PrivateContent Subscription', PCPP_ML) .'">';
}

foreach(array('shop_order', 'shop_subscription') as $pt) {
    add_filter('manage_edit-'. $pt .'_columns', 'pcpp_mark_woo_orders_head', 100); 
    add_action('manage_'. $pt .'_posts_custom_column', 'pcpp_mark_woo_orders_txt', 10, 2);
}






/********************************************
*** SHOW USER BILLING DETAILS ON CHECKOUT ***
********************************************/

function pcpp_woo_after_checkout_billing_form($checkout) {
    global $wp;
    $order_id = (isset($wp->query_vars['order-pay'])) ? (int)$wp->query_vars['order-pay'] : 0;

    if(!pcpp_woo_subscr_static::is_pcpp_woo_subscr_checkout() && !get_post_meta($order_id, 'pvtcontent_user_id', true)) {
        return false;    
    }
    global $pc_users, $pcpp_subscr;
    
    include_once(PC_DIR .'/classes/pc_form_framework.php');
	$f_fw = new pc_form;
    $pc_fields = $f_fw->fields;
    
    $fields = array(
        'name'      => 'name',
        'surname'   => 'surname',
        'company' 	=> get_option('pcpp_bill_company_f'),
        'address' 	=> get_option('pcpp_bill_address_f'),	
        'city' 		=> get_option('pcpp_bill_city_f'),	
        'postcode'	=> get_option('pcpp_bill_postcode_f'),	
        'country'	=> get_option('pcpp_bill_country_f'),
        'state'		=> get_option('pcpp_bill_state_f'),
    );
    
    // PCPP-FILTER - allow billing details filter before checkout form
    $fields = apply_filters('pcpp_woo_pre_checkout_billing_data', $fields);
    if(empty($fields)) {
        return false;   
    }
    
    
    // woo subscription
    if(!$order_id) {
        $vals = array_values(WC()->cart->cart_contents);
        $order_id = $vals[0]["subscription_initial_payment"]['order_id'];
    }
    
    $user_id = (int)get_post_meta($order_id, 'pvtcontent_user_id', true);
    
    $args = array(
        'to_get' => array_unique(array_values($fields)),
    );
    $ud = $pc_users->get_user($user_id, $args);
    
    if(empty($ud)) {
        return false;    
    }
    
    
    $code = '
    <table class="shop_table pcpp_checkout_billing_data">
        <tbody>';
    
        foreach($fields as $f_id) {
            if(empty($f_id) || !isset($pc_fields[ $f_id ])) {
                continue;   
            }
            
            $code .= '
            <tr>
                <th>'. $pc_fields[ $f_id ]['label'] .'</th>
                <td>'. $pc_users->data_to_human($f_id, $ud[ $f_id ]) .'</td>
            </tr>';
        }
    
    $code .= '
        </tbody>
    </table>';
    
    
    if(isset($_GET['pay_for_order'])) {
        $code = 
            '<h3>'. esc_html__('Billing details', 'woocommerce') .'</h3>' . $code . '<h3>'. esc_html__('Your order', 'woocommerce') .'</h3>';
    }
    echo $code;
}
add_action('woocommerce_after_checkout_billing_form', 'pcpp_woo_after_checkout_billing_form');
add_action('before_woocommerce_pay_form', 'pcpp_woo_after_checkout_billing_form');







/*************************************
*** WOO SUBSCRIPTION ADD-ON TRICKS ***
*************************************/

// no billing/shipping/extra fields on checkout
function pcpp_wc_checkout_fields($fields) { 
    if(pcpp_woo_subscr_static::is_pcpp_woo_subscr_checkout()) {
        return array(
            'billing'   => array(),
            'shipping'  => array(),
            'order'     => array(),
        );
    }
    
    return $fields;
}
add_filter('woocommerce_checkout_fields', 'pcpp_wc_checkout_fields', 999);




// hide billing/shipping/extra headings on checkout
function pcpp_hide_wc_checkout_headings() { 
    if(pcpp_woo_subscr_static::is_pcpp_woo_subscr_checkout()) {
    ?>
        <style type="text/css">
        .woocommerce-additional-fields {
            display: none !important;    
        }
        #customer_details .col-1 {
            min-width: 100%;        
        }
        </style>        
    <?php
    }
}
add_action('wp_head', 'pcpp_hide_wc_checkout_headings', 1);





// be sure to pass user e-mail through checkout
function pcpp_woocommerce_checkout_posted_data($data) {
    
    if(isset($data['billing_email'])) {
        return $data;   
    }
    
    $order_id = WC()->session->get('order_awaiting_payment');
    if(!is_int($order_id) || !pcpp_woo_subscr_static::order_belongs_to_subscr($order_id)) {
        return $data;   
    }
    
    $current_user = wp_get_current_user();
    $data['billing_email'] = $current_user->user_email;
    
    return $data;
}
add_filter('woocommerce_checkout_posted_data', 'pcpp_woocommerce_checkout_posted_data');





// hide billing/shipping/extra headings on checkout
function pcpp_subscr_hide_admin_fields() { 
    global $current_screen, $post;
    
    if($current_screen->base != 'post' || $current_screen->id != 'shop_subscription') {
        return true;    
    }

    if(pcpp_woo_subscr_static::order_is_subscr($post->ID)) {
    ?>
        <style type="text/css">
        #subscription-trial_end-date,
        #woocommerce-order-downloads,
        .add-line-item,
        .delete-order-item {
            display: none !important;    
        }
        </style>        
    <?php
    }
}
add_action('admin_head', 'pcpp_subscr_hide_admin_fields', 1);




// checkout requires WP user logged - login in WP using synced ID
function pcpp_woo_subscr_login_trick() {
    global $wp, $pcpp_subscr, $pc_users, $pc_wp_user;

    if(is_wc_endpoint_url('order-pay')) {
        $order_id = absint($wp->query_vars['order-pay']);
        
        if($pcpp_subscr->is_pvtcontent_order($order_id)) {        
            $plan_id = $pcpp_subscr->get_order_plan_id($order_id);
            
            if(pcpp_woo_subscr_static::plan_is_subscr($plan_id)) {
                $args = array(
                    'limit'     => 1,
                    'status'    => false,
                    'to_get'    => array('wp_user_id', 'username'),
                    'search'    => array(
                        array('key' => 'pcpp_active_order', 'operator' => '=', 'val' => $order_id)
                    )
                );
                $users = $pc_users->get_users($args);

                if(count($users) && (int)$users[0]['wp_user_id']) {
                    $wp_user_id = (int)$users[0]['wp_user_id'];
                    
                    // is already logged?
                    if(get_current_user_id() == $wp_user_id) {
                        return true;    
                    }
                    
                    update_user_meta($wp_user_id, 'pcpp_woo_subscr_login_trick', 1);

                    $GLOBALS['pc_manual_wp_user_login'] = true;
                    $pc_wp_user->manual_user_login($wp_user_id, $users[0]['username']);
                }
            }
        }
    }
}
add_action('template_redirect', 'pcpp_woo_subscr_login_trick', 1);




// function enqueuing and throwing custom lightbox to require credentials insertion
function pcpp_woo_subscr_login_trick_lb() {
    if(!pcpp_woo_subscr_static::is_pcpp_woo_subscr_checkout() || isset($GLOBALS['pc_user_id'])) {
        return false;    
    }
    
    $wp_user_id         = get_current_user_id();
    $security_meta_key  = 'pcpp_woo_subscr_login_trick_token';
    $security_token     = get_user_meta($wp_user_id, $security_meta_key, true);
    
    if(isset($_COOKIE[$security_meta_key]) && $_COOKIE[$security_meta_key] == $security_token) {
        return true;   
    }
    
    $GLOBALS['pc_has_lightboxes'] = true;
    $GLOBALS['pc_queued_lb'][] = 999999;
    ?>  

    <div id="pcpp_wslt" class="pc_displaynone">
        <div class="pc_lightbox_contents pc_lb_999999">
            <?php
            echo
                '<p id="pcpp_woo_subscr_login_trick_lb_txt">'. __('Credentials check required.<br>Please fill in the form and click the link in the resulting message.', PCPP_ML) .'</p>'. 
                pc_login_form( pc_static::curr_url() );
            ?>
        </div>   
    </div>  

    <div class="pc_lb_trig_999999 pc_modal_lb"></div>
    
    <script type="text/javascript">
    (function($) { 
        "use strict";    
        
        const lb_id = 999999;
        
        pc_lb_classes.push('.pc_lb_trig_' + lb_id);
        pc_ready_lb.push('.pc_lb_trig_' + lb_id);
        
        $('#pc_lb_codes').append( $('#pcpp_wslt').html() );
        
        $(document).ready(function($) {
            setTimeout(function() {
                $('.pc_modal_lb.pc_lb_trig_'+ lb_id).trigger('click');
            }, 1500);
        });
        
        $('#payment').remove();
    })(jQuery);
    </script>
    <?php
}
add_action('wp_footer', 'pcpp_woo_subscr_login_trick_lb'); 




// exclude pvtContent sessions check while using the trick
function pcpp_pc_is_allowed_session($bool) {
    global $pc_users, $wp_user_sync;
    
    if(!$pc_users->wp_user_sync || !get_current_user_id()) {
        return $bool;    
    }
    
    $wp_user_id = get_current_user_id();
    if(get_user_meta($wp_user_id, 'pcpp_woo_subscr_login_trick', true)) {
        return true;    
    }
    
    return $bool;    
}
add_filter('pc_is_allowed_session', 'pcpp_pc_is_allowed_session', 600);





// destroy pcpp_woo_subscr_login_trick() session if not in checkout procedure
function pcpp_woo_subscr_login_trick_logout($clearance, $pc_user_id = false) {
    $meta_name = 'pcpp_woo_subscr_login_trick';
    
    $wp_user_id = get_current_user_id();
    if(!$wp_user_id) {
        return true;    
    }
    
    $meta = get_user_meta($wp_user_id, $meta_name, true);
    if(!$meta) {
        return true;            
    }
    
    if(
        !is_admin() &&
        !is_404() &&
        !is_wc_endpoint_url('order-pay') && 
        !pcpp_woo_subscr_static::is_pcpp_woo_subscr_checkout() && 
        !defined('WC_DOING_AJAX') && 
        !isset($_GET['wc-ajax']) && 
        !is_wc_endpoint_url() &&
        !is_order_received_page()
    ) { 
        delete_user_meta($wp_user_id, $meta_name);
        delete_user_meta($wp_user_id, 'pcpp_woo_subscr_login_trick_token');
        
        wp_clear_auth_cookie();
        wp_logout();
        
        return false;
    }
    
    return true;
}
add_filter('template_redirect', 'pcpp_woo_subscr_login_trick_logout', 100);





// for whatever reason, Woo Subscr creates a new post after checkout. Apply metas  
function pcpp_woo_subscr_insert_post_meta($post_id, $post) {
    if($post->post_type == 'shop_subscription' && get_post_meta($post_id, 'is_pvtcontent_order', true)) {
        global $pc_meta; 
        
        $linked_user_id = get_post_meta($post_id, 'pvtcontent_user_id', true);
        update_post_meta($post_id, 'is_pvtcontent_subscr', 1);
        delete_post_meta($post_id, 'is_pvtcontent_order'); 
        
        $pc_meta->update_meta($linked_user_id, 'pcpp_recurr_subscr', $post_id);    
    }
}
add_action('wp_insert_post', 'pcpp_woo_subscr_insert_post_meta', 10, 2);





// woo subscr renewal order - track order addition and add to user ones and add order meta
function pcpp_woo_subscr_track_renewal_order($renewal_order_obj, $subscr_obj) {
    if(!is_object($renewal_order_obj)) {
        return $renewal_order_obj;    
    }
    
    $order_id = $renewal_order_obj->get_id();
    $subscr_id = $subscr_obj->get_id(); 
    
    if(!pcpp_woo_subscr_static::order_is_subscr($subscr_id)) {
        return $renewal_order_obj;    
    }
    
    $user_id = (int)get_post_meta($subscr_id, 'pvtcontent_user_id', true);
	if(empty($user_id)) {
        return $renewal_order_obj;
    }
    
    pcpp_user_subscr_static::manag_orders($user_id, $order_id, 'add', true);
    
    return $renewal_order_obj;
}
add_filter('wcs_renewal_order_created', 'pcpp_woo_subscr_track_renewal_order', 10, 2);






// woo subscr checkout - if there is a trial period - consider it
function pcpp_wcs_recurring_cart_start_date($exp_date, $cart, $product = false) {
    global $pc_meta, $pc_wp_user;
    
    $vals = array_values($cart->cart_contents);
    $order_id = $vals[0]["subscription_initial_payment"]['order_id'];
    
    $order = wc_get_order($order_id);
    $wp_user_id = $order->get_user_id();
    
    $result = $pc_wp_user->wp_user_is_linked($wp_user_id);
    if(!$result) {
        return $exp_date;   
    }
    
    $user_id = $result->id;
    
    // fixing the DAMN subscr add-on bug not maintaining order in session
    WC()->session->set( 'order_awaiting_payment', $order_id );
    WC()->session->set( 'store_api_draft_order', $order_id );
    
    
    // apply date if is trial
    if($pc_meta->get_meta($user_id, 'pcpp_subscr_status') == 'trial') {
        $GLOBALS['pcpp_wcs_recurring_cart_start_date'] = (int)$pc_meta->get_meta($user_id, 'pcpp_trial_ending'); 
        return wp_date("Y-m-d H:i:s", $GLOBALS['pcpp_wcs_recurring_cart_start_date']);    
    }
     
    return $exp_date;
}
add_filter('wcs_recurring_cart_trial_end_date', 'pcpp_wcs_recurring_cart_start_date', 400, 2);





// woo subscr checkout - if there is a trial period - consider it (also for subscr end)
function pcpp_wcs_recurring_cart_end_date($exp_date, $cart, $product) {
    global $pcpp_subscr;
    
    if(isset($GLOBALS['pcpp_wcs_recurring_cart_start_date'])) {
        $GLOBALS['pcpp_wcs_recurring_cart_start_date'] = $GLOBALS['pcpp_wcs_recurring_cart_start_date'] + 10; // move a bit forward for end date
        
        $prod_data = $pcpp_subscr->get_plan_data($product->get_id());
        $end_date = (int)$prod_data['duration_secs'] + $GLOBALS['pcpp_wcs_recurring_cart_start_date'];
        
        return wp_date("Y-m-d H:i:s", $end_date);    
    }

    return $exp_date;
}
add_filter('wcs_recurring_cart_next_payment_date', 'pcpp_wcs_recurring_cart_end_date', 400, 3);
add_filter('wcs_recurring_cart_end_date', 'pcpp_wcs_recurring_cart_end_date', 400, 3);


