<?php

//////////////////////////////////////////////////////
////// GENERATE INDEX FROM LABEL /////////////////////
//////////////////////////////////////////////////////

function pcud_generate_index() {
	if(!isset($_POST['pcud_nonce']) || !wp_verify_nonce($_POST['pcud_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	if(!isset($_POST['f_label']) || empty($_POST['f_label'])) {
		wp_die('Missing field label');	
	}
	
	echo sanitize_title($_POST['f_label']);
	wp_die();
}
add_action('wp_ajax_pcud_generate_index', 'pcud_generate_index');





//////////////////////////////////////////////////////
////// ADD CUSTOM FIELD //////////////////////////////
//////////////////////////////////////////////////////

function pcud_add_field() {
    if(!isset($_POST['pcud_nonce']) || !wp_verify_nonce($_POST['pcud_nonce'], 'lcwp_ajax')) {
        wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  =>'Cheating?'
        )));
    }
	include_once(PC_DIR . '/classes/pc_form_framework.php');
	
	if(!isset($_POST['f_label']) || empty($_POST['f_label'])) {
		wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  => __('Missing label', PCUD_ML)
        )));
	}
	
	$label = $_POST['f_label'];
	$index = ((!isset($_POST['f_index']) || empty($_POST['f_index']))) ? '' : sanitize_title($_POST['f_index']);
	
	// if empty index - create it 
	if(empty($index)) {
		$san = sanitize_title($_POST['f_label']);
		
		if(!term_exists($san , 'pcud_fields')) {
			$index = $san;	
		} 
		else {
			for($a=1; $a < 50; $a++) {
				if(!term_exists($san.'_'.$a, 'pcud_fields')) {
					$index = $san.'_'.$a;
					break;	
				}
			}	
		}
	}
	
	// avoid forbidden ones
	$f_fw = new pc_form;
	if(in_array($index, $f_fw->forbidden_indexes)) {
		wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  => __('Forbidden field index - please use a different one', PCUD_ML)
        )));	
	}
	
	// try to create it
	$args = array(
		'type' 		=> 'text',
		'subtype' 	=> '',
		'maxlen'	=> 255,
		'placeh'	=> '',
		'note'		=> '',
		'regex'		=> '',
		'check_txt' => '',
		'range_from'=> 0,
		'range_to'	=> 100, 
		'icon'		=> '',
        'unique_val'=> 0,
	);
	$result = wp_insert_term($label, 'pcud_fields', array(
        'slug' => $index,
        'description' => base64_encode(serialize($args))) 
    );
	
	if(is_wp_error($result)) {
		wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  => $result->get_error_message()
        )));
	} 
    else {
		
		// add ID in fields list utility
		$fields_order = (array)get_option('pcud_custom_fields_order', array());
		update_option('pcud_custom_fields_order', array_merge($fields_order, array($result['term_id'])));
		
        
        $term = get_term_by('id', $result['term_id'], 'pcud_fields'); 
        $sorted_fields = pcud_fields_static::get_fields();
        
		wp_die(json_encode(array(
            'status'    => 'success',
            'term_id'   => $result['term_id'],
            'code'      => pcud_fields_static::field_builder_block($term, $sorted_fields),
        )));
	}
}
add_action('wp_ajax_pcud_add_field', 'pcud_add_field');





//////////////////////////////////////////////////////
////// SAVE CUSTOM FIELDS ////////////////////////////
//////////////////////////////////////////////////////

function pcud_save_fields() {
    include_once(PC_DIR . '/classes/simple_form_validator.php');
    
    if(!isset($_POST['pcud_nonce']) || !wp_verify_nonce($_POST['pcud_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
    
    // init validator
    $validator = new simple_fv;
    $indexes = array();

    $indexes[] = array('index'=>'f_sect_assign', 'label'=>__('Field sections assignment', PCUD_ML), 'required'=>true);
    
    $indexes[] = array('index'=>'pcud_f_id', 'label'=>__('Field ID', PCUD_ML), 'required'=>true, 'type'=>'int');
    $indexes[] = array('index'=>'pcud_f_index', 'label'=>__('Field Index', PCUD_ML), 'required'=>true);
    $indexes[] = array('index'=>'pcud_f_label', 'label'=>__('Field Label', PCUD_ML), 'required'=>true);
    $indexes[] = array('index'=>'pcud_f_type', 'label'=>__('Field Type', PCUD_ML), 'required'=>true);
    $indexes[] = array('index'=>'pcud_f_subtype', 'label'=>__('Field Subtype', PCUD_ML));
    $indexes[] = array('index'=>'pcud_f_maxlen', 'label'=>__('Field max-length', PCUD_ML), 'type'=>'int', 'min_val'=>0, 'max_val'=>255);
    $indexes[] = array('index'=>'pcud_f_regex', 'label'=>'Regex custom validation');
    $indexes[] = array('index'=>'pcud_f_range_from', 'label'=>__('Allowed number from', PCUD_ML), 'type'=>'float', 'max_len'=>9);
    $indexes[] = array('index'=>'pcud_f_range_to', 'label'=>__('Allowed number to', PCUD_ML), 'type'=>'float', 'max_len'=>9);   
    $indexes[] = array('index'=>'pcud_f_date_from', 'label'=>__('Allowed date from', PCUD_ML), 'type'=>'iso_date');
    $indexes[] = array('index'=>'pcud_f_date_to', 'label'=>__('Allowed date to', PCUD_ML), 'type'=>'iso_date');
    $indexes[] = array('index'=>'pcud_f_time_from', 'label'=>__('Allowed time from', PCUD_ML), 'type'=>'24h_time');
    $indexes[] = array('index'=>'pcud_f_time_to', 'label'=>__('Allowed time to', PCUD_ML), 'type'=>'24h_time');
    $indexes[] = array('index'=>'pcud_f_placeh', 'label'=>'Field placeholder');
    $indexes[] = array('index'=>'pcud_f_combo_opts', 'label'=>'Combo options?');
    $indexes[] = array('index'=>'pcud_f_multi_select', 'label'=>'Multi-select?');
    $indexes[] = array('index'=>'pcud_f_check_txt', 'label'=>'Checkbox text');
    $indexes[] = array('index'=>'pcud_f_disclaimer', 'label'=>'Use as disclaimer?');
    $indexes[] = array('index'=>'pcud_f_helper', 'label'=>'Field helper');
    $indexes[] = array('index'=>'pcud_f_icon', 'label'=>'Field icon');
    $indexes[] = array('index'=>'pcud_f_unique_val', 'label'=>'Unique value?');
    $indexes[] = array('index'=>'pcud_fullw_f', 'label'=>'Fullwidth field?');
    $indexes[] = array('index'=>'pcud_f_note', 'label'=>'Field note', 'max_len'=>255);
    $indexes[] = array('index'=>'pcud_fields_in_users_list', 'label'=>'Field in users list?');

    $validator->formHandle($indexes);
    $error = $validator->getErrors();
    $fdata = $validator->form_val;

    if($error) {
        wp_die($error);
    }
    
    
    // clean data
    foreach($fdata as $key => $val) {
        if(!is_array($val)) {
            $fdata[$key] = stripslashes($val);
        } else {
            $fdata[$key] = array();
            foreach($val as $arr_val) {
                $fdata[$key][] = stripslashes($arr_val);
            }
        }
    }

    // update terms
    foreach($fdata['pcud_f_index'] as $key => $fid) {
        
        try {
            $args = array(
                'type' 			=> $fdata['pcud_f_type'][$key],
                'subtype' 		=> $fdata['pcud_f_subtype'][$key],
                'maxlen'		=> $fdata['pcud_f_maxlen'][$key],
                'regex'			=> $fdata['pcud_f_regex'][$key],
                'range_from'	=> (filter_var($fdata['pcud_f_range_from'][$key], FILTER_VALIDATE_FLOAT)) ? (float)$fdata['pcud_f_range_from'][$key] : (int)$fdata['pcud_f_range_from'][$key],
                'range_to'		=> (filter_var($fdata['pcud_f_range_to'][$key], FILTER_VALIDATE_FLOAT)) ? (float)$fdata['pcud_f_range_to'][$key] : (int)$fdata['pcud_f_range_to'][$key],
                'date_from'     => $fdata['pcud_f_date_from'][$key],
                'date_to'       => $fdata['pcud_f_date_to'][$key],
                'time_from'     => $fdata['pcud_f_time_from'][$key],
                'time_to'       => $fdata['pcud_f_time_to'][$key],
                'placeh'		=> $fdata['pcud_f_placeh'][$key],
                'combo_opts'	=> $fdata['pcud_f_combo_opts'][$key], 
                'multi_select'	=> $fdata['pcud_f_multi_select'][$key], 
                'check_txt'		=> $fdata['pcud_f_check_txt'][$key], 
                'disclaimer'	=> $fdata['pcud_f_disclaimer'][$key], 
                'helper'        => $fdata['pcud_f_helper'][$key], 
                'icon'			=> $fdata['pcud_f_icon'][$key], 
                'unique_val'    => $fdata['pcud_f_unique_val'][$key],
                'fullw_f'       => $fdata['pcud_fullw_f'][$key],
                'note'			=> $fdata['pcud_f_note'][$key],
            );
        } 
        catch(Exception $e) {
            wp_die($e->getMessage());
        }    

        wp_update_term($fdata['pcud_f_id'][$key], 'pcud_fields', array(
          'name' => $fdata['pcud_f_label'][$key],
          'description' => base64_encode(serialize($args))
        ));
    }

    // WPML / polylang sync
    pcud_fields_static::multilang_fields_sync($fdata);

    
    // update sections assignments
    $assign = json_decode($fdata['f_sect_assign'], true);
    update_option('pcud_fields_arrang', $assign);
    
    wp_die('success');
}
add_action('wp_ajax_pcud_save_fields', 'pcud_save_fields');





//////////////////////////////////////////////////////
////// DELETE CUSTOM FIELD ///////////////////////////
//////////////////////////////////////////////////////

function pcud_del_field() {
	if(!isset($_POST['pcud_nonce']) || !wp_verify_nonce($_POST['pcud_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	
	if(!isset($_POST['f_slug']) || empty($_POST['f_slug'])) {
		wp_die('Missing slug');	
	}
	$slug = $_POST['f_slug'];
	
	$fid = trim(addslashes($_POST['f_id'])); 
	if (!filter_var($fid, FILTER_VALIDATE_INT)) {
        wp_die('Wrong field ID');
    } 
	
	// remove term
	$result = wp_delete_term($fid, 'pcud_fields');

	if($result === false) {
		wp_die('Error deleting term');	
	}
	elseif(is_wp_error($result)) {
		echo $result->get_error_message();	
		wp_die();
	}

	// in case, remove from users list fields
	$ulf = (array)get_option('pcud_fields_in_users_list', array());
	if(($key = array_search($slug, $ulf)) !== false) {
		unset($ulf[$slug]);
		update_option('pcud_fields_in_users_list', $ulf);
	}
	
	echo 'success';
	wp_die();
}
add_action('wp_ajax_pcud_del_field', 'pcud_del_field');





///////////////////////////////////////////////////////////////////////////////////////////////////////




//////////////////////////////////////////////////////
////// LOAD OPTIONS WIZARD LB CODE ///////////////////
//////////////////////////////////////////////////////

function pcud_load_fow_code() {
	if(!isset($_POST['pcud_nonce']) || !wp_verify_nonce($_POST['pcud_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
    if(!isset($_POST['f_name'])) {
		wp_die('Field name missing');	
	}
    if(!isset($_POST['combo_opts'])) {
		wp_die('Combo options value missing');	
	}
    if(!isset($_POST['is_multiple'])) {
		wp_die('"is multiple" value missing');	
	}
	if(!isset($_POST['f_id']) || !(int)$_POST['f_id']) {
		wp_die('Field ID missing');	
	}
    
    $term_id = (int)$_POST['f_id'];
    $combo_opts = (string)$_POST['combo_opts'];
    
    $type = get_term_meta($term_id, 'pcud_fow_opts_type', true);
    $comp = get_term_meta($term_id, 'pcud_fow_opts_comp', true);
    $sort = get_term_meta($term_id, 'pcud_fow_opts_sort', true);
    $def_choice = (array)get_term_meta($term_id, 'pcud_fow_def_choice', true);
    
    $strip_linked_f = ($combo_opts) ? false : true;
    $opts = pcud_fields_static::get_f_opts($term_id, $strip_linked_f);
    
    $opts_type_class    = (!$type || $type == 'simple') ? 'pcud_fow_simple' : '';
    $manual_elems_vis   = ($comp == 'countries') ? 'pc_displaynone' : '';
    $countries_vis      = (!$combo_opts && $comp == 'countries') ? '' : 'pc_displaynone';
    $states_vis         = ($combo_opts && $comp == 'states') ? '' : 'pc_displaynone';
    
    $def_choice_th      = ($combo_opts) ? '' : '
    <th>
        <span class="dashicons dashicons-yes-alt" title="'. esc_attr__('predefined chosen value', PCUD_ML) .'"></span>
    </th>'; 
	?>
    
    <input type="hidden" name="pcud_fow_fid" value="<?php echo $term_id ?>" />
    <input type="hidden" name="pcud_fow_is_multiple" value="<?php echo (int)$_POST['is_multiple'] ?>" />

    <div class="pcud_fow_comp_save_wrap">
        <button title="<?php esc_attr_e('Save') ?>" class="button-primary">
            <span class="fas fa-save"></span>
        </button>
    </div>

    <?php if($combo_opts) : ?>
    <div class="pcud_fow_alv_wrap">
        <button title="<?php esc_attr_e('Add link to other field values', PCUD_ML) ?>" class="button-primary">
            <span class="dashicons dashicons-admin-links"></span>
        </button>
    </div> 
    <?php endif; ?>

    <div class="pcud_fow_elems_wrap <?php echo $opts_type_class ?>">
        <table class="pcud_fow_comp ">
            <tr>
                <td>    
                    <label><?php echo (string)$_POST['f_name'] ?> <?php _e('composition', PCUD_ML) ?></label>
                    <select name="pcud_fow_opts_comp" autocomplate="off">
                        <option value="manual"><?php esc_html_e('manual', PCUD_ML) ?></option>
                        
                        <?php if(!$combo_opts) : ?>
                        <option value="countries" <?php selected($comp, 'countries') ?>><?php esc_html_e('countries List', PCUD_ML) ?></option>
                        <?php else : ?>
                        <option value="states" <?php selected($comp, 'states') ?>><?php esc_html_e('states List', PCUD_ML) ?></option>
                        <?php endif; ?>
                    </select>
                </td>
                <td>
                    <label><?php _e('Options sorting', PCUD_ML) ?></label>  
                    <select name="pcud_fow_opts_sort" autocomplate="off">
                        <option value="custom"><?php esc_html_e('as shown here', PCUD_ML) ?></option>
                        <option value="a_z" <?php selected($sort, 'a_z') ?>><?php esc_html_e('alphabetically', PCUD_ML) ?> (A-Z)</option>
                        <option value="z_a" <?php selected($sort, 'z_a') ?>><?php esc_html_e('alphabetically', PCUD_ML) ?> (Z-A)</option>
                    </select>
                </td>
                <td>    
                    <label><?php _e('Type', PCUD_ML) ?></label>
                    <select name="pcud_fow_opts_type" autocomplate="off">
                        <option value="simple"><?php esc_html_e('simple (only label)', PCUD_ML) ?></option>
                        <option value="advanced" <?php selected($type, 'advanced') ?>><?php esc_html_e('advanced (value + label)', PCUD_ML) ?></option>
                    </select>
                </td>
            </tr>               
        </table>

        <div class="pcud_fow_addbox <?php echo $manual_elems_vis ?>">
            <table>
                <tr>
                    <td>
                        <input type="text" name="pcud_fow_add_opt_val" autocomplete="off" placeholder="<?php esc_attr_e('field value', PCUD_ML) ?>" maxlength="150" />
                    </td>
                    <td>
                        <input type="text" name="pcud_fow_add_opt_label" autocomplete="off" placeholder="<?php esc_attr_e('field label', PCUD_ML) ?>" maxlength="150" />
                    </td>
                    <td class="pcud_fow_addbox_btn_wrap">
                        <button title="<?php esc_attr_e('Add') ?>" class="button-primary">
                            <span class="dashicons dashicons-plus-alt"></span>
                        </button>
                    </td>
                </tr>
            </table>
        </div>

        <table class="pcud_fow_opts_table pcud_fow_man_vals_table <?php echo $manual_elems_vis ?>">
            <thead>
                <tr>
                    <th><?php _e('Value', PCUD_ML) ?></th>
                    <th><?php _e('Label', PCUD_ML) ?></th>
                    <?php echo $def_choice_th ?>
                    <th></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php 
                if($combo_opts) {
                    $first_printed = false;
                    
                    // be sure the array is redy for the combo structure
                    $arr_vals = array_values($opts);
                    
                    if(!count($arr_vals) || !is_array($arr_vals[0])) {
                        $opts = array('' => $opts);
                    }
                    
                    foreach($opts as $linked_opt => $opts) {
                        if(!$first_printed) {
                            echo pcud_fields_static::get_link_to_opt_tr($combo_opts, $linked_opt, true);   
                            $first_printed = true;
                        } 
                        else {
                            echo pcud_fields_static::get_link_to_opt_tr($combo_opts, $linked_opt); 
                        }
                        
                        foreach($opts as $val => $label) {
                            echo pcud_fields_static::get_opt_tr($val, $label, $def_choice, (int)$_POST['is_multiple'], $combo_opts);        
                        }
                    }
                } 
                else {
                    foreach($opts as $val => $label) {
                        echo pcud_fields_static::get_opt_tr($val, $label, $def_choice, (int)$_POST['is_multiple'], $combo_opts);    
                    }
                }
                ?>
            </tbody>
        </table>

        <table class="pcud_fow_opts_table pcud_fow_contries_table <?php echo $countries_vis ?>">
            <thead>
                <tr>
                    <th><?php _e('Value', PCUD_ML) ?></th>
                    <th><?php _e('Label', PCUD_ML) ?></th>
                    <th>
                        <span class="dashicons dashicons-yes-alt" title="<?php esc_attr_e('predefined chosen value', PCUD_ML) ?>"></span>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php
                include_once(PCUD_DIR .'/fixed_field_opts/countries.php');
                foreach($GLOBALS['pcud_countries'] as $key => $val) {
                    $is_def_choice = (in_array($key, $def_choice)) ? 'checked="checked"' : '';
                    
                    echo '
                    <tr>
                        <td>'. esc_attr($key) .'</td>
                        <td>'. $val .'</td>
                        <td>
                            <input type="radio" name="pcud_fow_def_sel" value="'. uniqid() .'" '. $is_def_choice .' autocomplete="off" />
                        </td>
                    </tr>';        
                }
                ?>
            </tbody>
        </table>
        
        <table class="pcud_fow_opts_table pcud_fow_states_table <?php echo $states_vis ?>">
            <thead>
                <tr>
                    <th><?php _e('Value', PCUD_ML) ?></th>
                    <th><?php _e('Label', PCUD_ML) ?></th>
                </tr>
            </thead>
            <tbody>
                <?php 
                include_once(PCUD_DIR .'/fixed_field_opts/states.php');
                foreach($GLOBALS['pcud_states'] as $key => $val) {
                    
                    if(empty($val)) {
                        continue;    
                    }
                    
                    echo '
                    <tr class="pcud_fow_linked_val_tr">
                        <td>'. $key .'</td>
                        <td><span>'. $key .'</span><i class="dashicons dashicons-admin-links" title="'. esc_attr__('All options underneath are linked to this value', PCUD_ML) .'"></i></td>
                    </tr>';
                    
                    foreach($val as $subkey => $subval) {
                        $is_def_choice = (in_array($subkey, $def_choice)) ? 'checked="checked"' : '';
                        
                        echo '
                        <tr>
                            <td>'. esc_attr($subkey) .'</td>
                            <td>'. $subval .'</td>
                        </tr>';         
                    }
                }
                ?>
            </tbody>
        </table>
    </div>


    <script type="text/javascript">
    (function($) { 
        "use strict";    

        // add linked option dropdown for combo dd
        $(document).off('click', '.pcud_fow_alv_wrap button').on('click', '.pcud_fow_alv_wrap button', function() {
            const code = `<?php echo pcud_fields_static::get_link_to_opt_tr($combo_opts) ?>`;
            $('.pcud_fow_man_vals_table tbody').append(code);
            
            // LC select for combo dd
            new lc_select('select[name="pcud_fow_linked_val"]', {
                wrap_width : '100%',
                addit_classes : ['lcslt-lcwp', 'pc_scw_field_dd'],
            });
        });
    })(jQuery);      
    </script>
    <?php
	wp_die();
}
add_action('wp_ajax_pcud_load_fow_code', 'pcud_load_fow_code');





//////////////////////////////////////////////////////
////// SAVE FIELD OPTIONS ////////////////////////////
//////////////////////////////////////////////////////

function pcud_fow_save_opts() {
	if(!isset($_POST['pcud_nonce']) || !wp_verify_nonce($_POST['pcud_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
    
    include_once(PC_DIR . '/classes/simple_form_validator.php');
	$validator = new simple_fv;	
		
	$indexes = array();
	$indexes[] = array('index'=>'f_id', 'label'=>'Field ID', 'type'=>'int', 'required'=>true);
	$indexes[] = array('index'=>'type', 'label'=>'Type', 'required'=>true, 'allowed'=>array('simple', 'advanced'));
	$indexes[] = array('index'=>'comp', 'label'=>'Composition', 'required'=>true, 'allowed'=>array('manual', 'countries'));
    $indexes[] = array('index'=>'sorting', 'label'=>'Sorting', 'required'=>true, 'allowed'=>array('custom', 'a_z', 'z_a'));
    $indexes[] = array('index'=>'is_combo', 'label'=>'Is combo', 'required'=>true);
    $indexes[] = array('index'=>'def_choice', 'label'=>'Value chosen by default');
	$indexes[] = array('index'=>'opts', 'label'=>__('Options', PCUD_ML), 'required'=>true);
	
	$validator->formHandle($indexes);
	$fdata = $validator->form_val;
	$error = $validator->getErrors();
    
    if($error) {
        wp_die($error);    
    }
    
    // options check
    $opts = array();
    $vals = array(); // used to check vdoubled
    
    if($fdata['comp'] == 'manual') {
        $fdata['opts'] = (array)json_decode(stripslashes($fdata['opts']));
        $doubled = array();          

        if($fdata['is_combo']) {
            foreach($fdata['opts'] as $to_link => $lv_opts) {
                $opts[ $to_link ] = array();
                
                foreach((array)$lv_opts as $opt) {
                    $opt->val = trim($opt->val);
                    
                    if(in_array($opt->val, $vals)) {
                        $doubled[] = $opt->val;
                        continue;
                    }

                    $vals[] = $opt->val;
                    $opts[ $to_link ][ $opt->val ] = trim($opt->label);    
                }
            }
        }
        else {
            foreach((array)$fdata['opts'] as $opt) {
                $opt->val = trim($opt->val);
                
                if(in_array($opt->val, $vals)) {
                    $doubled[] = $opt->val;
                    continue;
                }

                $vals[] = $opt->val;
                $opts[ $opt->val ] = trim($opt->label);    
            }
        }
        
        if(count($vals) < 2) {
            wp_die( __('Please insert at least two options', PCUD_ML));	        
        }       
        elseif(count($doubled)) {
            wp_die( __('There are doubled values', PCUD_ML) .': '. implode(', ', $doubled) );    
        }
    }
    
    update_term_meta( (int)$fdata['f_id'], 'pcud_fow_opts_type', $fdata['type']);
    update_term_meta( (int)$fdata['f_id'], 'pcud_fow_opts_comp', $fdata['comp']);
    update_term_meta( (int)$fdata['f_id'], 'pcud_fow_opts_sort', $fdata['sorting']);
    update_term_meta( (int)$fdata['f_id'], 'pcud_fow_def_choice', $fdata['def_choice']);
    update_term_meta( (int)$fdata['f_id'], 'pcud_fow_opts', $opts);
    
    pcud_fields_static::multilang_field_opts_sync($opts);
    
	echo 'success';
	wp_die();
}
add_action('wp_ajax_pcud_fow_save_opts', 'pcud_fow_save_opts');







///////////////////////////////////////////////////////////////////////////////////////////////////////







////////////////////////////////////////////////
////// ADD FORM TERM ///////////////////////////
////////////////////////////////////////////////

function pcud_add_form_term() {
    if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        wp_die(json_encode(array(
            'status'    => 'error',
            'mess'      =>'Cheating?'
        )));
    }
    
    if(!isset($_POST['subj']) || !in_array($_POST['subj'], array('registr', 'update'))) {
        wp_die(json_encode(array(
            'status'    => 'error',
            'mess'      => 'Subject missing or wrong'
        )));
    }
	if(!isset($_POST['form_name']) || empty($_POST['form_name'])) {
        wp_die(json_encode(array(
            'status'    => 'error',
            'mess'      => 'Form name missing'
        )));
    }
    
    $taxonomy = ($_POST['subj'] == 'registr') ? 'pc_reg_form' : 'pcud_forms'; 
	
    $args = array(
        'slug' => sanitize_title($_POST['form_name'])    
    );
    
    if($taxonomy == 'pc_reg_form') {
        require_once(PC_DIR .'/classes/pc_form_framework.php');
        $f_fw = new pc_form;
        
        $args['description'] = array(
            'include' => array('username', 'psw'), 
            'require' => array('username', 'psw')
        );

        if($f_fw->mail_is_required) {
            $args['description']['include'][] = 'email';
            $args['description']['require'][] = 'email';
        }
        
        $args['description'] = base64_encode(serialize($args['description']));
    }
    
    $resp = wp_insert_term(trim($_POST['form_name']), $taxonomy, $args);
	
	if(is_array($resp)) {
        wp_die(json_encode(array(
            'status'    => 'success',
            'term_id'   => $resp['term_id']
        )));
    }
	else {
        wp_die(json_encode(array(
            'status'    => 'error',
            'mess'      => $resp->errors['term_exists'][0]
        )));
	}
}
add_action('wp_ajax_pcud_add_form', 'pcud_add_form_term');





////////////////////////////////////////////////
////// RENAME FORM TERM ////////////////////////
////////////////////////////////////////////////

function pcud_rename_form() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	if(!isset($_POST['form_id']) || !(int)$_POST['form_id']) {
        wp_die('Form ID missing');
    }
    if(!isset($_POST['new_name']) || empty($_POST['new_name'])) {
        wp_die(__('Empty form name', PCUD_ML));
    }
    if(!isset($_POST['section']) || !in_array($_POST['section'], array('registr', 'update'))) {
        wp_die('Section missing or wrong');
    }
    
    $taxonomy = ($_POST['section'] == 'registr') ? 'pc_reg_form' : 'pcud_forms';
	$name = trim($_POST['new_name']);
    
	// check if name is already taken
	$check = get_term_by('name', $name, $taxonomy);
	if($check && $check->term_id != (int)$_POST['form_id']) {
		wp_die( __('Another form has this name', PCUD_ML) );	
	}

	// update
	$args = array(
  		'name' => $name,
	);
	$resp = wp_update_term((int)$_POST['form_id'], $taxonomy, $args);
	
	if(is_wp_error($resp)) {
		echo $resp->get_error_message();
		wp_die();
	} 
	else {	
		wp_die('success');
	}
}
add_action('wp_ajax_pcud_rename_form', 'pcud_rename_form');






////////////////////////////////////////////////
////// DELETE FORM TERM ////////////////////////
////////////////////////////////////////////////

function pcud_del_form_term() {
    if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	if(!isset($_POST['form_id']) || !(int)$_POST['form_id']) {
        wp_die('Form ID missing');
    }
    if(!isset($_POST['section']) || !in_array($_POST['section'], array('registr', 'update'))) {
        wp_die('Section missing or wrong');
    }
    
    $taxonomy = ($_POST['section'] == 'registr') ? 'pc_reg_form' : 'pcud_forms';
	$resp = wp_delete_term((int)$_POST['form_id'], $taxonomy);

	if($resp === true) {
		
		// delete WPML translation record
		if(function_exists('icl_unregister_string')) {
			icl_unregister_string('PrivateContent User Data', 'Form #'.(int)$_POST['form_id'].' - custom message');	
		}
		wp_die('success');
	}
	else {
        wp_die( __('Error during the form deletion', PCUD_ML));
    }
}
add_action('wp_ajax_pcud_del_form', 'pcud_del_form_term');






////////////////////////////////////////////////
////// DISPLAY FORM BUILDER ////////////////////
////////////////////////////////////////////////

function pcud_form_builder() {
    if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	require_once(PC_DIR .'/classes/pc_form_framework.php');
	
	if(!isset($_POST['form_id']) || !(int)$_POST['form_id']) {
        wp_die('Form ID missing');
    }
    
    if(!isset($_POST['section']) || !in_array($_POST['section'], array('registr', 'update'))) {
        wp_die('Section missing or wrong');
    }
    
    $form_id = (int)$_POST['form_id']; 
    $taxonomy = ($_POST['section'] == 'registr') ? 'pc_reg_form' : 'pcud_forms';
    $is_reg_form = ($_POST['section'] == 'registr');
    
	// get all the fields
	$f_fw = new pc_form;
	
	// retrieve form term
	$term = get_term_by('id', $form_id, $taxonomy);
	if(!$term) {
        wp_die( __('Form not found', PCUD_ML));
    }
	
	// field selector
    $use_cat = ($is_reg_form) ? true : false;
    $ignore = array_merge(pcud_static::wizards_ignore_fields($use_cat), array('username'));

    // add password support
    if(($key = array_search('psw', $ignore)) !== false) {
        unset($ignore[$key]);
    }

    $grouped_fields = $f_fw->get_fields_grouped();
    ?>
    <h3 class="pcud_field_name_heading"><?php echo $term->name; ?></h3>

    <div class="pcud_add_form_f_box">
        <select data-placeholder="<?php esc_attr_e('Select field', PCUD_ML); ?> .." name="pcud_fields_list" class="pcud_lc_select" autocomplete="off">
            
            <optgroup label="<?php esc_attr_e('Extra', PCUD_ML) ?>">
                <option value="custom|||text">- <?php esc_html_e('TEXT BLOCK', PCUD_ML) ?></option>
                <option value="custom|||page">- <?php esc_html_e('PAGINATOR', PCUD_ML) ?></option>
                <option value="custom|||sep">-  <?php esc_html_e('SEPARATOR BAR', PCUD_ML) ?></option>
            </optgroup>
                
            <?php  
            foreach($grouped_fields as $group_name => $fields) {
                echo '
                <optgroup label="'. esc_attr($group_name) .'">';
        
                    foreach($fields as $field => $data) {
                        if($is_reg_form && ($field == 'psw' || ($field == 'email' && $f_fw->mail_is_required))) {
                            continue;    
                        }

                        if(!in_array($field, $ignore)) {
                            echo '<option value="'.$field.'">'.$data['label'].'</option>';
                        }
                    }
                
                echo '
                </optgroup>';
            }
            ?>
        </select>  
        <button type="button" name="add_field" title="<?php esc_attr_e('Add field') ?>" class="button-secondary">
            <span class="dashicons dashicons-plus-alt"></span>
        </button>
    </div>

    
	<?php 
    // get form fields (care retrocompatibility)
	$form_fields = (!$is_reg_form && empty($term->description)) ? (array)get_option('pcud_form_'.$form_id, array()) : unserialize(base64_decode($term->description));
    
    // field conditions
    $f_conds = (array)get_term_meta($form_id, 'pcud_form_conditions', true);
    ?>
    <table id="pcud_form_table" class="widefat pc_table">
      <thead>
          <tr>
            <th></th><?php // del ?>
            <th></th><?php // sort ?>
            <th></th><?php // linked field ?>
            <th><?php _e('Field name', PCUD_ML); ?></th>
            <th><?php _e('Required?', PCUD_ML); ?> <span class="dashicons dashicons-info" title="<?php esc_attr_e('conditionally-hidden fields will not be required', PCUD_ML) ?>"></span></th>
            <th></th><?php // add condition ?>
          </tr>
      </thead>
      <tbody>
      	<?php 
		if(!empty($form_fields)) {
			$form_fields = pcud_fields_static::v2_field_names_sanitize($form_fields);
			
			$incl 	= (array)$form_fields['include'];
			$req 	= (array)$form_fields['require'];
			$texts 	= (isset($form_fields['texts'])) ? (array)$form_fields['texts'] : array();  
			
            if($is_reg_form && $f_fw->mail_is_required && !in_array('email', $incl)) {
                $incl[] = 'email';
                $req[]  = 'email';
            }
            
			$txt_id = 0;
			foreach($incl as $f_name) {
                $conditions_code = pcud_forms_static::builder_field_conditions($f_name, $form_id, $f_fw);
                
				$fixed_cmd = '
                <td>
                    <span class="pcud_del_field pc_del_field dashicons dashicons-no-alt" title="'. esc_attr__('remove field', PCUD_ML) .'"></span>
                </td>
				<td>
                    <span class="pcud_move_field pc_move_field dashicons dashicons-move" title="'. esc_attr__('move field', PCUD_ML) .'"></span>
                </td>';
                
                $fixed_last_cmd = '
                <td>
                    <button type="button" name="add_field_cond" title="'. esc_attr__('Add visibility condition', PCUD_ML) .'" class="button-secondary">
                        <span class="dashicons dashicons-randomize"></span>
                    </button>
                </td>';
                
				if(substr($f_name, 0, 13) == 'custom|||text' && isset($texts[$txt_id])) {
					echo '
					<tr data-f-id="'. esc_attr($f_name) .'" data-f-label="'. esc_attr__('Text block', PCUD_ML) .'">
						'. $fixed_cmd .'
                        <td></td>
						<td colspan="2" class="pcud_field_label_td">
                            <input type="hidden" name="pcud_include_field[]" value="'. $f_name .'" class="pcud_incl_f" />
                            <textarea name="pcud_form_texts[]" placeholder="'. esc_attr__('Supports HTML and shortcodes', PCUD_ML) .'" onkeyup="lcwp_sf_textAreaAdjust(this)">'. $texts[$txt_id] .'</textarea>
                            '. $conditions_code .'
						</td>
                        '. $fixed_last_cmd .'
					</tr>';
					
					$txt_id++;	
				}
                elseif(substr($f_name, 0, 12) == 'custom|||sep') {
					echo '
					<tr data-f-id="'. esc_attr($f_name) .'" data-f-label="'. esc_attr__('Separator bar', PCUD_ML) .'">
						'. $fixed_cmd .'
                        <td></td>
						<td colspan="2" class="pcud_separator_bar_td">
							<input type="hidden" name="pcud_include_field[]" value="'. $f_name .'" class="pcud_incl_f" />
							<strong>'. __('SEPARATOR BAR', PCUD_ML) .'</strong>
                            '. $conditions_code .'
						</td>
                        '. $fixed_last_cmd .'
					</tr>';
				}
				elseif($f_name == 'custom|||page') {
					echo '
					<tr data-f-id="'. esc_attr($f_name) .'" data-f-label="'. esc_attr__('Paginator', PCUD_ML) .'">
						'. $fixed_cmd .'
                        <td></td>
						<td colspan="3" class="pcud_paginator_td">
							<input type="hidden" name="pcud_include_field[]" value="'. $f_name .'" class="pcud_incl_f" />
							<strong>'. __('PAGINATOR', PCUD_ML) .'</strong>
						</td>
					</tr>';
				}
				else {
					if(!isset($f_fw->fields[$f_name])) {
                        continue;    
                    }
                        
                    $field_data   = $f_fw->fields[$f_name];
                    $sel          = (in_array($f_name, $req)) ? 'checked="checked"' : '';
                    $dis_check    = '';

                    // if password or required email disable "required" switch 
                    if($f_name == 'psw' || $f_name == 'category' || ($f_name == 'email' && $f_fw->mail_is_required)) {
                        $dis_check = 'disabled="disabled"';
                        $sel = 'checked="checked"';
                        $fixed_last_cmd = '<td></td>';
                    }

                    // registration forms always need psw and username
                    if($is_reg_form && 
                        (in_array($f_name, array('username', 'psw')) || ($f_name == 'email' && $f_fw->mail_is_required))
                    ) {
                        $dis_check = 'disabled="disabled"';
                        $sel = 'checked="checked"';

                        $fixed_cmd = '
                        <td></td>
                        <td>
                            <span class="pcud_move_field pc_move_field dashicons dashicons-move" title="'. esc_attr__('move field', PC_ML) .'"></span>
                        </td>';
                        
                        $fixed_last_cmd = '<td></td>';
                    }

                    // combo field icon
                    $combo_f_icon = pcud_fields_static::f_is_combo($f_name);
                    if($combo_f_icon && isset($f_fw->fields[$combo_f_icon])) {
                        $combo_f_icon = '<span class="dashicons dashicons-admin-links" title="'. sprintf(esc_attr__('Combo field, showing options in relation to "%s" field', PCUD_ML), $f_fw->fields[$combo_f_icon]['label']) .'" data-linked-f="'. esc_attr($combo_f_icon) .'"></span>';
                    }

                    echo '
                    <tr data-f-id="'. esc_attr($f_name) .'" data-f-label="'. esc_attr($field_data['label']) .'">
                        '. $fixed_cmd .'
                        <td>'. $combo_f_icon .'</td>
                        <td class="pcud_field_label_td">
                            <input type="hidden" name="pcud_include_field[]" value="'. $f_name .'" class="pcud_incl_f" />
                            <span>'. $field_data['label'] .'</span>
                            '. $conditions_code .'
                        </td>	
                        <td>
                            <input type="checkbox" name="pcud_require_field[]" value="'. $f_name .'" '. $sel .' '. $dis_check .' class="pcud_req_f pcud_check" />
                        </td>
                        '. $fixed_last_cmd .'
                    </tr>';		
				}
			}
		}
		?>
      </tbody>
    </table>
    
    <?php 
    if(!$is_reg_form) {
    
        $cust_mess      = (isset($form_fields['cust_mess'])) ? $form_fields['cust_mess'] : ''; // custom message
        $no_mail_notif  = (isset($form_fields['no_mail_notif']) && $form_fields['no_mail_notif']) ? true : false; // no mail notification
        $redirect       = (is_array($form_fields) && isset($form_fields['redirect'])) ? $form_fields['redirect'] : ''; // form redirect 
        $custom_red     = ($redirect == 'custom') ? $form_fields['cust_redir'] : ''; // custom redirect 

        
        // pages list
        $pages = get_pages(); 
        ?>
        <br/>
        <h3><?php _e('Additional details', PCUD_ML) ?></h3>
        <table id="pcud_form_add_det_table" class="widefat pc_table">
          </tbody>
            <tr>
                <td class="pc_label_td"><?php _e("Custom message", PCUD_ML); ?></td>
                <td class="pc_field_td" colspan="2">
                    <input type="text" name="pcud_cust_mess" id="pcud_cust_mess" value="<?php echo esc_attr($cust_mess); ?>" autocomplete="off" maxlength="250" />
                    <p><span class="info"><?php _e('Custom message after successful form submission - leave empty to use default one', PCUD_ML) ?></span></p>
                </td>
            </tr> 
            <tr <?php if(!function_exists('pcma_is_active') || !pcma_is_active() || !get_option('pcud_sf_admin_notif')) echo 'class="pc_displaynone"' ?>>
                <td class="pc_label_td"><?php _e("Disable admin notification for this form?", PCUD_ML); ?></td>
                <td class="pc_field_td">
                    <input type="checkbox" name="pcud_no_mail_notif" id="pcud_no_mail_notif" value="1" autocomplete="off" class="pcud_check" <?php if($no_mail_notif) echo 'checked="checked"' ?> />
                </td>
                <td>
                    <span class="info"><?php _e('If checked, avoid sending the admin notification e-mail whenever form is submitted', PCUD_ML) ?></span>
                </td>
            </tr> 

            <tr>
              <td class="pc_label_td" rowspan="2"><?php _e("Redirect after data saving", PCUD_ML); ?></td>
              <td class="pc_field_td">
                  <select id="pcud_redirect" name="pcud_redirect" class="pcud_lc_select" data-placeholder="<?php esc_attr_e('Select a page', PCUD_ML) ?> .." autocomplete="off">
                      <option value="">- <?php esc_html_e('No redirect', PCUD_ML) ?></option>
                      <option value="custom" <?php selected($redirect, 'custom') ?>>- <?php esc_html_e('Custom redirect', PCUD_ML) ?></option>
                      <option value="refresh" <?php selected($redirect, 'refresh') ?>>- <?php esc_html_e('Refresh page', PCUD_ML) ?></option>
                      <?php
                      foreach ($pages as $pag ) {
                          $selected = ($redirect == $pag->ID) ? 'selected="selected"' : '';
                          echo '<option value="'.$pag->ID.'" '.$selected.'>'.$pag->post_title.'</option>';
                      }
                      ?>
                  </select>   
              </td>
              <td><span class="info"><?php _e('Redirect target after successful form submission', PCUD_ML) ?></span></td>
            </tr>
            <tr id="pcud_cust_redir_wrap">
                <td colspan="2" <?php if($redirect != 'custom') {echo 'class="pc_displaynone"';} ?>>
                    <input type="text" name="pcud_cust_redir" value="<?php echo esc_attr($custom_red); ?>" autocomplete="off" placeholder="<?php esc_attr_e('insert a valid URL', PCUD_ML) ?>" />
                </td>
            </tr> 
          </tbody>
        </table>
        <?php
    } // is reg form end
    
	wp_die();
}
add_action('wp_ajax_pcud_form_builder', 'pcud_form_builder');






//////////////////////////////////////////////////
////// UPDATE FORM ///////////////////////////////
//////////////////////////////////////////////////

function pcud_save_form() {
	if (!isset($_POST['pcud_nonce']) || !wp_verify_nonce($_POST['pcud_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	
    if(!isset($_POST['section']) || !in_array($_POST['section'], array('registr', 'update'))) {
        wp_die('Section missing or wrong');
    }
    $taxonomy       = ($_POST['section'] == 'registr') ? 'pc_reg_form' : 'pcud_forms';
    $is_reg_form    = ($_POST['section'] == 'registr') ? true : false;
    
    
	include_once(PC_DIR .'/classes/simple_form_validator.php');
	$validator = new simple_fv;	
		
	$indexes = array();
	$indexes[] = array('index'=>'form_id', 'label'=>'form id', 'type'=>'int', 'required'=>true);
	$indexes[] = array('index'=>'fields_included', 'label'=>'fields included');
	$indexes[] = array('index'=>'fields_required', 'label'=>'fields required');
	$indexes[] = array('index'=>'texts', 'label'=>'text blocks');
    $indexes[] = array('index'=>'conditions', 'label'=>'field conditions');
    
    if(!$is_reg_form) {
        $indexes[] = array('index'=>'cust_mess', 'label'=>'custom message');
        $indexes[] = array('index'=>'no_mail_notif', 'label'=>'no mail notification');
        $indexes[] = array('index'=>'redirect', 'label'=>'redirect target');
        $indexes[] = array('index'=>'cust_redir', 'label'=>'custom redirect target');
    }
	
	$validator->formHandle($indexes);
	$fdata = $validator->form_val;
	$error = $validator->getErrors();
	
	if($error) {
        wp_die($error);    
    }
    
    require_once(PC_DIR .'/classes/pc_form_framework.php');
    $f_fw = new pc_form;

    $included = (array)$fdata['fields_included'];
    $required = (array)$fdata['fields_required'];
    
    
    // be sure included fields exist
    foreach($included as $incl) {
        if(substr($incl, 0, 13) != 'custom|||text' && substr($incl, 0, 12) != 'custom|||sep' && $incl != 'custom|||page') {
            if(!isset($f_fw->fields[$incl])) {
                wp_die( sprintf(esc_attr__('Fieeeeld "%s" is not among registered ones', PCUD_ML), $incl));    
            }
            $f_array = $f_fw->fields[$incl]; 

            // combo dropdowns - check linked fields existence
            if(isset($f_array['combo_link']) && $f_array['combo_link'] && isset($f_fw->fields[ $f_array['combo_link'] ])) {
                if(!in_array($f_array['combo_link'], $included)) {
                    $combo_link_label = $f_fw->fields[ $f_array['combo_link'] ]['label'];
                    wp_die( '"'. $f_array['label'] .'" '. sprintf(esc_attr__('combo field requires "%s"', PCUD_ML), $combo_link_label) );                                
                }
            }   
        }
    }
    
    
    // specific compositions check
    if($is_reg_form) {
        if(!in_array('username', $included) || !in_array('psw', $included) || ($f_fw->mail_is_required && !in_array('email', $included))) {
            wp_die( __('Username and password must be included in registration forms', PCUD_ML));                
        }
        if($f_fw->mail_is_required && !in_array('email', $included)) {
            wp_die( __('E-mail must be included in registration forms', PCUD_ML));                
        }
        if(!in_array('username', $required) || !in_array('psw', $required) || ($f_fw->mail_is_required && !in_array('email', $required))) {
            wp_die( __('Username and password must be required in registration forms', PCUD_ML));                
        }
        if($f_fw->mail_is_required && !in_array('email', $required)) {
            wp_die( __('E-mail must be required in registration forms', PCUD_ML));                
        }   
    }
    else {
        if(in_array('psw', $included) && !in_array('psw', $required)) {
            wp_die( __('Password must be required in data update forms', PCUD_ML));          
        }
        if($f_fw->mail_is_required && in_array('email', $included) && !in_array('email', $required)) {
            wp_die( __('E-mail must be required in data update forms', PCUD_ML));          
        }
    }
    

    // clean texts from slashes
    if(!empty($fdata['texts'])) {
        $escaped = array();

        foreach((array)$fdata['texts'] as $val) {
            $escaped[] = stripslashes($val);
        }

        $fdata['texts'] = $escaped;
    }
    
    
    // create form data structure
    $structure = array(
        'include' 	=> (array)$fdata['fields_included'], 
        'require'	=> (array)$fdata['fields_required'], 
        'texts'		=> (array)$fdata['texts'],
    );
    
    if(!$is_reg_form) {
        $structure = array_merge($structure, array(
            'cust_mess'     => $fdata['cust_mess'],
            'no_mail_notif' => $fdata['no_mail_notif'],
            'redirect'	    => $fdata['redirect'],
            'cust_redir'    => $fdata['cust_redir']   
        ));    
    }

    // update	
    $result = wp_update_term((int)$fdata['form_id'], $taxonomy, array(
        'description' => base64_encode(serialize($structure))
    ));

    
    // save conditions
    update_term_meta((int)$fdata['form_id'], 'pcud_form_conditions', json_decode(stripslashes($fdata['conditions']), true) );
    

    // result
    if(is_wp_error($result)) {
        echo $result->get_error_message();	
    }
    else {

        if(!$is_reg_form) {
            // sync with WPML
            if(function_exists('icl_register_string')) {
                $key = 'Form #'.$fdata['form_id'].' - custom message';
                if(!empty($fdata['cust_mess'])) {
                    icl_register_string('PrivateContent User Data', $key , $fdata['cust_mess']);
                } else {
                    icl_unregister_string('PrivateContent User Data', $key);	
                }
            }

            // sync with Polylang
            if(function_exists('pll_register_string')) {
                pll_register_string('PrivateContent User Data', $fdata['cust_mess'], $key);	
            }
        }

        echo 'success';	
    }
	wp_die();
}
add_action('wp_ajax_pcud_save_form', 'pcud_save_form');







///////////////////////////////////////////////////////////////////////////////////////////////////////







//////////////////////////////////////////////////////
////// SAVE USER DASHBOARD FIELDS ARRANGEMENT ////////
//////////////////////////////////////////////////////

function pcud_ud_save_f_arrang() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }

    // save arrangement
    $arrang = (!isset($_POST['arrang'])) ? array() : (array)$_POST['arrang'];
    update_option('pcud_fields_arrang', $arrang);
	
    
    // save fields order
    $f_order = array();
    foreach($arrang as $sect_name => $f_slugs) {
        $f_order[] = $f_slugs;     
    }
    update_option('pcud_user_dashboard_fields_order', $f_order);
    
    wp_die('success');
}
add_action('wp_ajax_pcud_ud_save_f_arrang', 'pcud_ud_save_f_arrang');
