<?php
// PRIVATECONTENT ADMIN INTEGRATIONS



///////////////////////////////////////////////
// ADD CUSTOM FIELDS into framework ///////////
///////////////////////////////////////////////

function pcud_add_fields_into_pc($fields) {
    $GLOBALS['pcud_fields_to_hide'] = array();
    $GLOBALS['pcud_empty_combo_fields'] = array();
    
	$pcud_fields = pcud_fields_static::get_fields();

	// if is WP error (called before taxonomies setup) - return fields
	if(is_wp_error($pcud_fields)) {
        return $fields;
    } 
	
	foreach($pcud_fields as $term) {
		$field_args = array(
            'label'         => pcud_static::wpml_translated_string($term->slug, $term->name),
            'pcud_term_id'  => $term->term_id
        );
		
		foreach($term->pcud_opts as $index => $val) {
			if($index == 'multi_select') {
				$field_args['multiple'] = (empty($val)) ? false : true;
			} 
			elseif($index == 'placeh') {
				$field_args[$index] = pcud_static::wpml_translated_string($term->slug, $val, 'placeh');	
			} 
			elseif($index == 'check_txt') {
				$field_args[$index] = pcud_static::wpml_translated_string($term->slug, $val, 'check_txt');	
			} 
			else {
				$field_args[$index] = $val;	
			}
		}
        
        
        // options for select and checkboxes
        if(in_array($term->pcud_opts['type'], array('select', 'checkbox', 'radio'))) {
            $is_combo = (isset($term->pcud_opts['combo_opts']) && $term->pcud_opts['combo_opts']) ? $term->pcud_opts['combo_opts'] : '';
            $field_args['combo_link'] = $is_combo;
            
            if($is_combo) {
                $combo_term = get_term_by('slug', $is_combo, 'pcud_fields');
                
                // get linked field selected values
                $linked_sel_vals = pcud_fields_static::get_sel_opts($is_combo);
                if(empty($linked_sel_vals)) {
                    $field_args['opt'] = array();        
                } else {
                    $field_args['opt'] = pcud_fields_static::get_f_opts_linked_to_val($term->term_id, $linked_sel_vals);   
                }
                
                if(empty($field_args['opt'])) {
                    $GLOBALS['pcud_empty_combo_fields'][] = $term->slug;     
                }
            }
            else {
                $field_args['opt'] = pcud_fields_static::get_f_opts($term->term_id, true, true);
            }
            
            $field_args['def_choice'] = (array)get_term_meta($term->term_id, 'pcud_fow_def_choice', true); 
        }
        
        
        // ignore regex for date fields and set validation to ISO format
        if($term->pcud_opts['type'] == 'text' && in_array($term->pcud_opts['subtype'], array('eu_date', 'us_date'))) {
            $field_args['regex'] = '';
        }
		
        // fullwidth field
        if(isset($term->pcud_opts['fullw_f']) && $term->pcud_opts['fullw_f']) {
            $field_args['fullw_f'] = true;    
        }
        
        // group
        $field_args['group'] = pcud_fields_static::get_field_section($term->slug);  
        
        
		$fields[$term->slug] = $field_args;
	}
	
	return $fields;
}
add_filter('pc_form_fields_filter', 'pcud_add_fields_into_pc');





// custom field validations - integrate into form framework
function pcud_form_valid_errors($errors, $fdata, $user_id) {
    global $wpdb;
    $pcud_fields = pcud_fields_static::get_fields();
    
    foreach($fdata as $index => $val) {
        if(empty($val) || !defined('PC_META_TABLE') || !isset($pcud_fields[$index])) {
            continue;    
        }
        $pcud_f_opts = $pcud_fields[$index]->pcud_opts;
        
        
        // unique val in DB
        if(
            in_array($pcud_f_opts['type'], array('text', 'textarea')) &&
            isset($pcud_f_opts['unique_val']) &&
            !empty($pcud_f_opts['unique_val'])
        ) {
            // query the DB to check value unicity
            $user_id_part = ($user_id) ? " AND user_id != ". (int)$user_id : '';
            
            $found = $wpdb->get_var( 
                $wpdb->prepare(
                    "SELECT COUNT(*) FROM ". PC_META_TABLE ." WHERE meta_key = '". $index ."' AND meta_value = %s ". $user_id_part ." LIMIT 1",
                    $val
                ) 
            );

            if($found) {
                $errors[] = $pcud_fields[$index]->name .' - '. __('another user already used this value', PCUD_ML);    
            }
        }
        
        
        // date range
        if(
            $pcud_f_opts['type'] == 'text' && 
            in_array($pcud_f_opts['subtype'], array('iso_date', 'eu_date', 'us_date')) &&
            isset($pcud_f_opts['date_from'])
        ) {
            if($pcud_f_opts['date_from'] && $val < $pcud_f_opts['date_from']) {  
                $errors[] = $pcud_fields[$index]->name .' - '. sprintf(esc_attr__('please use a date after %s', PCUD_ML), pc_form::iso_to_human_date($pcud_f_opts['date_from'], $pcud_f_opts['subtype']));     
            }
            elseif($pcud_f_opts['date_to'] && $val > $pcud_f_opts['date_to']) {  
                $errors[] = $pcud_fields[$index]->name .' - '. sprintf(esc_attr__('please use a date before %s', PCUD_ML), pc_form::iso_to_human_date($pcud_f_opts['date_to'], $pcud_f_opts['subtype']));     
            }
        }
        
                
        // time range
        if(
            $pcud_f_opts['type'] == 'text' && 
            in_array($pcud_f_opts['subtype'], array('12h_time', '24h_time')) &&
            isset($pcud_f_opts['time_from'])
        ) {
            if($pcud_f_opts['time_from'] && strtotime($val) < strtotime($pcud_f_opts['time_from'])) {  
                $errors[] = $pcud_fields[$index]->name .' - '. sprintf(esc_attr__('please use a time after %s', PCUD_ML), pc_form::db_to_human_time($pcud_f_opts['time_from'], $pcud_f_opts['subtype']));     
            }
            elseif($pcud_f_opts['time_to'] && strtotime($val) > strtotime($pcud_f_opts['time_to'])) {  
                $errors[] = $pcud_fields[$index]->name .' - '. sprintf(esc_attr__('please use a time before %s', PCUD_ML), pc_form::db_to_human_time($pcud_f_opts['time_to'], $pcud_f_opts['subtype']));     
            }
        }
    }
    
    return $errors;
}
add_filter('pc_form_valid_errors', 'pcud_form_valid_errors', 100, 3);





// convert dates/times into right formats before saving them into the DB
function pcud_filter_save_meta_fields($fdata, $user_id, $fields) {
    include_once(PC_DIR .'/classes/pc_form_framework.php');
    $pcud_fields = pcud_fields_static::get_fields();
    
    foreach($fdata as $f_key => $f_val) {
        if(!isset($pcud_fields[$f_key])) {
            continue;
        }
        $f_opts = $pcud_fields[$f_key]->pcud_opts;
        
        // dates
        if($f_opts['type'] == 'text' && in_array($f_opts['subtype'], array('iso_date', 'eu_date', 'us_date'))) {
            $fdata[ $f_key ] = pc_form::iso_to_human_date($f_val, $f_opts['subtype']); 
        }
           
        // times
        if($f_opts['type'] == 'text' && in_array($f_opts['subtype'], array('12h_time', '24h_time'))) {
            $fdata[ $f_key ] = pc_form::db_to_human_time($f_val, $f_opts['subtype']); 
        }
    }
    
    return $fdata;
}
add_filter('pc_save_meta_fields', 'pcud_filter_save_meta_fields', 100, 3);





// turn date validation format from us/eu to ISO to comply with HTML5 fields
function pcud_date_validator_indexes($indexes, $form_vals, $form_id, $form_taxonomy, $user_id, $class_obj) {
    $pcud_fields = pcud_fields_static::get_fields();

    foreach($indexes as $key => $data) {
        $f_index = $data['index'];
        
        if(isset($pcud_fields[$f_index]) && in_array($pcud_fields[$f_index]->pcud_opts['subtype'], array('eu_date', 'us_date'))) {
            $indexes[$key]['type'] = 'iso_date';         
        }
    }
    return $indexes;
}
add_filter('pc_form_validator_indexes', 'pcud_date_validator_indexes', 10, 6);






///////////////////////////////////////////////
// USERS LIST - show custom fields ////////////
///////////////////////////////////////////////


// table headings
function pcud_user_list_custom_fields($table_cols) {
	$pcud_fields = pcud_fields_static::get_fields();
    $to_show = get_option('pcud_fields_in_users_list', array());

	if(is_array($pcud_fields)) {
		// avoid useless queries - use stored fields
		include_once(PC_DIR .'/classes/pc_form_framework.php');
		$f_fw = new pc_form;
		$fields = $f_fw->fields;
		
		foreach($pcud_fields as $f) {
            $data = $f->pcud_opts;

            $table_cols[ $f->slug] = array(
                'name' 		=> $f->name,
                'sortable' 	=> (in_array($data['type'], array('multi_select', 'checkbox'))) ? false : true,
                'is_date'   => ($data['type'] == 'text' && in_array($data['subtype'], array('eu_date', 'us_date'))) ? true : false,
            );
		}
	}	
	  
	return $table_cols;	
}
add_filter('pc_users_list_table_fields', 'pcud_user_list_custom_fields');



// "screen option" options
function pcud_users_list_so_fields($columns) {
	$pcud_fields = pcud_fields_static::get_fields();
    
    if(is_array($pcud_fields)) {
        foreach($pcud_fields as $f) {
            $columns[ $f->slug ] = $f->name;    
        }
    }
	return $columns;	
}
add_filter('pc_users_list_so_fields', 'pcud_users_list_so_fields');





// trick integrating custom fields into users list page (screen option preference)
function pcud_pc_wp_user_ulist_columns($user_choices) {
    $pcud_fields = pcud_fields_static::get_fields();
    
    foreach($pcud_fields as $data) {

        // if user already expressed a preference about this field, skip 
        foreach($user_choices as $uc) {
            if($data->slug == $uc['id']) {
                continue;    
            }
        }
        
        $user_choices[] = array(
            'id'        => $data->slug,
            'checked'   => 0,
        ); 
    }
    
    return $user_choices;
}
add_filter('pc_wp_user_ulist_columns', 'pcud_pc_wp_user_ulist_columns');








//////////////////////////////////////////////////////////
// IMPORT PROCESS - add custom fields and try to import //
//////////////////////////////////////////////////////////

// form - wizard to add fields
function pcud_import_form($fields) {
	return array_merge($fields, pcud_fields_static::sorted_fields_indexes()); 
}
add_filter('pc_import_custom_fields', 'pcud_import_form');








////////////////////////////////////////////////////
// ADMIN USER DASHBOARD - ADD AND VALIDATE FIELDS //
////////////////////////////////////////////////////


// validation
function pcud_user_dashboard_validation($form_structure) {
    $f_indexes = pcud_fields_static::sorted_fields_indexes();
    
    // PCUD-FILTER - allow custom fields to not be printed in user dashboard. pass an array of field indexes
    $to_not_show = (array)apply_filters('pcud_ud_fields_to_hide', array(), $f_indexes);
    
    $filtered = array();
    foreach($f_indexes as $fid) {
        if(!in_array($fid, $to_not_show)) {
            $filtered[] = $fid;    
        }
    }
    
	$form_structure['include'] = array_merge($form_structure['include'], $filtered);  
	return $form_structure;
}
add_filter('pc_user_dashboard_validation', 'pcud_user_dashboard_validation');



// new dashboard tab
function pcud_user_dashboard_tabs($tabs) {
	return $tabs + array(
		'pcud' => 'User Data add-on'
	);	
}
add_filter('pc_user_dashboard_tabs', 'pcud_user_dashboard_tabs', 10);



// tab contents
function pcud_user_dashboard_tab_sections($sections, $user_id) {
	return 
	$sections + array(
		'pcud_fields' => array(
			'name'		=> '',
			'classes'	=> 'pc_ud_2_cols_form pc_ud_fullw_block',
			'callback' 	=> 'pcud_user_dashboard_fields'
		)
	);	
}
add_filter('pc_user_dashboard_pcud_tab_sections', 'pcud_user_dashboard_tab_sections', 1, 2);



// returns single field code
function pcud_user_dashboard_single_f_code($f_index, $user_data, $f_fw) {
    global $pc_meta;
    
    if(!isset($f_fw->fields[$f_index])) {
        return '';    
    }
    
    $f = $f_fw->fields[$f_index];
    $val = $user_data[$f_index];
    $f_index = esc_attr($f_index);

    
    // default value
    if(isset($f['def_choice']) && empty($val) && !isset($_GET['user'])) {
        $val = $f['def_choice'];
    }
    
    
    // specific cases
    $placeh = isset($f['placeh']) ? 'placeholder="'. esc_attr($f['placeh']) .'"' : '';


    // combo field helper
    $combo_helper = '';
    if(in_array($f['type'], array('select', 'checkbox', 'radio')) && $f['combo_link'] && isset($f_fw->fields[ $f['combo_link'] ])) {

        $combo_helper = '<span class="dashicons dashicons-admin-links pcud_ud_combo_f_helper" title="'. sprintf(esc_attr__('Combo field, showing options in relation to "%s" field', PCUD_ML), $f_fw->fields[ $f['combo_link'] ]['label']) .'" data-linked-f="'. esc_attr($f['combo_link']) .'"></span>';

        $GLOBALS['pcud_ud_combo_fields'][] = $f_index; 
    }


    // label
    $code = '
    <table class="widefat" data-f-slug="'. esc_attr($f_index) .'"><tbody><tr>
        <th>
            <span class="pcud_ud_move_field pc_move_field dashicons dashicons-move"></span>
            '. $f['label'] . 
            $combo_helper .'
        </th>
        <td>';


        //// code depending on field type
        if($f['type'] == 'text') {

            // specific text type
            switch($f['subtype']) {
                case 'email' 	: 
                    $subtype = 'email'; 
                    break;

                case 'url'		: 
                    $subtype = 'url'; 
                    break;

                case 'int' : 
                case 'float' : 	
                case 'zipcode' : 
                    $subtype = 'number'; 
                    break;

                case 'eu_date' :
                case 'us_date' :
                    $subtype = 'date'; 
                    break; 

                default : 
                    $subtype = 'text';
                    break;
            }

            // convert date format into ISO for HTML5 usage
            if(in_array($f['subtype'], array('iso_date', 'eu_date', 'us_date'))) {
                $val = pc_form::human_to_iso_date($val, $f['subtype']);       
            }
            
            // convert time format into ISO for HTML5 usage
            if(in_array($f['subtype'], array('12h_time', '24h_time'))) {
                $val = pc_form::human_to_db_time($val, $f['subtype']);       
            }

            $code .= '
            <input type="'. $subtype .'" name="'. $f_index .'" value="'. esc_attr($val) .'" maxlength="'. esc_attr($f['maxlen']) .'" '. $placeh .' autocomplete="off" />';
        }

        // textarea
        elseif($f['type'] == 'textarea') {
            $code .= '
              <textarea name="'. $f_index .'" autocomplete="off" '. $placeh .'>'. str_replace('<br />', '
            ', $val) .'</textarea>';
        }

        // select
        elseif($f['type'] == 'select') {	
            $multiple = (isset($f['multiple']) && $f['multiple']) ? 'multiple="multiple"' : '';
            $multi_name = ($multiple) ? '[]' : '';
            $placeh = (isset($f['placeh'])) ? 'data-placeholder="'. esc_attr($f['placeh']) .'"' : '';
            
            
            $code .= '
            <select name="'. esc_attr($f_index.$multi_name) .'"  class="pc_lc_select" '. $multiple .' '. $placeh .' autocomplete="off">';

                foreach((array)$f['opt'] as $f_key => $f_val) { 
                    $sel = (in_array($f_key, (array)$val)) ? 'selected="selected"' : false;
                    $code .= '<option value="'. esc_attr($f_key) .'" '. $sel .'>'. esc_html($f_val) .'</option>'; 
                }   

            $code .= '
            </select>';			
        }


        // checkbox / radio
        elseif(in_array($f['type'], array('checkbox', 'radio'))) {	
            $multiple = ($f['type'] == 'checkbox') ? 'multiple="multiple"' : '';
            $multi_name = ($multiple) ? '[]' : '';

            $code .= '
            <div class="pcud_ud_check_wrap">';

                foreach((array)$f['opt'] as $f_key => $f_val) { 
                    $sel = (in_array($f_key, (array)$val)) ? 'checked="checked"' : false;
                    $code .= '
                    <input type="'. $f['type'] .'" name="'. esc_attr($f_index.$multi_name) .'" value="'. esc_attr($f_key) .'" '. $sel .' autocomplete="off" />
                    <label>'. $f_val .'</label>';
                }   

            $code .= '
            </div>';			
        }


        // single-option checkbox
        elseif($f['type'] == 'single_checkbox') {	
            $checked = (empty($val)) ? '' : 'checked="checked"';
            $code .= '
            <input type="checkbox" name="'.$f_index.'" value="1" '.$checked.' class="lcwp_sf_check" autocomplete="off" />';
        }



    return $code .'
        </td></tr></tbody>
    </table>';
}



// code
function pcud_user_dashboard_fields($user_id = false) {
	include_once(PC_DIR .'/classes/pc_form_framework.php');
	
	global $pc_users;
	$f_fw = new pc_form;
    $GLOBALS['pcud_ud_combo_fields'] = array();
    
	$custom_f_indexes = pcud_fields_static::sorted_fields_indexes();
	if(empty($custom_f_indexes)) {
        return '';
    }
	
	// user data base array
	$ud = array();
	foreach($custom_f_indexes as $cfi) {
		$ud[$cfi] = '';	
	}
    

	// if editing - fill it
	if($user_id) {
		$ud = $pc_users->get_user($user_id, array(
			'to_get' => $custom_f_indexes
		));
	}
	$code = '';
	
    
    // PCUD-FILTER - allow custom fields to not be printed in user dashboard. pass an array of field indexes
    $to_not_show = (array)apply_filters('pcud_ud_fields_to_hide', array(), $custom_f_indexes);
    
    
    if(pc_wpuc_static::get_wp_user_editable_pc_cats() == 'any') {
        $code .= '
        <div class="pcud_ud_btns">
            <button type="button" class="button-secondary pcud_ud_add_f_sect">
                <i class="dashicons dashicons-plus-alt"></i>
                <span>'. esc_attr__('Add section', PCUD_ML) .'</span> 
            </button>
            
            <button type="button" class="button-secondary pcud_ud_arrange_f">
                <i class="dashicons dashicons-image-filter"></i>
                <span>'. esc_attr__('Arrange fields', PCUD_ML) .'</span> 
            </button>
            
            <button type="button" class="button-primary pcud_ud_save_arrang">
                <i class="dashicons dashicons-yes-alt"></i>
                <span>'. esc_attr__('Save arrangement', PCUD_ML) .'</span> 
            </button>
        </div>';    

        
    }
    
    
    // print custom arranged fields
    $arrang = (array)get_option('pcud_fields_arrang', array());
    $fields_order = (array)get_option('pcud_user_dashboard_fields_order', array());
    
    $arranged_fields_printed = array_merge(array(), $to_not_show);
    
    if(is_array($arrang)) {
        foreach($arrang as $sect_title => $a_field_slugs) {
            $a_field_slugs = array_diff($a_field_slugs, $to_not_show);
            
            $code .= '
            <div class="pc_user_dashboard_sect_wrap">
                <h3 class="pc_user_dashboard_sect_title">
                    <i class="pcud_ud_del_sect pc_del_field dashicons dashicons-no-alt"></i>
                    <i class="pcud_ud_move_sect pc_move_field dashicons dashicons-move"></i>
                    
                    <input type="text" name="pcud_ud_sect_title" value="'. esc_attr($sect_title) .'" placeholder="'. esc_attr__('fields section title', PCUD_ML) .'" maxlength="200" autocomplete="off" />
                    <span>'. esc_html($sect_title) .'</span>
                </h3>
                <div class="pcud_ud_fields_section">';

                    // strip hidden ones
                    $still_to_be_printed_in_section = $a_field_slugs;
                    for($a=0; $a < count($a_field_slugs); $a++) {
                            
                        foreach($fields_order as $f_slug) {
                            if (($key = array_search($f_slug, $a_field_slugs)) !== false) {
                                
                                $to_print = pcud_user_dashboard_single_f_code($f_slug, $ud, $f_fw);

                                if(!empty($to_print)) {
                                    $arranged_fields_printed[] = $afid;
                                    $code .= $to_print;
                                }
                                
                                unset($still_to_be_printed_in_section[$key]);
                            }
                        }
                    }
                       
                    // if there are still fields not included in $fields_order - print them
                    if(!empty($still_to_be_printed_in_section)) {
                        foreach($still_to_be_printed_in_section as $f_slug) {
                            $to_print = pcud_user_dashboard_single_f_code($f_slug, $ud, $f_fw);

                            if(!empty($to_print)) {
                                $arranged_fields_printed[] = $f_slug;
                                $code .= $to_print;
                            }        
                        }
                    }

                $code .= '
                </div>
            </div>';    
            
        }  
    }
    
    // unarranged fields (if there are fields left)
    if(count($arranged_fields_printed) < count($custom_f_indexes)) {
         
        $code .= '
        <h3 class="pc_user_dashboard_sect_title pcud_ud_unarranged_sect_title">'. __('Ungrouped Fields', PCUD_ML) .'</h3>';

        $code .= '
        <div class="pcud_ud_fields_section">';

            foreach($custom_f_indexes as $f_index) {
                if(in_array($f_index, $arranged_fields_printed) || in_array($f_index, $to_not_show)) {
                    continue;        
                }

                $code .= pcud_user_dashboard_single_f_code($f_index, $ud, $f_fw);
            }

        $code .= '
        </div>';
    }
    
    echo $code;
    ?>
    <script type="text/javascript">
    (function($) { 
        "use strict";
        
        
        const setup_sortable = function() {
            $('[data-sect-id="pcud_fields"] > div').sortable({
                handle      : ".pcud_ud_move_sect",
                items       : ".pc_user_dashboard_sect_wrap",
            }).disableSelection();
            
            $(".pcud_ud_fields_section").sortable({
                handle      : "th",
                items       : "> table",
                connectWith : ".pcud_ud_fields_section",
            }).disableSelection();
        };
        
        $(document).ready(function() {
            setup_sortable();    
        });
        
        
        
        // fields arrangement - show wizard
        $(document).on('click', '.pcud_ud_arrange_f', function() {
            $('.pc_user_dashboard_block[data-sect-id="pcud_fields"]').addClass('pcud_ud_arranging_f');        
        });
        
        // fields arrangement - add section
        $(document).on('click', '.pcud_ud_add_f_sect', function() {
            const code = `
            <div class="pc_user_dashboard_sect_wrap">
                <h3 class="pc_user_dashboard_sect_title">
                    <i class="pcud_ud_del_sect pc_del_field dashicons dashicons-no-alt"></i>
                    <i class="pcud_ud_move_sect pc_move_field dashicons dashicons-move"></i>

                    <input type="text" name="pcud_ud_sect_title" placeholder="<?php esc_attr_e('fields section title', PCUD_ML) ?>" maxlength="200" autocomplete="off" />
                    <span></span>
                </h3>
                <div class="pcud_ud_fields_section"></div>
            </div>`;
            
            $('.pcud_ud_btns').after(code);  
            setup_sortable();
        });
        
        
        
        // delete section
        $(document).on('click', '.pcud_ud_del_sect', function() {
            const $next_f_wrap = $(this).parents('h3').next('.pcud_ud_fields_section');
            
            if($next_f_wrap.find('table').length) {
                lc_wp_popup_message('error', "<?php esc_attr_e('All section fields must be reassigned to allow deletion', PCUD_ML) ?>"); 
                return false;
            }
            
            $(this).parents('h3').remove();
            $next_f_wrap.remove();
        });
        
        
        
        // save arrangement
        let saving_arrang = false;
        $(document).on('click', '.pcud_ud_save_arrang', function() {
            if(saving_arrang) {
                return false;    
            }
            const $btn = $(this);
            
            let arrang  = {},
                doubled = false,
                empty   = false;   
            
            $('#pc_ud_pcud .pc_user_dashboard_sect_title').not('.pcud_ud_unarranged_sect_title').each(function() {
                const title = $.trim( $(this).find('input[name="pcud_ud_sect_title"]').val());
                
                if(typeof(arrang[title]) !== 'undefined') {
                    doubled = true;
                    return false;    
                }
                
                arrang[ title ] = [];
                const $sect_wrap = $(this).next('.pcud_ud_fields_section');

                if(!$sect_wrap.find('> table').length) {
                    empty = true;
                    return false;
                }
                
                $sect_wrap.find('> table').each(function() {
                    arrang[ title ].push( $(this).data('f-slug') );           
                });
            });    
            
            if(doubled) {
                lc_wp_popup_message('error', "<?php esc_attr_e('There are sections having the same name', PCUD_ML) ?>"); 
                return false;
            }
            else if(empty) {
                lc_wp_popup_message('error', "<?php esc_attr_e('There are empty sections', PCUD_ML) ?>"); 
                return false;
            }
            
            
            // save
            saving_arrang = true;
            $btn.fadeTo(200, 0.7);

            var data = {
                action	: 'pcud_ud_save_f_arrang',
                arrang  : arrang,
                nonce	: '<?php echo wp_create_nonce('lcwp_ajax') ?>'
            };
            $.post(ajaxurl, data, function(response) {
                if($.trim(response) == 'success') {
                    lc_wp_popup_message('success', "<?php esc_attr_e('Arrangement successfully saved!', PCUD_ML) ?>");
                    
                    // apply section names
                    $('#pc_ud_pcud .pc_user_dashboard_sect_title').not('.pcud_ud_unarranged_sect_title').each(function() {
                        const val = $(this).find('input').val();
                        $(this).find('span').text(val);
                    });
                    
                    $('.pc_user_dashboard_block[data-sect-id="pcud_fields"]').removeClass('pcud_ud_arranging_f');     
                }
                else {
                    lc_wp_popup_message('error', response);
                }
            })
            .fail(function(e) {
                if(e.status) {
                    console.error(e);
                    lc_wp_popup_message('error', "<?php esc_attr_e('error saving fields arrangment', PCUD_ML) ?>");
                }
            })
            .always(function() {
                saving_arrang = false;
                $btn.fadeTo(200, 1);    
            });
        });
        
        
        
        
        ///////////////////////////////////////////////////
        
        
        
        // combo opts declaration
        let combo_opts = {};
        <?php 
        foreach($GLOBALS['pcud_ud_combo_fields'] as $cf) {
            $term_id = $f_fw->fields[$cf]['pcud_term_id'];
            echo 'combo_opts["'. esc_attr($cf) .'"] = JSON.parse(`'. json_encode(pcud_fields_static::get_f_opts($term_id, false, true, true)) .'`);';    
        }
        ?>

        
        
        // combo opts management
        let combo_change_tout = false; 
        $(document).on('change input', '.pcud_ud_fields_table select, .pcud_ud_check_wrap input', function(e) {
            const $this         = $(this), 
                  raw_f_index   = $(this).attr('name'),
                  linked_f_index= $(this).attr('name').replace('[]', ''); 
            
            if(combo_change_tout) {
                clearTimeout(combo_change_tout);    
            }
            combo_change_tout = setTimeout(function() {
            
                if(!$('.pcud_ud_combo_f_helper[data-linked-f="'+ linked_f_index +'"]').length) {
                    return true;    
                }
                let f_val = [];

                // get linked field value
                if($(e.target).is('select')) {
                    ($this.hasAttribute('multiple')) ? f_val = $this.val() : f_val.push( $this.val());    
                }
                else {
                    $this.parents('.pcud_ud_check_wrap').find('input[type="checkbox"]').each(function() {
                        if(this.checked) {
                            f_val.push( $(this).attr('value') );        
                        }
                    });
                }

                // compose new field options
                $('.pcud_ud_combo_f_helper[data-linked-f="'+ linked_f_index +'"]').each(function() {
                    const $f_block  = $(this).parents('table').first(), 
                          $f_wrap   = $f_block.find('td'),
                          f_slug    = $f_block.data('f-slug');

                    let opts = {},
                        code = '';
                    
                    $.each(f_val, function(i, val) {
                        if(typeof(combo_opts[ f_slug ][ val ]) != 'undefined') {
                            opts = { ...combo_opts[ f_slug ][ val ], ...opts }; 
                        }         
                    });

                    // apply options
                    // select
                    if($f_wrap.find('select').length) {
                        $.each(opts, function(i, v) {
                            code += '<option value="'+ esc_str_for_attr(i) +'">'+ esc_str_for_attr(v) +'</option>';    
                        });
                        
                        $f_wrap.find('select').html(code);
                        
                        const resyncEvent = new Event('lc-select-refresh');
                        $f_wrap.find('select')[0].dispatchEvent(resyncEvent);
                    }
                    
                    // checkboxes
                    else {
                        const type = ($f_wrap.find('input[type="radio"]').length) ? 'radio' : 'checkbox';
                        
                        $.each(opts, function(i, v) {
                            code += 
                                '<input type="'+ type +'" name="'+ f_slug +'[]" value="'+ esc_str_for_attr(i) +'" autocomplete="off" />' +
                                '<label class="pc_check_label">'+ v +'</label>';
                        });
                        
                        $f_wrap.find('.pcud_ud_check_wrap').html(code);
                    }
                });
            }, 20);
        });
        
        
        
        // escape option value, returning an attribute-safe string 
        const esc_str_for_attr = function(str) {
            return $.trim(str
            .replace(/&/g, '&amp;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;')
            .replace(/"/g, '&quot;')
            .replace(/'/g, '&#039;'));  
        };
        
        
    })(jQuery); 
    </script>
    <?php
}






////////////////////////////////////////////////////
// ADMIN USER DASHBOARD - FORCE PSW RESET BOX //////
////////////////////////////////////////////////////


// tab contents
function pcud_ud_force_psw_reset($sections, $user_id) {
	if(!$user_id)  {
		return $sections;	
	}
	
	return 
	$sections + array(
		'pcud_fpr' => array(
			'name'		=> 'User Data add-on - '. __('Forced Password Reset', PCUD_ML),
			'classes'	=> '',
			'callback' 	=> 'pcud_ud_force_psw_reset_cb'
		)
	);	
}
add_filter('pc_user_dashboard_main_tab_sections', 'pcud_ud_force_psw_reset', 30, 2);



// code
function pcud_ud_force_psw_reset_cb($user_id) {
	global $pc_meta;
	$fpr_key = $pc_meta->get_meta($user_id, 'pcud_forced_psw_reset');
	
	$ok_vis  = (empty($fpr_key)) ? '' : 'pc_displaynone';
	$req_vis = (empty($fpr_key)) ? 'pc_displaynone' : '';
	
	?>
	<div id="pcud_fpr_ok" class="pc_warn pc_wps_warn pc_success <?php echo $ok_vis ?>">
		<?php _e('Password status ok', PCUD_ML) ?>
        <button class="button-secondary pcud_fpr_change_status"><?php _e('Change Status', PCUD_ML) ?></button>
	</div>     
	
	<div id="pcud_fpr_required" class="pc_warn pc_wps_warn pc_warning <?php echo $req_vis ?>">
		<?php _e('Password reset required', PCUD_ML) ?>
        <button class="button-secondary pcud_fpr_change_status"><?php _e('Change Status', PCUD_ML) ?></button>
	</div>     

	<script type="text/javascript">
    (function($) { 
        "use strict";
        
        let pcud_fpr_acting = false;

        $(document).on('click', '.pcud_fpr_change_status', function(e) {		
            e.preventDefault();
            if(pcud_fpr_acting) {
                return false;
            }

            pcud_fpr_acting = true;
            var $btn = $(this);
            $btn.fadeTo(200, 0.7);

            var cmd = ($(this).parents('#pcud_fpr_required').length) ? 'unset' : 'set';

            var data = {
                action		: 'pcud_fpr_in_edit_user',
                pc_cmd		: cmd,
                pc_user_id	: <?php echo $user_id; ?>,
                pc_nonce	: '<?php echo wp_create_nonce('lcwp_ajax') ?>'
            };
            $.post(ajaxurl, data, function(response) {
                if($.trim(response) == 'success') {
                    if(cmd == 'set') {
                        $('#pcud_fpr_ok').hide();
                        $('#pcud_fpr_required').show();
                    } else {
                        $('#pcud_fpr_ok').show();
                        $('#pcud_fpr_required').hide();	
                    }
                }
                else {
                    lc_wp_popup_message('error', response);
                }
            })
            .fail(function(e) {
                if(e.status) {
                    console.error(e);
                    lc_wp_popup_message('error', "<?php esc_attr_e('error changing status', PCUD_ML) ?>");
                }
            })
            .always(function() {
                pcud_fpr_acting = false;
                $btn.fadeTo(200, 1);    
            });
        });

    })(jQuery); 
	</script>
	<?php
}
