<?php
// INTEGRATES WITH PC MENU 

add_action('pc_addons_menu_ready', 'pcud_in_pc_menu', 40);

function pcud_in_pc_menu($slug) {
    if(pc_wpuc_static::get_wp_user_editable_pc_cats() != 'any') {
        return false;
    }
    
    // get first user role to be used in add_menu_page()
    $curr_user = wp_get_current_user();
    $first_user_role = (count((array)$curr_user->roles)) ? reset($curr_user->roles) : false;
    
	add_submenu_page($slug, esc_html__('Custom Fields Builder', PCUD_ML), esc_html__('Custom Fields Builder', PCUD_ML), $first_user_role, 'pcud_fields_builder', 'pcud_cust_fields_builder');	
	add_submenu_page($slug, esc_html__('Forms Builder', PCUD_ML), esc_html__('Forms Builder', PCUD_ML), $first_user_role, 'pcud_forms_builder', 'pcud_forms_builder');
}


function pcud_cust_fields_builder() {
    include_once(PCUD_DIR . '/cust_fields_builder.php');
}

function pcud_forms_builder() {
    include_once(PCUD_DIR . '/forms_builder.php');
}


