<?php

// user fields array builder for VC
function pcud_cs_fl_array($use_cat = false) {
	include_once(PC_DIR .'/classes/pc_form_framework.php');

	pcud_cpt_n_ct();
	$f_fw = new pc_form;
	
	$arr = array();
	foreach($f_fw->fields as $field_id => $data) {
		if($field_id == 'username' || !in_array($field_id, pcud_static::wizards_ignore_fields($use_cat))) {
			$arr[] = array(
				'value' => $field_id,
				'label' => $data['label']
			);
			
		}
	}
	
	return $arr;
}



			

add_action('cornerstone_register_elements', 'pcud_cornerstone_register_elements');
add_filter('cornerstone_icon_map', 'pcud_cornerstone_icon_map', 900);


function pcud_cornerstone_register_elements() {
	pcud_cpt_n_ct(); // be sure tax are registered
	
	cornerstone_register_element('lcweb_pcud_user_data',	'lcweb_pcud_user_data', 	PCUD_DIR .'/builders_integration/cs_elements/user_data');
	cornerstone_register_element('lcweb_pcud_cust_form', 	'lcweb_pcud_cust_form', 	PCUD_DIR .'/builders_integration/cs_elements/cust_form');
	cornerstone_register_element('lcweb_pcud_cond_block', 	'lcweb_pcud_cond_block', 	PCUD_DIR .'/builders_integration/cs_elements/cond_block');
}


function pcud_cornerstone_icon_map( $icon_map ) {
	$icon_map['lcweb_pcud_user_data'] 	= PCUD_URL .'/img/cs_icon.svg';
	$icon_map['lcweb_pcud_cust_form'] 	= PCUD_URL .'/img/cs_icon.svg';
	$icon_map['lcweb_pcud_cond_block'] 	= PCUD_URL .'/img/cs_icon.svg';
	
	return $icon_map;
}
