<?php
// INITIALIZE DIVI MODULES

class pcud_divi_modules {

    // DEEFINE MODULES
    // module slug => php files slug
    private $modules = array(
        'pcud_form'         => 'pcud_form',
        'pcud_data'         => 'user_data',
        'pcud_cond_block'   => 'cond_block', 
    );
    
    
    
    /* 
     * static method to render elements from both builder and frontend 
     *
     * @param (string) $module_slug
     * @param (array) $vals = values passed by the builder
     */
    public static function front_shortcode_render($module_slug, $vals) {
        switch($module_slug) {
           
            case 'pcud_form' :
                $shortcode = '[pcud-form '. self::vals_to_sc_params($module_slug, $vals) .']';
                break;
                
                
            case 'pcud_data' :
                $shortcode = '[pcud-user-data '. self::vals_to_sc_params($module_slug, $vals) .']';
                break;    
            
                
            case 'pcud_cond_block' :
                $contents = $vals['cond_block_txt'];
                unset($vals['cond_block_txt']);
                
                $shortcode = '[pcud-cond-block '. self::vals_to_sc_params($module_slug, $vals) .']'. $contents .'[/pcud-cond-block]';
                break;      
            
                
            default :
                return $module_slug .' module not found';  
        }    
        
        //echo $shortcode;
        return do_shortcode($shortcode);
    }
    
    
    
    /* insert here custom actions upon initialization (eg. to create global variable containing galleries array) */
    private function custom_actions() {
        //$GLOBALS['pc_divi_icon_path'] = PC_DIR .'/builders_integration/divi_modules/icon.svg';

    }
    
    
    
    

    ####################################################################################################
    ## Common methods
    
    
    function __construct() {
        // initialize modules
        add_action('divi_extensions_init', array($this, 'init_modules'));
        
        // ajax handlers
        foreach($this->modules as $key => $name) {
            add_action('wp_ajax_'. $key .'_for_divi', array($this, 'ajax_handler'));
        }
    }
    
    
    /* include divi integration files */
    public function init_modules() {   
        $this->custom_actions();
        
        foreach($this->modules as $module) {
            include_once(__DIR__ .'/divi_modules/'. $module .'/includes/register.php');
        }  
    } 
    
    
    
    public function ajax_handler() {
        if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
            wp_die('Cheating?');
        };
        
        if(!isset($_POST['module'])) {
            die('module not found');    
        }
        
        echo self::front_shortcode_render($_POST['module'], $_POST['params']);
        die();
    }
    
    
    
    /* 
     * Static method compiling shortcode attributes from values array. Also strips out useless Divi values 
     * @param (array) $exception_indexes = array of extra indexes to save (eg. width and height) 
     */
    private static function vals_to_sc_params($module_slug, $vals, $exception_indexes = array()) {
       
        // strip useless parameters
        if(isset($GLOBALS[$module_slug .'_divi_field_indexes'])) {
            foreach($vals as $key => $val) {
                if(!in_array($key, $GLOBALS[$module_slug .'_divi_field_indexes']) && !in_array($key, (array)$exception_indexes)) {
                    unset($vals[$key]);    
                }
            }
        }
        
        // atts string creator
        $params = '';
        foreach($vals as $key => $val) {
            if($val === 'on' || $val === __('Yes')) {
                $val = 1;
            }
            elseif($val === 'off' || $val === __('No')) {
                $val = 0;
            }
            elseif($val === 'unset') {
                $val = '';
            }

            $params .= $key.'="'. esc_attr((string)$val) .'" ';
        }    
        
        return $params;
    }
}
new pcud_divi_modules();



