<?php
// DEFINING MODULE STRUCTURE AND FIELDS


class pcud_cond_block_divi_module extends ET_Builder_Module {

	public $slug       = 'pcud_cond_block';
	public $vb_support = 'on';
    public $ml_key     = PCUD_ML;
    
    
	protected $module_credits = array(
        'module_uri' => 'https://lcweb.it/privatecontent/user-data-add-on',
        'author'     => 'LCweb',
        'author_uri' => 'https://lcweb.it/',
	);

    
    public function get_advanced_fields_config() {
        return unserialize(LC_DIVI_DEF_OPTS_OVERRIDE);
	}

    
	public function init() {
		$this->name               = 'PCUD - '. esc_html__('Conditional Block', $this->ml_key);
		$this->icon_path          =  $GLOBALS['pc_divi_icon_path'];
		$this->main_css_element   = '%%order_class%%';	
        
        $this->settings_modal_toggles  = array(
			'general'  => array(
				'toggles' => array(
					'main'     => esc_html__('Main Options', $this->ml_key),
					'styling'  => esc_html__('Styling', $this->ml_key),
				),
			),
		);
	}
 
    
    
    
    // user categories array builder
	protected function pc_uc_array($bulk_opts = true, $apply_filter = true) {

		// fix for PCPP
		if(function_exists('pcpp_is_integrated_flag')) {
			pcpp_is_integrated_flag();	
		}
		
		
		$raw = pc_static::restr_opts_arr($bulk_opts, $apply_filter);
		
		$arr = array();
		foreach($raw as $block) {
			foreach($block['opts'] as $id => $name) {
				$arr[$id] = $name;	
			}
		}
		return $arr;
	}
    
    
    
	public function get_fields() {
        
        // get user fields
		include_once(PC_DIR .'/classes/pc_form_framework.php');

		pcud_cpt_n_ct();
		$f_fw = new pc_form;
		
		$user_fields = array( __('Choose a field ..', PCUD_ML) => ' ');
		foreach($f_fw->fields as $field_id => $data) {
			if($field_id == 'username' || !in_array($field_id, pcud_static::wizards_ignore_fields(false))) {
				$user_fields[ $field_id ] = $data['label'];
			}
		}
        
        
        
        $conds = array(
            '=' 	=> __('is equal to', PCUD_ML),
            '!='	=> __('is different from', PCUD_ML),
            'big'	=> __('is greater than', PCUD_ML),
            'small'	=> __('is lower than', PCUD_ML),
            'like'	=> __('contains', PCUD_ML)
        );
        
		
		//////////////////////
        
        
        $fields =array(
            'f' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('User data to display', $this->ml_key),
				'type'            => 'select',
				'default'         => current(array_keys($user_fields)),
				'default_on_front'=> current(array_keys($user_fields)),					
				'options'         => $user_fields
			),
            'cond' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Condition', $this->ml_key),
				'type'            => 'select',
				'default'         => current(array_keys($conds)),
				'default_on_front'=> current(array_keys($conds)),					
				'options'         => $conds
			),
            'val' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Matching value', $this->ml_key),
				'type'            => 'text',
                'default'         => '',
				'default_on_front'=> '',
                //'description'     => esc_html__('Message shown if "warning" option is enabled', $this->ml_key),
			),
            'cond_block_txt' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Content', $this->ml_key),
				'type'            => 'textarea',
                'default'         => '',
				'default_on_front'=> '',
                //'description'     => esc_html__('Remember you can use placeholders and FontAwesome icons as explained in settings', GG_ML),
			),
		);
        
        
        $GLOBALS[ $this->slug .'_divi_field_indexes'] = array_keys($fields);
        return $fields;
	}


    
    public function render($attrs, $content = null, $render_slug = null) {
        return pcud_divi_modules::front_shortcode_render($this->slug, $this->props);  
	}
}

new pcud_cond_block_divi_module;

