<?php
// DEFINING MODULE STRUCTURE AND FIELDS


class pcud_form_divi_module extends ET_Builder_Module {

	public $slug       = 'pcud_form';
	public $vb_support = 'on';
    public $ml_key     = PCUD_ML;
    
    
	protected $module_credits = array(
        'module_uri' => 'https://lcweb.it/privatecontent/user-data-add-on',
        'author'     => 'LCweb',
        'author_uri' => 'https://lcweb.it/',
	);

    
    public function get_advanced_fields_config() {
        return unserialize(LC_DIVI_DEF_OPTS_OVERRIDE);
	}

    
	public function init() {
		$this->name               = 'PCUD - '. esc_html__('Data-update Form', $this->ml_key);
		$this->icon_path          =  $GLOBALS['pc_divi_icon_path'];
		$this->main_css_element   = '%%order_class%%';	
        
        $this->settings_modal_toggles  = array(
			'general'  => array(
				'toggles' => array(
					'main'     => esc_html__('Main Options', $this->ml_key),
                    'styling'  => esc_html__('Styling', $this->ml_key),
				),
			),
		);
	}
 
    
	public function get_fields() {
        
        // get forms	
		$forms_arr = array();
		$forms = get_terms('pcud_forms', 'hide_empty=0');
		
		foreach($forms as $form) {
			$forms_arr[ $form->term_id ] = $form->name;	
		}
        
        
        
        $fields =array(
            'form' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Which form to use?', $this->ml_key),
				'type'            => 'select',
				'default'         => current(array_keys($forms_arr)),
				'default_on_front'=> current(array_keys($forms_arr)),					
				'options'         => $forms_arr
			),
            'layout' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Layout', $this->ml_key),
				'type'            => 'select',
				'default'         => '',
				'default_on_front'=> '',					
				'options'         => array(
                    '' 			=> __('Default one', $this->ml_key),
                    'one_col'	=> __('Single column', $this->ml_key),
                    'fluid'		=> __('Fluid (multi column)', $this->ml_key),
			    )
			),
            'align' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Alignment', $this->ml_key),
				'type'            => 'select',
				'default'         => 'center',
				'default_on_front'=> 'center',					
				'options'         => $GLOBALS['pc_divi_forms_align']
			),
		);
        
        
        $GLOBALS[ $this->slug .'_divi_field_indexes'] = array_keys($fields);
        return $fields;
	}


    
    public function render($attrs, $content = null, $render_slug = null) {
        return pcud_divi_modules::front_shortcode_render($this->slug, $this->props);  
	}
}

new pcud_form_divi_module;
