<?php
// DEFINING MODULE STRUCTURE AND FIELDS


class pcud_data_divi_module extends ET_Builder_Module {

	public $slug       = 'pcud_data';
	public $vb_support = 'off';
    public $ml_key     = PCUD_ML;
    
    
	protected $module_credits = array(
        'module_uri' => 'https://lcweb.it/privatecontent/user-data-add-on',
        'author'     => 'LCweb',
        'author_uri' => 'https://lcweb.it/',
	);

    
    public function get_advanced_fields_config() {
        return unserialize(LC_DIVI_DEF_OPTS_OVERRIDE);
	}

    
	public function init() {
		$this->name               = 'PCUD - '. esc_html__('User Data', $this->ml_key);
		$this->icon_path          =  $GLOBALS['pc_divi_icon_path'];
		$this->main_css_element   = '%%order_class%%';	
           
        $this->settings_modal_toggles  = array(
			'general'  => array(
				'toggles' => array(
					'main'     => esc_html__('Main Options', $this->ml_key),
                    'styling'  => esc_html__('Styling', $this->ml_key),
				),
			),
		);
	}
 
    
	public function get_fields() {
        
        // get user fields
		include_once(PC_DIR .'/classes/pc_form_framework.php');

		pcud_cpt_n_ct();
		$f_fw = new pc_form;
		
		$user_fields = array( __('Choose a field ..', PCUD_ML) => ' ');
		foreach($f_fw->fields as $field_id => $data) {
			if($field_id == 'username' || !in_array($field_id, pcud_static::wizards_ignore_fields(true))) {
				$user_fields[ $field_id ] = $data['label'];
			}
		}

		
		//////////////////////
        
        
        $fields =array(
            'f' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('User data to display', $this->ml_key),
				'type'            => 'select',
				'default'         => current(array_keys($user_fields)),
				'default_on_front'=> current(array_keys($user_fields)),					
				'options'         => $user_fields
			),
		);
        
        
        $GLOBALS[ $this->slug .'_divi_field_indexes'] = array_keys($fields);
        return $fields;
	}


    
    public function render($attrs, $content = null, $render_slug = null) {
        return pcud_divi_modules::front_shortcode_render($this->slug, $this->props);  
	}
}

new pcud_data_divi_module;
