<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class pcud_cond_block_on_elementor extends Widget_Base {
	
	 public function get_icon() {
      return 'emtr_lcweb_icon';
   }
	
	public function get_name() {
		return 'pcud-cond-block';
	}

	public function get_categories() {
		return array('privatecontent');
	}

   public function get_title() {
      return 'PCUD - '. __('Conditional Block', PCUD_ML);
   }




	protected function register_controls() {

		// get user fields
		include_once(PC_DIR .'/classes/pc_form_framework.php');

		pcud_cpt_n_ct();
		$f_fw = new pc_form;
		
		$user_fields = array(' ' => __('Choose a field ..', PCUD_ML));
		foreach($f_fw->fields as $field_id => $data) {
			if($field_id == 'username' || !in_array($field_id, pcud_static::wizards_ignore_fields(false))) {
				$user_fields[ $field_id ] = $data['label'];
			}
		}

		
		//////////////////////


		$this->start_controls_section(
			'main',
			array(
				'label' => __('Main Parameters', PCUD_ML),
			)
		);
   
		$this->add_control(
		   'f',
		   array(
			  'label' 	=> __('User data to display', PCUD_ML),
			  'type' 	=> \Elementor\Controls_Manager::SELECT2,
			  'default' => current(array_keys( $user_fields )),
			  'options' => $user_fields
		   )
		);
		
		$this->add_control(
		   'cond',
		   array(
			  'label' 		=> __('Define condition', PCUD_ML),
			  'type' 	=> Controls_Manager::SELECT,
			  'default' => '=',
			  'options' => array(
			  	'=' 	=> __('is equal to', PCUD_ML),
				'!='	=> __('is different from', PCUD_ML),
				'big'	=> __('is greater than', PCUD_ML),
				'small'	=> __('is lower than', PCUD_ML),
				'like'	=> __('contains', PCUD_ML)
			  )
		   )
		);
		
		$this->add_control(
		   'val',
		   array(
			  	'label' => __('Matching value', PCUD_ML),
				'type' 	=> Controls_Manager::TEXT,
		   )
		);
		
		$this->add_control(
		   'contents',
		   array(
			  	'label' => __("Contents to hide", PCUD_ML),
				'type' => Controls_Manager::WYSIWYG,
		   )
		);
		
		
		$this->end_controls_section();
   }


	
	////////////////////////


	protected function render() {
     	$vals = $this->get_settings();
		//var_dump($vals);

		$parts = array('f', 'cond', 'val');
		$params = '';
		
		foreach($parts as $part) {
			$params .= $part.'="';

			if(!isset($vals[$part])) {$vals[$part] = '';}
			$params .= $vals[$part].'" ';	
		}
		
        
        echo (!isset($GLOBALS['pc_user_id']) && $GLOBALS['lcwp_is_elementor_builder']) ? 
            '[PrivateContent User Data add-on '. __('conditional block - login to see it', PCUD_ML) .']' : 
            do_shortcode('[pcud-cond-block '. $params .']'. trim($vals['contents']) .'[/pcud-cond-block]');
	}
}
