<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class pcud_form_on_elementor extends Widget_Base {
	
	 public function get_icon() {
      return 'emtr_lcweb_icon';
   }
	
	public function get_name() {
		return 'pcud-form';
	}

	public function get_categories() {
		return array('privatecontent');
	}

   public function get_title() {
      return 'PCUD - '. __('Data-update Form', PCUD_ML);
   }



   protected function register_controls() {
			
		// get forms	
		$forms_arr = array();
		$forms = get_terms('pcud_forms', 'hide_empty=0');
		
		foreach($forms as $form) {
			$forms_arr[ $form->term_id ] = $form->name;	
		}	
		
		
		//////////////////////
			
			
		$this->start_controls_section(
			'main',
			array(
				'label' => __('Main Parameters', PCUD_ML),
			)
		);
  
		$this->add_control(
		   'form',
		   array(
			  'label' 	=> __('Which form?', PCUD_ML),
			  'type' 	=> \Elementor\Controls_Manager::SELECT2,
			  'default' => current(array_keys( $forms_arr )),
			  'options' => $forms_arr
		   )
		);
		
		$this->add_control(
		   'layout',
		   array(
			  'label' 	=> __('Layout', PCUD_ML),
			  'type' 	=> Controls_Manager::SELECT,
			  'default' => '',
			  'options' => array(
			  	'' 			=> __('Default one', PCUD_ML),
				'one_col' 	=> __('Single column', PCUD_ML),
				'fluid'		=> __('Fluid (multi column)', PCUD_ML),
			  )
		   )
		);
		
		$this->add_control(
		   'align',
		   array(
			  'label' 	=> __('Alignment', PCUD_ML),
			  'type' 	=> Controls_Manager::SELECT,
			  'default' => 'center',
			  'options' => array(
			  	'center' 	=> __('Center', PCUD_ML),
				'left'		=> __('Left', PCUD_ML),
				'right'		=> __('Right', PCUD_ML),
			  )
		   )
		);
			
		$this->end_controls_section();
   }


	
	////////////////////////



	protected function render() {
     	$vals = $this->get_settings();
		//var_dump($vals);

		$parts = array('form', 'layout', 'align');
		$params = '';
		
		foreach($parts as $part) {
			$params .= $part.'="';
			
			if(!isset($vals[$part])) {$vals[$part] = '';}
			$params .= $vals[$part].'" ';	
		}
		
        
        echo (!isset($GLOBALS['pc_user_id']) && $GLOBALS['lcwp_is_elementor_builder']) ? 
            '[PrivateContent '. __('data-update form - login to see it', PCUD_ML) .']' : 
            do_shortcode('[pcud-form '. $params .']');
	}
}
