<?php
// REGISTER BLOCK



// reg forms
$cf = array();
foreach(get_terms('pcud_forms', 'hide_empty=0&orderby=name&order=ASC') as $term) {
	$cf[ $term->term_id ] = $term->name;
}




// structure
$defaults = array(
	'pcud_form' => array(
		'label'		=> __('Which form?', PC_ML),
		'type'		=> 'select',
		'opts'		=> $cf,
		'default' 	=> current(array_keys($cf)),
		'panel'		=> 'main',
	),
	'layout' => array(
		'label'		=> __('Layout', PC_ML),
		'type'		=> 'select',
		'opts'		=> array(
			''			=> __('Default one', PC_ML),
			'one_col'	=> __('Single column', PC_ML),
			'fluid'		=> __('Fluid (multi column)', PC_ML),
		),
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'pc_align' => array(
		'label'		=> __('Form alignment', PC_ML),
		'type'		=> 'select',
		'opts'		=> array(
			'center'	=> __('Center', PC_ML),
			'left'		=> __('Left', PC_ML),
			'right'		=> __('Right', PC_ML),
		),
		'default' 	=> 'center',
		'panel'		=> 'main',
	),
);




$defaults = pc_fix_block_defs($defaults);

register_block_type('lcweb/pcud-form', array(
	'editor_script' 	=> 'pcud_form_on_guten',
	'render_callback' 	=> 'pcud_form_guten_handler',
	'attributes' 		=> $defaults
));


wp_localize_script('wp-blocks', 'pcud_form_defaults', $defaults);
