<?php
// INITIALIZE GUTEN BLOCKS AND DEFINE HANDLERS




// register blocks
function pcud_guten_register() {
	if(!function_exists('register_block_type')) {
        return;
    }
    
    //////// not for WP 5.8 widgets.. for now
    if($_SERVER["REQUEST_URI"] == '/wp-admin/widgets.php') {
        return;
    }
    ////////
	
	$shortcodes = array(
		'pcud-form'	=> 'cust_form/cust_form',
	);

	foreach($shortcodes as $ch) {
		include_once(PCUD_DIR .'/builders_integration/guten_elements/'. $ch .'.php');	
	}
}
add_action('init', 'pcud_guten_register');






// enqueue scripts in gutenberg 
function pcud_guten_scripts() {
	global $current_screen;

    //////// not for WP 5.8 widgets.. for now
    if($_SERVER["REQUEST_URI"] == '/wp-admin/widgets.php') {
        return;
    }
    ////////
    
    $deps = array(
        'wp-blocks',
        'wp-i18n',
        'wp-element',
    );  
    if($current_screen->base != 'widgets') {
        $deps[] = 'wp-editor';     
    }
    
    $shortcodes = array(
		'pcud-form'	=> 'cust_form/cust_form',
	);
	
	foreach($shortcodes as $key => $script_name) {
		wp_enqueue_script(
			'lcweb/'. $key,
			PCUD_URL .'/builders_integration/guten_elements/'. $script_name .'.js',
			$deps,
			PCUD_VER, 
			true
		);
	}
}
add_action('enqueue_block_editor_assets', 'pcud_guten_scripts');






function pcud_form_guten_handler($atts) {
	$code = pc_guten_handler_common();
	return $code . do_shortcode('[pcud-form '. pc_guten_atts_compile($atts) .']');
}