<?php
//  visual composer integration


// user fields array builder for VC
function pcud_vc_fl_array($use_cat = false) {
	include_once(PC_DIR .'/classes/pc_form_framework.php');

	pcud_cpt_n_ct();
	$f_fw = new pc_form;
	
	$arr = array( __('Choose a field ..', PCUD_ML) => ' ');
	foreach($f_fw->fields as $field_id => $data) {
		if($field_id == 'username' || !in_array($field_id, pcud_static::wizards_ignore_fields($use_cat))) {
			$arr[ $data['label'] ] = $field_id;
		}
	}
	
	return $arr;
}



function pcud_on_visual_composer() {
    pcud_cpt_n_ct(); // be sure tax are registered
	
	
	#########################################
	######## USER DATA ######################
	#########################################
	
	// parameters
	$params = array(
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> __('User data to display', PCUD_ML),
			'param_name' 	=> 'f',
			'admin_label' 	=> true,
			'value' 		=> pcud_vc_fl_array(true),
		),
	);
	
	// compile
	vc_map(
        array(
            'name' 			=> 'PCUD - '. __('User Data', PC_ML),
			'description'	=> __("Displays PrivateContent user data", PCUD_ML),
            'base' 			=> 'pcud-user-data',
            'category' 		=> "PrivateContent",
			'icon'			=> PCUD_URL .'/img/vc_icon.png',
            'params' 		=> $params,
        )
    );
	
	
	
	
	
	#########################################
	####### DATA-UPDAATE FORM ###############
	#########################################
	
	$form_arr = array();
	$forms = get_terms('pcud_forms', 'hide_empty=0');
	
	foreach($forms as $form) {
		$form_arr[ $form->name ] = $form->term_id;	
	}
	
	// parameters
	$params = array(
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> __('Form to use', PCUD_ML),
			'param_name' 	=> 'form',
			'admin_label' 	=> true,
			'value' 		=> $form_arr,
		),
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> __('Layout', PCUD_ML),
			'param_name' 	=> 'layout',
			'admin_label' 	=> true,
			'value' 		=> array(
				__('Default one', PCUD_ML) => '',
				__('Single column', PCUD_ML) => 'one_col',
				__('Fluid (multi column)', PCUD_ML) => 'fluid',
			),
		),
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> __('Alignment', PCUD_ML),
			'param_name' 	=> 'align',
			'admin_label' 	=> true,
			'value' 		=> array(
				__('Center', PCUD_ML) 	=> 'center',
				__('Left', PCUD_ML) 	=> 'left',
				__('Right', PCUD_ML) 	=> 'right',
			),
		),
	);
		
	// compile
	vc_map(
        array(
            'name' 			=> 'PCUD - '. __('Data-update Form', PCUD_ML),
			'description'	=> __("Displays User Data add-on form to update user's data", PCUD_ML),
            'base' 			=> 'pcud-form',
            'category' 		=> "PrivateContent",
			'icon'			=> PCUD_URL .'/img/vc_icon.png',
			'admin_enqueue_css'	 => PCUD_URL .'/css/vc_fix.css',
            'params' 		=> $params,
        )
    );
	
	
	

	#########################################
	####### CONDITIONAL BLOCK ###############
	#########################################
	
	// parameters
	$params = array(
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> __('Field to match', PCUD_ML),
			'param_name' 	=> 'f',
			'admin_label' 	=> true,
			'value' 		=> pcud_vc_fl_array(),
		),
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> __('Define condition', PCUD_ML),
			'param_name' 	=> 'cond',
			'admin_label' 	=> true,
			'value' 		=> array(
				__('is equal to', PCUD_ML) 		=> '=',
				__('is different from', PCUD_ML)	=> '!=',
				__('is greater than', PCUD_ML)	=> 'big',
				__('is lower than', PCUD_ML)		=> 'small',
				__('contains', PCUD_ML)			=> 'like'
			),
		),
		array(
			'type' 			=> 'textfield',
			'heading' 		=> __('Matching value', PCUD_ML),
			'param_name' 	=> 'val',
			'value' 		=> '',
		),
		
		 array(
            "type" => "textarea_html",
            "holder" => "div",
            "heading" => __("Contents", "pc_ml"),
            "param_name" => "content",
            "value" => '',
            "description" => __("Protected content", "pc_ml")
         )
	);
  
	// compile
	vc_map(
        array(
           	'name' 			=> 'PCUD - '. __('Conditional Block', PCUD_ML),
			'description'	=> __("Restrict contents basing on conditional matching", PC_ML),
            'base' 			=> 'pcud-cond-block',
            'category' 		=> "PrivateContent",
			'icon'			=> PCUD_URL .'/img/vc_icon.png',
			'admin_enqueue_css'	 => PCUD_URL .'/css/vc_fix.css',
            'params' 		=> $params,
        )
    );

}
add_action('vc_before_init', 'pcud_on_visual_composer');


