<?php
// TOOLSET TO MANAGE FORCED USER PASSWORD

class pcud_forced_psw_reset {
	
	private $meta_key = 'pcud_forced_psw_reset';
	private $user_id;
	
	
	public function __construct($user_id) {
		$this->user_id = $user_id;	
		
		// admin side
		if(is_admin()) {	
			add_action('wp_ajax_pcud_fpr_in_edit_user', array($this, 'edit_user_ajax'));
			
			add_action('pc_import_form', 	array($this, 'import_form_field'), 1);	
			add_action('pc_imported_users', array($this, 'affect_imported_users'));	
		}
		
		// front side
		else {
            add_action('wp_enqueue_scripts', array($this, 'maybe_enqueue_lb'));
			add_action('wp_footer', array($this, 'frontend_lb'), 9999);	
			add_action('pvtcont_init', array($this, 'frontend_lb_ajax'), 30);
		}
		
		
		// Mail Actions add-on - wheter to force reset on password recovery
		add_action('pcma_resetted_psw', array($this, 'fpr_on_pcma_resetted_psw'));
	}
	
	
	
	//////////////////////////////////////////////////////
	
	
	
	/* "Edit User" - ajax handler */
	public function edit_user_ajax() {
		if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
            die('Cheating?');
        };
		global $pc_meta;
	
		$user_id = trim(addslashes($_POST['pc_user_id'])); 
		if (!filter_var($user_id, FILTER_VALIDATE_INT)) {
            die('User ID Missing');
        }
		
		$cmd = trim($_POST['pc_cmd']); 
		if (!in_array($cmd, array('set', 'unset'))) {
            die('Missing Command');
        }
		
		
		if($cmd == 'set') {
			$key = wp_generate_password(8, false); 
			$pc_meta->update_meta($user_id, $this->meta_key, $key);
		} 
		else {
			$pc_meta->delete_meta($user_id, $this->meta_key);	
		}	
		
		die('success');
	}
	
	
	
	
	
	/* Import user - field */
	public function import_form_field() {
		?>
        <tr>
            <td class="pc_label_td">
				<?php _e("Force password reset?", PCUD_ML); ?>
            </td>
            <td class="pc_field_td">
				<?php $checked = (isset($_POST['pcud_forced_psw_reset']) && $_POST['pcud_forced_psw_reset']) ? 'checked="checked"' : ''; ?>
                <input type="checkbox" name="pcud_forced_psw_reset" value="1" <?php echo $checked; ?> class="pc_lc_switch" />
            </td>
            <td>
            	<span class="info"><?php _e("If checked, imported users will be forced to reset their passwords to access contents", PCUD_ML); ?></span>
        	</td>
        </tr>
        <?php	
	}
	
	/* Import user - perform forcing */
	public function affect_imported_users($imported_list) {
		global $pc_meta;
		
		if(!isset($_POST['pcud_forced_psw_reset']) || !$_POST['pcud_forced_psw_reset']) {
			return false;	
		}
		
		foreach($imported_list as $user_id => $arr_data) {
			$key = wp_generate_password(8, false); 
			$pc_meta->update_meta($user_id, $this->meta_key, $key);
		}
	}




    
	/////////////////////////////////////////
	
	
	
    
    /* be sure lightbox is enqueued */
    public function maybe_enqueue_lb() {
        global $pc_meta;
		
		if(!isset($GLOBALS['pc_user_id'])) {
			return false;	
		} else {
			$user_id = $GLOBALS['pc_user_id'];
		}
		
		// is reset required
		$fpr_key = $pc_meta->get_meta($user_id, $this->meta_key);
		if(empty($fpr_key)) {
			return false;	
		}	
        
        wp_enqueue_style('pc_lightbox');	
        wp_enqueue_script('pc_lightbox');	
    }
    
    
    
    
    
	/* persistent lightbox on frontend */
	public function frontend_lb() {
		include_once(PC_DIR . '/classes/pc_form_framework.php');
		$form_fw = new pc_form;
		global $pc_meta;
		
		if(!isset($GLOBALS['pc_user_id'])) {
			return false;	
		} else {
			$user_id = $GLOBALS['pc_user_id'];
		}
		
		// is reset required
		$fpr_key = $pc_meta->get_meta($user_id, $this->meta_key);
		if(empty($fpr_key)) {
			return false;	
		}	
		
		
		// compose lightbox contents
		$form_struct = array(
			'include' => array(
				'custom|||text',
				'psw'
			),
			'texts' => array(
				'<div class="pc_warn_box">
					'. (string)get_option('pcud_fpr_legend', 'Due to security reasons, you must change your password. Please insert a new password, different from the past one.') .
					'<input type="hidden" name="pcud_fpr_key" value="'. $fpr_key .'" />' .
				'</div>'
			),
			'require' => array()
		);
		?>
       	<div class="pc_displaynone">
            <div class="pc_lb_pcud_fpr">
                <?php 
                echo '
                <form class="pvtcont_form pc_custom_form_pcud_fpr pc_one_col_form" data-form-pag="1">'.
                
                    $form_fw->form_code($form_struct) .'		
                    <div class="pc_form_response pc_custom_form_message"></div>
                    
                    <button class="pcud_fpr_btn" type="button">
                        <span class="pc_inner_btn">'. __('Submit', PCUD_ML) .'</span>
                    </button>
                </form>';
                ?>
            </div>
        </div>
        
		<script type="text/javascript">
        (function($) { 
            "use strict"; 
            
            $(document).ready(function($) {

                // handle form
                $(document).on('click', '.pcud_fpr_btn:not(.pc_spinner_btn)',  function(e) {	
                    e.preventDefault();
                    var $form = $(this).parents('form');

                    var f_data = $(this).parents('form').serialize();

                    // HTML5 validate first
                    if( !$form.pc_validate_form_fieldset() ) {
                        return false;	
                    }

                    // be sure both fields are filled
                    if( !$.trim( $form.find('[name=psw]').val()) || ( $form.find('[name=check_psw]').length && !$.trim( $form.find('[name=check_psw]').val()) ) ) {
                        return false;	
                    }

                    $form.find('.pcud_fpr_btn').addClass('pc_spinner_btn');
                    $form.find('.pc_custom_form_message').empty();

                    $.ajax({
                        type: "POST",
                        url: window.location.href,
                        data: "type=pcud_fpr_submit&" + f_data,
                        success: function(resp) {

                            if($.trim(resp) == 'success') {
                                $form.find('.pc_custom_form_message').empty().append('<span class="pc_success_mess"><?php esc_attr_e('Password updated successfully!', PCUD_ML) ?></span>');

                                setTimeout(function() {
                                    location.reload(); 
                                }, 1000);
                            }
                            else {
                                $form.find('.pc_custom_form_message').empty().append('<span class="pc_error_mess">'+ resp +'</span>');
                            }
                        }
                    })
                    .fail(function(e) {
                        if(e.status) {
                            console.error(e);
                            $form.find('.pc_custom_form_message').empty().append('<span class="pc_error_mess">'+ pc_vars.ajax_failed_mess +'</span>');	
                        }    
                    })
                    .always(function() {
                        // a bit of delay to display the loader
                        setTimeout(function() {
                            $form.find('.pcud_fpr_btn').removeClass('pc_spinner_btn');
                        }, 370);
                    });
                });


                // keep pushing it even if hidden by furbacchioni
                const keep_it_alive = function() {
                    setTimeout(function() {
                        if((!$('.mfp-bg.pc_lightbox').length || !$('.mfp-wrap .pc_custom_form_pcud_fpr').length) && typeof($.magnificPopup) != 'undefined') {
                            $.magnificPopup.close();

                            setTimeout(function() {
                                $.magnificPopup.open({
                                    items : {
                                        src: '.pc_lb_pcud_fpr',
                                        type: 'inline'
                                    },
                                    mainClass			: 'pc_lightbox',
                                    closeOnContentClick	: false,
                                    closeOnBgClick		: false, 
                                    preloader			: false,
                                    modal				: true,
                                    focus				: 'input',
                                    removalDelay		: 300
                                });

                                keep_it_alive();
                            }, 400);	
                        }
                        else {
                            keep_it_alive();	
                        }
                    }, 400);
                }

                // init
                keep_it_alive();
            });
        })(jQuery);
		</script>
        <?php		
	}
	
	
    
    
    
	/* frontend lightbox - ajax */
	public function frontend_lb_ajax() {
		include_once(PC_DIR .'/classes/pc_form_framework.php');
		$form_fw = new pc_form;
		
		global $pc_users, $pc_meta;
		
		if(!isset($_POST['type']) || $_POST['type'] != 'pcud_fpr_submit') {
			return true;
		}
		
		if(!isset($GLOBALS['pc_user_id'])) {
			die('User ID not found');	
		}
		
		
		// check fpr key
		$user_id = $GLOBALS['pc_user_id']; 
		$fpr_key = $pc_meta->get_meta($user_id, $this->meta_key);
		
		if(empty($fpr_key) || !isset($_POST['pcud_fpr_key']) || $_POST['pcud_fpr_key'] !== $fpr_key) {
			die('Wrong key');	
		}	
		
		
		#### check password 
		// matching
		if(
            !isset($_POST['psw']) || empty($_POST['psw']) ||
            (!get_option('pg_single_psw_f_w_reveal') && (!isset($_POST['check_psw']) || empty($_POST['check_psw'])))
        ) {
			die( __('Please insert a valid password', PCUD_ML) );		
		}
		if(!get_option('pg_single_psw_f_w_reveal') && $_POST['psw'] !== $_POST['check_psw']) {
			die( __("Password doesn't match", PCUD_ML) );		
		}
		$psw = $_POST['psw'];
		
		// password requirements
		if( strlen($psw) < (int)get_option('pg_psw_min_length', 4) ) {	
			echo sprintf( __('Password must be at least %s characters long', PCUD_ML), (int)get_option('pg_psw_min_length', 4) );
			die();
		}
		
		$regex_check = $form_fw->check_psw_strength($psw);
		if($regex_check !== true) {
			echo __('Password', PCUD_ML) .' '. $regex_check;
			die();
		}
		
		// match against old one
		$old_psw = $pc_users->get_user_field($user_id, 'psw');
		if(wp_check_password($psw, $old_psw)) {
			die( __("Password must be different from old one", PCUD_ML) );		
		}
		
		
		// everything's ok - save!
		$response = $pc_users->update_user($user_id, array('psw' => $psw));
		if(!$response) {
			die("Error updating password");		
		}
		$pc_meta->delete_meta($user_id, $this->meta_key);
		
		// update cookie value (don't know how to keep "remember me")
		$cookie_time = (get_option('pg_no_cookie_login')) ? (60 * 10) : 3600; // 10 or 60 minutes

		// cookie structure = user id - encrypted password
		$encrypted_psw 	= $pc_users->get_user_field($user_id, 'psw');
		$cookie_data 	= array($user_id, $encrypted_psw);
        
        pc_static::setcookie('pc_user', implode('|||', $cookie_data), (time() + $cookie_time));
		die('success');
	}
	
	
	
    
	
	/* Force password reset when user requests a password recovery */
	public function fpr_on_pcma_resetted_psw($user_id) {
		global $pc_meta;
		
		if(defined('PCMA_DIR') && get_option('pcud_fpr_on_pcma_recovery')) {
			$key = wp_generate_password(8, false); 
			$pc_meta->update_meta($user_id, $this->meta_key, $key);	
		}
	}
}






function pcud_forced_user_psw_init($user_id) {
	$pcud_fpr = new pcud_forced_psw_reset($user_id);
}
add_action('pc_user_session_checked', 'pcud_forced_user_psw_init');