<?php
// STATIC METHODS RELATED TO FIELDS MANAGEMENT
class pcud_fields_static {
	

    // array of field types
    public static function field_types() {
        $types = array(
            'text' 				=> __('Text', PCUD_ML),
            'select' 			=> __('Dropdown', PCUD_ML),
            'textarea' 			=> __('Textarea', PCUD_ML),
            'checkbox' 			=> __('Checkboxes', PCUD_ML),
            'radio' 			=> __('Radio buttons', PCUD_ML),
            'single_checkbox' 	=> __('Single-option checkbox', PCUD_ML),
        );
        return $types;	
    }


    
    // array of field subtypes
    public static function field_subtypes() {
        $subtypes = array(
            '' 			=> __('Anything', PCUD_ML),
            'email' 	=> __('E-mail', PCUD_ML),
            'int' 		=> __('Integer Number', PCUD_ML),
            'float' 	=> __('Floating Number', PCUD_ML),
            'eu_date' 	=> __('European Date', PCUD_ML),
            'us_date' 	=> __('US Date', PCUD_ML),
            'iso_date' 	=> __('ISO Date', PCUD_ML),
            '24h_time' 	=> __('24h time', PCUD_ML),
            '12h_time' 	=> __('12h time', PCUD_ML),
            'us_tel' 	=> __('US Telephone', PCUD_ML),
            'zipcode' 	=> __('US Zipcode', PCUD_ML),
            'url' 		=> __('Standard URL', PCUD_ML)
        );
        return $subtypes;	
    }


    
    // get custom fields - already sorted - (returns array of term ojects)
    public static function get_fields($sorting = 'name_asc') {
       
        switch($sorting) {
            case 'name_asc' :
            default :
                $sorting = 'name_asc';
                $sort_str = 'orderby=name&order=ASC';
                break;
                
            case 'name_desc' :
                $sort_str = 'orderby=name&order=DESC';
                break;
                
            case 'date_desc' :
                $sort_str = 'orderby=id&order=DESC';
                break;
                
            case 'date_asc' :
                $sort_str = 'orderby=id&order=ASC';
                break;         
        }
        
        
        if(!is_admin() && isset($GLOBALS['pcud_sorted_fields'.$sorting])) { // cache
            return $GLOBALS['pcud_sorted_fields'.$sorting];
        } 

        // sort fields
        $terms = get_terms('pcud_fields', 'hide_empty=0&'.$sort_str);
        $to_return = array();
        
        // already elaborate pcud options
        if(is_array($terms)) {
            foreach($terms as $key => $t) {
                $to_return[ $t->slug ] = $t;
                $to_return[ $t->slug ]->pcud_opts = unserialize(base64_decode($t->description));
            }
        }
        
        $GLOBALS['pcud_sorted_fields'.$sorting] = $to_return;
        return $to_return;
    }

    
    
    // given the field slug, returns its section (related to admin arrangment) or an empty string
    public static function get_field_section($f_slug) {
        $arrang = get_option('pcud_fields_arrang', array());
        if(empty($arrang)) {
            $arrang = array();    
        }
        
        foreach($arrang as $sect_name => $sect_f_slugs) {
            if(in_array($f_slug, $sect_f_slugs)) {
                return $sect_name;   
            }
        }
        
        return '';
    }
    

    
    // get single field pcud data ($subj can be term ID or slug)
    public static function get_single_field_data($subj, $subj_type = 'slug') {
        $term = get_term_by($subj_type, $subj, 'pcud_fields');
        if(!$term) {
            return false;    
        }
        
        return unserialize(base64_decode($term->description));
    }

    
    
    // get sorted field indexes
    public static function sorted_fields_indexes() {
        $data = self::get_fields();	
        
        if(!is_array($data)) {
            return array();    
        }
        return array_keys($data);
    }
    


    // turn forms fields name into v2 compatible
    public static function v2_field_names_sanitize($data) {
        if(!is_array($data) || !isset($data['include'])) {
            return $data;
        }

        $incl = array();
        $req = array();

        foreach($data['include'] as $fname) {
            if(substr($fname, 0, 13) != 'custom|||text' && substr($fname, 0, 12) != 'custom|||sep' && $fname != 'custom|||page') {
                $incl[] = sanitize_title($fname);	
            }
            else {
                $incl[] = $fname;	
            }
        }

        if(is_array($data['require'])) {
            foreach($data['require'] as $fname) {
                $req[] = sanitize_title($fname);	
            }	
        }

        $data['include'] = $incl;
        $data['require'] = $req;

        return $data;
    }
    
    
    
        
    /* 
     * returns the HTML code for a single field in the custom fields builder
     *
     * @param (object) $term = WP term object related to the field
     * @param (array) $pcud_fields = list of fields
     * @param (array) $val = array of field parameter values
     */
    public static function field_builder_block($term, $pcud_fields, $val = array()) {
        if(empty($val)) {
            $val = array(
                'type' => 'text',
                'subtype' => ''
            );    
        }
        
        // stored values manag for old versions data (from v1.5)				
        if(!isset($val['regex'])) {
            $val['regex'] = '';
            $val['range_from'] = 0; 
            $val['range_to'] = 100; 
            $val['check_txt'] = ''; 
            $val['multi_select'] = ''; 
            $val['disclaimer'] = ''; 
            $val['maxlen'] = 255;
            $val['note'] = '';
        }

        if(!isset($val['placeh']))      {$val['placeh'] = '';}
        if(!isset($val['helper']))      {$val['helper'] = '';}
        if(!isset($val['icon']))        {$val['icon'] = '';}
        if(!isset($val['combo_opts']))	{$val['combo_opts'] = '';}
        if(!isset($val['unique_val']))	{$val['unique_val'] = '';}
        if(!isset($val['fullw_f']))	    {$val['fullw_f'] = '';}

        if(!isset($val['date_from']))	{
            $val['date_from'] = '';
            $val['date_to'] = '';
        }
        
        if(!isset($val['time_from']))	{
            $val['time_from'] = '';
            $val['time_to'] = '';
        }
        
        $code = '
        <table class="widefat pc_table pcud_fb_table" data-f_id="'. $term->term_id .'" data-f_slug="'. $term->slug .'">
          <thead>
              <tr>
                <th>
                    <input type="hidden" name="pcud_f_id[]" value="'. $term->term_id .'" />
                    <input type="hidden" name="pcud_f_index[]" value="'. $term->slug .'" />
                    <input type="text" name="pcud_f_label[]" class="pcud_f_label" value="'. esc_attr($term->name) .'" maxlength="255" placeholder="'.  esc_attr__('field label', PCUD_ML) .'" autocomplete="off" required="required" />

                    <small class="pcud_f_index">'. __('field index', PCUD_ML) .': <em>'. $term->slug .'</em></small>
                </th>
                <th>
                    <div class="pcud_cmd">
                        <small class="pcud_ec">
                            ( <a href="javascript:void(0)" class="collapse">'. __('collapse', PCUD_ML) .'</a>
                            <a href="javascript:void(0)" class="pc_displaynone">'. __('expand', PCUD_ML) .'</a> )
                        </small>
                        <span class="pcud_move_field pc_move_field dashicons dashicons-migrate" title="'. esc_attr__('move to another section', PCUD_ML) .'"></span>
                        <span class="pcud_del_field pc_del_field dashicons dashicons-no-alt" title="'. esc_attr__('delete field', PCUD_ML) .'"></span>
                    </div>
                </th>
              </tr>
          </thead>
          <tbody>
            <tr>
                <td colspan="2">
                    <div class="pcud_field">
                        <label>'. __('Field type', PCUD_ML) .'</label>
                        <select name="pcud_f_type[]" class="pcud_lcslt f_type" data-placeholder="'. esc_attr__('Select type', PCUD_ML) .' .." autocomplete="off">';
                           
                          foreach(pcud_fields_static::field_types() as $key => $opt) {
                              $code .= '<option value="'. $key .'" '. selected($val['type'], $key, false).'>'. $opt .'</option>';	
                          }
        
                        $code .= '
                        </select>
                    </div>


                    <div class="pcud_field pcud_subtype '; 
                        if($val['type'] != 'text') {
                            $code .= 'pc_displaynone';
                        }
                    
                        $code .= '
                        ">

                        <label>'. __('Subtype', PCUD_ML) .'</label>
                        <select name="pcud_f_subtype[]" class="pcud_lcslt f_subtype" data-placeholder="'. esc_attr__('Select subtype', PCUD_ML) .' .." autocomplete="off">';
        
                          foreach(pcud_fields_static::field_subtypes() as $key=>$opt) {
                              $code .= '<option value="'. esc_attr($key) .'" '. selected($val['subtype'], $key, false).'>'. esc_html($opt) .'</option>';	
                          }
        
                        $code .= '
                        </select>
                    </div>


                    <div class="pcud_field pcud_maxlength '; 
                        if($val['type'] != 'text' || !empty($val['subtype'])) {
                            $code .= 'pc_displaynone';
                        } 
                        
                        $code .= '
                        ">
                        
                        <label>'. __('Max length', PCUD_ML) .'</label>
                        <input type="number" name="pcud_f_maxlen[]" value="'. (int)$val['maxlen'] .'" min="1" max="255" step="1" data-respect-limits="1" data-unit="chars" class="pcud_val_n_num" />
                    </div>


                    <div class="pcud_field pcud_regex '; 
                        if(!in_array($val['type'], array('text', 'textarea')) || ($val['type'] == 'text' && in_array($val['subtype'], array('iso_date', 'eu_date', 'us_date', '12h_time', '24h_time')) )) {
                            $code .= 'pc_displaynone';
                        }
        
                        $code .= '
                        ">
                        
                        <label>'. __('Custom regexp validation', PCUD_ML) .'</label>
                        <input type="text" name="pcud_f_regex[]" value="'. esc_attr($val['regex']) .'" placeholder="'. esc_attr__('example', PCUD_ML) .' - '. esc_attr('/[^a-z_\-0-9]/i') .'" autocomplete="off" />
                    </div>  


                    <div class="pcud_field pcud_num_range '; 
                        if($val['type'] != 'text' || !in_array($val['subtype'], array('int', 'float'))) {
                            $code .= 'pc_displaynone';
                        } 
                        
                        $code .= '
                        ">
                        <label>'. __('Values range', PCUD_ML) .' <span class="dashicons dashicons-info" title="'. esc_attr__('use zero to ignore', PCUD_ML) .'"></span></label>

                        <span>'. __('From', PCUD_ML) .'</span> 
                        <input type="number" name="pcud_f_range_from[]" value="'. (float)$val['range_from'] .'" autocomplete="off" step="0.1" />
                        <span>'. __('to', PCUD_ML) .'</span> 
                        <input type="number" name="pcud_f_range_to[]" value="'. (float)$val['range_to'] .'" autocomplete="off" step="0.1" />
                    </div>


                    <div class="pcud_field pcud_date_range '; 
                        if($val['type'] != 'text' || !in_array($val['subtype'], array('iso_date', 'eu_date', 'us_date'))) {
                            $code .= 'pc_displaynone';
                        }

                        $code .= '
                        ">

                        <label>'. __('Date range', PCUD_ML) .' <span class="dashicons dashicons-info" title="'. esc_attr__('leave empty to ignore', PCUD_ML) .'"></span></label>

                        <span>'. __('From', PCUD_ML) .'</span> 
                        <input type="date" name="pcud_f_date_from[]" value="'. esc_attr($val['date_from']) .'" autocomplete="off" />
                        <span>'. __('to', PCUD_ML) .'</span> 
                        <input type="date" name="pcud_f_date_to[]" value="'. esc_attr($val['date_to']) .'" autocomplete="off" />
                    </div>
                    

                    <div class="pcud_field pcud_time_range '; 
                        if($val['type'] != 'text' || !in_array($val['subtype'], array('12h_time', '24h_time'))) {
                            $code .= 'pc_displaynone';
                        }

                        $code .= '
                        ">

                        <label>'. __('Time range', PCUD_ML) .' <span class="dashicons dashicons-info" title="'. esc_attr__('leave empty to ignore', PCUD_ML) .'"></span></label>

                        <span>'. __('From', PCUD_ML) .'</span> 
                        <input type="time" name="pcud_f_time_from[]" value="'. esc_attr($val['time_from']) .'" autocomplete="off" />
                        <span>'. __('to', PCUD_ML) .'</span> 
                        <input type="time" name="pcud_f_time_to[]" value="'. esc_attr($val['time_to']) .'" autocomplete="off" />
                    </div>


                    <div class="pcud_field pcud_combo_opts '; 
                        if(!in_array($val['type'], array('select', 'checkbox', 'radio'))) {
                            $code .= 'pc_displaynone';
                        }

                        $code .= '
                        ">

                        <label>'. __('Combo-options? Link to', PCUD_ML) .' <span class="dashicons dashicons-info" title="'. esc_attr__('show options depending another dropdown/checkbox/radio field value', PCUD_ML) .'"></span></label>
                        <select name="pcud_f_combo_opts[]" class="pcud_lcslt" data-placeholder="'. esc_attr__('Select an option', PCUD_ML) .' .." autocomplete="off">
                            <option value="">'. esc_html__('none') .'</option>';
 
                            foreach($pcud_fields as $cot_term) {
                                if($cot_term->term_id == $term->term_id || !in_array($cot_term->pcud_opts['type'], array('select', 'checkbox', 'radio'))) {
                                    continue;    
                                }

                                $code .= '<option value="'. esc_attr($cot_term->slug) .'" '. selected($val['combo_opts'], $cot_term->slug, false) .'>'. esc_html($cot_term->name) .'</option>';
                            }
                        
                        $code .= '
                        </select>
                    </div>  


                    <div class="pcud_field pcud_options '; 
                        if(!in_array($val['type'], array('select', 'checkbox', 'radio'))) {
                            $code .= 'pc_displaynone';
                        }
        
                        $code .= '
                        ">
                        
                        <label>'. __('Options', PCUD_ML) .'</label>
                        <input type="button" name="pcud_man_opt_btn" value="'. esc_attr__('Manage options', PCUD_ML) .'" class="button-secondary" />
                    </div>


                    <div class="pcud_field pcud_f_multi_select '; 
                        if($val['type'] != 'select') {
                            $code .= 'pc_displaynone';
                        }
        
                        $code .= '
                        ">
        
                        <label>'. __('Multi-choice?', PCUD_ML) .'</label>
                         <select name="pcud_f_multi_select[]" class="pcud_lcslt" data-placeholder="'. esc_attr__('Select an option', PCUD_ML) .' .." autocomplete="off">
                            <option value="">'. esc_html__('no') .'</option>
                            <option value="1" '; if(!empty($val['multi_select'])) {$code .= 'selected="selected"';} $code .= '>'. esc_html__('yes') .'</option>
                        </select>
                    </div>     


                    <div class="pcud_field pcud_placeh ';
                        if(!in_array($val['type'], array('text', 'textarea', 'select')) || ($val['type'] == 'text' && in_array($val['subtype'], array('iso_date', 'eu_date', 'us_date', '12h_time', '24h_time')) )) {
                            $code .= 'pc_displaynone';
                        }
        
                        $code .= '
                        ">
                        
                        <label>
                            '. __('Field Placeholder', PCUD_ML) .'

                            <span class="dashicons dashicons-info pcud_dd_placeh_helper '; 
                                if($val['type'] != 'select' || ($val['type'] == 'select' && $val['multi_select'])) {
                                    $code .= 'pc_displaynone';
                                } 
                            
                            $code .= '
                            " title="'. esc_attr__('If filled, prepends an empty value option using this text. Leave empty to discard', PCUD_ML) .'"></span>
                        </label>
                        <input type="text" name="pcud_f_placeh[]" value="'. esc_attr($val['placeh']) .'" maxlength="200" autocomplete="off" />
                    </div>    


                    <div class="pcud_field pcud_helper ';
                        if($val['type'] == 'single_checkbox') {
                            $code .= 'pc_displaynone';
                        }
        
                        $code .= '
                        ">

                        <label>
                            '. __('Field helper', PCUD_ML) .'

                            <span class="dashicons dashicons-info" title="'. esc_attr__('Optionally gives users a contextual guide to the field. Supports A, BR, STRONG, EM,I HTML tags', PCUD_ML) .'"></span>
                        </label>
                        <textarea name="pcud_f_helper[]" rows="1" onkeyup="lcwp_sf_textAreaAdjust(this)" autocomplete="off">'. esc_textarea($val['helper']) .'</textarea>
                    </div>


                     <div class="pcud_field pcud_f_check_txt ';
                        if($val['type'] != 'single_checkbox') {
                            $code .= 'pc_displaynone';
                        }
        
                        $code .= '
                        ">
                        
                        <label>'. __('Checkbox text', PCUD_ML) .'</label>
                        <textarea name="pcud_f_check_txt[]" rows="1" placeholder="'. esc_attr__('Text used in forms (supports HTML)', PCUD_ML) .'" onkeyup="lcwp_sf_textAreaAdjust(this)" autocomplete="off">'. esc_textarea($val['check_txt']) .'</textarea>
                    </div>   


                    <div class="pcud_field pcud_f_disclaimer ';
                        if($val['type'] != 'single_checkbox') {
                            $code .= 'pc_displaynone';
                        }
        
                        $code .= '
                        ">

                        <label>'. __('Use as disclaimer?', PCUD_ML) .'</label>
                         <select name="pcud_f_disclaimer[]" class="pc_lc_select" data-placeholder="'. esc_attr__('Select an option', PCUD_ML) .' .." autocomplete="off">
                            <option value="">'. esc_html__('no') .'</option>
                            <option value="1" '; if(!empty($val['disclaimer'])) {$code .= 'selected="selected"';} $code .= '>'. esc_html__('yes') .'</option>
                        </select>
                    </div> 


                    <div class="pcud_field pcud_f_icon ';
                        if(!in_array($val['type'], array('text', 'select'))) {
                            $code .= 'pc_displaynone';
                        }
        
                        $code .= '
                        ">
                        
                        <label>'. __("Field's icon", PCUD_ML) .'</label>
                        <div class="pc_field_icon_trigger">
                            <i class="'. esc_attr( pc_static::fontawesome_v4_retrocomp($val['icon'])) .'" title="'. esc_attr__('set icon', PCUD_ML) .'"></i>
                            <input type="hidden" name="pcud_f_icon[]" value="'. esc_attr($val['icon']) .'" /> 
                        </div>
                    </div> 


                    <div class="pcud_field pcud_f_unique_val ';
                        if(!in_array($val['type'], array('text', 'textarea'))) {
                            $code .= 'pc_displaynone';
                        }
        
                        $code .= '
                        ">

                        <label>'. __('Unique value?', PCUD_ML) .' <span class="dashicons dashicons-info" title="'. esc_attr__('When enabled, only a unique values will be accepted for each user', PCUD_ML) .'"></span></label>
                         <select name="pcud_f_unique_val[]" class="pcud_lcslt" data-placeholder="'. esc_attr__('Select an option', PCUD_ML) .' .." autocomplete="off">
                            <option value="">'. esc_html__('no', PCUD_ML) .'</option>
                            <option value="1" '; if(!empty($val['unique_val'])) {$code .= 'selected="selected"';} $code .= '>'. esc_html__('yes') .'</option>
                        </select>
                    </div>


                    <div class="pcud_field pcud_fullw_f_val">
                        <label>'. __('Fullwidth field?', PCUD_ML) .' <span class="dashicons dashicons-info" title="'. esc_attr__('When enabled, field will take 100% of the form width', PCUD_ML) .'"></span></label>
                         <select name="pcud_fullw_f[]" class="pcud_lcslt" data-placeholder="'. esc_attr__('Select an option', PCUD_ML) .' .." autocomplete="off">
                            <option value="">'. esc_html__('no') .'</option>
                            <option value="1" '; if(!empty($val['fullw_f'])) {$code .= 'selected="selected"';} $code .= '>'. esc_html__('yes') .'</option>
                        </select>
                    </div>


                    <div class="pcud_field">
                        <label>'. __('Internal note', PCUD_ML) .'</label>
                        <textarea name="pcud_f_note[]" rows="1" onkeyup="lcwp_sf_textAreaAdjust(this)" autocomplete="off">'. esc_textarea($val['note']) .'</textarea>
                    </div>
                </td>
            </tr>
          </tbody>	
        </table>';

        return $code;
    }

    
    
    ///////////////////////////////////////////////////////////////////////////////
    
    
    
    // know whether a field is a combo-dd and eventually return the linked field slug
    public static function f_is_combo($field_slug) {
        $data = self::get_single_field_data($field_slug); 
        return ($data && in_array($data['type'], array('select', 'checkbox', 'radio'))) ? $data['combo_opts'] : '';
    }
    
    
    
    
    /* 
     * returns field options array - use $strip_linked_f to return a simple array out of combo select fields
     *
     * @param (bool) $strip_linked_f - whether to return only options array - used in combo-to-single commutation
     * @param (bool) $ready_for_use - whether to manage combo linked values by splitting joined ones
     */
    public static function get_f_opts($f_term_id, $strip_linked_f = false, $translate_labels = false, $ready_for_use = false) {
        $source = get_term_meta($f_term_id, 'pcud_fow_opts_comp', true);
        
        if($source == 'countries') {
            include_once(PCUD_DIR .'/fixed_field_opts/countries.php');
            return $GLOBALS['pcud_countries'];
        }
        elseif($source == 'states') {
            include_once(PCUD_DIR .'/fixed_field_opts/states.php');
            
            if(!$strip_linked_f) {
                return $GLOBALS['pcud_states'];
            }
            
            $opts = $GLOBALS['pcud_states'];
        }
        else {
            $opts = get_term_meta($f_term_id, 'pcud_fow_opts', true);
            if(!is_array($opts)) {
                $opts = array();    
            }

            if($translate_labels) {
                $translated_opts = array();
                
                foreach($opts as $key => $val) {
                    if(is_array($val)) { // combo-dd
                        $translated_opts[$key] = array();
                        
                        foreach($val as $opt_val => $opt_label) {
                            $translated_opts[$key][$opt_val] = self::get_translated_opt($opt_val, $opt_label);       
                        }
                    }
                    else {
                        $translated_opts[$key] = self::get_translated_opt($key, $val);                   
                    }
                }
                
                $opts = $translated_opts;
            }
        }
        
        // strip linked opts for combo?
        if($strip_linked_f) {
            $f_data = self::get_single_field_data($f_term_id, 'id');
            if(isset($f_data['combo_opts']) && (int)$f_data['combo_opts']) {
            
                $opt_vals = array_values($opts);
                if(is_array($opt_vals[0])) {
                 
                    $stripped = array();
                    foreach($opts as $linked => $sub_opts) {
                        $stripped = array_merge($stripped, $sub_opts);    
                    }
                    
                    $opts = $stripped;
                }
            }
        }
        
        
        // split joined linked vals
        if($ready_for_use) {
            foreach($opts as $linked_val => $lv_opts) {
                if(strpos($linked_val, '|||') === false || !is_array($lv_opts)) {
                    continue;
                }

                foreach(explode('|||', $linked_val) as $lv) {
                    $opts[$lv] = $lv_opts;        
                }

                unset($opts[$linked_val]);
            }    
        }
        
        return $opts;
    }
    
    
    
    
    /* get field options array related to specific linked field values (already translated)
     * @param (string | array) $linked_val - linked field value
     */
    public static function get_f_opts_linked_to_val($f_term_id, $linked_vals) {
        $all_opts = self::get_f_opts($f_term_id, false, true, true);    
        $opts = array();

        foreach((array)$linked_vals as $lv) {
            if(isset($all_opts[$lv])) {
                $opts = array_merge($opts, (array)$all_opts[$lv]);     
            }
        }
        return $opts;
    }
    
    
    
    
    // returns dropdown/checkbox/radio selected choices considering default values and currently logged user's data
    public static function get_sel_opts($field_slug, $f_term_id = false) {
        if(!$f_term_id) {
            $term = get_term_by('slug', $field_slug, 'pcud_fields');  
            $f_term_id = $term->term_id;
        }
        $def_choice = (array)get_term_meta($f_term_id, 'pcud_fow_def_choice', true);  
        
        if(isset($GLOBALS['pc_user_id'])) {
            global $pc_meta;
            $user_meta = $pc_meta->get_meta($GLOBALS['pc_user_id'], $field_slug);
            
            if($user_meta !== false) {
                $def_choice = $user_meta;
            }
        }
        return $def_choice;
    }
    
    
    
    
    // return the table row (HTML block) for field options wizard, related to another field
    public static function get_link_to_opt_tr($rel_term_slug, $selected_vals = array(), $is_fist = false) {
        $term = get_term_by('slug', $rel_term_slug, 'pcud_fields');
        
        $opts = self::get_f_opts($term->term_id, true);
        $is_first_class = ($is_fist) ? 'pcud_first_fow_linked_val_tr' : ''; 
        
        if(!is_array($selected_vals)) {
            $selected_vals = explode('|||', $selected_vals);   
        }
        
        $code = '
        <tr class="pcud_fow_linked_val_tr '. $is_first_class .'">
            <td></td>
            <td>
                <select name="pcud_fow_linked_val" multiple="multiple" autocomplete="off">';
        
                    foreach($opts as $val => $label) {
                        $sel = (in_array($val, $selected_vals)) ? 'selected="selected"' : '';
                        $code .= '<option value="'. trim(esc_attr($val)) .'" '. $sel .'>'. trim(esc_html($val)) .'</option>';
                    }
            
        return $code .= '
                </select>
                <i class="dashicons dashicons-admin-links" title="'. esc_attr__('All options underneath are linked to this value', PCUD_ML) .'"></i>
            </td>
            <td>
                <span class="pcud_fow_move_opt pc_move_field dashicons dashicons-move" title="'. esc_attr__('sort link', PCUD_ML) .'"></span>
            </td>
            <td>
                <span class="pcud_fow_del_opt pc_del_field dashicons dashicons-no-alt" title="'. esc_attr__('delete link', PCUD_ML) .'"></span>
            </td>
        </tr>';    
    }
    
    
    
    
    // return the table row (HTML block) for field options wizard
    public static function get_opt_tr($val, $label, $def_choice, $is_multiple = true, $combo_opts = false) {
        $is_def_choice = (in_array($val, $def_choice)) ? 'checked="checked"' : '';
        $def_choice_type = ($is_multiple) ? 'checkbox' : 'radio';
        
        $def_choice_td = ($combo_opts) ? '' : '
        <td>
            <input type="'. $def_choice_type .'" name="pcud_fow_def_sel" value="'. uniqid() .'" '. $is_def_choice .' autocomplete="off" />
        </td>'; 
        
        return '
        <tr>
            <td>
                <input type="text" name="pcud_fow_opt_val" value="'. trim(esc_attr($val)) .'" autocomplete="off" maxlength="150" />
            </td>
            <td>
                <input type="text" name="pcud_fow_opt_label" value="'. trim(esc_attr($label)) .'" autocomplete="off" maxlength="150" />
            </td>
            '. $def_choice_td .'
            <td>
                <span class="pcud_fow_move_opt pc_move_field dashicons dashicons-move" title="'. esc_attr__('sort option', PCUD_ML) .'"></span>
            </td>
            <td>
                <span class="pcud_fow_del_opt pc_del_field dashicons dashicons-no-alt" title="'. esc_attr__('delete option', PCUD_ML) .'"></span>
            </td>
        </tr>';    
    }
    
    
    
    ///////////////////////////////////////////////////////////////////////////////
    
    
    
    // sync custom fields name with WPML or Polylang
    public static function multilang_fields_sync($fdata) {
        
        // WPML
        if(function_exists('icl_register_string')) {
            $saved = (array)get_option('pcud_wpml_synced_fields', array());
            $to_save = array();

            foreach($fdata['pcud_f_index'] as $key => $val) {
                $index = $val;
                $to_save[$index] = array('label');

                //// label 
                // check if unregister before
                if(isset($saved[$index]) && isset($saved[$index]['label']) && $saved[$index]['label'] != $fdata['pcud_f_label'][$key]) {
                    icl_unregister_string('PrivateContent User Data', 'Custom fields - '.$index); // retrocompatibility
                    icl_unregister_string('PrivateContent User Data', $index.' - label');
                }
                $to_save[$index]['label'] = $fdata['pcud_f_label'][$key];
                icl_register_string('PrivateContent User Data', $index.' - label', $fdata['pcud_f_label'][$key]);	


                //// placeholder
                // check if unregister before
                if(isset($saved[$index]) && isset($saved[$index]['placeh']) && $saved[$index]['placeh'] != $fdata['pcud_f_placeh'][$key]) {
                    icl_unregister_string('PrivateContent User Data', 'Custom fields placeholder - '.$index); // retrocompatibility
                    icl_unregister_string('PrivateContent User Data', $index.' - placeholder');
                }
                if(!empty($fdata['pcud_f_placeh'][$key])) {
                    $to_save[$index]['placeh'] = $fdata['pcud_f_placeh'][$key];
                    icl_register_string('PrivateContent User Data', $index.' - placeholder', $fdata['pcud_f_placeh'][$key]);	
                }
                
                
                //// field helper
                // check if unregister before
                if(isset($saved[$index]) && isset($saved[$index]['helper']) && $saved[$index]['helper'] != $fdata['pcud_f_helper'][$key]) {
                    icl_unregister_string('PrivateContent User Data', 'Custom fields helper - '.$index); // retrocompatibility
                    icl_unregister_string('PrivateContent User Data', $index.' - helper');
                }
                if(!empty($fdata['pcud_f_helper'][$key])) {
                    $to_save[$index]['placeh'] = $fdata['pcud_f_placeh'][$key];
                    icl_register_string('PrivateContent User Data', $index.' - helper', $fdata['pcud_f_placeh'][$key]);	
                }


                //// single checkbox text
                // check if unregister before
                if(isset($saved[$index]) && isset($saved[$index]['check_txt']) && $saved[$index]['check_txt'] != $fdata['pcud_f_check_txt'][$key]) {
                    icl_unregister_string('PrivateContent User Data', $index.' - checkbox text');
                }
                if(!empty($fdata['pcud_f_check_txt'][$key])) {
                    $to_save[$index]['check_txt'] = $fdata['pcud_f_check_txt'][$key];
                    icl_register_string('PrivateContent User Data', $index.' - checkbox text', $fdata['pcud_f_check_txt'][$key]);	
                }
            }

            // save registered fields
            update_option('pcud_wpml_synced_fields', $to_save);	
        }
        
        
        // POLYLANG
        if(function_exists('pll_register_string')) {
            foreach($fdata['pcud_f_index'] as $key => $val) {
                $index = $val;

                // label 
                pll_register_string('PrivateContent User Data', $fdata['pcud_f_label'][$key], $index.' - label');

                // placeholder
                pll_register_string('PrivateContent User Data', $fdata['pcud_f_placeh'][$key], $index.' - placeholder');
                
                // helpe
                pll_register_string('PrivateContent User Data', $fdata['pcud_f_helper'][$key], $index.' - helper');

                // single checkbox text
                pll_register_string('PrivateContent User Data', $fdata['pcud_f_check_txt'][$key], $index.' - checkbox text');	
            }
        }
    }
    
    
    
    
    // sync field options with WPML or Polylang
    public static function multilang_field_opts_sync($opts) {
        
        // WPML
        if(function_exists('icl_register_string')) {
            foreach($opts as $val => $label) {
                icl_register_string('PCUD - Field Options', $val, $label);        
            }
        }
        
        
        // POLYLANG
        if(function_exists('pll_register_string')) {
            foreach($opts as $val => $label) {
                pll_register_string('PCUD - Field Options', $label, $val);        
            }
        }
    }
    
    
    
    // get translated option name - WPML & Polylang integration
    public static function get_translated_opt($val, $label) {
        
        // WPML
        if(function_exists('icl_t')){
            return icl_t('PCUD - Field Options', $val, $label);
        } 
        
        
        // POLYLANG
        if(function_exists('pll__')) {
            return pll__($label);	
        }

        return $label;
    }
    
}
