<?php
// STATIC METHODS RELATED TO FORMS MANAGEMENT
class pcud_forms_static {
	
    
    // returns the tabbed forms list (registration/data-update) to be used in forms builder
    public static function builder_forms_list($sel_tab = 'registr', $sel_form = false) {
        $reg_sel        = ($sel_tab == 'registr') ? 'pcud_flt_sel' : '';
        $du_sel         = ($sel_tab == 'update') ? 'pcud_flt_sel' : '';
        $reg_list_vis   = ($sel_tab == 'registr') ? '' : 'pc_displaynone'; 
        $du_list_vis    = ($sel_tab == 'update') ? '' : 'pc_displaynone'; 
        
        $code = '
        <div class="pcud_forms_list_tabs">
            <div class="'. $reg_sel .'" data-subj="registr">'. __('Registration', PCUD_ML) .'</div>
            <div class="'. $du_sel .'" data-subj="update">'. __('Data Update', PCUD_ML) .'</div>
        </div>
        
        <div class="inside">
            <div class="'. $reg_list_vis .'" data-subj="registr" data-no-forms-txt="'. esc_attr__('no forms found', PCUD_ML) .' ..">';
               
            $reg_forms = get_terms('pc_reg_form', 'hide_empty=0&orderby=name&order=ASC');
            if(is_array($reg_forms)) {
                foreach($reg_forms as $rf) {
                    $checked = ($rf->term_id == $sel_form) ? 'checked="checked"' : '';
                    
                    $code .= '
                    <div>
                        <span>
                            <input type="radio" name="pcud_fb_sel" value="'. $rf->term_id .'" '. $checked .' autocomplete="off" />
                        </span>
                        <span class="pcud_form_tit" title="ID #'. $rf->term_id .'">'. esc_html($rf->name) .'</span>
                        
                        <span class="pcud_rename_form pc_move_field dashicons dashicons-edit"></span>
                        <span class="pcud_del_form pc_del_field dashicons dashicons-no-alt"></span>
                    </div>';
                }
            }

        $code .= '   
            </div>
            <div class="'. $du_list_vis .'" data-subj="update" data-no-forms-txt="'. esc_attr__('no forms found', PCUD_ML) .' ..">';
            
            $reg_forms = get_terms('pcud_forms', 'hide_empty=0&orderby=name&order=ASC');
            if(is_array($reg_forms)) {
                foreach($reg_forms as $rf) {
                    $checked = ($rf->term_id == $sel_form) ? 'checked="checked"' : '';
                    
                    $code .= '
                    <div>
                        <span>
                            <input type="radio" name="pcud_fb_sel" value="'. $rf->term_id .'" '. $checked .' autocomplete="off" />
                        </span>
                        <span class="pcud_form_tit" title="ID #'. $rf->term_id .'">'. esc_html($rf->name) .'</span>
                        
                        <span class="pcud_rename_form pc_move_field dashicons dashicons-edit" title="'. esc_attr__('rename form', PCUD_ML) .'"></span>
                        <span class="pcud_del_form pc_del_field dashicons dashicons-no-alt" title="'. esc_attr__('delete form', PCUD_ML) .'"></span>
                    </div>';
                }
            }
        
        $code .= '
            </div>
        </div>';
        
        return $code;
    }
    
    
    
    
    // returns the HTML code for field conditions
    public static function builder_field_conditions($field_slug, $form_id, $f_fw) {
        $f_conds = (array)get_term_meta((int)$form_id, 'pcud_form_conditions', true);
        
        if(empty($f_conds) || !isset($f_conds[$field_slug]) || empty($f_conds[$field_slug])) {
            $f_cond = array(
                "def_vis"   => false,
                "main_cond" => false,
                "conds"     => array()    
            );       
        }
        else {
            $f_cond = $f_conds[$field_slug];        
        }
        
        $wrap_vis   = (empty($f_cond['conds'])) ? 'pc_displaynone' : '';
        $cond_label = ($f_cond["def_vis"] == 'hidden') ? esc_attr__('Show if', PCUD_ML) : esc_attr__('Hide if', PCUD_ML);
        
        $code = '
        <div class="pcud_field_cond_def '. $wrap_vis .'">
            <select name="pcud_cond_def_vis" autocomplete="off">
                <option value="hidden">'. esc_html__('hidden by default', PCUD_ML) .'</option>
                <option value="shown" '. selected('shown', $f_cond["def_vis"], false) .'>'. esc_html__('visible by default', PCUD_ML) .'</option>
            </select>
            <select name="pcud_cond_main_cond" autocomplete="off">
                <option value="OR">'. esc_html__('one condition must be satisfied', PCUD_ML) .'</option>
                <option value="AND" '. selected('AND', $f_cond["main_cond"], false) .'>'. esc_html__('all conditions must be satisfied', PCUD_ML) .'</option>
            </select>
            <i>|</i>
            <strong>'. $cond_label .':</strong>
        </div>
        <ul class="pcud_field_cont_ul">';
        
        // PCUD-FILTER - fields ID ignored in conditional field dropdown
        $fields_to_ignore = apply_filters('pcud_cond_f_ignored_dd_opts', array());
        
        foreach((array)$f_cond['conds'] as $cond_data) {
            $code .= '
            <li>
                <div>
                    <select name="pcud_cond_field" class="pcud_lc_select" autocomplete="off">';
            
                    foreach($f_fw->get_fields_grouped() as $group_name => $fields) {
                        $code .= '
                        <optgroup label="'. esc_attr($group_name) .'">';

                            foreach($fields as $f_id => $data) {
                                if(!in_array($f_id, $fields_to_ignore)) {
                                    $code .= '<option value="'. $f_id .'" '. selected($f_id, $cond_data['field'], false) .'>'. $data['label'] .'</option>';
                                }
                            }

                        $code .= '
                        </optgroup>';
                    }	
            
                    $code .= '
                    </select>
                </div>
                <select name="pcud_cond_operator" autocomplete="off">
                    <option value="is_equal">'. esc_html__('is equal to', PCUD_ML) .'</option>
                    <option value="is_different" '. selected('is_different', $cond_data['operator'], false) .'>'. esc_html__('is different from', PCUD_ML) .'</option>
                    <option value="contains" '. selected('contains', $cond_data['operator'], false) .'>'. esc_html__('contains', PCUD_ML) .'</option>
                    <option value="not_contain" '. selected('not_contain', $cond_data['operator'], false) .'>'. esc_html__("does not contain", PCUD_ML) .'</option>
                    <option value="bigger" '. selected('bigger', $cond_data['operator'], false) .'>'. esc_html__("is bigger than", PCUD_ML) .'</option>
                    <option value="smaller" '. selected('smaller', $cond_data['operator'], false) .'>'. esc_html__("is smaller than", PCUD_ML) .'</option>
                </select>
                <input type="text" name="pcud_cond_val" value="'. esc_attr($cond_data['val']) .'" autocomplete="off" />
                <span class="pcud_del_field_cond pc_del_field dashicons dashicons-dismiss" title="'. esc_attr__('remove condition', PCUD_ML) .'"></span>
            </li>';    
        }
        
        return $code .'</ul>';
    }
    
    
    
    
    /* know whether a field is visible due to form conditions
     *
     * @param (string) $field_id
     * @param (array) $conditions 
     * @param (object) $form_class_obj = "pc_form" class instance
     * @param (int|false) $user_id 
     * @param (array|false) $form_vals = associative array of fetched form values. Use false to match against DB values (if user is logged) or all empty values
     *
     * @return (bool) 
     */
    public static function form_f_is_cond_vis($field_id, $conditions, $form_class_obj, $user_id = false, $form_vals = false) {
        if(!is_array($conditions) || !isset($conditions[$field_id]) || !$conditions[$field_id]) {
            return true;    
        }
        
        $f_cond_data    = $conditions[$field_id];
        $all_f_vals     = pcud_static::all_user_data_vals($user_id, $form_class_obj);
        
        if($form_vals) {
            $all_f_vals = array_merge($all_f_vals, $form_vals);    
        }
        
        
        // elaborate
        $is_vis = ($f_cond_data['def_vis'] == 'shown') ? true : false;
        $cond_responses = array();
        
        foreach($f_cond_data['conds'] as $cond) {
            if(!isset($all_f_vals[ $cond['field'] ])) {
                continue;    
            }
            
            $target_val = $all_f_vals[ $cond['field'] ];
            if(!is_array($target_val)) {
                $target_val = array($target_val);
            }
            
            $condition_satisfied = 0;
            
            // multi-choices - no selection case
            if(empty($target_val) && $cond['operator'] == 'is_equal' && $cond['val'] === '') {
                $condition_satisfied = 1;          
            }
            
            else {
                foreach($target_val as $val) {
                    if(
                        ($cond['operator'] == 'is_equal' && $val == $cond['val']) || 
                        ($cond['operator'] == 'is_different' && $val != $cond['val']) ||
                        ($cond['val'] !== '' && $cond['operator'] == 'contains' && strpos($val, $cond['val']) !== false) ||
                        ($cond['val'] !== '' && $cond['operator'] == 'not_contain' && strpos($val, $cond['val']) === false) ||
                        ($cond['val'] !== '' && $cond['operator'] == 'bigger' && (float)$val > (float)$cond['val']) ||
                        ($cond['val'] !== '' && $cond['operator'] == 'smaller' && (float)$val < (float)$cond['val'])
                    ) {
                        $condition_satisfied = 1;    
                    }
                }
            }
            $cond_responses[] = $condition_satisfied;
            
            // if satisfied and OR condition, stop here
            if($condition_satisfied && $f_cond_data['main_cond'] == 'OR') {
                break;    
            }
        }
        
        
        // iterate and return the final response
        if($f_cond_data['main_cond'] == 'OR') {
            return (in_array(1, $cond_responses)) ? !$is_vis : $is_vis;   
        } else {
            return (in_array(0, $cond_responses)) ? $is_vis : !$is_vis;       
        }
    }
    
    
}
