<?php
// GENERIC PLUGIN STATIC METHODS
class pcud_static {
	

    // fields to ignore in wizards
    public static function wizards_ignore_fields($use_cat = false) {
        include_once(PC_DIR .'/classes/pc_form_framework.php');
        $f_fw = new pc_form;	

        $fields = (array)$f_fw->no_wizard_indexes;
        if(!$use_cat) {
            $fields[] = 'categories';
        }

        return array_unique($fields); 	
    }
    
    
    
    
    // returns an associative array containing all possible form field indexes and related user data (empty value if no user logged)
    public static function all_user_data_vals($user_id = 'auto', $form_class_obj = false) {
        global $pc_users;
        
        if($user_id == 'auto') {
            $user_id = (isset($GLOBALS['pc_user_id'])) ? (int)$GLOBALS['pc_user_id'] : false;    
        }
        
        if(!$form_class_obj) {
            include_once(PC_DIR .'/classes/pc_form_framework.php');
            $form_class_obj = new pc_form;	        
        }
        $all_f_vals = array();
        
        // prepare an array for each possible form value
        if($user_id) {
            if(!isset($GLOBALS['pcud_f_cond_user_data'])) {
                global $pc_users;     
                $GLOBALS['pcud_f_cond_user_data'] = $pc_users->get_user($user_id, array('to_get' => array_keys($form_class_obj->fields)) );  
            }
            $all_f_vals = $GLOBALS['pcud_f_cond_user_data'];
        }
        else {
            foreach(array_keys($form_class_obj->fields) as $fid) {
                $all_f_vals[$fid] = '';    
            }        
        }
        
        
        // PCUD-FILTER - allows user field values filter, to control conditional fields visibilty
        return (array)apply_filters('pcud_all_user_data_vals', $all_f_vals, $user_id); 
    }
    
    
    
    
    // strip indexes from an associative array
    public static function strip_array_indices($ArrayToStrip) {
        foreach( $ArrayToStrip as $objArrayItem) {
            $NewArray[] =  $objArrayItem;
        }
        return($NewArray);
    }

    

    
    // get translated field name - WPML & Polylang integration
    public static function wpml_translated_string($index, $original_val, $context = 'label') {
        if(function_exists('icl_t')){
            switch($context) {
                case 'options' 	: $suffix = ' - options'; break;
                case 'placeh' 	: $suffix = ' - placeholder'; break;
                case 'check_txt': $suffix = ' - checkbox text'; break;
                default 		: $suffix = ' - label'; break;		
            }

            return icl_t('PrivateContent User Data',  $index.$suffix, $original_val);
        } 

        // Polylang
        if(function_exists('pll__')) {
            return pll__($original_val);	
        }

        return $original_val;
    }
    
}
