<?php
// CUSTOM POST TYPES AND TAXONOMIES DECLARATION


function pcud_cpt_n_ct() {

    // CUSTOM FIELDS TAXONOMY
    $labels = array( 
        'name'                       => esc_html__('Fields', PCUD_ML),
        'singular_name'              => esc_html__('Field', PCUD_ML),
        'search_items'               => esc_html__('Search Fields', PCUD_ML),
        'popular_items'              => esc_html__('Popular Fields', PCUD_ML),
        'all_items'                  => esc_html__('All Fields', PCUD_ML),
        'parent_item'                => esc_html__('Parent Field', PCUD_ML),
        'parent_item_colon'          => esc_html__('Parent Field:', PCUD_ML),
        'edit_item'                  => esc_html__('Edit Field', PCUD_ML),
        'update_item'                => esc_html__('Update Field', PCUD_ML),
        'add_new_item'               => esc_html__('Add New Field', PCUD_ML),
        'new_item_name'              => esc_html__('New Field', PCUD_ML),
        'separate_items_with_commas' => esc_html__('Separate fields with commas', PCUD_ML),
        'add_or_remove_items'        => esc_html__('Add or remove Fields', PCUD_ML),
        'choose_from_most_used'      => esc_html__('Choose from most used Fields', PCUD_ML),
        'menu_name'                  => esc_html__('Fields', PCUD_ML),
    );

    $args = array( 
        'labels' => $labels,
        'public' => false,
        'show_in_nav_menus' => false,
        'show_ui' => false,
        'show_tagcloud' => false,
        'hierarchical' => false,
        'rewrite' => false,
        'query_var' => true
    );
    register_taxonomy('pcud_fields', null, $args);
    
    
    
    // FIELD OPTIONS TAXONOMY
    $labels = array( 
        'name'                       => esc_html__('Options', PCUD_ML),
        'singular_name'              => esc_html__('Option', PCUD_ML),
        'search_items'               => esc_html__('Search Options', PCUD_ML),
        'popular_items'              => esc_html__('Popular Options', PCUD_ML),
        'all_items'                  => esc_html__('All Options', PCUD_ML),
        'parent_item'                => esc_html__('Parent Option', PCUD_ML),
        'parent_item_colon'          => esc_html__('Parent Option:', PCUD_ML),
        'edit_item'                  => esc_html__('Edit Option', PCUD_ML),
        'update_item'                => esc_html__('Update Option', PCUD_ML),
        'add_new_item'               => esc_html__('Add New Option', PCUD_ML),
        'new_item_name'              => esc_html__('New Option', PCUD_ML),
        'separate_items_with_commas' => esc_html__('Separate Options with commas', PCUD_ML),
        'add_or_remove_items'        => esc_html__('Add or remove Options', PCUD_ML),
        'choose_from_most_used'      => esc_html__('Choose from most used Options', PCUD_ML),
        'menu_name'                  => esc_html__('Options', PCUD_ML),
    );

    $args = array( 
        'labels' => $labels,
        'public' => false,
        'show_in_nav_menus' => false,
        'show_ui' => false,
        'show_tagcloud' => false,
        'hierarchical' => true,
        'rewrite' => false,
        'query_var' => true
    );
    register_taxonomy('pcud_f_opts', null, $args);
    
    
    
    // DATA-UPDATE FORMS TAXONOMY
    $labels = array( 
        'name'                       => esc_html__('Forms', PCUD_ML),
        'singular_name'              => esc_html__('Form', PCUD_ML),
        'search_items'               => esc_html__('Search Forms', PCUD_ML),
        'popular_items'              => esc_html__('Popular Forms', PCUD_ML),
        'all_items'                  => esc_html__('All Forms', PCUD_ML),
        'parent_item'                => esc_html__('Parent Form', PCUD_ML),
        'parent_item_colon'          => esc_html__('Parent Form:', PCUD_ML),
        'edit_item'                  => esc_html__('Edit Form', PCUD_ML),
        'update_item'                => esc_html__('Update Form', PCUD_ML),
        'add_new_item'               => esc_html__('Add New Form', PCUD_ML),
        'new_item_name'              => esc_html__('New Form', PCUD_ML),
        'separate_items_with_commas' => esc_html__('Separate forms with commas', PCUD_ML),
        'add_or_remove_items'        => esc_html__('Add or remove Forms', PCUD_ML),
        'choose_from_most_used'      => esc_html__('Choose from most used Forms', PCUD_ML),
        'menu_name'                  => esc_html__('Forms', PCUD_ML),
    );

    $args = array( 
        'labels' => $labels,
        'public' => false,
        'show_in_nav_menus' => false,
        'show_ui' => false,
        'show_tagcloud' => false,
        'hierarchical' => false,
        'rewrite' => false,
        'query_var' => true
    );
    register_taxonomy('pcud_forms', null, $args);
}
add_action('init', 'pcud_cpt_n_ct', 1);