<?php 
dike_lc('lcweb', PCUD_DIKE_SLUG, true); 

// RETRIEVE FIELDS  
$f_sorting = (isset($_COOKIE['pcud_fields_builder_sort'])) ? $_COOKIE['pcud_fields_builder_sort'] : 'name_asc';
$pcud_fields = pcud_fields_static::get_fields();   
?>

<div class="wrap pc_form pcud_fields_builder">  
	<h2 class="pc_page_title">PrivateContent - <?php _e('Custom Fields Builder', PCUD_ML) ?>
    	<a href="javascript:void(0)" class="add-new-h2" id="pcud_show_add_field"><?php _e('Add new field', PCUD_ML)?></a>
    </h2>  

    <form name="pcud_form" method="post" class="form-wrap pcud_cust_fields_form" action="<?php echo admin_url() ?>admin.php?page=pcud_fields_builder">  

		<div id="pcud_add_f_wrap" class="pc_displaynone">
            <h3><?php _e('Add new field', PCUD_ML) ?>
            	<small>(<?php _e('field index must to be unique and cannot be changed', PCUD_ML) ?>)</small>
            </h3>
            
            <table class="widefat pc_table pcud_fb_table">
              <tr><td class="pcud_addfield_wrap">
                <div class="pcud_field">
                    <label><?php _e('Field label', PCUD_ML) ?></label>
                    <input type="text" name="new_f_label" id="pcud_new_f_label" value="" autocomplete="off" />
                </div>
                
                <div class="pcud_field">
                    <label><?php _e('Field index', PCUD_ML) ?></label>
                    <input type="text" name="new_f_index" id="pcud_new_f_index" value="" placeholder="<?php esc_attr_e('leave empty to auto-generate from label', PCUD_ML) ?>" autocomplete="off" />
                </div>
                <div class="pcud_field">
                	<input type="button" name="pcud_new_f_create_index" id="pcud_new_f_create_index" class="button-secondary" value="<?php esc_attr_e('generate index', PCUD_ML); ?>" />
                </div>
             </td></tr>
            </table> 
        
       		<input type="button" name="pcud_add_field" value="<?php esc_attr_e('Add Field', PCUD_ML) ?>" class="button-primary" /> 
            <input type="button" name="pcud_dismiss_additon" value="<?php esc_attr_e('Cancel', PCUD_ML) ?>" class="button-secondary" /> 
            <hr/>
        </div>    

        <?php if($pcud_fields && count($pcud_fields) > 2) : ?>
            <div id="pcud_cf_top_cmd">
                <select name="pcud_cf_sorting" autocomplete="off">
                    <option value="name_asc"><?php esc_html_e('Sort by name (A-Z)', PCUD_ML) ?></option>
                    <option value="name_desc" <?php selected($f_sorting, "name_desc") ?>><?php esc_html_e('Sort by name (Z-A)', PCUD_ML) ?></option>
                    <option value="date_desc" <?php selected($f_sorting, "date_desc") ?>><?php esc_html_e('Sort by date (old-to-new)', PCUD_ML) ?></option>
                    <option value="date_asc" <?php selected($f_sorting, "date_asc") ?>><?php esc_html_e('Sort by date (new-to-old)', PCUD_ML) ?></option>
                </select>

                <small>( 
                    <a href="javascript:void(0)" class="collapse"><?php _e('collapse all', PCUD_ML) ?></a>
                    <a href="javascript:void(0)" class="pc_displaynone"><?php _e('expand all', PCUD_ML) ?></a> 
                )</small>
                
                <div id="pcud_cf_search"> 	
                    <input type="text" name="pcud_f_search" placeholder="🔍 <?php esc_attr_e("search field's name", PCUD_ML) ?>" autocomplete="off" />
                    <i id="pcud_fs_clear" class="dashicons dashicons-no-alt" title="<?php esc_attr_e('clear', PCUD_ML) ?>"></i>
                </div>  
            </div>  
        <?php endif; ?>    
    
        
        <div id="pcuf_cf_wrap">
            <?php
            if(empty($pcud_fields)) {
                echo '
                <div class="pcud_no_cust_fields">
                    <i class="dashicons dashicons-feedback"></i>
                    <span>.. '. __('no fields found', PCUD_ML) .' ..</span>
                </div>';    
            }
            
            else {
                $arrangments = (array)get_option('pcud_fields_arrang', array());
                ksort($arrangments);
                
                $f_to_be_printed = $pcud_fields;
                
                echo '
                <h2 class="nav-tab-wrapper lcwp_settings_tabs pcud_f_builder_tabs">';
                
                foreach(array_keys($arrangments) as $key => $sect_name) {
                    echo '
                    <a class="nav-tab pcud_cf_sect" href="#pcud_f_sect_'. (int)$key .'">
                        <span>'. esc_html($sect_name) .'</span>
                        
                        <em>
                            <i class="dashicons dashicons-edit" title="'. esc_attr__('edit section name', PCUD_ML) .'"></i>
                            <i class="dashicons dashicons-move" title="'. esc_attr__('sort section', PCUD_ML) .'"></i>
                            <i class="dashicons dashicons-no" title="'. esc_attr__('delete section', PCUD_ML) .'"></i>
                        </em>    
                    </a>';    
                }
                
                echo '
                    <a class="nav-tab pcud_cf_add_sect" href="javascript:void(0)" title="'. esc_attr__("add new section", PCUD_ML) .'">
                        <i class="dashicons dashicons-plus"></i>
                    </a> 
                </h2>';
                
                $a = 0;
                foreach($arrangments as $sect_name => $field_slugs) { 
                    echo '
                    <div id="pcud_f_sect_'. $a .'">';
                    
                        foreach((array)$field_slugs as $f_slug) {
                            if(isset($f_to_be_printed[$f_slug])) {
                                
                                echo pcud_fields_static::field_builder_block($pcud_fields[$f_slug], $pcud_fields, $pcud_fields[$f_slug]->pcud_opts);   
                                unset($f_to_be_printed[$f_slug]);
                            }
                        }
                    
                    echo '
                    </div>';
                    
                    $a++;
                }
                
                if(empty($arrangments) || !empty($f_to_be_printed)) {
                    echo '
                    <script type="text/javascript">
                    (function($) { 
                        "use strict"; 

                        $(".pcud_cf_add_sect").before(\'<a class="nav-tab pcud_cf_sect_unarranged" href="#pcud_f_sect_unarranged">('. esc_html__('Ungrouped', PCUD_ML) .')</a>\');
                    })(jQuery); 
                    </script>
                    
                    <div id="pcud_f_sect_unarranged">';
                    
                        foreach($f_to_be_printed as $field_slug => $term) {
                            echo pcud_fields_static::field_builder_block($term, $pcud_fields, $term->pcud_opts);
                        }        
                    
                    echo '
                    </div>';
                }
            }
            ?>
        </div>
        
        <input type="button" name="pcud_cf_submit" value="<?php esc_attr_e('Update Fields', PCUD_ML ) ?>" class="pcud_cf_submit button-primary" />  
    </form>
</div> 




<?php
// FIELDS ICON WIZARD
echo pc_static::fa_icon_picker_code( __('no icon', PC_ML), true);
?>

<script type="text/javascript">
(function($) { 
    "use strict"; 

    <?php pc_static::fa_icon_picker_js('pc_field_icon_trigger'); ?>
})(jQuery); 
</script>





<?php
// OPTIONS WIZARD LIGHTBOX
?>
<div id="pcud_f_opts_wizard_lb" class="pc_displaynone">
    <button title="<?php esc_attr_e('Close') ?>" type="button" class="mfp-close">×</button>
    
    <div class="pc_center_spinner">
        <div class="pc_spinner pc_spinner_big"></div>
    </div>
</div>
    
    



<?php // SCRIPTS ?>
<script type="text/javascript">
(function($) { 
    "use strict";
    
    const pcud_nonce    = `<?php echo wp_create_nonce('lcwp_ajax') ?>`;
    
	let pcud_is_acting = false,
        sel_sect = false;
    
	
    
	// show add-field box
	$(document).on('click', '#pcud_show_add_field', function() {
		if(pcud_is_acting) {
            return false;    
        }
        
        if($('#pcud_add_f_wrap').is(':hidden')) {
			$('#pcud_add_f_wrap').slideDown(300);	
			$(this).fadeOut();
		}
	});
	
    
    
    // dismiss addition form
    $(document).on('click', 'input[name="pcud_dismiss_additon"]', function() {
        if(pcud_is_acting) {
            return false;    
        }
        
        $('#pcud_add_f_wrap').slideUp(300, function() {
            $('#pcud_new_f_label, #pcud_new_f_index').val('');            
        });
        
        $('#pcud_show_add_field').show();
    });
    
    
    
	// generate field index via ajax
	$(document).on('click', '#pcud_new_f_create_index', function() {
		if(pcud_is_acting) {
            return false;    
        }
            
        var val = $.trim( $('#pcud_new_f_label').val());
        if(!val) {
            lc_wp_popup_message('error', "<?php esc_attr_e('Insert something in label field', PCUD_ML) ?>");
            return false;	
        }

        $(this).attr('disabled', 'disabled');
        pcud_is_acting = true;

        let data = {
            action: 'pcud_generate_index',
            f_label: val,
            pcud_nonce: pcud_nonce
        };
        $.post(ajaxurl, data, function(response) {
            $('#pcud_new_f_index').val(response);
        })
        .fail(function(e) {
            if(e.status) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e('Error generating the index', PCUD_ML) ?>");	
            }    
        })
        .always(function() {
            pcud_is_acting = false;   
            $('#pcud_new_f_create_index').removeAttr('disabled');
        });
	});
    
	
    
	// add new field 
	$(document).on('click', 'input[name="pcud_add_field"]', function() {
		const $btn = $(this),
              f_label = $.trim( $('#pcud_new_f_label').val() ),
              f_index = $.trim( $('#pcud_new_f_index').val() );
        
        if(pcud_is_acting || !f_label) {
            return false;    
        }
        
        // prior JS check against existing fields
        if(f_index && $('.pcud_fb_table[data-f_slug="'+ f_index +'"]').length) {
            lc_wp_popup_message('error', "<?php esc_attr_e('Another field has the same index', PCUD_ML) ?>");
            return false;
        }
        
        pcud_is_acting = true;
        $btn.fadeTo(200, 0.7);

        var data = {
            action: 'pcud_add_field',
            f_label: f_label,
            f_index: f_index,
            pcud_nonce: pcud_nonce
        };
        $.post(ajaxurl, data, function(response) {
            try {
                const resp = JSON.parse(response);

                if(resp.status == 'error') {
                    lc_wp_popup_message('error', resp.mess);
                }
                else {
                    lc_wp_popup_message('success', "<?php esc_attr_e('Field added successfully!', PCUD_ML) ?>");	
                    
                    if(!sel_sect) {
                        sel_sect = $('#pcuf_cf_wrap > div').first().attr('id');    
                    }
                    
                    $('#'+sel_sect).append(resp.code);
                    form_js_plugins_init();
                    
                    $('#pcud_new_f_label, #pcud_new_f_index').val(''); 
                    sort_fields();
                    
                    // wait for pcud_is_acting flag to be managed
                    setTimeout(function() {
                        $('input[name="pcud_dismiss_additon"]').trigger('click');
                        
                        // wait for pcud_dismiss_additon animation
                        setTimeout(function() {
                            const new_f_top_pos = $('.pcud_fb_table[data-f_id="'+ resp.term_id +'"]').offset().top;
                            $('html, body').animate({'scrollTop': new_f_top_pos - 45}, 500);  
                        }, 310);
                    }, 10);
                }
            }
            catch(e) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e('Error performing the action', PCUD_ML) ?>");

                pcud_is_acting = false;
                $btn.fadeTo(200, 1);
            }
        })
        .fail(function(e) {
            if(e.status) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e('Error adding field', PCUD_ML) ?>");	
            }    
        })
        .always(function() {
            pcud_is_acting = false;
            $btn.fadeTo(200, 1);
        });
	});
    
    
    
    // fields sorting (set cookie and execute)
    $(document).on('change', 'select[name="pcud_cf_sorting"]', function() {
        const val   = $(this).val(),
              d     = new Date();
        
        d.setTime(d.getTime() + (180 * 24 * 60 * 60 * 1000)); // 180 days
        let expires = "expires="+d.toUTCString();
        document.cookie = "pcud_fields_builder_sort=" + val + ";" + expires + ";path=/; ;domain=<?php echo COOKIE_DOMAIN ?>";
        
        sort_fields();
    });
		
	
    
    
    // add fields section
    $(document).on('click', '.pcud_cf_add_sect', function() {
        if(pcud_is_acting) {
            return false;    
        }
        
        let new_sect = prompt("<?php esc_attr_e("New section name", PCUD_ML) ?>", "");
        if(new_sect == null) {
            return false;
        }
        
        if(new_sect.trim().length < 3) {
            lc_wp_popup_message('error', "<?php esc_attr_e('Section name must be at least 3 characters long', PCUD_ML) ?>");	
            return false;    
        }
        
        const sanitized_name = esc_html(new_sect);
        
        let exists = false;
        $('.nav-tab span').each(function() {
            if(sanitized_name.toLowerCase() == esc_html($(this).text()).toLowerCase()) {
                exists = true;
            }
        });
        
        if(exists) {
            lc_wp_popup_message('error', "<?php esc_attr_e('Another section already has this name', PCUD_ML) ?>");	
            return false;    
        }
        
        const d = new Date(),
              time = d.getTime(); 
        
        const $target = ($('.pcud_cf_sect_unarranged').length) ? $('.pcud_cf_sect_unarranged') : $('.pcud_cf_add_sect');
        $target.before(`
            <a class="nav-tab pcud_cf_sect" href="#pcud_f_sect_${ time }">
                <span>${ sanitized_name }</span>

                <em>
                    <i class="dashicons dashicons-edit" title="<?php esc_attr_e('edit section name', PCUD_ML) ?>"></i>
                    <i class="dashicons dashicons-move" title="<?php esc_attr_e('sort section', PCUD_ML) ?>"></i>
                    <i class="dashicons dashicons-no" title="<?php esc_attr_e('delete section', PCUD_ML) ?>"></i>
                </em>
            </a>
        `);
        
        $('#pcuf_cf_wrap').append('<div id="pcud_f_sect_'+ time +'"></div>');
        
        sortable_sections();
        tabify();
    });
    
    
    
    // update fields section's name
    $(document).on('click', '.pcud_cf_sect em i:first-of-type', function() {
        if(pcud_is_acting) {
            return false;    
        }
        
        const $target = $(this).parents('a').first().find('span');
        const curr_name = $target.text();
        
        let sect_name = prompt("<?php esc_attr_e("Section name", PCUD_ML) ?>", curr_name);
        if(sect_name == null || sect_name == curr_name) {
            return false;
        }
        
        if(sect_name.trim().length < 3) {
            lc_wp_popup_message('error', "<?php esc_attr_e('Section name must be at least 3 characters long', PCUD_ML) ?>");	
            return false;    
        }
        
        const sanitized_name = esc_html(sect_name);
        
        let exists = false;
        $('.nav-tab span').each(function() {
            if(sanitized_name.toLowerCase() == esc_html($(this).text()).toLowerCase()) {
                exists = true;
            }
        });
        
        if(exists) {
            lc_wp_popup_message('error', "<?php esc_attr_e('Another section already has this name', PCUD_ML) ?>");	
            return false;    
        }
        
        $target.text(sanitized_name);
        sortable_sections();
    });
    
    
    
    // delete fields section
    $(document).on('click', '.pcud_cf_sect em i:last-of-type', function() {
        if(pcud_is_acting || !confirm("<?php esc_attr_e("Do you really want to remove this section?", PCUD_ML) ?>")) {
            return false;    
        }
        
        const $section = $(this).parents('a').first(),
              $sect_fields_wrap = $( $section.attr('href') );
        
        // be sure there are no fields in it
        if($sect_fields_wrap.find('.pcud_fb_table').length) {
            lc_wp_popup_message('error', "<?php esc_attr_e('The section must be empty to be deleted. Re-assign its fields please', PCUD_ML) ?>");	
            return false;    
        }
        
        $section.remove();
        $sect_fields_wrap.remove();
        
        // select another tab first
        $('.pcud_f_builder_tabs > a:not(.pcud_cf_add_sect)').first().click();
    });
    
    
    
    // assign field to another section - show modal
    $(document).on('click', '.pcud_cmd .pcud_move_field', function() {
        if(pcud_is_acting) {
            return false;    
        }
        const f_slug = $(this).parents('table').first().data('f_slug');
        
        let other_sections_opts = '';
        $('.pcud_cf_sect').each(function() {
            const name = esc_html($(this).find('span').text()),
                  container_id = $(this).attr('href').replace('#', '');
            
            if(container_id == sel_sect) {
                return true;    
            }
            
            other_sections_opts += '<option value="'+ container_id +'">'+ name +'</option>';
        });
        
        if(!other_sections_opts) {
            lc_wp_popup_message('error', "<?php esc_attr_e('Please create another section where to move fields', PCUD_ML) ?>");	
            return false;    
        }
        
            
        let code = `
        <form class="pcud_cf_ats_form">
            <h4><?php esc_attr_e("Which section to target?", PCUD_ML) ?></h4>
            <select name="pcud_cf_ats_sect">
                ${ other_sections_opts }
            </select>

            <input type='button' value='<?php esc_attr_e('Assign', PCUD_ML) ?>' class='button-primary pcud_assign_f_to_sect' data-f-slug="${ f_slug }" />
            <input type='button' value='<?php esc_attr_e('Close', PCUD_ML) ?>' class='button-secondary pcud_close_lc_modal' />
        </form>`;


        lc_wp_popup_message('modal', code);
        document.body.style.overflow = 'hidden';

        document.querySelector('.lcwpm_modal').classList.add('pcud_cf_ats_wrap');

        document.querySelector('.pcud_close_lc_modal').addEventListener('click', function(e) {
            close_lc_popup_modal();       
        });
        
    });
    

    
    // assign field to another section - show modal
    $(document).on('click', '.pcud_assign_f_to_sect', function() {
        const $target = $('#'+ $('select[name="pcud_cf_ats_sect"]').val());
        if(!$target.length) {
            alert('section not found');
            return false;    
        }
        
        const $table = $('[data-f_slug="'+ $(this).data('f-slug') +'"]').detach();
        $target.append($table);
        
        sort_fields();
        close_lc_popup_modal();
    });
    
    
    
    // get section assignments object or false if there are errors
    const get_f_sect_assignments = function() {
        let assign = {},
            error_found = false;
        
        $('.pcud_cf_sect').each(function() {
            const name = esc_html($(this).find('span').text()),
                  container_id = $(this).attr('href').replace('#', '');
            
            let sect_fields = [];
            
            if(!$('#'+ container_id +' > table').length) {
                lc_wp_popup_message('error', `<?php esc_attr_e('Section', PCUD_ML) ?> "${ name }" <?php esc_attr_e('is empty', PCUD_ML) ?>`);
                error_found = true;    
            }
            
            $('#'+ container_id +' > table').each(function() {
                sect_fields.push( $(this).data('f_slug') );
            });
            
            assign[ name ] = sect_fields;
        });
        
        return (error_found) ? false : JSON.stringify(assign);
    };
    
    
	
	// save fields
	$(document).on('click', '.pcud_cf_submit', function() {
        if(pcud_is_acting) {
            return false;    
        }
        pcud_is_acting = true;
        
        const $form = $('.pcud_cust_fields_form');
        
        $form.fadeTo(200, 0.65);
        $form.css('pointer-events', 'none');
        $('.pcud_fields_builder').css('cursor', 'wait');

        
        // trick to save section assignments through textarea and take advantage of serialize()
        if(!$form.find('textarea.pcud_f_assign_json').length) {
            $form.prepend('<textarea name="f_sect_assign" class="pcud_f_assign_json"></textarea>');    
        }
        const assignments = get_f_sect_assignments();
        if(!assignments) {
            return false;    
        }
        $form.find('textarea.pcud_f_assign_json').val(assignments);
        
        
        let data = 
            'action=pcud_save_fields' +
            '&pcud_nonce='+ pcud_nonce + '&' +
            $form.serialize();

        $.post(ajaxurl, data, function(response) {
            if($.trim(response) == 'success') {
                lc_wp_popup_message('success', "<?php esc_attr_e('Fields saved successfully!', PCUD_ML) ?>");
            }
            else {
                lc_wp_popup_message('error', response);
            } 
        })
        .fail(function(e) {
            if(e.status) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e('Error saving fields', PCUD_ML) ?>");	
            }    
        })
        .always(function() {
            $form.fadeTo(200, 1);
            $form.css('pointer-events', 'auto');
            $('.pcud_fields_builder').css('cursor', 'auto');
            
            pcud_is_acting = false;
        });
	});
    
	
	
	// delete field
	$(document).on('click', '.pcud_del_field', function() {
		if(!confirm('<?php esc_attr_e('Removing the field ANY related user data will be lost DEFINITIVELY, continue?', PCUD_ML) ?>') ) {
		  return false;	
        }
            
        const $subj     = $(this).parents('table'),
              f_id      = $subj.data('f_id'),
              f_slug    = $subj.data('f_slug');

        $subj.fadeTo(300, 0.7);
        $('.pcud_cf_submit').attr('disabled', 'disabled');

        var data = {
            action: 'pcud_del_field',
            f_id: f_id,
            f_slug: f_slug,
            pcud_nonce: pcud_nonce
        };
        $.post(ajaxurl, data, function(response) {
            if($.trim(response) == 'success') {
                $subj.fadeOut(function() {
                    $(this).remove();
                });
            }
            else {
                lc_wp_popup_message('error', response);
            } 
        })
        .fail(function(e) {
            if(e.status) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e('Error deleting the field', PCUD_ML) ?>");	
            }    
        })
        .always(function() {
            $subj.fadeTo(300, 1);
            $('.pcud_cf_submit').removeAttr('disabled');
        });
	});
    
    
    
    // bulk collapse fields
	$(document).on('click', '#pcud_cf_top_cmd small a', function() {
		if($(this).parent().find('.collapse').is(':hidden')) {
			$(this).parent().find('.collapse').show();
			$(this).parent().find('a:not(.collapse)').hide();
            
			$('.pcud_ec a.collapse').show();
            $('.pcud_ec a:not(.collapse)').hide();
            $('#pcuf_cf_wrap table tbody').show();
		}
		else {
			$(this).parent().find('.collapse').hide();
			$(this).parent().find('a:not(.collapse)').show();
            
            $('.pcud_ec a.collapse').hide();
            $('.pcud_ec a:not(.collapse)').show();
			$('#pcuf_cf_wrap table tbody').hide();
		}
	});
    
    
	
	// collapse fields
	$(document).on('click', '.pcud_ec a', function() {
		if($(this).parent().find('.collapse').is(':hidden')) {
			$(this).parent().find('.collapse').show();
			$(this).parent().find('a:not(.collapse)').hide();
			$(this).parents('table').find('tbody').show();	
		}
		else {
			$(this).parent().find('.collapse').hide();
			$(this).parent().find('a:not(.collapse)').show();
			$(this).parents('table').find('tbody').hide();	
		}
	});
	
    
	
	// toggles based on type + subtype
	$(document).on('change', '.f_type, .f_subtype', function() {
		const $parent   = $(this).parents('table'),
              type      = $parent.find('.f_type').val(),
              subtype   = $parent.find('.f_subtype').val();
		
		// subtype by type
		if(type == 'text') {
			$parent.find('.pcud_subtype').css('display', 'inline-block');
		} else {
			$parent.find('.pcud_subtype').hide();
		}
		
		// max-length
		if(
			(type != 'text') || 
			(type == 'text' && subtype != '')
		) {
			$parent.find('.pcud_maxlength').hide();	
		}
		else {
			$parent.find('.pcud_maxlength').css('display', 'inline-block');	
		}
		
		// num range
		if(type != 'text' || $.inArray(subtype, ['int', 'float']) === -1) {
			$parent.find('.pcud_num_range').hide();	
		} else {
			$parent.find('.pcud_num_range').css('display', 'inline-block');	
		}
        
        // date range
        if(type != 'text' || $.inArray(subtype, ['iso_date', 'eu_date', 'us_date']) === -1) {
			$parent.find('.pcud_date_range').hide();	
		} else {
			$parent.find('.pcud_date_range').css('display', 'inline-block');	
		}
        
        // time range
        if(type != 'text' || $.inArray(subtype, ['12h_time', '24h_time']) === -1) {
			$parent.find('.pcud_time_range').hide();	
		} else {
			$parent.find('.pcud_time_range').css('display', 'inline-block');	
		}
				
		// regex by type
		if((type == 'text' && $.inArray(subtype, ['iso_date', 'eu_date', 'us_date', '12h_time', '24h_time']) === -1) || type == 'textarea') {
			$parent.find('.pcud_regex').css('display', 'inline-block');
		} else {
			$parent.find('.pcud_regex').hide();
		}
		
		// options / combo opts by type
		if($.inArray(type, ['select', 'checkbox', 'radio']) === -1) {
			$parent.find('.pcud_combo_opts, .pcud_options').hide();
		} else {
			$parent.find('.pcud_combo_opts, .pcud_options').css('display', 'inline-block');
		}
		
		// multi-select by type
		if(type != 'select') {
			$parent.find('.pcud_f_multi_select').hide();
		} else {
			$parent.find('.pcud_f_multi_select').css('display', 'inline-block');
		}
		
		// placeholder by type
		if(
            $.inArray(type, ['text', 'textarea', 'select']) === -1 ||
            (type == 'text' && $.inArray(subtype, ['iso_date', 'eu_date', 'us_date', '12h_time', '24h_time']) !== -1) 
        ) {
			$parent.find('.pcud_placeh').hide();
		} else {
			$parent.find('.pcud_placeh').css('display', 'inline-block');
		}
        
		// helper by type
		if(type == 'single_checkbox') {
			$parent.find('.pcud_f_helper').hide();
		} else {
			$parent.find('.pcud_f_helper').css('display', 'inline-block');
		}
        
		// single checkbox/disclaimer text by type
		if(type != 'single_checkbox') {
			$parent.find('.pcud_f_check_txt, .pcud_f_disclaimer').hide();
		} else {
			$parent.find('.pcud_f_check_txt, .pcud_f_disclaimer').css('display', 'inline-block');
		}
		
		// field's icon by type
		if($.inArray(type, ['text', 'select']) === -1) {
			$parent.find('.pcud_f_icon').hide();
		} else {
			$parent.find('.pcud_f_icon').css('display', 'inline-block');
		}
        
        // field's unique val by type
		if($.inArray(type, ['text', 'textarea']) === -1) {
			$parent.find('.pcud_f_unique_val').hide();
		} else {
			$parent.find('.pcud_f_unique_val').css('display', 'inline-block');
		}
	});
	
	
    
	/* placeholder toggle for single/multiple dropdown */
	$(document).on('change', '.pcud_f_multi_select select', function() {
		const $parent = $(this).parents('table');
		
        if($(this).val()) {
            $parent.find('.pcud_dd_placeh_helper').hide();
        } else {
            $parent.find('.pcud_dd_placeh_helper').css('display', 'inline-block');
        }	
	});
	
	
	
    
	//////////////////////////////////////////////////////////
	
    
	
	
	//// live fields search
	
	// reset search and hide searchbar
	$(document).on('click', '#pcud_fs_clear', function() {
		$('input[name="pcud_f_search"]').val("");
		$(this).fadeOut(300);
		
		$('#pcuf_cf_wrap .pcud_fb_table').slideDown(300);
		$('#pcud_fs_no_result').remove();
	});
	
    
	// perform search
    let pcud_fs_keyup;
	$(document).on('keyup', 'input[name="pcud_f_search"]', function() {
		if(pcud_fs_keyup) {
            clearTimeout(pcud_fs_keyup);
        }
		
		pcud_fs_keyup = setTimeout(function() {
			var val = $('input[name="pcud_f_search"]').val();
			
			if(!val || val.length < 2) {
				$('#pcud_fs_clear').fadeOut(300);
				$('#pcud_fs_no_result').remove();
				$('#pcuf_cf_wrap .pcud_fb_table').slideDown(300);	
			}
			else {
				$('#pcud_fs_clear').fadeIn(300);
				
				var src_arr = val.toLowerCase().split(' ');
				var matched = 0;
				
				// cyle and check each searched term 
				$('#pcuf_cf_wrap .pcud_fb_table').each(function() {
					var src_attr = $(this).find('.pcud_f_label').val();
					var matching = false;
					
					$.each(src_arr, function(i, word) {						
						if( src_attr.toLowerCase().indexOf(word) !== -1 ) {
							matching = true;
							matched++;
							return false;	
						}
					});
					
					if(matching) {
						$(this).slideDown(300);
					} else {
						$(this).slideUp(300);	
					}
				});
				
				if(matched) {
					$('.pcud_no_cust_fields').remove();	
				} else {
					if(!$('.pcud_no_cust_fields').length) {
						$('#pcuf_cf_wrap').append(`
                        <div class="pcud_no_cust_fields">
                            <i class="dashicons dashicons-feedback"></i>
                            <span>.. <?php _e('no fields found', PCUD_ML) ?> ..</span>
                        </div>`);
					}
				}
			}
		}, 200);
	});

    
	
	//////////////////////////////////////////////////////////
	
    
	
    // load opts manager through lightbox
	$(document).on('click', 'input[name="pcud_man_opt_btn"]', function(e) {
		const $btn    = $(this),
              $wrap   = $btn.parents('.pcud_fb_table');
        
		$.magnificPopup.open({
            text: false,
			items : {
				src: '#pcud_f_opts_wizard_lb > *',
				type: 'inline'
			},
			mainClass	: 'pcud_f_opts_wizard',
			closeOnContentClick	: false,
			closeOnBgClick		: false, 
			preloader	: false,
			callbacks	: {
				beforeOpen: function() {
					$('body').addClass('pcud_fow_body_class'); 
                    
                    if($(window).width() < 800) {
					  this.st.focus = false;
					}
				},
				open : function() {
					const $lb      = $('.pcud_f_opts_wizard'),
                          fname    = $wrap.find('.pcud_f_label').val();
                    
                    // retrieve lightbox contents
                    let data = {
                        action      : 'pcud_load_fow_code',
                        f_id        : $wrap.data('f_id'),
                        f_name      : fname,
                        combo_opts  : $wrap.find('.pcud_combo_opts select').val(),
                        is_multiple : ($wrap.find('.f_type').val() == 'checkbox' || ($wrap.find('.f_type').val() == 'select' && $wrap.find('select[name="pcud_f_multi_select[]"]').val())) ? 1 : 0,
                        pcud_nonce  : pcud_nonce
                    };
                    $.post(ajaxurl, data, function(response) {
                        $lb.find('.pc_center_spinner').replaceWith(response);
                        
                        // sortable options
                        $lb.find('.pcud_fow_man_vals_table tbody').sortable({
                            handle: '.pcud_fow_move_opt',
                            items: "> tr:not(.pcud_first_fow_linked_val_tr)"
                        });
                        $lb.find('.pcud_fow_move_opt').disableSelection();
                        
                        
                        // LC select for combo dd
                        new lc_select('select[name="pcud_fow_linked_val"]', {
                            wrap_width : '100%',
                            addit_classes : ['lcslt-lcwp', 'pc_scw_field_dd'],
                        });
                    })
                    .fail(function(e) {
                        if(e.status) {
                            console.error(e);
                            $lb.find('.pc_center_spinner').replaceWith("<?php esc_attr_e('Error retrieving the data', PCUD_ML) ?>");	
                        }    
                    });
				},
                close: function() {
                    $('body').removeClass('pcud_fow_body_class');    
                },
            }
        });
	});
    
    
    
    // options type switch
    $(document).on('change', '.pcud_f_opts_wizard select[name="pcud_fow_opts_type"]', function() {
        const $subj = $('.pcud_f_opts_wizard .pcud_fow_elems_wrap');
        ($(this).val() == 'simple') ? $subj.addClass('pcud_fow_simple') : $subj.removeClass('pcud_fow_simple');
    });
    
    
    
    // options source switch
    $(document).on('change', '.pcud_f_opts_wizard select[name="pcud_fow_opts_comp"]', function() {
        const $lb = $('.pcud_f_opts_wizard'),
              val = $(this).val();
              
        if(val == 'manual') {
            $lb.find('.pcud_fow_man_vals_table, .pcud_fow_addbox').show();    
            $lb.find('.pcud_fow_contries_table').hide();
            $lb.find('.pcud_fow_states_table').hide();
        }
        else if(val == 'countries') {
            $lb.find('.pcud_fow_man_vals_table, .pcud_fow_addbox').hide();    
            $lb.find('.pcud_fow_contries_table').show(); 
            $lb.find('.pcud_fow_states_table').hide();
        }
        else if(val == 'states') {
            $lb.find('.pcud_fow_man_vals_table, .pcud_fow_addbox').hide();    
            $lb.find('.pcud_fow_contries_table').hide();  
            $lb.find('.pcud_fow_states_table').show();
        }
    });
    

    
    // escape option value, returning an attribute-safe string 
    const esc_str_for_attr = function(str) {
        return $.trim(str
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;')
        .replace(/'/g, '&#039;'));  
    };
    
    
    
    // add manual option
    $(document).on('click', '.pcud_fow_addbox_btn_wrap button', function() {
        const $lb       = $('.pcud_f_opts_wizard'),
              $table    = $lb.find('.pcud_fow_man_vals_table'),
              is_combo  = $lb.find('.pcud_fow_alv_wrap').length,
              
              opts_type = $lb.find('select[name="pcud_fow_opts_type"]').val(),
              label     = esc_str_for_attr($lb.find('input[name="pcud_fow_add_opt_label"]').val()),
              val       = (opts_type == 'simple') ? label : esc_str_for_attr($lb.find('input[name="pcud_fow_add_opt_val"]').val());
        
        if(!val || !label) {
            lc_wp_popup_message('error', "<?php esc_attr_e('Please fill the fields', PCUD_ML) ?>");	
            return false;
        }
        
        // check for existing values
        let existing = false;
        $table.find('input[name="pcud_fow_opt_val"]').each(function() {
            
            if(esc_str_for_attr($(this).val()) == val) {
                existing = true;
                return false;    
            }
        });
        
        if(existing) {
            lc_wp_popup_message('error', "<?php esc_attr_e('There is another option with the same value', PCUD_ML) ?>");	
            return false;
        }
        
        const def_val_ftype = (parseInt($lb.find('input[name="pcud_fow_is_multiple"]').val(), 10)) ? 'checkbox' : 'radio';
        
        const def_val_fcode = (is_combo) ? '' : 
            `<td>
                <input type="${ def_val_ftype }" name="pcud_fow_def_sel" value="${ Math.random().toString(36).substr(2, 9) }" autocomplete="off" />
            </td>`;
        
        
        $table.find('tbody').append(`
        <tr>
            <td>
                <input type="text" name="pcud_fow_opt_val" value="${ val }" autocomplete="off" maxlength="150" />
            </td>
            <td>
                <input type="text" name="pcud_fow_opt_label" value="${ label }" autocomplete="off" maxlength="150" />
            </td>
            ${ def_val_fcode }
            <td>
                <span class="pcud_fow_move_opt pc_move_field dashicons dashicons-move" title="<?php esc_attr_e('sort option', PCUD_ML) ?>"></span>
            </td>
            <td>
                <span class="pcud_fow_del_opt pc_del_field dashicons dashicons-no-alt" title="<?php esc_attr_e('delete option', PCUD_ML) ?>"></span>
            </td>
        </tr>`); 
        
        $lb.find('.pcud_fow_addbox input[type=text]').val('');
        
        // sortable options
        $lb.find('.pcud_fow_man_vals_table tbody').sortable({
            handle: '.pcud_fow_move_opt'
        });
        $lb.find('.pcud_fow_move_opt').disableSelection();
    });
    
    
    
    // remove manual option
    $(document).on('click', '.pcud_fow_del_opt', function() {
        $(this).parents('tr').remove();
    });
    
    
    
    // add option on enter keypress
    $(document).on('keyup', '.pcud_fow_addbox input[type=text]', function(e) {
        if(e.keyCode === 13){
            $(this).parents('.pcud_fow_addbox').find('.button-primary').trigger('click');
            e.preventDefault();
            return false;
        }            
    }); 
    
    
    
    // combo-dropdown - be sure the same option is not set in multiple cases
    const dd_selector = 'select[name="pcud_fow_linked_val"]';
    $(document).off('change', dd_selector).on('change', dd_selector, function() {
        const $dd = $(this),
              sel = $(this).val();

        if(!sel.length) {
            return true;    
        }

        // check in other dropdowns
        let already_taken = []; 

        $(dd_selector).not(this).each(function() {

            const dd_val = $(this).val(); 
            already_taken = [...already_taken, ...dd_val];
        });

        if(!already_taken.length) {
            return true;    
        }

        let to_remove = false;
        $.each(sel, function(i, v) {
            if($.inArray(v, already_taken) !== -1) {
                to_remove = v;
                return false;
            }
        });

        if(to_remove) {
            lc_wp_popup_message('error', "<?php esc_attr_e('This option is already taken', PCUD_ML) ?>");
            $dd.find('option[value="'+ to_remove +'"]').removeAttr('selected');

            const resyncEvent = new Event('lc-select-refresh');
            $dd[0].dispatchEvent(resyncEvent);
        }    
    });
    
    
    
    // options save
    let is_saving_opts = false;
    $(document).on('click', '.pcud_fow_comp_save_wrap button', function() {
        const $lb       = $('.pcud_f_opts_wizard'),
              $btn      = $(this),
              comp      = $lb.find('select[name="pcud_fow_opts_comp"]').val(),
              is_combo  = $lb.find('.pcud_fow_alv_wrap').length;
        
        let opts = (is_combo) ? {} : [],
            abort_save = false;
            
        if(comp == 'manual') {
        
            // retrieve options
            let vals    = [], // array used to find doubled vals
                doubled = [],
                active_linked_opt = false;
            
            $lb.find('.pcud_fow_man_vals_table tbody tr').each(function() {

                if($(this).hasClass('pcud_fow_linked_val_tr')) {
                    const linked_opt = $(this).find('select').val().join('|||');
                    
                    if(!linked_opt) {
                        lc_wp_popup_message('error', "<?php esc_attr_e('Please select at least one linked option', PCUD_ML) ?>");	
                        abort_save = true;
                        return false;    
                    }
                    
                    active_linked_opt = linked_opt;
                    opts[linked_opt] = [];
                    return true;
                }

                const val   = $.trim( $(this).find('input[name="pcud_fow_opt_val"]').val() ),
                      label = $.trim( $(this).find('input[name="pcud_fow_opt_label"]').val() ); 

                if($.inArray(val, vals) !== -1) {
                    doubled.push(val);    
                }
                vals.push(val);
                
                if(is_combo) {
                    opts[active_linked_opt].push({
                        val     : val,
                        label   : label
                    });    
                }
                else {
                    opts.push({
                        val     : val,
                        label   : label
                    });
                }
            });

            // errors reporting
            if(!abort_save && vals.length < 2) {
                lc_wp_popup_message('error', "<?php esc_attr_e('Please insert at least two options', PCUD_ML) ?>");	
                abort_save = true;
            }
            else if(!abort_save && doubled.length) {
                lc_wp_popup_message('error', "<?php esc_attr_e('There are doubled values', PCUD_ML) ?>: "+ doubled.join(", "));	
                abort_save = false;  
            }
        }
        
        // save
        if(abort_save || is_saving_opts) {
            return false;    
        }
        $btn.fadeTo(300, 0.5);
        is_saving_opts = true;
        
        
        // get default chosen value
        let def_choice = [];
        if(!is_combo) {
            $lb.find('input[name="pcud_fow_def_sel"]:checked').each(function() {
                
                if($(this).parents('.pcud_fow_contries_table').length) {
                    def_choice.push( $(this).parents('tr').find('td').first().text() );   
                }
                else {
                    def_choice.push( $.trim( $(this).parents('tr').find('input[name="pcud_fow_opt_val"]').val()) );    
                }
            });
        }
        
        // ajax
        let data = {
            action      : 'pcud_fow_save_opts',
            f_id        : parseInt($lb.find('input[name="pcud_fow_fid"]').val(), 10),
            type        : $lb.find('select[name="pcud_fow_opts_type"]').val(),
            comp        : comp,
            sorting     : $lb.find('select[name="pcud_fow_opts_sort"]').val(),
            is_combo    : (is_combo) ? 1 : 0,
            opts        : JSON.stringify(opts),
            def_choice  : def_choice,
            pcud_nonce  : pcud_nonce
        };
        $.post(ajaxurl, data, function(response) {
            if($.trim(response) == 'success') {
                lc_wp_popup_message('success', "<?php esc_attr_e('Options saved successfully!', PCUD_ML) ?>");        
            } else {
                lc_wp_popup_message('error', response);    
            }
        })
        .fail(function(e) {
            if(e.status) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e('Error saving options', PCUD_ML) ?>");
            }    
        })
        .always(function() {
            $btn.fadeTo(300, 1);
            is_saving_opts = false;        
        });
    });
    
    
    
	//////////////////////////////////////////////////////////
	
    
	
	// fixed submit position
	const pcud_fixed_submit = function(btn_selector) {
		var $subj = $(btn_selector);
		if(!$subj.length) {
            return false;
        }
		
		var clone = $subj.clone().wrap("<div />").parent().html();

		setInterval(function() {
			
			// if page has scrollers or scroll is far from bottom
			if(($(document).height() > $(window).height()) && ($(document).height() - $(window).height() - $(window).scrollTop()) > 130) {
				if(!$('.lcwp_settings_fixed_submit').length) {	
					$subj.after('<div class="lcwp_settings_fixed_submit">'+ clone +'</div>');
				}
			}
			else {
				if($('.lcwp_settings_fixed_submit').length) {	
					$('.lcwp_settings_fixed_submit').remove();
				}
			}
		}, 50);
	};
	pcud_fixed_submit('.pcud_cf_submit');
	
	
    
	//////////////////////////////////////////////////////////
	
    
    // tabify (dynamic)
    const tabify = function() {
        $('.lcwp_settings_tabs').each(function() {
            var sel = '';
            var hash = window.location.hash;

            var $form = $(".pcud_cust_fields_form");
            var form_act = $form.attr('action');

            // if no active - set first as active
            if(!$(this).find('.nav-tab-active').length) {
                $(this).find('.nav-tab').first().addClass('nav-tab-active');	
            }

            // hide unselected
            $(this).find('.nav-tab').each(function() {
                var id = $(this).attr('href');

                if($(this).hasClass('nav-tab-active')) {
                    sel = id
                }
                else {
                    $(id).hide();
                }
            });
            
            
            // track clicks
            if(sel) {
                $(this).find('.nav-tab:not(.pcud_cf_add_sect)').off('click').on('click', function(e) {
                    e.preventDefault();

                    // do not target section editing icon
                    if($(e.target).hasClass('dashicons-edit') || $(this).hasClass('nav-tab-active')) {
                        return true;    
                    }
                    
                    var sel_id = $(this).attr('href');
                    
                    var hashless = sel_id.replace('#', '');
                    sel_sect = hashless;

                    // show selected and hide others
                    $(this).parents('.lcwp_settings_tabs').find('.nav-tab').each(function() {
                        var id = $(this).attr('href');

                        if(sel_id == id) {
                            $(this).addClass('nav-tab-active');
                            $(id).show();		
                        }
                        else {
                            $(this).removeClass('nav-tab-active');
                            $(id).hide();	
                        }
                    });
                    
                    sort_fields();
                });
            }
        });    
    };
        
        
        
    // sanitize string to be used in HTML attributes
    const esc_html = function(string) {
        const map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#x27;',
            "/": '&#x2F;',
        };
        const reg = /[&<>"'/]/ig;
        return string.replace(reg, (match)=>(map[match]));
    };    
    
    
    
    // close lc popup modal
    const close_lc_popup_modal = () => {
        window.lcwpm_close();
        document.body.style.overflow = 'auto';
    };
    
    
    
    // sortable section tabs
    const sortable_sections = function() {
        $('.pcud_f_builder_tabs').sortable({
            handle      : "i.dashicons-move",
            items       : "> .pcud_cf_sect",
        }).disableSelection();
    };
    
    
    
    // sort sections alphabetically
    const sort_fields = function() {
        const sorting           = $('select[name="pcud_cf_sorting"]').val(),
              target_data_attr  = (sorting.indexOf('name_') !== -1) ? 'f_slug' : 'f_id',
              reverse           = (
                  (sorting.indexOf('name_') !== -1 && sorting.indexOf('_desc') !== -1) ||
                  (sorting.indexOf('name_') === -1 && sorting.indexOf('_desc') === -1)
              ) ? true : false;
        
        $('#pcuf_cf_wrap > div').each(function() {
            const $wrap = $(this);
            let $items = $wrap.find(' > table').get(); 
            
            $items.sort(function(a, b) {
               return $(a).data(target_data_attr).toString().toLowerCase().localeCompare( 
                   $(b).data(target_data_attr).toString().toLowerCase(), 
                   undefined, 
                   {numeric: true, sensitivity: 'base'}
               );
            });
            
            if(reverse) {
                $items = $items.reverse();    
            }
            
            $.each($items, function(idx, itm) {
                $wrap.append(itm);
            });   
        });
    };
    
    
    
    // auto-height textarea
    window.lcwp_sf_textAreaAdjust = function(o) {
        o.style.height = "1px";

        let new_h = 4 + o.scrollHeight;
        if(new_h < 28) {
            new_h = 28;    
        }

        o.style.height = new_h +"px";
    };


    // fixed submit position
    const lcwp_sf_fixed_submit = function(btn_selector) {
        const $subj = $(btn_selector);
        if(!$subj.length) {
            return false;
        }

        let clone = $subj.clone().wrap("<div />").parent().html();

        setInterval(function() {

            // if page has scrollers or scroll is far from bottom
            if(($(document).height() > $(window).height()) && ($(document).height() - $(window).height() - $(window).scrollTop()) > 130) {
                if(!$('.pcud_fixed_submit').length) {	
                    $subj.after('<div class="pcud_fixed_submit">'+ clone +'</div>');
                }
            }
            else {
                if($('.pcud_fixed_submit').length) {	
                    $('.pcud_fixed_submit').remove();
                }
            }
        }, 50);
    };
    
    
    
    // initialize JS plugins for form fields
    const form_js_plugins_init = function() {
        // lc switch
		lc_switch('.pc_lc_switch', {
            on_txt      : "<?php echo strtoupper(esc_attr__('yes')) ?>",
            off_txt     : "<?php echo strtoupper(esc_attr__('no')) ?>",   
        });
        
        
        // LC select
        new lc_select('.pcud_lcslt', {
            wrap_width : '100%',
            addit_classes : ['lcslt-lcwp'],
        });
        
        
        // sliders
        new lc_range_n_num('.pcud_val_n_num', {
            unit_width: 40    
        }); 
        
        
        $('.pcud_fb_table textarea').each(function() {
            lcwp_sf_textAreaAdjust(this);    
        });
    };
    
    
    
    // operations on page ready
	$(document).ready(function() {
        
        // tabify and sort
        $("html, body").animate({scrollTop: 0}, 0);
        
        tabify();
        sortable_sections();
        sort_fields();
        
        form_js_plugins_init();
        
        lcwp_sf_fixed_submit('.pcud_cf_submit');
	});
    
})(jQuery);    
</script>