<?php
// Handle AJAX call for data-update forms

//add_action('pvtcont_init', 'pcud_handle_custom_form', 50); // be sure taxonomies have been registered and auths performed

function pcud_custom_form_submit() { 
    global $wpdb, $pc_users;
    require_once(PC_DIR .'/classes/pc_form_framework.php');
		
    $f_fw = new pc_form;
    $form_id = pc_static::decrypt_number($_POST['pcud_fid']); 
    $f_fw->form_term_id = $form_id;
		
    // check for logged users
    $pc_logged = pc_user_logged(false);
    if($pc_logged === false && !pc_wpuc_static::current_wp_user_bypass_restrictions()) {
        wp_die(json_encode(array( 
            'resp' => 'error',
            'mess' => __('You must be logged to use this form', PCUD_ML) 
        )));
    }


    ////////// VALIDATION ////////////////////////////////////

    // get form structure	
    $term = get_term_by('id', $form_id, 'pcud_forms');
    if(empty($term)) {
        wp_die(json_encode(array( 
            'resp' => 'error',
            'mess' => __('Form not found', PCUD_ML) 
        )));
    }

    // retrocompatibility
    $form_fields = (empty($term->description)) ? (array)get_option('pcud_form_'.$form_id, array()) : unserialize(base64_decode($term->description));


    $indexes = $f_fw->generate_validator( pcud_fields_static::v2_field_names_sanitize($form_fields), array());

    $is_valid = $f_fw->validate_form($indexes, $cust_errors = array(), false, false, $form_id, 'pcud_forms');	
    $fdata = $f_fw->form_data;

    if(!$is_valid) {
        $error = $f_fw->errors;
    }
    else {
        $GLOBALS['pc_updating_user'] = true; // report that is updating user - avoid logout
        $redirect = '';
        
        // check for redirects
        if(isset($form_fields['redirect']) && !empty($form_fields['redirect'])) {
            if($form_fields['redirect'] == 'refresh') {
                $redirect = 'refresh';    
            }
            else {
                $redirect = ($form_fields['redirect'] == 'custom') ? $form_fields['cust_redir'] : get_permalink($form_fields['redirect']);    
            }
        }

        // if not PC user - stop here
        if(!$pc_logged) {
            wp_die(json_encode(array( 
                'resp' 		=> 'success',
                'mess' 		=> __('Form submitted successfully.<br/> Not logged as PrivateContent user, nothing has been saved', PCUD_ML),
                'redirect'	=> $redirect
            )));	
        }

        
        // PCUD-ACTION - before user data are updated - passes form data,  form ID and form term data
        do_action('pcud_pre_user_data_update', $fdata, $form_id, $form_fields);
        
        
        // update user
        $result = $pc_users->update_user($GLOBALS['pc_user_id'], $fdata);
        if(!$result) {
            $error = $pc_users->validation_errors;	
        }
    }

    
    // results
    if(isset($error) && !empty($error)) {
        wp_die(json_encode(array( 
            'resp' => 'error',
            'mess' => $error
        )));
    }
    
    
    
    // if is updating password - sync also cookie
    if(isset($fdata['psw'])) {
        $encrypted_psw = $pc_users->get_user_field($GLOBALS['pc_user_id'], 'psw');
        $cookie_data = array($GLOBALS['pc_user_id'], $encrypted_psw);

        if(isset($_COOKIE['pc_remember_login'])) {
            $basic_cookie_time = (get_option('pg_no_cookie_login')) ? 600 : (3600); // 10 or 60 minutes
            pc_static::setcookie('pc_user', implode('|||', $cookie_data), (time() + $basic_cookie_time));        
        }
        else {
            $refresh_timing = time() + (3600 * 24 * 14); // (WP remember me timing)
            pc_static::setcookie('pc_user', implode('|||', $cookie_data), $refresh_timing);   
        }
    }


    // Create Google Analytics event
    if(isset($GLOBALS['pc_google_analytics'])) {
        $params = array(
            't'		=> 'event',
            'ec'	=> 'User Data add-on',
            'ea'	=> 'custom_form_save',
            'el'	=> 'Form "'. $term->name .'" saved',
            'ni'	=> 0,
        );
        $GLOBALS['pc_google_analytics']->call($params, $GLOBALS['pc_user_id']);
    }


    // PCUD-ACTION - user updated its data - passes form data,  form ID and form term data
    do_action('pcud_user_updated_data', $fdata, $form_id, $form_fields);	


    // custom message
    if(isset($form_fields['cust_mess']) && !empty($form_fields['cust_mess'])) {
        if(function_exists('icl_t')) {
            $mess = icl_t('PrivateContent User Data', 'Form #'.$form_id.' - custom message', $form_fields['cust_mess']);
        } else {
            $mess = $form_fields['cust_mess'];	
        }
    } 
    else {
        $mess = __('Data saved successfully', PCUD_ML);
    }


    // success message
    wp_die(json_encode(array( 
        'resp' 		=> 'success',
        'mess' 		=> $mess,
        'redirect'	=> $redirect,
        'fid'       => $form_id,
    )));
}
add_action('wp_ajax_pcud_custom_form_submit', 'pcud_custom_form_submit');
add_action('wp_ajax_nopriv_pcud_custom_form_submit', 'pcud_custom_form_submit');




// Create Google Analytics event
function pcud_cf_saved($calls) {
	$calls['pcud_cf_save'] = array(
		't'		=> 'event',
		'ec'	=> 'User Data add-on',
		'ea'	=> 'data_update_form_save',
		'el'	=> 'Data-update '. $_POST['pcud_fid'] .' saved',
		'ni'	=> 0,
	);
	return $calls;	
}




// pcma settings - send e-mail
function pcud_pcma_send_email($indexes, $form_id, $form_data) {
    
    if(
        !function_exists('pcma_is_active') || !pcma_is_active() || !get_option('pcud_sf_admin_notif') ||
        (isset($form_data['no_mail_notif']) && $form_data['no_mail_notif'])
    ) {
        return false;
    }

    $txt = pcma_replace_placeholders($GLOBALS['pc_user_id'], get_option('pcud_sfan_txt'));
    $title = pcma_replace_placeholders($GLOBALS['pc_user_id'], get_option('pcud_sfan_title'));
    
    // format is string, eventually comma split
    $receivers = get_option('pcud_sfan_receivers');
    if(is_array($receivers)) {
        $receivers = implode(',', $receivers);    
    }
    
    $mail_sent = pcma_send_mail('', $receivers, $title, $txt);
}
add_action('pcud_user_updated_data', 'pcud_pcma_send_email', 10, 3);