<?php
$GLOBALS['pcud_states'] = array(
	'AF' => array(),
	'AO' => array( // Angola states.
		'BGO' => __( 'Bengo', 'pcud_ml'),
		'BLU' => __( 'Benguela', 'pcud_ml'),
		'BIE' => __( 'Bié', 'pcud_ml'),
		'CAB' => __( 'Cabinda', 'pcud_ml'),
		'CNN' => __( 'Cunene', 'pcud_ml'),
		'HUA' => __( 'Huambo', 'pcud_ml'),
		'HUI' => __( 'Huíla', 'pcud_ml'),
		'CCU' => __( 'Kuando Kubango', 'pcud_ml'),
		'CNO' => __( 'Kwanza-Norte', 'pcud_ml'),
		'CUS' => __( 'Kwanza-Sul', 'pcud_ml'),
		'LUA' => __( 'Luanda', 'pcud_ml'),
		'LNO' => __( 'Lunda-Norte', 'pcud_ml'),
		'LSU' => __( 'Lunda-Sul', 'pcud_ml'),
		'MAL' => __( 'Malanje', 'pcud_ml'),
		'MOX' => __( 'Moxico', 'pcud_ml'),
		'NAM' => __( 'Namibe', 'pcud_ml'),
		'UIG' => __( 'Uíge', 'pcud_ml'),
		'ZAI' => __( 'Zaire', 'pcud_ml'),
	),
	'AR' => array( // Argentinian provinces.
		'C' => __( 'Ciudad Autónoma de Buenos Aires', 'pcud_ml'),
		'B' => __( 'Buenos Aires', 'pcud_ml'),
		'K' => __( 'Catamarca', 'pcud_ml'),
		'H' => __( 'Chaco', 'pcud_ml'),
		'U' => __( 'Chubut', 'pcud_ml'),
		'X' => __( 'Córdoba', 'pcud_ml'),
		'W' => __( 'Corrientes', 'pcud_ml'),
		'E' => __( 'Entre Ríos', 'pcud_ml'),
		'P' => __( 'Formosa', 'pcud_ml'),
		'Y' => __( 'Jujuy', 'pcud_ml'),
		'L' => __( 'La Pampa', 'pcud_ml'),
		'F' => __( 'La Rioja', 'pcud_ml'),
		'M' => __( 'Mendoza', 'pcud_ml'),
		'N' => __( 'Misiones', 'pcud_ml'),
		'Q' => __( 'Neuquén', 'pcud_ml'),
		'R' => __( 'Río Negro', 'pcud_ml'),
		'A' => __( 'Salta', 'pcud_ml'),
		'J' => __( 'San Juan', 'pcud_ml'),
		'D' => __( 'San Luis', 'pcud_ml'),
		'Z' => __( 'Santa Cruz', 'pcud_ml'),
		'S' => __( 'Santa Fe', 'pcud_ml'),
		'G' => __( 'Santiago del Estero', 'pcud_ml'),
		'V' => __( 'Tierra del Fuego', 'pcud_ml'),
		'T' => __( 'Tucumán', 'pcud_ml'),
	),
	'AT' => array(),
	'AU' => array( // Australian states.
		'ACT' => __( 'Australian Capital Territory', 'pcud_ml'),
		'NSW' => __( 'New South Wales', 'pcud_ml'),
		'NT'  => __( 'Northern Territory', 'pcud_ml'),
		'QLD' => __( 'Queensland', 'pcud_ml'),
		'SA'  => __( 'South Australia', 'pcud_ml'),
		'TAS' => __( 'Tasmania', 'pcud_ml'),
		'VIC' => __( 'Victoria', 'pcud_ml'),
		'WA'  => __( 'Western Australia', 'pcud_ml'),
	),
	'AX' => array(),
	'BD' => array( // Bangladeshi states (districts).
		'BD-05' => __( 'Bagerhat', 'pcud_ml'),
		'BD-01' => __( 'Bandarban', 'pcud_ml'),
		'BD-02' => __( 'Barguna', 'pcud_ml'),
		'BD-06' => __( 'Barishal', 'pcud_ml'),
		'BD-07' => __( 'Bhola', 'pcud_ml'),
		'BD-03' => __( 'Bogura', 'pcud_ml'),
		'BD-04' => __( 'Brahmanbaria', 'pcud_ml'),
		'BD-09' => __( 'Chandpur', 'pcud_ml'),
		'BD-10' => __( 'Chattogram', 'pcud_ml'),
		'BD-12' => __( 'Chuadanga', 'pcud_ml'),
		'BD-11' => __( "Cox's Bazar", 'pcud_ml'),
		'BD-08' => __( 'Cumilla', 'pcud_ml'),
		'BD-13' => __( 'Dhaka', 'pcud_ml'),
		'BD-14' => __( 'Dinajpur', 'pcud_ml'),
		'BD-15' => __( 'Faridpur ', 'pcud_ml'),
		'BD-16' => __( 'Feni', 'pcud_ml'),
		'BD-19' => __( 'Gaibandha', 'pcud_ml'),
		'BD-18' => __( 'Gazipur', 'pcud_ml'),
		'BD-17' => __( 'Gopalganj', 'pcud_ml'),
		'BD-20' => __( 'Habiganj', 'pcud_ml'),
		'BD-21' => __( 'Jamalpur', 'pcud_ml'),
		'BD-22' => __( 'Jashore', 'pcud_ml'),
		'BD-25' => __( 'Jhalokati', 'pcud_ml'),
		'BD-23' => __( 'Jhenaidah', 'pcud_ml'),
		'BD-24' => __( 'Joypurhat', 'pcud_ml'),
		'BD-29' => __( 'Khagrachhari', 'pcud_ml'),
		'BD-27' => __( 'Khulna', 'pcud_ml'),
		'BD-26' => __( 'Kishoreganj', 'pcud_ml'),
		'BD-28' => __( 'Kurigram', 'pcud_ml'),
		'BD-30' => __( 'Kushtia', 'pcud_ml'),
		'BD-31' => __( 'Lakshmipur', 'pcud_ml'),
		'BD-32' => __( 'Lalmonirhat', 'pcud_ml'),
		'BD-36' => __( 'Madaripur', 'pcud_ml'),
		'BD-37' => __( 'Magura', 'pcud_ml'),
		'BD-33' => __( 'Manikganj ', 'pcud_ml'),
		'BD-39' => __( 'Meherpur', 'pcud_ml'),
		'BD-38' => __( 'Moulvibazar', 'pcud_ml'),
		'BD-35' => __( 'Munshiganj', 'pcud_ml'),
		'BD-34' => __( 'Mymensingh', 'pcud_ml'),
		'BD-48' => __( 'Naogaon', 'pcud_ml'),
		'BD-43' => __( 'Narail', 'pcud_ml'),
		'BD-40' => __( 'Narayanganj', 'pcud_ml'),
		'BD-42' => __( 'Narsingdi', 'pcud_ml'),
		'BD-44' => __( 'Natore', 'pcud_ml'),
		'BD-45' => __( 'Nawabganj', 'pcud_ml'),
		'BD-41' => __( 'Netrakona', 'pcud_ml'),
		'BD-46' => __( 'Nilphamari', 'pcud_ml'),
		'BD-47' => __( 'Noakhali', 'pcud_ml'),
		'BD-49' => __( 'Pabna', 'pcud_ml'),
		'BD-52' => __( 'Panchagarh', 'pcud_ml'),
		'BD-51' => __( 'Patuakhali', 'pcud_ml'),
		'BD-50' => __( 'Pirojpur', 'pcud_ml'),
		'BD-53' => __( 'Rajbari', 'pcud_ml'),
		'BD-54' => __( 'Rajshahi', 'pcud_ml'),
		'BD-56' => __( 'Rangamati', 'pcud_ml'),
		'BD-55' => __( 'Rangpur', 'pcud_ml'),
		'BD-58' => __( 'Satkhira', 'pcud_ml'),
		'BD-62' => __( 'Shariatpur', 'pcud_ml'),
		'BD-57' => __( 'Sherpur', 'pcud_ml'),
		'BD-59' => __( 'Sirajganj', 'pcud_ml'),
		'BD-61' => __( 'Sunamganj', 'pcud_ml'),
		'BD-60' => __( 'Sylhet', 'pcud_ml'),
		'BD-63' => __( 'Tangail', 'pcud_ml'),
		'BD-64' => __( 'Thakurgaon', 'pcud_ml'),
	),
	'BE' => array(),
	'BG' => array( // Bulgarian states.
		'BG-01' => __( 'Blagoevgrad', 'pcud_ml'),
		'BG-02' => __( 'Burgas', 'pcud_ml'),
		'BG-08' => __( 'Dobrich', 'pcud_ml'),
		'BG-07' => __( 'Gabrovo', 'pcud_ml'),
		'BG-26' => __( 'Haskovo', 'pcud_ml'),
		'BG-09' => __( 'Kardzhali', 'pcud_ml'),
		'BG-10' => __( 'Kyustendil', 'pcud_ml'),
		'BG-11' => __( 'Lovech', 'pcud_ml'),
		'BG-12' => __( 'Montana', 'pcud_ml'),
		'BG-13' => __( 'Pazardzhik', 'pcud_ml'),
		'BG-14' => __( 'Pernik', 'pcud_ml'),
		'BG-15' => __( 'Pleven', 'pcud_ml'),
		'BG-16' => __( 'Plovdiv', 'pcud_ml'),
		'BG-17' => __( 'Razgrad', 'pcud_ml'),
		'BG-18' => __( 'Ruse', 'pcud_ml'),
		'BG-27' => __( 'Shumen', 'pcud_ml'),
		'BG-19' => __( 'Silistra', 'pcud_ml'),
		'BG-20' => __( 'Sliven', 'pcud_ml'),
		'BG-21' => __( 'Smolyan', 'pcud_ml'),
		'BG-23' => __( 'Sofia', 'pcud_ml'),
		'BG-22' => __( 'Sofia-Grad', 'pcud_ml'),
		'BG-24' => __( 'Stara Zagora', 'pcud_ml'),
		'BG-25' => __( 'Targovishte', 'pcud_ml'),
		'BG-03' => __( 'Varna', 'pcud_ml'),
		'BG-04' => __( 'Veliko Tarnovo', 'pcud_ml'),
		'BG-05' => __( 'Vidin', 'pcud_ml'),
		'BG-06' => __( 'Vratsa', 'pcud_ml'),
		'BG-28' => __( 'Yambol', 'pcud_ml'),
	),
	'BH' => array(),
	'BI' => array(),
	'BJ' => array( // Benin states.
		'AL' => __( 'Alibori', 'pcud_ml'),
		'AK' => __( 'Atakora', 'pcud_ml'),
		'AQ' => __( 'Atlantique', 'pcud_ml'),
		'BO' => __( 'Borgou', 'pcud_ml'),
		'CO' => __( 'Collines', 'pcud_ml'),
		'KO' => __( 'Kouffo', 'pcud_ml'),
		'DO' => __( 'Donga', 'pcud_ml'),
		'LI' => __( 'Littoral', 'pcud_ml'),
		'MO' => __( 'Mono', 'pcud_ml'),
		'OU' => __( 'Ouémé', 'pcud_ml'),
		'PL' => __( 'Plateau', 'pcud_ml'),
		'ZO' => __( 'Zou', 'pcud_ml'),
	),
	'BO' => array( // Bolivian states.
		'B' => __( 'Chuquisaca', 'pcud_ml'),
		'H' => __( 'Beni', 'pcud_ml'),
		'C' => __( 'Cochabamba', 'pcud_ml'),
		'L' => __( 'La Paz', 'pcud_ml'),
		'O' => __( 'Oruro', 'pcud_ml'),
		'N' => __( 'Pando', 'pcud_ml'),
		'P' => __( 'Potosí', 'pcud_ml'),
		'S' => __( 'Santa Cruz', 'pcud_ml'),
		'T' => __( 'Tarija', 'pcud_ml'),
	),
	'BR' => array( // Brazillian states.
		'AC' => __( 'Acre', 'pcud_ml'),
		'AL' => __( 'Alagoas', 'pcud_ml'),
		'AP' => __( 'Amapá', 'pcud_ml'),
		'AM' => __( 'Amazonas', 'pcud_ml'),
		'BA' => __( 'Bahia', 'pcud_ml'),
		'CE' => __( 'Ceará', 'pcud_ml'),
		'DF' => __( 'Distrito Federal', 'pcud_ml'),
		'ES' => __( 'Espírito Santo', 'pcud_ml'),
		'GO' => __( 'Goiás', 'pcud_ml'),
		'MA' => __( 'Maranhão', 'pcud_ml'),
		'MT' => __( 'Mato Grosso', 'pcud_ml'),
		'MS' => __( 'Mato Grosso do Sul', 'pcud_ml'),
		'MG' => __( 'Minas Gerais', 'pcud_ml'),
		'PA' => __( 'Pará', 'pcud_ml'),
		'PB' => __( 'Paraíba', 'pcud_ml'),
		'PR' => __( 'Paraná', 'pcud_ml'),
		'PE' => __( 'Pernambuco', 'pcud_ml'),
		'PI' => __( 'Piauí', 'pcud_ml'),
		'RJ' => __( 'Rio de Janeiro', 'pcud_ml'),
		'RN' => __( 'Rio Grande do Norte', 'pcud_ml'),
		'RS' => __( 'Rio Grande do Sul', 'pcud_ml'),
		'RO' => __( 'Rondônia', 'pcud_ml'),
		'RR' => __( 'Roraima', 'pcud_ml'),
		'SC' => __( 'Santa Catarina', 'pcud_ml'),
		'SP' => __( 'São Paulo', 'pcud_ml'),
		'SE' => __( 'Sergipe', 'pcud_ml'),
		'TO' => __( 'Tocantins', 'pcud_ml'),
	),
	'CA' => array( // Canadian states.
		'AB' => __( 'Alberta', 'pcud_ml'),
		'BC' => __( 'British Columbia', 'pcud_ml'),
		'MB' => __( 'Manitoba', 'pcud_ml'),
		'NB' => __( 'New Brunswick', 'pcud_ml'),
		'NL' => __( 'Newfoundland and Labrador', 'pcud_ml'),
		'NT' => __( 'Northwest Territories', 'pcud_ml'),
		'NS' => __( 'Nova Scotia', 'pcud_ml'),
		'NU' => __( 'Nunavut', 'pcud_ml'),
		'ON' => __( 'Ontario', 'pcud_ml'),
		'PE' => __( 'Prince Edward Island', 'pcud_ml'),
		'QC' => __( 'Quebec', 'pcud_ml'),
		'SK' => __( 'Saskatchewan', 'pcud_ml'),
		'YT' => __( 'Yukon Territory', 'pcud_ml'),
	),
	'CH' => array( // Cantons of Switzerland.
		'AG' => __( 'Aargau', 'pcud_ml'),
		'AR' => __( 'Appenzell Ausserrhoden', 'pcud_ml'),
		'AI' => __( 'Appenzell Innerrhoden', 'pcud_ml'),
		'BL' => __( 'Basel-Landschaft', 'pcud_ml'),
		'BS' => __( 'Basel-Stadt', 'pcud_ml'),
		'BE' => __( 'Bern', 'pcud_ml'),
		'FR' => __( 'Fribourg', 'pcud_ml'),
		'GE' => __( 'Geneva', 'pcud_ml'),
		'GL' => __( 'Glarus', 'pcud_ml'),
		'GR' => __( 'Graubünden', 'pcud_ml'),
		'JU' => __( 'Jura', 'pcud_ml'),
		'LU' => __( 'Luzern', 'pcud_ml'),
		'NE' => __( 'Neuchâtel', 'pcud_ml'),
		'NW' => __( 'Nidwalden', 'pcud_ml'),
		'OW' => __( 'Obwalden', 'pcud_ml'),
		'SH' => __( 'Schaffhausen', 'pcud_ml'),
		'SZ' => __( 'Schwyz', 'pcud_ml'),
		'SO' => __( 'Solothurn', 'pcud_ml'),
		'SG' => __( 'St. Gallen', 'pcud_ml'),
		'TG' => __( 'Thurgau', 'pcud_ml'),
		'TI' => __( 'Ticino', 'pcud_ml'),
		'UR' => __( 'Uri', 'pcud_ml'),
		'VS' => __( 'Valais', 'pcud_ml'),
		'VD' => __( 'Vaud', 'pcud_ml'),
		'ZG' => __( 'Zug', 'pcud_ml'),
		'ZH' => __( 'Zürich', 'pcud_ml'),
	),
	'CN' => array( // Chinese states.
		'CN1'  => __( 'Yunnan / 云南', 'pcud_ml'),
		'CN2'  => __( 'Beijing / 北京', 'pcud_ml'),
		'CN3'  => __( 'Tianjin / 天津', 'pcud_ml'),
		'CN4'  => __( 'Hebei / 河北', 'pcud_ml'),
		'CN5'  => __( 'Shanxi / 山西', 'pcud_ml'),
		'CN6'  => __( 'Inner Mongolia / 內蒙古', 'pcud_ml'),
		'CN7'  => __( 'Liaoning / 辽宁', 'pcud_ml'),
		'CN8'  => __( 'Jilin / 吉林', 'pcud_ml'),
		'CN9'  => __( 'Heilongjiang / 黑龙江', 'pcud_ml'),
		'CN10' => __( 'Shanghai / 上海', 'pcud_ml'),
		'CN11' => __( 'Jiangsu / 江苏', 'pcud_ml'),
		'CN12' => __( 'Zhejiang / 浙江', 'pcud_ml'),
		'CN13' => __( 'Anhui / 安徽', 'pcud_ml'),
		'CN14' => __( 'Fujian / 福建', 'pcud_ml'),
		'CN15' => __( 'Jiangxi / 江西', 'pcud_ml'),
		'CN16' => __( 'Shandong / 山东', 'pcud_ml'),
		'CN17' => __( 'Henan / 河南', 'pcud_ml'),
		'CN18' => __( 'Hubei / 湖北', 'pcud_ml'),
		'CN19' => __( 'Hunan / 湖南', 'pcud_ml'),
		'CN20' => __( 'Guangdong / 广东', 'pcud_ml'),
		'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'pcud_ml'),
		'CN22' => __( 'Hainan / 海南', 'pcud_ml'),
		'CN23' => __( 'Chongqing / 重庆', 'pcud_ml'),
		'CN24' => __( 'Sichuan / 四川', 'pcud_ml'),
		'CN25' => __( 'Guizhou / 贵州', 'pcud_ml'),
		'CN26' => __( 'Shaanxi / 陕西', 'pcud_ml'),
		'CN27' => __( 'Gansu / 甘肃', 'pcud_ml'),
		'CN28' => __( 'Qinghai / 青海', 'pcud_ml'),
		'CN29' => __( 'Ningxia Hui / 宁夏', 'pcud_ml'),
		'CN30' => __( 'Macao / 澳门', 'pcud_ml'),
		'CN31' => __( 'Tibet / 西藏', 'pcud_ml'),
		'CN32' => __( 'Xinjiang / 新疆', 'pcud_ml'),
	),
	'CZ' => array(),
	'DE' => array(),
	'DK' => array(),
	'DO' => array( // Dominican Republic.
		'DO-01' => __( 'Distrito Nacional', 'pcud_ml'),
		'DO-02' => __( 'Azua', 'pcud_ml'),
		'DO-03' => __( 'Baoruco', 'pcud_ml'),
		'DO-04' => __( 'Barahona', 'pcud_ml'),
		'DO-05' => __( 'Dajabón', 'pcud_ml'),
		'DO-06' => __( 'Duarte', 'pcud_ml'),
		'DO-07' => __( 'Elías Piña', 'pcud_ml'),
		'DO-08' => __( 'El Seibo', 'pcud_ml'),
		'DO-09' => __( 'Espaillat', 'pcud_ml'),
		'DO-10' => __( 'Independencia', 'pcud_ml'),
		'DO-11' => __( 'La Altagracia', 'pcud_ml'),
		'DO-12' => __( 'La Romana', 'pcud_ml'),
		'DO-13' => __( 'La Vega', 'pcud_ml'),
		'DO-14' => __( 'María Trinidad Sánchez', 'pcud_ml'),
		'DO-15' => __( 'Monte Cristi', 'pcud_ml'),
		'DO-16' => __( 'Pedernales', 'pcud_ml'),
		'DO-17' => __( 'Peravia', 'pcud_ml'),
		'DO-18' => __( 'Puerto Plata', 'pcud_ml'),
		'DO-19' => __( 'Hermanas Mirabal', 'pcud_ml'),
		'DO-20' => __( 'Samaná', 'pcud_ml'),
		'DO-21' => __( 'San Cristóbal', 'pcud_ml'),
		'DO-22' => __( 'San Juan', 'pcud_ml'),
		'DO-23' => __( 'San Pedro de Macorís', 'pcud_ml'),
		'DO-24' => __( 'Sánchez Ramírez', 'pcud_ml'),
		'DO-25' => __( 'Santiago', 'pcud_ml'),
		'DO-26' => __( 'Santiago Rodríguez', 'pcud_ml'),
		'DO-27' => __( 'Valverde', 'pcud_ml'),
		'DO-28' => __( 'Monseñor Nouel', 'pcud_ml'),
		'DO-29' => __( 'Monte Plata', 'pcud_ml'),
		'DO-30' => __( 'Hato Mayor', 'pcud_ml'),
		'DO-31' => __( 'San José de Ocoa', 'pcud_ml'),
		'DO-32' => __( 'Santo Domingo', 'pcud_ml'),
	),
	'DZ' => array(
		'DZ-01' => __( 'Adrar', 'pcud_ml'),
		'DZ-02' => __( 'Chlef', 'pcud_ml'),
		'DZ-03' => __( 'Laghouat', 'pcud_ml'),
		'DZ-04' => __( 'Oum El Bouaghi', 'pcud_ml'),
		'DZ-05' => __( 'Batna', 'pcud_ml'),
		'DZ-06' => __( 'Béjaïa', 'pcud_ml'),
		'DZ-07' => __( 'Biskra', 'pcud_ml'),
		'DZ-08' => __( 'Béchar', 'pcud_ml'),
		'DZ-09' => __( 'Blida', 'pcud_ml'),
		'DZ-10' => __( 'Bouira', 'pcud_ml'),
		'DZ-11' => __( 'Tamanghasset', 'pcud_ml'),
		'DZ-12' => __( 'Tébessa', 'pcud_ml'),
		'DZ-13' => __( 'Tlemcen', 'pcud_ml'),
		'DZ-14' => __( 'Tiaret', 'pcud_ml'),
		'DZ-15' => __( 'Tizi Ouzou', 'pcud_ml'),
		'DZ-16' => __( 'Algiers', 'pcud_ml'),
		'DZ-17' => __( 'Djelfa', 'pcud_ml'),
		'DZ-18' => __( 'Jijel', 'pcud_ml'),
		'DZ-19' => __( 'Sétif', 'pcud_ml'),
		'DZ-20' => __( 'Saïda', 'pcud_ml'),
		'DZ-21' => __( 'Skikda', 'pcud_ml'),
		'DZ-22' => __( 'Sidi Bel Abbès', 'pcud_ml'),
		'DZ-23' => __( 'Annaba', 'pcud_ml'),
		'DZ-24' => __( 'Guelma', 'pcud_ml'),
		'DZ-25' => __( 'Constantine', 'pcud_ml'),
		'DZ-26' => __( 'Médéa', 'pcud_ml'),
		'DZ-27' => __( 'Mostaganem', 'pcud_ml'),
		'DZ-28' => __( 'M’Sila', 'pcud_ml'),
		'DZ-29' => __( 'Mascara', 'pcud_ml'),
		'DZ-30' => __( 'Ouargla', 'pcud_ml'),
		'DZ-31' => __( 'Oran', 'pcud_ml'),
		'DZ-32' => __( 'El Bayadh', 'pcud_ml'),
		'DZ-33' => __( 'Illizi', 'pcud_ml'),
		'DZ-34' => __( 'Bordj Bou Arréridj', 'pcud_ml'),
		'DZ-35' => __( 'Boumerdès', 'pcud_ml'),
		'DZ-36' => __( 'El Tarf', 'pcud_ml'),
		'DZ-37' => __( 'Tindouf', 'pcud_ml'),
		'DZ-38' => __( 'Tissemsilt', 'pcud_ml'),
		'DZ-39' => __( 'El Oued', 'pcud_ml'),
		'DZ-40' => __( 'Khenchela', 'pcud_ml'),
		'DZ-41' => __( 'Souk Ahras', 'pcud_ml'),
		'DZ-42' => __( 'Tipasa', 'pcud_ml'),
		'DZ-43' => __( 'Mila', 'pcud_ml'),
		'DZ-44' => __( 'Aïn Defla', 'pcud_ml'),
		'DZ-45' => __( 'Naama', 'pcud_ml'),
		'DZ-46' => __( 'Aïn Témouchent', 'pcud_ml'),
		'DZ-47' => __( 'Ghardaïa', 'pcud_ml'),
		'DZ-48' => __( 'Relizane', 'pcud_ml'),
	),
	'EE' => array(),
	'EG' => array( // Egypt states.
		'EGALX' => __( 'Alexandria', 'pcud_ml'),
		'EGASN' => __( 'Aswan', 'pcud_ml'),
		'EGAST' => __( 'Asyut', 'pcud_ml'),
		'EGBA'  => __( 'Red Sea', 'pcud_ml'),
		'EGBH'  => __( 'Beheira', 'pcud_ml'),
		'EGBNS' => __( 'Beni Suef', 'pcud_ml'),
		'EGC'   => __( 'Cairo', 'pcud_ml'),
		'EGDK'  => __( 'Dakahlia', 'pcud_ml'),
		'EGDT'  => __( 'Damietta', 'pcud_ml'),
		'EGFYM' => __( 'Faiyum', 'pcud_ml'),
		'EGGH'  => __( 'Gharbia', 'pcud_ml'),
		'EGGZ'  => __( 'Giza', 'pcud_ml'),
		'EGIS'  => __( 'Ismailia', 'pcud_ml'),
		'EGJS'  => __( 'South Sinai', 'pcud_ml'),
		'EGKB'  => __( 'Qalyubia', 'pcud_ml'),
		'EGKFS' => __( 'Kafr el-Sheikh', 'pcud_ml'),
		'EGKN'  => __( 'Qena', 'pcud_ml'),
		'EGLX'  => __( 'Luxor', 'pcud_ml'),
		'EGMN'  => __( 'Minya', 'pcud_ml'),
		'EGMNF' => __( 'Monufia', 'pcud_ml'),
		'EGMT'  => __( 'Matrouh', 'pcud_ml'),
		'EGPTS' => __( 'Port Said', 'pcud_ml'),
		'EGSHG' => __( 'Sohag', 'pcud_ml'),
		'EGSHR' => __( 'Al Sharqia', 'pcud_ml'),
		'EGSIN' => __( 'North Sinai', 'pcud_ml'),
		'EGSUZ' => __( 'Suez', 'pcud_ml'),
		'EGWAD' => __( 'New Valley', 'pcud_ml'),
	),
	'ES' => array( // Spanish states.
		'C'  => __( 'A Coruña', 'pcud_ml'),
		'VI' => __( 'Araba/Álava', 'pcud_ml'),
		'AB' => __( 'Albacete', 'pcud_ml'),
		'A'  => __( 'Alicante', 'pcud_ml'),
		'AL' => __( 'Almería', 'pcud_ml'),
		'O'  => __( 'Asturias', 'pcud_ml'),
		'AV' => __( 'Ávila', 'pcud_ml'),
		'BA' => __( 'Badajoz', 'pcud_ml'),
		'PM' => __( 'Baleares', 'pcud_ml'),
		'B'  => __( 'Barcelona', 'pcud_ml'),
		'BU' => __( 'Burgos', 'pcud_ml'),
		'CC' => __( 'Cáceres', 'pcud_ml'),
		'CA' => __( 'Cádiz', 'pcud_ml'),
		'S'  => __( 'Cantabria', 'pcud_ml'),
		'CS' => __( 'Castellón', 'pcud_ml'),
		'CE' => __( 'Ceuta', 'pcud_ml'),
		'CR' => __( 'Ciudad Real', 'pcud_ml'),
		'CO' => __( 'Córdoba', 'pcud_ml'),
		'CU' => __( 'Cuenca', 'pcud_ml'),
		'GI' => __( 'Girona', 'pcud_ml'),
		'GR' => __( 'Granada', 'pcud_ml'),
		'GU' => __( 'Guadalajara', 'pcud_ml'),
		'SS' => __( 'Gipuzkoa', 'pcud_ml'),
		'H'  => __( 'Huelva', 'pcud_ml'),
		'HU' => __( 'Huesca', 'pcud_ml'),
		'J'  => __( 'Jaén', 'pcud_ml'),
		'LO' => __( 'La Rioja', 'pcud_ml'),
		'GC' => __( 'Las Palmas', 'pcud_ml'),
		'LE' => __( 'León', 'pcud_ml'),
		'L'  => __( 'Lleida', 'pcud_ml'),
		'LU' => __( 'Lugo', 'pcud_ml'),
		'M'  => __( 'Madrid', 'pcud_ml'),
		'MA' => __( 'Málaga', 'pcud_ml'),
		'ML' => __( 'Melilla', 'pcud_ml'),
		'MU' => __( 'Murcia', 'pcud_ml'),
		'NA' => __( 'Navarra', 'pcud_ml'),
		'OR' => __( 'Ourense', 'pcud_ml'),
		'P'  => __( 'Palencia', 'pcud_ml'),
		'PO' => __( 'Pontevedra', 'pcud_ml'),
		'SA' => __( 'Salamanca', 'pcud_ml'),
		'TF' => __( 'Santa Cruz de Tenerife', 'pcud_ml'),
		'SG' => __( 'Segovia', 'pcud_ml'),
		'SE' => __( 'Sevilla', 'pcud_ml'),
		'SO' => __( 'Soria', 'pcud_ml'),
		'T'  => __( 'Tarragona', 'pcud_ml'),
		'TE' => __( 'Teruel', 'pcud_ml'),
		'TO' => __( 'Toledo', 'pcud_ml'),
		'V'  => __( 'Valencia', 'pcud_ml'),
		'VA' => __( 'Valladolid', 'pcud_ml'),
		'BI' => __( 'Biscay', 'pcud_ml'),
		'ZA' => __( 'Zamora', 'pcud_ml'),
		'Z'  => __( 'Zaragoza', 'pcud_ml'),
	),
	'FI' => array(),
	'FR' => array(),
	'GF' => array(),
	'GH' => array( // Ghanaian Regions.
		'AF' => __( 'Ahafo', 'pcud_ml'),
		'AH' => __( 'Ashanti', 'pcud_ml'),
		'BA' => __( 'Brong-Ahafo', 'pcud_ml'),
		'BO' => __( 'Bono', 'pcud_ml'),
		'BE' => __( 'Bono East', 'pcud_ml'),
		'CP' => __( 'Central', 'pcud_ml'),
		'EP' => __( 'Eastern', 'pcud_ml'),
		'AA' => __( 'Greater Accra', 'pcud_ml'),
		'NE' => __( 'North East', 'pcud_ml'),
		'NP' => __( 'Northern', 'pcud_ml'),
		'OT' => __( 'Oti', 'pcud_ml'),
		'SV' => __( 'Savannah', 'pcud_ml'),
		'UE' => __( 'Upper East', 'pcud_ml'),
		'UW' => __( 'Upper West', 'pcud_ml'),
		'TV' => __( 'Volta', 'pcud_ml'),
		'WP' => __( 'Western', 'pcud_ml'),
		'WN' => __( 'Western North', 'pcud_ml'),
	),
	'GP' => array(),
	'GR' => array( // Greek Regions.
		'I' => __( 'Attica', 'pcud_ml'),
		'A' => __( 'East Macedonia and Thrace', 'pcud_ml'),
		'B' => __( 'Central Macedonia', 'pcud_ml'),
		'C' => __( 'West Macedonia', 'pcud_ml'),
		'D' => __( 'Epirus', 'pcud_ml'),
		'E' => __( 'Thessaly', 'pcud_ml'),
		'F' => __( 'Ionian Islands', 'pcud_ml'),
		'G' => __( 'West Greece', 'pcud_ml'),
		'H' => __( 'Central Greece', 'pcud_ml'),
		'J' => __( 'Peloponnese', 'pcud_ml'),
		'K' => __( 'North Aegean', 'pcud_ml'),
		'L' => __( 'South Aegean', 'pcud_ml'),
		'M' => __( 'Crete', 'pcud_ml'),
	),
	'GT' => array( // Guatemalan states.
		'AV' => __( 'Alta Verapaz', 'pcud_ml'),
		'BV' => __( 'Baja Verapaz', 'pcud_ml'),
		'CM' => __( 'Chimaltenango', 'pcud_ml'),
		'CQ' => __( 'Chiquimula', 'pcud_ml'),
		'PR' => __( 'El Progreso', 'pcud_ml'),
		'ES' => __( 'Escuintla', 'pcud_ml'),
		'GU' => __( 'Guatemala', 'pcud_ml'),
		'HU' => __( 'Huehuetenango', 'pcud_ml'),
		'IZ' => __( 'Izabal', 'pcud_ml'),
		'JA' => __( 'Jalapa', 'pcud_ml'),
		'JU' => __( 'Jutiapa', 'pcud_ml'),
		'PE' => __( 'Petén', 'pcud_ml'),
		'QZ' => __( 'Quetzaltenango', 'pcud_ml'),
		'QC' => __( 'Quiché', 'pcud_ml'),
		'RE' => __( 'Retalhuleu', 'pcud_ml'),
		'SA' => __( 'Sacatepéquez', 'pcud_ml'),
		'SM' => __( 'San Marcos', 'pcud_ml'),
		'SR' => __( 'Santa Rosa', 'pcud_ml'),
		'SO' => __( 'Sololá', 'pcud_ml'),
		'SU' => __( 'Suchitepéquez', 'pcud_ml'),
		'TO' => __( 'Totonicapán', 'pcud_ml'),
		'ZA' => __( 'Zacapa', 'pcud_ml')
	),
	'HK' => array( // Hong Kong states.
		'HONG KONG'       => __( 'Hong Kong Island', 'pcud_ml'),
		'KOWLOON'         => __( 'Kowloon', 'pcud_ml'),
		'NEW TERRITORIES' => __( 'New Territories', 'pcud_ml'),
	),
	'HU' => array( // Hungary states.
		'BK' => __( 'Bács-Kiskun', 'pcud_ml'),
		'BE' => __( 'Békés', 'pcud_ml'),
		'BA' => __( 'Baranya', 'pcud_ml'),
		'BZ' => __( 'Borsod-Abaúj-Zemplén', 'pcud_ml'),
		'BU' => __( 'Budapest', 'pcud_ml'),
		'CS' => __( 'Csongrád-Csanád', 'pcud_ml'),
		'FE' => __( 'Fejér', 'pcud_ml'),
		'GS' => __( 'Győr-Moson-Sopron', 'pcud_ml'),
		'HB' => __( 'Hajdú-Bihar', 'pcud_ml'),
		'HE' => __( 'Heves', 'pcud_ml'),
		'JN' => __( 'Jász-Nagykun-Szolnok', 'pcud_ml'),
		'KE' => __( 'Komárom-Esztergom', 'pcud_ml'),
		'NO' => __( 'Nógrád', 'pcud_ml'),
		'PE' => __( 'Pest', 'pcud_ml'),
		'SO' => __( 'Somogy', 'pcud_ml'),
		'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'pcud_ml'),
		'TO' => __( 'Tolna', 'pcud_ml'),
		'VA' => __( 'Vas', 'pcud_ml'),
		'VE' => __( 'Veszprém', 'pcud_ml'),
		'ZA' => __( 'Zala', 'pcud_ml'),
	),
	'ID' => array( // Indonesia Provinces.
		'AC' => __( 'Daerah Istimewa Aceh', 'pcud_ml'),
		'SU' => __( 'Sumatera Utara', 'pcud_ml'),
		'SB' => __( 'Sumatera Barat', 'pcud_ml'),
		'RI' => __( 'Riau', 'pcud_ml'),
		'KR' => __( 'Kepulauan Riau', 'pcud_ml'),
		'JA' => __( 'Jambi', 'pcud_ml'),
		'SS' => __( 'Sumatera Selatan', 'pcud_ml'),
		'BB' => __( 'Bangka Belitung', 'pcud_ml'),
		'BE' => __( 'Bengkulu', 'pcud_ml'),
		'LA' => __( 'Lampung', 'pcud_ml'),
		'JK' => __( 'DKI Jakarta', 'pcud_ml'),
		'JB' => __( 'Jawa Barat', 'pcud_ml'),
		'BT' => __( 'Banten', 'pcud_ml'),
		'JT' => __( 'Jawa Tengah', 'pcud_ml'),
		'JI' => __( 'Jawa Timur', 'pcud_ml'),
		'YO' => __( 'Daerah Istimewa Yogyakarta', 'pcud_ml'),
		'BA' => __( 'Bali', 'pcud_ml'),
		'NB' => __( 'Nusa Tenggara Barat', 'pcud_ml'),
		'NT' => __( 'Nusa Tenggara Timur', 'pcud_ml'),
		'KB' => __( 'Kalimantan Barat', 'pcud_ml'),
		'KT' => __( 'Kalimantan Tengah', 'pcud_ml'),
		'KI' => __( 'Kalimantan Timur', 'pcud_ml'),
		'KS' => __( 'Kalimantan Selatan', 'pcud_ml'),
		'KU' => __( 'Kalimantan Utara', 'pcud_ml'),
		'SA' => __( 'Sulawesi Utara', 'pcud_ml'),
		'ST' => __( 'Sulawesi Tengah', 'pcud_ml'),
		'SG' => __( 'Sulawesi Tenggara', 'pcud_ml'),
		'SR' => __( 'Sulawesi Barat', 'pcud_ml'),
		'SN' => __( 'Sulawesi Selatan', 'pcud_ml'),
		'GO' => __( 'Gorontalo', 'pcud_ml'),
		'MA' => __( 'Maluku', 'pcud_ml'),
		'MU' => __( 'Maluku Utara', 'pcud_ml'),
		'PA' => __( 'Papua', 'pcud_ml'),
		'PB' => __( 'Papua Barat', 'pcud_ml'),
	),
	'IE' => array( // Republic of Ireland.
		'CW' => __( 'Carlow', 'pcud_ml'),
		'CN' => __( 'Cavan', 'pcud_ml'),
		'CE' => __( 'Clare', 'pcud_ml'),
		'CO' => __( 'Cork', 'pcud_ml'),
		'DL' => __( 'Donegal', 'pcud_ml'),
		'D'  => __( 'Dublin', 'pcud_ml'),
		'G'  => __( 'Galway', 'pcud_ml'),
		'KY' => __( 'Kerry', 'pcud_ml'),
		'KE' => __( 'Kildare', 'pcud_ml'),
		'KK' => __( 'Kilkenny', 'pcud_ml'),
		'LS' => __( 'Laois', 'pcud_ml'),
		'LM' => __( 'Leitrim', 'pcud_ml'),
		'LK' => __( 'Limerick', 'pcud_ml'),
		'LD' => __( 'Longford', 'pcud_ml'),
		'LH' => __( 'Louth', 'pcud_ml'),
		'MO' => __( 'Mayo', 'pcud_ml'),
		'MH' => __( 'Meath', 'pcud_ml'),
		'MN' => __( 'Monaghan', 'pcud_ml'),
		'OY' => __( 'Offaly', 'pcud_ml'),
		'RN' => __( 'Roscommon', 'pcud_ml'),
		'SO' => __( 'Sligo', 'pcud_ml'),
		'TA' => __( 'Tipperary', 'pcud_ml'),
		'WD' => __( 'Waterford', 'pcud_ml'),
		'WH' => __( 'Westmeath', 'pcud_ml'),
		'WX' => __( 'Wexford', 'pcud_ml'),
		'WW' => __( 'Wicklow', 'pcud_ml'),
	),
	'IN' => array( // Indian states.
		'AP' => __( 'Andhra Pradesh', 'pcud_ml'),
		'AR' => __( 'Arunachal Pradesh', 'pcud_ml'),
		'AS' => __( 'Assam', 'pcud_ml'),
		'BR' => __( 'Bihar', 'pcud_ml'),
		'CT' => __( 'Chhattisgarh', 'pcud_ml'),
		'GA' => __( 'Goa', 'pcud_ml'),
		'GJ' => __( 'Gujarat', 'pcud_ml'),
		'HR' => __( 'Haryana', 'pcud_ml'),
		'HP' => __( 'Himachal Pradesh', 'pcud_ml'),
		'JK' => __( 'Jammu and Kashmir', 'pcud_ml'),
		'JH' => __( 'Jharkhand', 'pcud_ml'),
		'KA' => __( 'Karnataka', 'pcud_ml'),
		'KL' => __( 'Kerala', 'pcud_ml'),
		'LA' => __( 'Ladakh', 'pcud_ml'),
		'MP' => __( 'Madhya Pradesh', 'pcud_ml'),
		'MH' => __( 'Maharashtra', 'pcud_ml'),
		'MN' => __( 'Manipur', 'pcud_ml'),
		'ML' => __( 'Meghalaya', 'pcud_ml'),
		'MZ' => __( 'Mizoram', 'pcud_ml'),
		'NL' => __( 'Nagaland', 'pcud_ml'),
		'OR' => __( 'Odisha', 'pcud_ml'),
		'PB' => __( 'Punjab', 'pcud_ml'),
		'RJ' => __( 'Rajasthan', 'pcud_ml'),
		'SK' => __( 'Sikkim', 'pcud_ml'),
		'TN' => __( 'Tamil Nadu', 'pcud_ml'),
		'TS' => __( 'Telangana', 'pcud_ml'),
		'TR' => __( 'Tripura', 'pcud_ml'),
		'UK' => __( 'Uttarakhand', 'pcud_ml'),
		'UP' => __( 'Uttar Pradesh', 'pcud_ml'),
		'WB' => __( 'West Bengal', 'pcud_ml'),
		'AN' => __( 'Andaman and Nicobar Islands', 'pcud_ml'),
		'CH' => __( 'Chandigarh', 'pcud_ml'),
		'DN' => __( 'Dadra and Nagar Haveli', 'pcud_ml'),
		'DD' => __( 'Daman and Diu', 'pcud_ml'),
		'DL' => __( 'Delhi', 'pcud_ml'),
		'LD' => __( 'Lakshadeep', 'pcud_ml'),
		'PY' => __( 'Pondicherry (Puducherry)', 'pcud_ml'),
	),
	'IR' => array( // Iran States.
		'KHZ' => __( 'Khuzestan (خوزستان)', 'pcud_ml'),
		'THR' => __( 'Tehran (تهران)', 'pcud_ml'),
		'ILM' => __( 'Ilaam (ایلام)', 'pcud_ml'),
		'BHR' => __( 'Bushehr (بوشهر)', 'pcud_ml'),
		'ADL' => __( 'Ardabil (اردبیل)', 'pcud_ml'),
		'ESF' => __( 'Isfahan (اصفهان)', 'pcud_ml'),
		'YZD' => __( 'Yazd (یزد)', 'pcud_ml'),
		'KRH' => __( 'Kermanshah (کرمانشاه)', 'pcud_ml'),
		'KRN' => __( 'Kerman (کرمان)', 'pcud_ml'),
		'HDN' => __( 'Hamadan (همدان)', 'pcud_ml'),
		'GZN' => __( 'Ghazvin (قزوین)', 'pcud_ml'),
		'ZJN' => __( 'Zanjan (زنجان)', 'pcud_ml'),
		'LRS' => __( 'Luristan (لرستان)', 'pcud_ml'),
		'ABZ' => __( 'Alborz (البرز)', 'pcud_ml'),
		'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'pcud_ml'),
		'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'pcud_ml'),
		'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'pcud_ml'),
		'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'pcud_ml'),
		'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'pcud_ml'),
		'NKH' => __( 'North Khorasan (خراسان شمالی)', 'pcud_ml'),
		'SMN' => __( 'Semnan (سمنان)', 'pcud_ml'),
		'FRS' => __( 'Fars (فارس)', 'pcud_ml'),
		'QHM' => __( 'Qom (قم)', 'pcud_ml'),
		'KRD' => __( 'Kurdistan / کردستان)', 'pcud_ml'),
		'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'pcud_ml'),
		'GLS' => __( 'Golestan (گلستان)', 'pcud_ml'),
		'GIL' => __( 'Gilan (گیلان)', 'pcud_ml'),
		'MZN' => __( 'Mazandaran (مازندران)', 'pcud_ml'),
		'MKZ' => __( 'Markazi (مرکزی)', 'pcud_ml'),
		'HRZ' => __( 'Hormozgan (هرمزگان)', 'pcud_ml'),
		'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'pcud_ml'),
	),
	'IS' => array(),
	'IT' => array( // Italy Provinces.
		'AG' => __( 'Agrigento', 'pcud_ml'),
		'AL' => __( 'Alessandria', 'pcud_ml'),
		'AN' => __( 'Ancona', 'pcud_ml'),
		'AO' => __( 'Aosta', 'pcud_ml'),
		'AR' => __( 'Arezzo', 'pcud_ml'),
		'AP' => __( 'Ascoli Piceno', 'pcud_ml'),
		'AT' => __( 'Asti', 'pcud_ml'),
		'AV' => __( 'Avellino', 'pcud_ml'),
		'BA' => __( 'Bari', 'pcud_ml'),
		'BT' => __( 'Barletta-Andria-Trani', 'pcud_ml'),
		'BL' => __( 'Belluno', 'pcud_ml'),
		'BN' => __( 'Benevento', 'pcud_ml'),
		'BG' => __( 'Bergamo', 'pcud_ml'),
		'BI' => __( 'Biella', 'pcud_ml'),
		'BO' => __( 'Bologna', 'pcud_ml'),
		'BZ' => __( 'Bolzano', 'pcud_ml'),
		'BS' => __( 'Brescia', 'pcud_ml'),
		'BR' => __( 'Brindisi', 'pcud_ml'),
		'CA' => __( 'Cagliari', 'pcud_ml'),
		'CL' => __( 'Caltanissetta', 'pcud_ml'),
		'CB' => __( 'Campobasso', 'pcud_ml'),
		'CE' => __( 'Caserta', 'pcud_ml'),
		'CT' => __( 'Catania', 'pcud_ml'),
		'CZ' => __( 'Catanzaro', 'pcud_ml'),
		'CH' => __( 'Chieti', 'pcud_ml'),
		'CO' => __( 'Como', 'pcud_ml'),
		'CS' => __( 'Cosenza', 'pcud_ml'),
		'CR' => __( 'Cremona', 'pcud_ml'),
		'KR' => __( 'Crotone', 'pcud_ml'),
		'CN' => __( 'Cuneo', 'pcud_ml'),
		'EN' => __( 'Enna', 'pcud_ml'),
		'FM' => __( 'Fermo', 'pcud_ml'),
		'FE' => __( 'Ferrara', 'pcud_ml'),
		'FI' => __( 'Firenze', 'pcud_ml'),
		'FG' => __( 'Foggia', 'pcud_ml'),
		'FC' => __( 'Forlì-Cesena', 'pcud_ml'),
		'FR' => __( 'Frosinone', 'pcud_ml'),
		'GE' => __( 'Genova', 'pcud_ml'),
		'GO' => __( 'Gorizia', 'pcud_ml'),
		'GR' => __( 'Grosseto', 'pcud_ml'),
		'IM' => __( 'Imperia', 'pcud_ml'),
		'IS' => __( 'Isernia', 'pcud_ml'),
		'SP' => __( 'La Spezia', 'pcud_ml'),
		'AQ' => __( "L'Aquila", 'pcud_ml'),
		'LT' => __( 'Latina', 'pcud_ml'),
		'LE' => __( 'Lecce', 'pcud_ml'),
		'LC' => __( 'Lecco', 'pcud_ml'),
		'LI' => __( 'Livorno', 'pcud_ml'),
		'LO' => __( 'Lodi', 'pcud_ml'),
		'LU' => __( 'Lucca', 'pcud_ml'),
		'MC' => __( 'Macerata', 'pcud_ml'),
		'MN' => __( 'Mantova', 'pcud_ml'),
		'MS' => __( 'Massa-Carrara', 'pcud_ml'),
		'MT' => __( 'Matera', 'pcud_ml'),
		'ME' => __( 'Messina', 'pcud_ml'),
		'MI' => __( 'Milano', 'pcud_ml'),
		'MO' => __( 'Modena', 'pcud_ml'),
		'MB' => __( 'Monza e della Brianza', 'pcud_ml'),
		'NA' => __( 'Napoli', 'pcud_ml'),
		'NO' => __( 'Novara', 'pcud_ml'),
		'NU' => __( 'Nuoro', 'pcud_ml'),
		'OR' => __( 'Oristano', 'pcud_ml'),
		'PD' => __( 'Padova', 'pcud_ml'),
		'PA' => __( 'Palermo', 'pcud_ml'),
		'PR' => __( 'Parma', 'pcud_ml'),
		'PV' => __( 'Pavia', 'pcud_ml'),
		'PG' => __( 'Perugia', 'pcud_ml'),
		'PU' => __( 'Pesaro e Urbino', 'pcud_ml'),
		'PE' => __( 'Pescara', 'pcud_ml'),
		'PC' => __( 'Piacenza', 'pcud_ml'),
		'PI' => __( 'Pisa', 'pcud_ml'),
		'PT' => __( 'Pistoia', 'pcud_ml'),
		'PN' => __( 'Pordenone', 'pcud_ml'),
		'PZ' => __( 'Potenza', 'pcud_ml'),
		'PO' => __( 'Prato', 'pcud_ml'),
		'RG' => __( 'Ragusa', 'pcud_ml'),
		'RA' => __( 'Ravenna', 'pcud_ml'),
		'RC' => __( 'Reggio Calabria', 'pcud_ml'),
		'RE' => __( 'Reggio Emilia', 'pcud_ml'),
		'RI' => __( 'Rieti', 'pcud_ml'),
		'RN' => __( 'Rimini', 'pcud_ml'),
		'RM' => __( 'Roma', 'pcud_ml'),
		'RO' => __( 'Rovigo', 'pcud_ml'),
		'SA' => __( 'Salerno', 'pcud_ml'),
		'SS' => __( 'Sassari', 'pcud_ml'),
		'SV' => __( 'Savona', 'pcud_ml'),
		'SI' => __( 'Siena', 'pcud_ml'),
		'SR' => __( 'Siracusa', 'pcud_ml'),
		'SO' => __( 'Sondrio', 'pcud_ml'),
		'SU' => __( 'Sud Sardegna', 'pcud_ml'),
		'TA' => __( 'Taranto', 'pcud_ml'),
		'TE' => __( 'Teramo', 'pcud_ml'),
		'TR' => __( 'Terni', 'pcud_ml'),
		'TO' => __( 'Torino', 'pcud_ml'),
		'TP' => __( 'Trapani', 'pcud_ml'),
		'TN' => __( 'Trento', 'pcud_ml'),
		'TV' => __( 'Treviso', 'pcud_ml'),
		'TS' => __( 'Trieste', 'pcud_ml'),
		'UD' => __( 'Udine', 'pcud_ml'),
		'VA' => __( 'Varese', 'pcud_ml'),
		'VE' => __( 'Venezia', 'pcud_ml'),
		'VB' => __( 'Verbano-Cusio-Ossola', 'pcud_ml'),
		'VC' => __( 'Vercelli', 'pcud_ml'),
		'VR' => __( 'Verona', 'pcud_ml'),
		'VV' => __( 'Vibo Valentia', 'pcud_ml'),
		'VI' => __( 'Vicenza', 'pcud_ml'),
		'VT' => __( 'Viterbo', 'pcud_ml'),
	),
	'IL' => array(),
	'IM' => array(),
	'JM' => array( // Jamaica's Parishes. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:JM.
		'JM-01' => __( 'Kingston', 'pcud_ml'),
		'JM-02' => __( 'Saint Andrew', 'pcud_ml'),
		'JM-03' => __( 'Saint Thomas', 'pcud_ml'),
		'JM-04' => __( 'Portland', 'pcud_ml'),
		'JM-05' => __( 'Saint Mary', 'pcud_ml'),
		'JM-06' => __( 'Saint Ann', 'pcud_ml'),
		'JM-07' => __( 'Trelawny', 'pcud_ml'),
		'JM-08' => __( 'Saint James', 'pcud_ml'),
		'JM-09' => __( 'Hanover', 'pcud_ml'),
		'JM-10' => __( 'Westmoreland', 'pcud_ml'),
		'JM-11' => __( 'Saint Elizabeth', 'pcud_ml'),
		'JM-12' => __( 'Manchester', 'pcud_ml'),
		'JM-13' => __( 'Clarendon', 'pcud_ml'),
		'JM-14' => __( 'Saint Catherine', 'pcud_ml'),
	),

	/**
	 * Japan States.
	 *
	 * English notation of prefectures conform to the notation of Japan Post.
	 * The suffix corresponds with the Japanese translation file.
	 */
	'JP' => array(
		'JP01' => __( 'Hokkaido', 'pcud_ml'),
		'JP02' => __( 'Aomori', 'pcud_ml'),
		'JP03' => __( 'Iwate', 'pcud_ml'),
		'JP04' => __( 'Miyagi', 'pcud_ml'),
		'JP05' => __( 'Akita', 'pcud_ml'),
		'JP06' => __( 'Yamagata', 'pcud_ml'),
		'JP07' => __( 'Fukushima', 'pcud_ml'),
		'JP08' => __( 'Ibaraki', 'pcud_ml'),
		'JP09' => __( 'Tochigi', 'pcud_ml'),
		'JP10' => __( 'Gunma', 'pcud_ml'),
		'JP11' => __( 'Saitama', 'pcud_ml'),
		'JP12' => __( 'Chiba', 'pcud_ml'),
		'JP13' => __( 'Tokyo', 'pcud_ml'),
		'JP14' => __( 'Kanagawa', 'pcud_ml'),
		'JP15' => __( 'Niigata', 'pcud_ml'),
		'JP16' => __( 'Toyama', 'pcud_ml'),
		'JP17' => __( 'Ishikawa', 'pcud_ml'),
		'JP18' => __( 'Fukui', 'pcud_ml'),
		'JP19' => __( 'Yamanashi', 'pcud_ml'),
		'JP20' => __( 'Nagano', 'pcud_ml'),
		'JP21' => __( 'Gifu', 'pcud_ml'),
		'JP22' => __( 'Shizuoka', 'pcud_ml'),
		'JP23' => __( 'Aichi', 'pcud_ml'),
		'JP24' => __( 'Mie', 'pcud_ml'),
		'JP25' => __( 'Shiga', 'pcud_ml'),
		'JP26' => __( 'Kyoto', 'pcud_ml'),
		'JP27' => __( 'Osaka', 'pcud_ml'),
		'JP28' => __( 'Hyogo', 'pcud_ml'),
		'JP29' => __( 'Nara', 'pcud_ml'),
		'JP30' => __( 'Wakayama', 'pcud_ml'),
		'JP31' => __( 'Tottori', 'pcud_ml'),
		'JP32' => __( 'Shimane', 'pcud_ml'),
		'JP33' => __( 'Okayama', 'pcud_ml'),
		'JP34' => __( 'Hiroshima', 'pcud_ml'),
		'JP35' => __( 'Yamaguchi', 'pcud_ml'),
		'JP36' => __( 'Tokushima', 'pcud_ml'),
		'JP37' => __( 'Kagawa', 'pcud_ml'),
		'JP38' => __( 'Ehime', 'pcud_ml'),
		'JP39' => __( 'Kochi', 'pcud_ml'),
		'JP40' => __( 'Fukuoka', 'pcud_ml'),
		'JP41' => __( 'Saga', 'pcud_ml'),
		'JP42' => __( 'Nagasaki', 'pcud_ml'),
		'JP43' => __( 'Kumamoto', 'pcud_ml'),
		'JP44' => __( 'Oita', 'pcud_ml'),
		'JP45' => __( 'Miyazaki', 'pcud_ml'),
		'JP46' => __( 'Kagoshima', 'pcud_ml'),
		'JP47' => __( 'Okinawa', 'pcud_ml'),
	),
	'KE' => array( // Kenya counties.
		'KE01' => __( 'Baringo', 'pcud_ml'),
		'KE02' => __( 'Bomet', 'pcud_ml'),
		'KE03' => __( 'Bungoma', 'pcud_ml'),
		'KE04' => __( 'Busia', 'pcud_ml'),
		'KE05' => __( 'Elgeyo-Marakwet', 'pcud_ml'),
		'KE06' => __( 'Embu', 'pcud_ml'),
		'KE07' => __( 'Garissa', 'pcud_ml'),
		'KE08' => __( 'Homa Bay', 'pcud_ml'),
		'KE09' => __( 'Isiolo', 'pcud_ml'),
		'KE10' => __( 'Kajiado', 'pcud_ml'),
		'KE11' => __( 'Kakamega', 'pcud_ml'),
		'KE12' => __( 'Kericho', 'pcud_ml'),
		'KE13' => __( 'Kiambu', 'pcud_ml'),
		'KE14' => __( 'Kilifi', 'pcud_ml'),
		'KE15' => __( 'Kirinyaga', 'pcud_ml'),
		'KE16' => __( 'Kisii', 'pcud_ml'),
		'KE17' => __( 'Kisumu', 'pcud_ml'),
		'KE18' => __( 'Kitui', 'pcud_ml'),
		'KE19' => __( 'Kwale', 'pcud_ml'),
		'KE20' => __( 'Laikipia', 'pcud_ml'),
		'KE21' => __( 'Lamu', 'pcud_ml'),
		'KE22' => __( 'Machakos', 'pcud_ml'),
		'KE23' => __( 'Makueni', 'pcud_ml'),
		'KE24' => __( 'Mandera', 'pcud_ml'),
		'KE25' => __( 'Marsabit', 'pcud_ml'),
		'KE26' => __( 'Meru', 'pcud_ml'),
		'KE27' => __( 'Migori', 'pcud_ml'),
		'KE28' => __( 'Mombasa', 'pcud_ml'),
		'KE29' => __( 'Murang’a', 'pcud_ml'),
		'KE30' => __( 'Nairobi County', 'pcud_ml'),
		'KE31' => __( 'Nakuru', 'pcud_ml'),
		'KE32' => __( 'Nandi', 'pcud_ml'),
		'KE33' => __( 'Narok', 'pcud_ml'),
		'KE34' => __( 'Nyamira', 'pcud_ml'),
		'KE35' => __( 'Nyandarua', 'pcud_ml'),
		'KE36' => __( 'Nyeri', 'pcud_ml'),
		'KE37' => __( 'Samburu', 'pcud_ml'),
		'KE38' => __( 'Siaya', 'pcud_ml'),
		'KE39' => __( 'Taita-Taveta', 'pcud_ml'),
		'KE40' => __( 'Tana River', 'pcud_ml'),
		'KE41' => __( 'Tharaka-Nithi', 'pcud_ml'),
		'KE42' => __( 'Trans Nzoia', 'pcud_ml'),
		'KE43' => __( 'Turkana', 'pcud_ml'),
		'KE44' => __( 'Uasin Gishu', 'pcud_ml'),
		'KE45' => __( 'Vihiga', 'pcud_ml'),
		'KE46' => __( 'Wajir', 'pcud_ml'),
		'KE47' => __( 'West Pokot', 'pcud_ml'),
	),
	'KR' => array(),
	'KW' => array(),
	'LA' => array(
		'AT' => __( 'Attapeu', 'pcud_ml'),
		'BK' => __( 'Bokeo', 'pcud_ml'),
		'BL' => __( 'Bolikhamsai', 'pcud_ml'),
		'CH' => __( 'Champasak', 'pcud_ml'),
		'HO' => __( 'Houaphanh', 'pcud_ml'),
		'KH' => __( 'Khammouane', 'pcud_ml'),
		'LM' => __( 'Luang Namtha', 'pcud_ml'),
		'LP' => __( 'Luang Prabang', 'pcud_ml'),
		'OU' => __( 'Oudomxay', 'pcud_ml'),
		'PH' => __( 'Phongsaly', 'pcud_ml'),
		'SL' => __( 'Salavan', 'pcud_ml'),
		'SV' => __( 'Savannakhet', 'pcud_ml'),
		'VI' => __( 'Vientiane Province', 'pcud_ml'),
		'VT' => __( 'Vientiane', 'pcud_ml'),
		'XA' => __( 'Sainyabuli', 'pcud_ml'),
		'XE' => __( 'Sekong', 'pcud_ml'),
		'XI' => __( 'Xiangkhouang', 'pcud_ml'),
		'XS' => __( 'Xaisomboun', 'pcud_ml'),
	),
	'LB' => array(),
	'LR' => array( // Liberia provinces.
		'BM' => __( 'Bomi', 'pcud_ml'),
		'BN' => __( 'Bong', 'pcud_ml'),
		'GA' => __( 'Gbarpolu', 'pcud_ml'),
		'GB' => __( 'Grand Bassa', 'pcud_ml'),
		'GC' => __( 'Grand Cape Mount', 'pcud_ml'),
		'GG' => __( 'Grand Gedeh', 'pcud_ml'),
		'GK' => __( 'Grand Kru', 'pcud_ml'),
		'LO' => __( 'Lofa', 'pcud_ml'),
		'MA' => __( 'Margibi', 'pcud_ml'),
		'MY' => __( 'Maryland', 'pcud_ml'),
		'MO' => __( 'Montserrado', 'pcud_ml'),
		'NM' => __( 'Nimba', 'pcud_ml'),
		'RV' => __( 'Rivercess', 'pcud_ml'),
		'RG' => __( 'River Gee', 'pcud_ml'),
		'SN' => __( 'Sinoe', 'pcud_ml'),
	),
	'LU' => array(),
	'MD' => array( // Moldova states.
		'C'  => __( 'Chișinău', 'pcud_ml'),
		'BL' => __( 'Bălți', 'pcud_ml'),
		'AN' => __( 'Anenii Noi', 'pcud_ml'),
		'BS' => __( 'Basarabeasca', 'pcud_ml'),
		'BR' => __( 'Briceni', 'pcud_ml'),
		'CH' => __( 'Cahul', 'pcud_ml'),
		'CT' => __( 'Cantemir', 'pcud_ml'),
		'CL' => __( 'Călărași', 'pcud_ml'),
		'CS' => __( 'Căușeni', 'pcud_ml'),
		'CM' => __( 'Cimișlia', 'pcud_ml'),
		'CR' => __( 'Criuleni', 'pcud_ml'),
		'DN' => __( 'Dondușeni', 'pcud_ml'),
		'DR' => __( 'Drochia', 'pcud_ml'),
		'DB' => __( 'Dubăsari', 'pcud_ml'),
		'ED' => __( 'Edineț', 'pcud_ml'),
		'FL' => __( 'Fălești', 'pcud_ml'),
		'FR' => __( 'Florești', 'pcud_ml'),
		'GE' => __( 'UTA Găgăuzia', 'pcud_ml'),
		'GL' => __( 'Glodeni', 'pcud_ml'),
		'HN' => __( 'Hîncești', 'pcud_ml'),
		'IL' => __( 'Ialoveni', 'pcud_ml'),
		'LV' => __( 'Leova', 'pcud_ml'),
		'NS' => __( 'Nisporeni', 'pcud_ml'),
		'OC' => __( 'Ocnița', 'pcud_ml'),
		'OR' => __( 'Orhei', 'pcud_ml'),
		'RZ' => __( 'Rezina', 'pcud_ml'),
		'RS' => __( 'Rîșcani', 'pcud_ml'),
		'SG' => __( 'Sîngerei', 'pcud_ml'),
		'SR' => __( 'Soroca', 'pcud_ml'),
		'ST' => __( 'Strășeni', 'pcud_ml'),
		'SD' => __( 'Șoldănești', 'pcud_ml'),
		'SV' => __( 'Ștefan Vodă', 'pcud_ml'),
		'TR' => __( 'Taraclia', 'pcud_ml'),
		'TL' => __( 'Telenești', 'pcud_ml'),
		'UN' => __( 'Ungheni', 'pcud_ml'),
	),
	'MQ' => array(),
	'MT' => array(),
	'MX' => array( // Mexico States.
		'DF' => __( 'Ciudad de México', 'pcud_ml'),
		'JA' => __( 'Jalisco', 'pcud_ml'),
		'NL' => __( 'Nuevo León', 'pcud_ml'),
		'AG' => __( 'Aguascalientes', 'pcud_ml'),
		'BC' => __( 'Baja California', 'pcud_ml'),
		'BS' => __( 'Baja California Sur', 'pcud_ml'),
		'CM' => __( 'Campeche', 'pcud_ml'),
		'CS' => __( 'Chiapas', 'pcud_ml'),
		'CH' => __( 'Chihuahua', 'pcud_ml'),
		'CO' => __( 'Coahuila', 'pcud_ml'),
		'CL' => __( 'Colima', 'pcud_ml'),
		'DG' => __( 'Durango', 'pcud_ml'),
		'GT' => __( 'Guanajuato', 'pcud_ml'),
		'GR' => __( 'Guerrero', 'pcud_ml'),
		'HG' => __( 'Hidalgo', 'pcud_ml'),
		'MX' => __( 'Estado de México', 'pcud_ml'),
		'MI' => __( 'Michoacán', 'pcud_ml'),
		'MO' => __( 'Morelos', 'pcud_ml'),
		'NA' => __( 'Nayarit', 'pcud_ml'),
		'OA' => __( 'Oaxaca', 'pcud_ml'),
		'PU' => __( 'Puebla', 'pcud_ml'),
		'QT' => __( 'Querétaro', 'pcud_ml'),
		'QR' => __( 'Quintana Roo', 'pcud_ml'),
		'SL' => __( 'San Luis Potosí', 'pcud_ml'),
		'SI' => __( 'Sinaloa', 'pcud_ml'),
		'SO' => __( 'Sonora', 'pcud_ml'),
		'TB' => __( 'Tabasco', 'pcud_ml'),
		'TM' => __( 'Tamaulipas', 'pcud_ml'),
		'TL' => __( 'Tlaxcala', 'pcud_ml'),
		'VE' => __( 'Veracruz', 'pcud_ml'),
		'YU' => __( 'Yucatán', 'pcud_ml'),
		'ZA' => __( 'Zacatecas', 'pcud_ml'),
	),
	'MY' => array( // Malaysian states.
		'JHR' => __( 'Johor', 'pcud_ml'),
		'KDH' => __( 'Kedah', 'pcud_ml'),
		'KTN' => __( 'Kelantan', 'pcud_ml'),
		'LBN' => __( 'Labuan', 'pcud_ml'),
		'MLK' => __( 'Malacca (Melaka)', 'pcud_ml'),
		'NSN' => __( 'Negeri Sembilan', 'pcud_ml'),
		'PHG' => __( 'Pahang', 'pcud_ml'),
		'PNG' => __( 'Penang (Pulau Pinang)', 'pcud_ml'),
		'PRK' => __( 'Perak', 'pcud_ml'),
		'PLS' => __( 'Perlis', 'pcud_ml'),
		'SBH' => __( 'Sabah', 'pcud_ml'),
		'SWK' => __( 'Sarawak', 'pcud_ml'),
		'SGR' => __( 'Selangor', 'pcud_ml'),
		'TRG' => __( 'Terengganu', 'pcud_ml'),
		'PJY' => __( 'Putrajaya', 'pcud_ml'),
		'KUL' => __( 'Kuala Lumpur', 'pcud_ml'),
	),
	'MZ' => array( // Mozambique provinces.
		'MZP'   => __( 'Cabo Delgado', 'pcud_ml'),
		'MZG'   => __( 'Gaza', 'pcud_ml'),
		'MZI'   => __( 'Inhambane', 'pcud_ml'),
		'MZB'   => __( 'Manica', 'pcud_ml'),
		'MZL'   => __( 'Maputo Province', 'pcud_ml'),
		'MZMPM' => __( 'Maputo', 'pcud_ml'),
		'MZN'   => __( 'Nampula', 'pcud_ml'),
		'MZA'   => __( 'Niassa', 'pcud_ml'),
		'MZS'   => __( 'Sofala', 'pcud_ml'),
		'MZT'   => __( 'Tete', 'pcud_ml'),
		'MZQ'   => __( 'Zambézia', 'pcud_ml'),
	),
	'NA' => array( // Namibia regions.
		'ER' => __( 'Erongo', 'pcud_ml'),
		'HA' => __( 'Hardap', 'pcud_ml'),
		'KA' => __( 'Karas', 'pcud_ml'),
		'KE' => __( 'Kavango East', 'pcud_ml'),
		'KW' => __( 'Kavango West', 'pcud_ml'),
		'KH' => __( 'Khomas', 'pcud_ml'),
		'KU' => __( 'Kunene', 'pcud_ml'),
		'OW' => __( 'Ohangwena', 'pcud_ml'),
		'OH' => __( 'Omaheke', 'pcud_ml'),
		'OS' => __( 'Omusati', 'pcud_ml'),
		'ON' => __( 'Oshana', 'pcud_ml'),
		'OT' => __( 'Oshikoto', 'pcud_ml'),
		'OD' => __( 'Otjozondjupa', 'pcud_ml'),
		'CA' => __( 'Zambezi', 'pcud_ml'),
	),
	'NG' => array( // Nigerian provinces.
		'AB' => __( 'Abia', 'pcud_ml'),
		'FC' => __( 'Abuja', 'pcud_ml'),
		'AD' => __( 'Adamawa', 'pcud_ml'),
		'AK' => __( 'Akwa Ibom', 'pcud_ml'),
		'AN' => __( 'Anambra', 'pcud_ml'),
		'BA' => __( 'Bauchi', 'pcud_ml'),
		'BY' => __( 'Bayelsa', 'pcud_ml'),
		'BE' => __( 'Benue', 'pcud_ml'),
		'BO' => __( 'Borno', 'pcud_ml'),
		'CR' => __( 'Cross River', 'pcud_ml'),
		'DE' => __( 'Delta', 'pcud_ml'),
		'EB' => __( 'Ebonyi', 'pcud_ml'),
		'ED' => __( 'Edo', 'pcud_ml'),
		'EK' => __( 'Ekiti', 'pcud_ml'),
		'EN' => __( 'Enugu', 'pcud_ml'),
		'GO' => __( 'Gombe', 'pcud_ml'),
		'IM' => __( 'Imo', 'pcud_ml'),
		'JI' => __( 'Jigawa', 'pcud_ml'),
		'KD' => __( 'Kaduna', 'pcud_ml'),
		'KN' => __( 'Kano', 'pcud_ml'),
		'KT' => __( 'Katsina', 'pcud_ml'),
		'KE' => __( 'Kebbi', 'pcud_ml'),
		'KO' => __( 'Kogi', 'pcud_ml'),
		'KW' => __( 'Kwara', 'pcud_ml'),
		'LA' => __( 'Lagos', 'pcud_ml'),
		'NA' => __( 'Nasarawa', 'pcud_ml'),
		'NI' => __( 'Niger', 'pcud_ml'),
		'OG' => __( 'Ogun', 'pcud_ml'),
		'ON' => __( 'Ondo', 'pcud_ml'),
		'OS' => __( 'Osun', 'pcud_ml'),
		'OY' => __( 'Oyo', 'pcud_ml'),
		'PL' => __( 'Plateau', 'pcud_ml'),
		'RI' => __( 'Rivers', 'pcud_ml'),
		'SO' => __( 'Sokoto', 'pcud_ml'),
		'TA' => __( 'Taraba', 'pcud_ml'),
		'YO' => __( 'Yobe', 'pcud_ml'),
		'ZA' => __( 'Zamfara', 'pcud_ml'),
	),
	'NL' => array(),
	'NO' => array(),
	'NP' => array( // Nepal states (Zones).
		'BAG' => __( 'Bagmati', 'pcud_ml'),
		'BHE' => __( 'Bheri', 'pcud_ml'),
		'DHA' => __( 'Dhaulagiri', 'pcud_ml'),
		'GAN' => __( 'Gandaki', 'pcud_ml'),
		'JAN' => __( 'Janakpur', 'pcud_ml'),
		'KAR' => __( 'Karnali', 'pcud_ml'),
		'KOS' => __( 'Koshi', 'pcud_ml'),
		'LUM' => __( 'Lumbini', 'pcud_ml'),
		'MAH' => __( 'Mahakali', 'pcud_ml'),
		'MEC' => __( 'Mechi', 'pcud_ml'),
		'NAR' => __( 'Narayani', 'pcud_ml'),
		'RAP' => __( 'Rapti', 'pcud_ml'),
		'SAG' => __( 'Sagarmatha', 'pcud_ml'),
		'SET' => __( 'Seti', 'pcud_ml'),
	),
	'NZ' => array( // New Zealand States.
		'NL' => __( 'Northland', 'pcud_ml'),
		'AK' => __( 'Auckland', 'pcud_ml'),
		'WA' => __( 'Waikato', 'pcud_ml'),
		'BP' => __( 'Bay of Plenty', 'pcud_ml'),
		'TK' => __( 'Taranaki', 'pcud_ml'),
		'GI' => __( 'Gisborne', 'pcud_ml'),
		'HB' => __( 'Hawke’s Bay', 'pcud_ml'),
		'MW' => __( 'Manawatu-Wanganui', 'pcud_ml'),
		'WE' => __( 'Wellington', 'pcud_ml'),
		'NS' => __( 'Nelson', 'pcud_ml'),
		'MB' => __( 'Marlborough', 'pcud_ml'),
		'TM' => __( 'Tasman', 'pcud_ml'),
		'WC' => __( 'West Coast', 'pcud_ml'),
		'CT' => __( 'Canterbury', 'pcud_ml'),
		'OT' => __( 'Otago', 'pcud_ml'),
		'SL' => __( 'Southland', 'pcud_ml'),
	),
	'PE' => array( // Peru states.
		'CAL' => __( 'El Callao', 'pcud_ml'),
		'LMA' => __( 'Municipalidad Metropolitana de Lima', 'pcud_ml'),
		'AMA' => __( 'Amazonas', 'pcud_ml'),
		'ANC' => __( 'Ancash', 'pcud_ml'),
		'APU' => __( 'Apurímac', 'pcud_ml'),
		'ARE' => __( 'Arequipa', 'pcud_ml'),
		'AYA' => __( 'Ayacucho', 'pcud_ml'),
		'CAJ' => __( 'Cajamarca', 'pcud_ml'),
		'CUS' => __( 'Cusco', 'pcud_ml'),
		'HUV' => __( 'Huancavelica', 'pcud_ml'),
		'HUC' => __( 'Huánuco', 'pcud_ml'),
		'ICA' => __( 'Ica', 'pcud_ml'),
		'JUN' => __( 'Junín', 'pcud_ml'),
		'LAL' => __( 'La Libertad', 'pcud_ml'),
		'LAM' => __( 'Lambayeque', 'pcud_ml'),
		'LIM' => __( 'Lima', 'pcud_ml'),
		'LOR' => __( 'Loreto', 'pcud_ml'),
		'MDD' => __( 'Madre de Dios', 'pcud_ml'),
		'MOQ' => __( 'Moquegua', 'pcud_ml'),
		'PAS' => __( 'Pasco', 'pcud_ml'),
		'PIU' => __( 'Piura', 'pcud_ml'),
		'PUN' => __( 'Puno', 'pcud_ml'),
		'SAM' => __( 'San Martín', 'pcud_ml'),
		'TAC' => __( 'Tacna', 'pcud_ml'),
		'TUM' => __( 'Tumbes', 'pcud_ml'),
		'UCA' => __( 'Ucayali', 'pcud_ml'),
	),

	/**
	 * Philippine Provinces.
	 */
	'PH' => array(
		'ABR' => __( 'Abra', 'pcud_ml'),
		'AGN' => __( 'Agusan del Norte', 'pcud_ml'),
		'AGS' => __( 'Agusan del Sur', 'pcud_ml'),
		'AKL' => __( 'Aklan', 'pcud_ml'),
		'ALB' => __( 'Albay', 'pcud_ml'),
		'ANT' => __( 'Antique', 'pcud_ml'),
		'APA' => __( 'Apayao', 'pcud_ml'),
		'AUR' => __( 'Aurora', 'pcud_ml'),
		'BAS' => __( 'Basilan', 'pcud_ml'),
		'BAN' => __( 'Bataan', 'pcud_ml'),
		'BTN' => __( 'Batanes', 'pcud_ml'),
		'BTG' => __( 'Batangas', 'pcud_ml'),
		'BEN' => __( 'Benguet', 'pcud_ml'),
		'BIL' => __( 'Biliran', 'pcud_ml'),
		'BOH' => __( 'Bohol', 'pcud_ml'),
		'BUK' => __( 'Bukidnon', 'pcud_ml'),
		'BUL' => __( 'Bulacan', 'pcud_ml'),
		'CAG' => __( 'Cagayan', 'pcud_ml'),
		'CAN' => __( 'Camarines Norte', 'pcud_ml'),
		'CAS' => __( 'Camarines Sur', 'pcud_ml'),
		'CAM' => __( 'Camiguin', 'pcud_ml'),
		'CAP' => __( 'Capiz', 'pcud_ml'),
		'CAT' => __( 'Catanduanes', 'pcud_ml'),
		'CAV' => __( 'Cavite', 'pcud_ml'),
		'CEB' => __( 'Cebu', 'pcud_ml'),
		'COM' => __( 'Compostela Valley', 'pcud_ml'),
		'NCO' => __( 'Cotabato', 'pcud_ml'),
		'DAV' => __( 'Davao del Norte', 'pcud_ml'),
		'DAS' => __( 'Davao del Sur', 'pcud_ml'),
		'DAC' => __( 'Davao Occidental', 'pcud_ml'),
		'DAO' => __( 'Davao Oriental', 'pcud_ml'),
		'DIN' => __( 'Dinagat Islands', 'pcud_ml'),
		'EAS' => __( 'Eastern Samar', 'pcud_ml'),
		'GUI' => __( 'Guimaras', 'pcud_ml'),
		'IFU' => __( 'Ifugao', 'pcud_ml'),
		'ILN' => __( 'Ilocos Norte', 'pcud_ml'),
		'ILS' => __( 'Ilocos Sur', 'pcud_ml'),
		'ILI' => __( 'Iloilo', 'pcud_ml'),
		'ISA' => __( 'Isabela', 'pcud_ml'),
		'KAL' => __( 'Kalinga', 'pcud_ml'),
		'LUN' => __( 'La Union', 'pcud_ml'),
		'LAG' => __( 'Laguna', 'pcud_ml'),
		'LAN' => __( 'Lanao del Norte', 'pcud_ml'),
		'LAS' => __( 'Lanao del Sur', 'pcud_ml'),
		'LEY' => __( 'Leyte', 'pcud_ml'),
		'MAG' => __( 'Maguindanao', 'pcud_ml'),
		'MAD' => __( 'Marinduque', 'pcud_ml'),
		'MAS' => __( 'Masbate', 'pcud_ml'),
		'MSC' => __( 'Misamis Occidental', 'pcud_ml'),
		'MSR' => __( 'Misamis Oriental', 'pcud_ml'),
		'MOU' => __( 'Mountain Province', 'pcud_ml'),
		'NEC' => __( 'Negros Occidental', 'pcud_ml'),
		'NER' => __( 'Negros Oriental', 'pcud_ml'),
		'NSA' => __( 'Northern Samar', 'pcud_ml'),
		'NUE' => __( 'Nueva Ecija', 'pcud_ml'),
		'NUV' => __( 'Nueva Vizcaya', 'pcud_ml'),
		'MDC' => __( 'Occidental Mindoro', 'pcud_ml'),
		'MDR' => __( 'Oriental Mindoro', 'pcud_ml'),
		'PLW' => __( 'Palawan', 'pcud_ml'),
		'PAM' => __( 'Pampanga', 'pcud_ml'),
		'PAN' => __( 'Pangasinan', 'pcud_ml'),
		'QUE' => __( 'Quezon', 'pcud_ml'),
		'QUI' => __( 'Quirino', 'pcud_ml'),
		'RIZ' => __( 'Rizal', 'pcud_ml'),
		'ROM' => __( 'Romblon', 'pcud_ml'),
		'WSA' => __( 'Samar', 'pcud_ml'),
		'SAR' => __( 'Sarangani', 'pcud_ml'),
		'SIQ' => __( 'Siquijor', 'pcud_ml'),
		'SOR' => __( 'Sorsogon', 'pcud_ml'),
		'SCO' => __( 'South Cotabato', 'pcud_ml'),
		'SLE' => __( 'Southern Leyte', 'pcud_ml'),
		'SUK' => __( 'Sultan Kudarat', 'pcud_ml'),
		'SLU' => __( 'Sulu', 'pcud_ml'),
		'SUN' => __( 'Surigao del Norte', 'pcud_ml'),
		'SUR' => __( 'Surigao del Sur', 'pcud_ml'),
		'TAR' => __( 'Tarlac', 'pcud_ml'),
		'TAW' => __( 'Tawi-Tawi', 'pcud_ml'),
		'ZMB' => __( 'Zambales', 'pcud_ml'),
		'ZAN' => __( 'Zamboanga del Norte', 'pcud_ml'),
		'ZAS' => __( 'Zamboanga del Sur', 'pcud_ml'),
		'ZSI' => __( 'Zamboanga Sibugay', 'pcud_ml'),
		'00'  => __( 'Metro Manila', 'pcud_ml'),
	),
	'PK' => array( // Pakistan's states.
		'JK' => __( 'Azad Kashmir', 'pcud_ml'),
		'BA' => __( 'Balochistan', 'pcud_ml'),
		'TA' => __( 'FATA', 'pcud_ml'),
		'GB' => __( 'Gilgit Baltistan', 'pcud_ml'),
		'IS' => __( 'Islamabad Capital Territory', 'pcud_ml'),
		'KP' => __( 'Khyber Pakhtunkhwa', 'pcud_ml'),
		'PB' => __( 'Punjab', 'pcud_ml'),
		'SD' => __( 'Sindh', 'pcud_ml'),
	),
	'PL' => array(),
	'PR' => array(),
	'PT' => array(),
	'PY' => array( // Paraguay states.
		'PY-ASU' => __( 'Asunción', 'pcud_ml'),
		'PY-1'   => __( 'Concepción', 'pcud_ml'),
		'PY-2'   => __( 'San Pedro', 'pcud_ml'),
		'PY-3'   => __( 'Cordillera', 'pcud_ml'),
		'PY-4'   => __( 'Guairá', 'pcud_ml'),
		'PY-5'   => __( 'Caaguazú', 'pcud_ml'),
		'PY-6'   => __( 'Caazapá', 'pcud_ml'),
		'PY-7'   => __( 'Itapúa', 'pcud_ml'),
		'PY-8'   => __( 'Misiones', 'pcud_ml'),
		'PY-9'   => __( 'Paraguarí', 'pcud_ml'),
		'PY-10'  => __( 'Alto Paraná', 'pcud_ml'),
		'PY-11'  => __( 'Central', 'pcud_ml'),
		'PY-12'  => __( 'Ñeembucú', 'pcud_ml'),
		'PY-13'  => __( 'Amambay', 'pcud_ml'),
		'PY-14'  => __( 'Canindeyú', 'pcud_ml'),
		'PY-15'  => __( 'Presidente Hayes', 'pcud_ml'),
		'PY-16'  => __( 'Alto Paraguay', 'pcud_ml'),
		'PY-17'  => __( 'Boquerón', 'pcud_ml'),
	),
	'RE' => array(),
	'RO' => array( // Romania states.
		'AB' => __( 'Alba', 'pcud_ml'),
		'AR' => __( 'Arad', 'pcud_ml'),
		'AG' => __( 'Argeș', 'pcud_ml'),
		'BC' => __( 'Bacău', 'pcud_ml'),
		'BH' => __( 'Bihor', 'pcud_ml'),
		'BN' => __( 'Bistrița-Năsăud', 'pcud_ml'),
		'BT' => __( 'Botoșani', 'pcud_ml'),
		'BR' => __( 'Brăila', 'pcud_ml'),
		'BV' => __( 'Brașov', 'pcud_ml'),
		'B'  => __( 'București', 'pcud_ml'),
		'BZ' => __( 'Buzău', 'pcud_ml'),
		'CL' => __( 'Călărași', 'pcud_ml'),
		'CS' => __( 'Caraș-Severin', 'pcud_ml'),
		'CJ' => __( 'Cluj', 'pcud_ml'),
		'CT' => __( 'Constanța', 'pcud_ml'),
		'CV' => __( 'Covasna', 'pcud_ml'),
		'DB' => __( 'Dâmbovița', 'pcud_ml'),
		'DJ' => __( 'Dolj', 'pcud_ml'),
		'GL' => __( 'Galați', 'pcud_ml'),
		'GR' => __( 'Giurgiu', 'pcud_ml'),
		'GJ' => __( 'Gorj', 'pcud_ml'),
		'HR' => __( 'Harghita', 'pcud_ml'),
		'HD' => __( 'Hunedoara', 'pcud_ml'),
		'IL' => __( 'Ialomița', 'pcud_ml'),
		'IS' => __( 'Iași', 'pcud_ml'),
		'IF' => __( 'Ilfov', 'pcud_ml'),
		'MM' => __( 'Maramureș', 'pcud_ml'),
		'MH' => __( 'Mehedinți', 'pcud_ml'),
		'MS' => __( 'Mureș', 'pcud_ml'),
		'NT' => __( 'Neamț', 'pcud_ml'),
		'OT' => __( 'Olt', 'pcud_ml'),
		'PH' => __( 'Prahova', 'pcud_ml'),
		'SJ' => __( 'Sălaj', 'pcud_ml'),
		'SM' => __( 'Satu Mare', 'pcud_ml'),
		'SB' => __( 'Sibiu', 'pcud_ml'),
		'SV' => __( 'Suceava', 'pcud_ml'),
		'TR' => __( 'Teleorman', 'pcud_ml'),
		'TM' => __( 'Timiș', 'pcud_ml'),
		'TL' => __( 'Tulcea', 'pcud_ml'),
		'VL' => __( 'Vâlcea', 'pcud_ml'),
		'VS' => __( 'Vaslui', 'pcud_ml'),
		'VN' => __( 'Vrancea', 'pcud_ml'),
	),
	'SG' => array(),
	'SK' => array(),
	'SI' => array(),
	'TH' => array( // Thailand states.
		'TH-37' => __( 'Amnat Charoen', 'pcud_ml'),
		'TH-15' => __( 'Ang Thong', 'pcud_ml'),
		'TH-14' => __( 'Ayutthaya', 'pcud_ml'),
		'TH-10' => __( 'Bangkok', 'pcud_ml'),
		'TH-38' => __( 'Bueng Kan', 'pcud_ml'),
		'TH-31' => __( 'Buri Ram', 'pcud_ml'),
		'TH-24' => __( 'Chachoengsao', 'pcud_ml'),
		'TH-18' => __( 'Chai Nat', 'pcud_ml'),
		'TH-36' => __( 'Chaiyaphum', 'pcud_ml'),
		'TH-22' => __( 'Chanthaburi', 'pcud_ml'),
		'TH-50' => __( 'Chiang Mai', 'pcud_ml'),
		'TH-57' => __( 'Chiang Rai', 'pcud_ml'),
		'TH-20' => __( 'Chonburi', 'pcud_ml'),
		'TH-86' => __( 'Chumphon', 'pcud_ml'),
		'TH-46' => __( 'Kalasin', 'pcud_ml'),
		'TH-62' => __( 'Kamphaeng Phet', 'pcud_ml'),
		'TH-71' => __( 'Kanchanaburi', 'pcud_ml'),
		'TH-40' => __( 'Khon Kaen', 'pcud_ml'),
		'TH-81' => __( 'Krabi', 'pcud_ml'),
		'TH-52' => __( 'Lampang', 'pcud_ml'),
		'TH-51' => __( 'Lamphun', 'pcud_ml'),
		'TH-42' => __( 'Loei', 'pcud_ml'),
		'TH-16' => __( 'Lopburi', 'pcud_ml'),
		'TH-58' => __( 'Mae Hong Son', 'pcud_ml'),
		'TH-44' => __( 'Maha Sarakham', 'pcud_ml'),
		'TH-49' => __( 'Mukdahan', 'pcud_ml'),
		'TH-26' => __( 'Nakhon Nayok', 'pcud_ml'),
		'TH-73' => __( 'Nakhon Pathom', 'pcud_ml'),
		'TH-48' => __( 'Nakhon Phanom', 'pcud_ml'),
		'TH-30' => __( 'Nakhon Ratchasima', 'pcud_ml'),
		'TH-60' => __( 'Nakhon Sawan', 'pcud_ml'),
		'TH-80' => __( 'Nakhon Si Thammarat', 'pcud_ml'),
		'TH-55' => __( 'Nan', 'pcud_ml'),
		'TH-96' => __( 'Narathiwat', 'pcud_ml'),
		'TH-39' => __( 'Nong Bua Lam Phu', 'pcud_ml'),
		'TH-43' => __( 'Nong Khai', 'pcud_ml'),
		'TH-12' => __( 'Nonthaburi', 'pcud_ml'),
		'TH-13' => __( 'Pathum Thani', 'pcud_ml'),
		'TH-94' => __( 'Pattani', 'pcud_ml'),
		'TH-82' => __( 'Phang Nga', 'pcud_ml'),
		'TH-93' => __( 'Phatthalung', 'pcud_ml'),
		'TH-56' => __( 'Phayao', 'pcud_ml'),
		'TH-67' => __( 'Phetchabun', 'pcud_ml'),
		'TH-76' => __( 'Phetchaburi', 'pcud_ml'),
		'TH-66' => __( 'Phichit', 'pcud_ml'),
		'TH-65' => __( 'Phitsanulok', 'pcud_ml'),
		'TH-54' => __( 'Phrae', 'pcud_ml'),
		'TH-83' => __( 'Phuket', 'pcud_ml'),
		'TH-25' => __( 'Prachin Buri', 'pcud_ml'),
		'TH-77' => __( 'Prachuap Khiri Khan', 'pcud_ml'),
		'TH-85' => __( 'Ranong', 'pcud_ml'),
		'TH-70' => __( 'Ratchaburi', 'pcud_ml'),
		'TH-21' => __( 'Rayong', 'pcud_ml'),
		'TH-45' => __( 'Roi Et', 'pcud_ml'),
		'TH-27' => __( 'Sa Kaeo', 'pcud_ml'),
		'TH-47' => __( 'Sakon Nakhon', 'pcud_ml'),
		'TH-11' => __( 'Samut Prakan', 'pcud_ml'),
		'TH-74' => __( 'Samut Sakhon', 'pcud_ml'),
		'TH-75' => __( 'Samut Songkhram', 'pcud_ml'),
		'TH-19' => __( 'Saraburi', 'pcud_ml'),
		'TH-91' => __( 'Satun', 'pcud_ml'),
		'TH-17' => __( 'Sing Buri', 'pcud_ml'),
		'TH-33' => __( 'Sisaket', 'pcud_ml'),
		'TH-90' => __( 'Songkhla', 'pcud_ml'),
		'TH-64' => __( 'Sukhothai', 'pcud_ml'),
		'TH-72' => __( 'Suphan Buri', 'pcud_ml'),
		'TH-84' => __( 'Surat Thani', 'pcud_ml'),
		'TH-32' => __( 'Surin', 'pcud_ml'),
		'TH-63' => __( 'Tak', 'pcud_ml'),
		'TH-92' => __( 'Trang', 'pcud_ml'),
		'TH-23' => __( 'Trat', 'pcud_ml'),
		'TH-34' => __( 'Ubon Ratchathani', 'pcud_ml'),
		'TH-41' => __( 'Udon Thani', 'pcud_ml'),
		'TH-61' => __( 'Uthai Thani', 'pcud_ml'),
		'TH-53' => __( 'Uttaradit', 'pcud_ml'),
		'TH-95' => __( 'Yala', 'pcud_ml'),
		'TH-35' => __( 'Yasothon', 'pcud_ml'),
	),
	'TR' => array( // Turkey States.
		'TR01' => __( 'Adana', 'pcud_ml'),
		'TR02' => __( 'Adıyaman', 'pcud_ml'),
		'TR03' => __( 'Afyon', 'pcud_ml'),
		'TR04' => __( 'Ağrı', 'pcud_ml'),
		'TR05' => __( 'Amasya', 'pcud_ml'),
		'TR06' => __( 'Ankara', 'pcud_ml'),
		'TR07' => __( 'Antalya', 'pcud_ml'),
		'TR08' => __( 'Artvin', 'pcud_ml'),
		'TR09' => __( 'Aydın', 'pcud_ml'),
		'TR10' => __( 'Balıkesir', 'pcud_ml'),
		'TR11' => __( 'Bilecik', 'pcud_ml'),
		'TR12' => __( 'Bingöl', 'pcud_ml'),
		'TR13' => __( 'Bitlis', 'pcud_ml'),
		'TR14' => __( 'Bolu', 'pcud_ml'),
		'TR15' => __( 'Burdur', 'pcud_ml'),
		'TR16' => __( 'Bursa', 'pcud_ml'),
		'TR17' => __( 'Çanakkale', 'pcud_ml'),
		'TR18' => __( 'Çankırı', 'pcud_ml'),
		'TR19' => __( 'Çorum', 'pcud_ml'),
		'TR20' => __( 'Denizli', 'pcud_ml'),
		'TR21' => __( 'Diyarbakır', 'pcud_ml'),
		'TR22' => __( 'Edirne', 'pcud_ml'),
		'TR23' => __( 'Elazığ', 'pcud_ml'),
		'TR24' => __( 'Erzincan', 'pcud_ml'),
		'TR25' => __( 'Erzurum', 'pcud_ml'),
		'TR26' => __( 'Eskişehir', 'pcud_ml'),
		'TR27' => __( 'Gaziantep', 'pcud_ml'),
		'TR28' => __( 'Giresun', 'pcud_ml'),
		'TR29' => __( 'Gümüşhane', 'pcud_ml'),
		'TR30' => __( 'Hakkari', 'pcud_ml'),
		'TR31' => __( 'Hatay', 'pcud_ml'),
		'TR32' => __( 'Isparta', 'pcud_ml'),
		'TR33' => __( 'İçel', 'pcud_ml'),
		'TR34' => __( 'İstanbul', 'pcud_ml'),
		'TR35' => __( 'İzmir', 'pcud_ml'),
		'TR36' => __( 'Kars', 'pcud_ml'),
		'TR37' => __( 'Kastamonu', 'pcud_ml'),
		'TR38' => __( 'Kayseri', 'pcud_ml'),
		'TR39' => __( 'Kırklareli', 'pcud_ml'),
		'TR40' => __( 'Kırşehir', 'pcud_ml'),
		'TR41' => __( 'Kocaeli', 'pcud_ml'),
		'TR42' => __( 'Konya', 'pcud_ml'),
		'TR43' => __( 'Kütahya', 'pcud_ml'),
		'TR44' => __( 'Malatya', 'pcud_ml'),
		'TR45' => __( 'Manisa', 'pcud_ml'),
		'TR46' => __( 'Kahramanmaraş', 'pcud_ml'),
		'TR47' => __( 'Mardin', 'pcud_ml'),
		'TR48' => __( 'Muğla', 'pcud_ml'),
		'TR49' => __( 'Muş', 'pcud_ml'),
		'TR50' => __( 'Nevşehir', 'pcud_ml'),
		'TR51' => __( 'Niğde', 'pcud_ml'),
		'TR52' => __( 'Ordu', 'pcud_ml'),
		'TR53' => __( 'Rize', 'pcud_ml'),
		'TR54' => __( 'Sakarya', 'pcud_ml'),
		'TR55' => __( 'Samsun', 'pcud_ml'),
		'TR56' => __( 'Siirt', 'pcud_ml'),
		'TR57' => __( 'Sinop', 'pcud_ml'),
		'TR58' => __( 'Sivas', 'pcud_ml'),
		'TR59' => __( 'Tekirdağ', 'pcud_ml'),
		'TR60' => __( 'Tokat', 'pcud_ml'),
		'TR61' => __( 'Trabzon', 'pcud_ml'),
		'TR62' => __( 'Tunceli', 'pcud_ml'),
		'TR63' => __( 'Şanlıurfa', 'pcud_ml'),
		'TR64' => __( 'Uşak', 'pcud_ml'),
		'TR65' => __( 'Van', 'pcud_ml'),
		'TR66' => __( 'Yozgat', 'pcud_ml'),
		'TR67' => __( 'Zonguldak', 'pcud_ml'),
		'TR68' => __( 'Aksaray', 'pcud_ml'),
		'TR69' => __( 'Bayburt', 'pcud_ml'),
		'TR70' => __( 'Karaman', 'pcud_ml'),
		'TR71' => __( 'Kırıkkale', 'pcud_ml'),
		'TR72' => __( 'Batman', 'pcud_ml'),
		'TR73' => __( 'Şırnak', 'pcud_ml'),
		'TR74' => __( 'Bartın', 'pcud_ml'),
		'TR75' => __( 'Ardahan', 'pcud_ml'),
		'TR76' => __( 'Iğdır', 'pcud_ml'),
		'TR77' => __( 'Yalova', 'pcud_ml'),
		'TR78' => __( 'Karabük', 'pcud_ml'),
		'TR79' => __( 'Kilis', 'pcud_ml'),
		'TR80' => __( 'Osmaniye', 'pcud_ml'),
		'TR81' => __( 'Düzce', 'pcud_ml'),
	),
	'TZ' => array( // Tanzania States.
		'TZ01' => __( 'Arusha', 'pcud_ml'),
		'TZ02' => __( 'Dar es Salaam', 'pcud_ml'),
		'TZ03' => __( 'Dodoma', 'pcud_ml'),
		'TZ04' => __( 'Iringa', 'pcud_ml'),
		'TZ05' => __( 'Kagera', 'pcud_ml'),
		'TZ06' => __( 'Pemba North', 'pcud_ml'),
		'TZ07' => __( 'Zanzibar North', 'pcud_ml'),
		'TZ08' => __( 'Kigoma', 'pcud_ml'),
		'TZ09' => __( 'Kilimanjaro', 'pcud_ml'),
		'TZ10' => __( 'Pemba South', 'pcud_ml'),
		'TZ11' => __( 'Zanzibar South', 'pcud_ml'),
		'TZ12' => __( 'Lindi', 'pcud_ml'),
		'TZ13' => __( 'Mara', 'pcud_ml'),
		'TZ14' => __( 'Mbeya', 'pcud_ml'),
		'TZ15' => __( 'Zanzibar West', 'pcud_ml'),
		'TZ16' => __( 'Morogoro', 'pcud_ml'),
		'TZ17' => __( 'Mtwara', 'pcud_ml'),
		'TZ18' => __( 'Mwanza', 'pcud_ml'),
		'TZ19' => __( 'Coast', 'pcud_ml'),
		'TZ20' => __( 'Rukwa', 'pcud_ml'),
		'TZ21' => __( 'Ruvuma', 'pcud_ml'),
		'TZ22' => __( 'Shinyanga', 'pcud_ml'),
		'TZ23' => __( 'Singida', 'pcud_ml'),
		'TZ24' => __( 'Tabora', 'pcud_ml'),
		'TZ25' => __( 'Tanga', 'pcud_ml'),
		'TZ26' => __( 'Manyara', 'pcud_ml'),
		'TZ27' => __( 'Geita', 'pcud_ml'),
		'TZ28' => __( 'Katavi', 'pcud_ml'),
		'TZ29' => __( 'Njombe', 'pcud_ml'),
		'TZ30' => __( 'Simiyu', 'pcud_ml'),
	),
	'LK' => array(),
	'RS' => array( // Serbia districts. Ref: https://github.com/unicode-org/cldr/blob/release-37/common/subdivisions/en.xml#L4251-L4283.
		'RS00' => _x( 'Belgrade', 'district', 'pcud_ml'),
		'RS14' => _x( 'Bor', 'district', 'pcud_ml'),
		'RS11' => _x( 'Braničevo', 'district', 'pcud_ml'),
		'RS02' => _x( 'Central Banat', 'district', 'pcud_ml'),
		'RS10' => _x( 'Danube', 'district', 'pcud_ml'),
		'RS23' => _x( 'Jablanica', 'district', 'pcud_ml'),
		'RS09' => _x( 'Kolubara', 'district', 'pcud_ml'),
		'RS08' => _x( 'Mačva', 'district', 'pcud_ml'),
		'RS17' => _x( 'Morava', 'district', 'pcud_ml'),
		'RS20' => _x( 'Nišava', 'district', 'pcud_ml'),
		'RS01' => _x( 'North Bačka', 'district', 'pcud_ml'),
		'RS03' => _x( 'North Banat', 'district', 'pcud_ml'),
		'RS24' => _x( 'Pčinja', 'district', 'pcud_ml'),
		'RS22' => _x( 'Pirot', 'district', 'pcud_ml'),
		'RS13' => _x( 'Pomoravlje', 'district', 'pcud_ml'),
		'RS19' => _x( 'Rasina', 'district', 'pcud_ml'),
		'RS18' => _x( 'Raška', 'district', 'pcud_ml'),
		'RS06' => _x( 'South Bačka', 'district', 'pcud_ml'),
		'RS04' => _x( 'South Banat', 'district', 'pcud_ml'),
		'RS07' => _x( 'Srem', 'district', 'pcud_ml'),
		'RS12' => _x( 'Šumadija', 'district', 'pcud_ml'),
		'RS21' => _x( 'Toplica', 'district', 'pcud_ml'),
		'RS05' => _x( 'West Bačka', 'district', 'pcud_ml'),
		'RS15' => _x( 'Zaječar', 'district', 'pcud_ml'),
		'RS16' => _x( 'Zlatibor', 'district', 'pcud_ml'),
		'RS25' => _x( 'Kosovo', 'district', 'pcud_ml'),
		'RS26' => _x( 'Peć', 'district', 'pcud_ml'),
		'RS27' => _x( 'Prizren', 'district', 'pcud_ml'),
		'RS28' => _x( 'Kosovska Mitrovica', 'district', 'pcud_ml'),
		'RS29' => _x( 'Kosovo-Pomoravlje', 'district', 'pcud_ml'),
		'RSKM' => _x( 'Kosovo-Metohija', 'district', 'pcud_ml'),
		'RSVO' => _x( 'Vojvodina', 'district', 'pcud_ml'),
	),
	'SE' => array(),
	'UA' => array( // Ukraine. Ref: https://en.wikipedia.org/wiki/Oblasts_of_Ukraine.
		'VN' => __( 'Vinnytsia Oblast', 'pcud_ml'),
		'VL' => __( 'Volyn Oblast', 'pcud_ml'),
		'DP' => __( 'Dnipropetrovsk Oblast', 'pcud_ml'),
		'DT' => __( 'Donetsk Oblast', 'pcud_ml'),
		'ZT' => __( 'Zhytomyr Oblast', 'pcud_ml'),
		'ZK' => __( 'Zakarpattia Oblast', 'pcud_ml'),
		'ZP' => __( 'Zaporizhzhia Oblast', 'pcud_ml'),
		'IF' => __( 'Ivano-Frankivsk Oblast', 'pcud_ml'),
		'KV' => __( 'Kyiv Oblast', 'pcud_ml'),
		'KH' => __( 'Kirovohrad Oblast', 'pcud_ml'),
		'LH' => __( 'Luhansk Oblast', 'pcud_ml'),
		'LV' => __( 'Lviv Oblast', 'pcud_ml'),
		'MY' => __( 'Mykolaiv Oblast', 'pcud_ml'),
		'OD' => __( 'Odessa Oblast', 'pcud_ml'),
		'PL' => __( 'Poltava Oblast', 'pcud_ml'),
		'RV' => __( 'Rivne Oblast', 'pcud_ml'),
		'SM' => __( 'Sumy Oblast', 'pcud_ml'),
		'TP' => __( 'Ternopil Oblast', 'pcud_ml'),
		'KK' => __( 'Kharkiv Oblast', 'pcud_ml'),
		'KS' => __( 'Kherson Oblast', 'pcud_ml'),
		'KM' => __( 'Khmelnytskyi Oblast', 'pcud_ml'),
		'CK' => __( 'Cherkasy Oblast', 'pcud_ml'),
		'CH' => __( 'Chernihiv Oblast', 'pcud_ml'),
		'CV' => __( 'Chernivtsi Oblast', 'pcud_ml'),
	),
	'UG' => array( // Uganda districts. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:UG.
		'UG314' => __( 'Abim', 'pcud_ml'),
		'UG301' => __( 'Adjumani', 'pcud_ml'),
		'UG322' => __( 'Agago', 'pcud_ml'),
		'UG323' => __( 'Alebtong', 'pcud_ml'),
		'UG315' => __( 'Amolatar', 'pcud_ml'),
		'UG324' => __( 'Amudat', 'pcud_ml'),
		'UG216' => __( 'Amuria', 'pcud_ml'),
		'UG316' => __( 'Amuru', 'pcud_ml'),
		'UG302' => __( 'Apac', 'pcud_ml'),
		'UG303' => __( 'Arua', 'pcud_ml'),
		'UG217' => __( 'Budaka', 'pcud_ml'),
		'UG218' => __( 'Bududa', 'pcud_ml'),
		'UG201' => __( 'Bugiri', 'pcud_ml'),
		'UG235' => __( 'Bugweri', 'pcud_ml'),
		'UG420' => __( 'Buhweju', 'pcud_ml'),
		'UG117' => __( 'Buikwe', 'pcud_ml'),
		'UG219' => __( 'Bukedea', 'pcud_ml'),
		'UG118' => __( 'Bukomansimbi', 'pcud_ml'),
		'UG220' => __( 'Bukwa', 'pcud_ml'),
		'UG225' => __( 'Bulambuli', 'pcud_ml'),
		'UG416' => __( 'Buliisa', 'pcud_ml'),
		'UG401' => __( 'Bundibugyo', 'pcud_ml'),
		'UG430' => __( 'Bunyangabu', 'pcud_ml'),
		'UG402' => __( 'Bushenyi', 'pcud_ml'),
		'UG202' => __( 'Busia', 'pcud_ml'),
		'UG221' => __( 'Butaleja', 'pcud_ml'),
		'UG119' => __( 'Butambala', 'pcud_ml'),
		'UG233' => __( 'Butebo', 'pcud_ml'),
		'UG120' => __( 'Buvuma', 'pcud_ml'),
		'UG226' => __( 'Buyende', 'pcud_ml'),
		'UG317' => __( 'Dokolo', 'pcud_ml'),
		'UG121' => __( 'Gomba', 'pcud_ml'),
		'UG304' => __( 'Gulu', 'pcud_ml'),
		'UG403' => __( 'Hoima', 'pcud_ml'),
		'UG417' => __( 'Ibanda', 'pcud_ml'),
		'UG203' => __( 'Iganga', 'pcud_ml'),
		'UG418' => __( 'Isingiro', 'pcud_ml'),
		'UG204' => __( 'Jinja', 'pcud_ml'),
		'UG318' => __( 'Kaabong', 'pcud_ml'),
		'UG404' => __( 'Kabale', 'pcud_ml'),
		'UG405' => __( 'Kabarole', 'pcud_ml'),
		'UG213' => __( 'Kaberamaido', 'pcud_ml'),
		'UG427' => __( 'Kagadi', 'pcud_ml'),
		'UG428' => __( 'Kakumiro', 'pcud_ml'),
		'UG101' => __( 'Kalangala', 'pcud_ml'),
		'UG222' => __( 'Kaliro', 'pcud_ml'),
		'UG122' => __( 'Kalungu', 'pcud_ml'),
		'UG102' => __( 'Kampala', 'pcud_ml'),
		'UG205' => __( 'Kamuli', 'pcud_ml'),
		'UG413' => __( 'Kamwenge', 'pcud_ml'),
		'UG414' => __( 'Kanungu', 'pcud_ml'),
		'UG206' => __( 'Kapchorwa', 'pcud_ml'),
		'UG236' => __( 'Kapelebyong', 'pcud_ml'),
		'UG126' => __( 'Kasanda', 'pcud_ml'),
		'UG406' => __( 'Kasese', 'pcud_ml'),
		'UG207' => __( 'Katakwi', 'pcud_ml'),
		'UG112' => __( 'Kayunga', 'pcud_ml'),
		'UG407' => __( 'Kibaale', 'pcud_ml'),
		'UG103' => __( 'Kiboga', 'pcud_ml'),
		'UG227' => __( 'Kibuku', 'pcud_ml'),
		'UG432' => __( 'Kikuube', 'pcud_ml'),
		'UG419' => __( 'Kiruhura', 'pcud_ml'),
		'UG421' => __( 'Kiryandongo', 'pcud_ml'),
		'UG408' => __( 'Kisoro', 'pcud_ml'),
		'UG305' => __( 'Kitgum', 'pcud_ml'),
		'UG319' => __( 'Koboko', 'pcud_ml'),
		'UG325' => __( 'Kole', 'pcud_ml'),
		'UG306' => __( 'Kotido', 'pcud_ml'),
		'UG208' => __( 'Kumi', 'pcud_ml'),
		'UG333' => __( 'Kwania', 'pcud_ml'),
		'UG228' => __( 'Kween', 'pcud_ml'),
		'UG123' => __( 'Kyankwanzi', 'pcud_ml'),
		'UG422' => __( 'Kyegegwa', 'pcud_ml'),
		'UG415' => __( 'Kyenjojo', 'pcud_ml'),
		'UG125' => __( 'Kyotera', 'pcud_ml'),
		'UG326' => __( 'Lamwo', 'pcud_ml'),
		'UG307' => __( 'Lira', 'pcud_ml'),
		'UG229' => __( 'Luuka', 'pcud_ml'),
		'UG104' => __( 'Luwero', 'pcud_ml'),
		'UG124' => __( 'Lwengo', 'pcud_ml'),
		'UG114' => __( 'Lyantonde', 'pcud_ml'),
		'UG223' => __( 'Manafwa', 'pcud_ml'),
		'UG320' => __( 'Maracha', 'pcud_ml'),
		'UG105' => __( 'Masaka', 'pcud_ml'),
		'UG409' => __( 'Masindi', 'pcud_ml'),
		'UG214' => __( 'Mayuge', 'pcud_ml'),
		'UG209' => __( 'Mbale', 'pcud_ml'),
		'UG410' => __( 'Mbarara', 'pcud_ml'),
		'UG423' => __( 'Mitooma', 'pcud_ml'),
		'UG115' => __( 'Mityana', 'pcud_ml'),
		'UG308' => __( 'Moroto', 'pcud_ml'),
		'UG309' => __( 'Moyo', 'pcud_ml'),
		'UG106' => __( 'Mpigi', 'pcud_ml'),
		'UG107' => __( 'Mubende', 'pcud_ml'),
		'UG108' => __( 'Mukono', 'pcud_ml'),
		'UG334' => __( 'Nabilatuk', 'pcud_ml'),
		'UG311' => __( 'Nakapiripirit', 'pcud_ml'),
		'UG116' => __( 'Nakaseke', 'pcud_ml'),
		'UG109' => __( 'Nakasongola', 'pcud_ml'),
		'UG230' => __( 'Namayingo', 'pcud_ml'),
		'UG234' => __( 'Namisindwa', 'pcud_ml'),
		'UG224' => __( 'Namutumba', 'pcud_ml'),
		'UG327' => __( 'Napak', 'pcud_ml'),
		'UG310' => __( 'Nebbi', 'pcud_ml'),
		'UG231' => __( 'Ngora', 'pcud_ml'),
		'UG424' => __( 'Ntoroko', 'pcud_ml'),
		'UG411' => __( 'Ntungamo', 'pcud_ml'),
		'UG328' => __( 'Nwoya', 'pcud_ml'),
		'UG331' => __( 'Omoro', 'pcud_ml'),
		'UG329' => __( 'Otuke', 'pcud_ml'),
		'UG321' => __( 'Oyam', 'pcud_ml'),
		'UG312' => __( 'Pader', 'pcud_ml'),
		'UG332' => __( 'Pakwach', 'pcud_ml'),
		'UG210' => __( 'Pallisa', 'pcud_ml'),
		'UG110' => __( 'Rakai', 'pcud_ml'),
		'UG429' => __( 'Rubanda', 'pcud_ml'),
		'UG425' => __( 'Rubirizi', 'pcud_ml'),
		'UG431' => __( 'Rukiga', 'pcud_ml'),
		'UG412' => __( 'Rukungiri', 'pcud_ml'),
		'UG111' => __( 'Sembabule', 'pcud_ml'),
		'UG232' => __( 'Serere', 'pcud_ml'),
		'UG426' => __( 'Sheema', 'pcud_ml'),
		'UG215' => __( 'Sironko', 'pcud_ml'),
		'UG211' => __( 'Soroti', 'pcud_ml'),
		'UG212' => __( 'Tororo', 'pcud_ml'),
		'UG113' => __( 'Wakiso', 'pcud_ml'),
		'UG313' => __( 'Yumbe', 'pcud_ml'),
		'UG330' => __( 'Zombo', 'pcud_ml'),
	),
	'UM' => array(
		'81' => __( 'Baker Island', 'pcud_ml'),
		'84' => __( 'Howland Island', 'pcud_ml'),
		'86' => __( 'Jarvis Island', 'pcud_ml'),
		'67' => __( 'Johnston Atoll', 'pcud_ml'),
		'89' => __( 'Kingman Reef', 'pcud_ml'),
		'71' => __( 'Midway Atoll', 'pcud_ml'),
		'76' => __( 'Navassa Island', 'pcud_ml'),
		'95' => __( 'Palmyra Atoll', 'pcud_ml'),
		'79' => __( 'Wake Island', 'pcud_ml'),
	),
	'US' => array( // United States.
		'AL' => __( 'Alabama', 'pcud_ml'),
		'AK' => __( 'Alaska', 'pcud_ml'),
		'AZ' => __( 'Arizona', 'pcud_ml'),
		'AR' => __( 'Arkansas', 'pcud_ml'),
		'CA' => __( 'California', 'pcud_ml'),
		'CO' => __( 'Colorado', 'pcud_ml'),
		'CT' => __( 'Connecticut', 'pcud_ml'),
		'DE' => __( 'Delaware', 'pcud_ml'),
		'DC' => __( 'District Of Columbia', 'pcud_ml'),
		'FL' => __( 'Florida', 'pcud_ml'),
		'GA' => _x( 'Georgia', 'US state of Georgia', 'pcud_ml'),
		'HI' => __( 'Hawaii', 'pcud_ml'),
		'ID' => __( 'Idaho', 'pcud_ml'),
		'IL' => __( 'Illinois', 'pcud_ml'),
		'IN' => __( 'Indiana', 'pcud_ml'),
		'IA' => __( 'Iowa', 'pcud_ml'),
		'KS' => __( 'Kansas', 'pcud_ml'),
		'KY' => __( 'Kentucky', 'pcud_ml'),
		'LA' => __( 'Louisiana', 'pcud_ml'),
		'ME' => __( 'Maine', 'pcud_ml'),
		'MD' => __( 'Maryland', 'pcud_ml'),
		'MA' => __( 'Massachusetts', 'pcud_ml'),
		'MI' => __( 'Michigan', 'pcud_ml'),
		'MN' => __( 'Minnesota', 'pcud_ml'),
		'MS' => __( 'Mississippi', 'pcud_ml'),
		'MO' => __( 'Missouri', 'pcud_ml'),
		'MT' => __( 'Montana', 'pcud_ml'),
		'NE' => __( 'Nebraska', 'pcud_ml'),
		'NV' => __( 'Nevada', 'pcud_ml'),
		'NH' => __( 'New Hampshire', 'pcud_ml'),
		'NJ' => __( 'New Jersey', 'pcud_ml'),
		'NM' => __( 'New Mexico', 'pcud_ml'),
		'NY' => __( 'New York', 'pcud_ml'),
		'NC' => __( 'North Carolina', 'pcud_ml'),
		'ND' => __( 'North Dakota', 'pcud_ml'),
		'OH' => __( 'Ohio', 'pcud_ml'),
		'OK' => __( 'Oklahoma', 'pcud_ml'),
		'OR' => __( 'Oregon', 'pcud_ml'),
		'PA' => __( 'Pennsylvania', 'pcud_ml'),
		'RI' => __( 'Rhode Island', 'pcud_ml'),
		'SC' => __( 'South Carolina', 'pcud_ml'),
		'SD' => __( 'South Dakota', 'pcud_ml'),
		'TN' => __( 'Tennessee', 'pcud_ml'),
		'TX' => __( 'Texas', 'pcud_ml'),
		'UT' => __( 'Utah', 'pcud_ml'),
		'VT' => __( 'Vermont', 'pcud_ml'),
		'VA' => __( 'Virginia', 'pcud_ml'),
		'WA' => __( 'Washington', 'pcud_ml'),
		'WV' => __( 'West Virginia', 'pcud_ml'),
		'WI' => __( 'Wisconsin', 'pcud_ml'),
		'WY' => __( 'Wyoming', 'pcud_ml'),
		'AA' => __( 'Armed Forces (AA)', 'pcud_ml'),
		'AE' => __( 'Armed Forces (AE)', 'pcud_ml'),
		'AP' => __( 'Armed Forces (AP)', 'pcud_ml'),
	),
	'VE' => array( // Venezuela States. Ref: https://github.com/unicode-org/cldr/blob/release-38-1/common/subdivisions/en.xml#L5426-L5451
		'A' => __( 'Capital', 'pcud_ml'),
		'B' => __( 'Anzoátegui', 'pcud_ml'),
		'C' => __( 'Apure', 'pcud_ml'),
		'D' => __( 'Aragua', 'pcud_ml'),
		'E' => __( 'Barinas', 'pcud_ml'),
		'F' => __( 'Bolívar', 'pcud_ml'),
		'G' => __( 'Carabobo', 'pcud_ml'),
		'H' => __( 'Cojedes', 'pcud_ml'),
		'I' => __( 'Falcón', 'pcud_ml'),
		'J' => __( 'Guárico', 'pcud_ml'),
		'K' => __( 'Lara', 'pcud_ml'),
		'L' => __( 'Mérida', 'pcud_ml'),
		'M' => __( 'Miranda', 'pcud_ml'),
		'N' => __( 'Monagas', 'pcud_ml'),
		'O' => __( 'Nueva Esparta', 'pcud_ml'),
		'P' => __( 'Portuguesa', 'pcud_ml'),
		'R' => __( 'Sucre', 'pcud_ml'),
		'S' => __( 'Táchira', 'pcud_ml'),
		'T' => __( 'Trujillo', 'pcud_ml'),
		'U' => __( 'Yaracuy', 'pcud_ml'),
		'V' => __( 'Zulia', 'pcud_ml'),
		'W' => __( 'Federal Dependencies', 'pcud_ml'),
		'X' => __( 'Vargas', 'pcud_ml'),
		'Y' => __( 'Delta Amacuro', 'pcud_ml'),
		'Z' => __( 'Amazonas', 'pcud_ml')
	),
	'VN' => array(),
	'YT' => array(),
	'ZA' => array( // South African states.
		'EC'  => __( 'Eastern Cape', 'pcud_ml'),
		'FS'  => __( 'Free State', 'pcud_ml'),
		'GP'  => __( 'Gauteng', 'pcud_ml'),
		'KZN' => __( 'KwaZulu-Natal', 'pcud_ml'),
		'LP'  => __( 'Limpopo', 'pcud_ml'),
		'MP'  => __( 'Mpumalanga', 'pcud_ml'),
		'NC'  => __( 'Northern Cape', 'pcud_ml'),
		'NW'  => __( 'North West', 'pcud_ml'),
		'WC'  => __( 'Western Cape', 'pcud_ml'),
	),
	'ZM' => array( // Zambia's Provinces. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:ZM.
		'ZM-01' => __( 'Western', 'pcud_ml'),
		'ZM-02' => __( 'Central', 'pcud_ml'),
		'ZM-03' => __( 'Eastern', 'pcud_ml'),
		'ZM-04' => __( 'Luapula', 'pcud_ml'),
		'ZM-05' => __( 'Northern', 'pcud_ml'),
		'ZM-06' => __( 'North-Western', 'pcud_ml'),
		'ZM-07' => __( 'Southern', 'pcud_ml'),
		'ZM-08' => __( 'Copperbelt', 'pcud_ml'),
		'ZM-09' => __( 'Lusaka', 'pcud_ml'),
		'ZM-10' => __( 'Muchinga', 'pcud_ml'),
	),
);
