<?php
dike_lc('lcweb', PCUD_DIKE_SLUG, true);

include_once(PC_DIR .'/classes/pc_form_framework.php');
$f_fw = new pc_form;
?>

<div class="wrap pc_form">  
    <h2 class="pc_page_title">PrivateContent User Data add-on - <?php _e('Forms Builder', PCUD_ML) ?></h2>   

    <div id="poststuff" class="metabox-holder has-right-sidebar">

        <?php // SIDEBAR ?>
        <div id="side-info-column" class="inner-sidebar">
            <form class="form-wrap">	

                <div id="pcud_add_form_box" class="postbox">
                    <h3 class="hndle"><?php _e('Add Form', PCUD_ML) ?></h3>
                    <div class="inside">
                        <input type="text" name="pcud_add_form_name" placeholder="<?php esc_attr_e('Form name', PCUD_ML) ?>" maxlenght="100" autocomplete="off" />    
                        <select name="pcud_add_form_type" autocomplete="off">
                            <option value="registr"><?php esc_html_e('registration form', PCUD_ML) ?></option>
                            <option value="update"><?php esc_html_e('data update form', PCUD_ML) ?></option>
                        </select>
                        
                        <button type="button" name="add_form_btn" title="<?php esc_attr_e('Add', PCUD_ML) ?>" class="button-primary">
                            <span class="dashicons dashicons-plus-alt"></span>
                        </button> 
                    </div>
                </div>


                <div id="pcud_man_forms_list" class="postbox">
                    <?php echo pcud_forms_static::builder_forms_list(); ?>
                </div>


                <div id="pcud_save_form_box" class="postbox">
                    <input type="button" name="save-form" value="<?php esc_attr_e('Save form', PCUD_ML) ?>" class="button-primary" />
                    <div></div>
                </div>
            </form>	
        </div>

        
        <?php // PAGE CONTENT ?>
        <form class="form-wrap" id="pcud_forms_builder">  
            <div id="post-body">
                <div id="post-body-content">
                    <div class="pcud_no_sel_form">
                        <i class="dashicons dashicons-forms"></i>
                        <span>.. <?php _e('select a form first', PCUD_ML) ?> ..</span>
                    </div>
                </div>
            </div>
        </form>

        <br class="clear" />
    </div>

</div>  




<?php // SCRIPTS ?>
<script type="text/javascript">
(function($) { 
    "use strict";    
    
    const nonce             = '<?php echo wp_create_nonce('lcwp_ajax') ?>',
          no_sel_code       = $('#post-body-content').html(),
          mail_is_required  = <?php echo ($f_fw->mail_is_required) ? 1: 0 ?>;
    
    // selected form vars
    let is_acting       = false,
        sel_section     = 'registr', // registr or update
        sel_form        = 0,
        involved_fields = [];	
    
    
    
    // fields data object 
    const grouped_fields = JSON.parse(`<?php echo str_replace('\\', '', json_encode($f_fw->get_fields_grouped())) ?>`);
    const fields = JSON.parse(`<?php
        $fields = array();    
        foreach($f_fw->fields as $f_id => $f_data) {
            
            $fields[$f_id] = array(
                'label'     => $f_data['label'],
                'is_combo'  => (isset($f_data['combo_link'])) ? $f_data['combo_link'] : '',
            );    
        }
        echo json_encode($fields); 
    ?>`);

    
    
    // add form
    $('button[name="add_form_btn"]').on('click', function() {
        const $btn = $(this),
              subj = $('select[name="pcud_add_form_type"]').val(),
              name = $.trim( $('input[name="pcud_add_form_name"]').val() );

        if(is_acting || !name) {
            return false;    
        }
        
        is_acting = true;
        $('#pcud_add_form_box').find('input, select, button').prop('disabled', 'disabled');

        let data = {
            action      : 'pcud_add_form',
            subj        : subj,
            form_name   : name,
            nonce       : nonce
        };
        $.post(ajaxurl, data, function(response) {
            try {
                const resp = JSON.parse(response);
                
                if(resp.status == 'success') {
                    lc_wp_popup_message('success', "<?php esc_attr_e('Form added successfully!', PCUD_ML) ?>");     
                    
                    const $wrap = (subj == 'registr') ? $('#pcud_man_forms_list .inside div[data-subj="registr"]') : $('#pcud_man_forms_list .inside div[data-subj="update"]'); 
                    $wrap.prepend(
                    `<div>
                        <span>
                            <input type="radio" name="pcud_fb_sel" value="${ resp.term_id }" autocomplete="off" />
                        </span>
                        <span class="pcud_form_tit" title="ID #${ resp.term_id }">${ name }</span>
                        
                        <span class="pcud_rename_form pc_move_field dashicons dashicons-edit"></span>
                        <span class="pcud_del_form pc_del_field dashicons dashicons-no-alt"></span>
                    </div>`);
                    
                    $('input[name="pcud_add_form_name"]').val('');
                }
                else {
                    lc_wp_popup_message('error', resp.mess);      
                }
            }
            catch(e) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e('Error creating the form', PCUD_ML) ?>");    
                
                $('#pcud_add_form_box').find('input, select, button').removeAttr('disabled');
                is_acting = false;
            }
        })
        .fail(function(e) {
            if(e.status) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e('Error creating the form', PCUD_ML) ?>");	
            }    
        })
        .always(function() {
            $('#pcud_add_form_box').find('input, select, button').removeAttr('disabled');
            is_acting = false;
        });	
    });
    
    // add also through input
    $(document).on('keyup', 'input[name="pcud_add_form_name"]', function(e) {
        if(e.keyCode === 13){
            $('button[name="add_form_btn"]').trigger('click');
            return false;
        }
    });


    
    // forms tab selection
    $(document).on('click', '.pcud_forms_list_tabs div:not(.pcud_flt_sel)', function() {
        sel_section = $(this).data('subj');
        
        $('.pcud_forms_list_tabs div').removeClass('pcud_flt_sel');
        $(this).addClass('pcud_flt_sel');
        
        $('#pcud_man_forms_list .inside > div').hide();
        $('#pcud_man_forms_list .inside > div[data-subj="'+ sel_section +'"]').show();
    });
    
    
    
    // rename form
    $(document).on('click', '.pcud_rename_form', function() {
        if(is_acting) {
            return false;    
        }
        
        const $wrap     = $(this).parents('div').first(),
              form_id   = parseInt($wrap.find('input').attr('value'), 10),
              old_name  = $wrap.find('.pcud_form_tit').text();
        
        const new_name = $.trim(prompt("<?php esc_attr_e('New form name', PCUD_ML) ?>", old_name));   
        if(!new_name) {
            return false;    
        }
        
        is_acting = true;
        $wrap.fadeTo(300, 0.5);
        
        let data = {
            action  : 'pcud_rename_form',
            form_id : form_id,
            section : sel_section,
            new_name: new_name,
            nonce   : nonce
        };
        $.post(ajaxurl, data, function(response) {
            let resp = $.trim(response); 

            if(resp == 'success') {
                $wrap.find('.pcud_form_tit').text(new_name);
            } else {
                lc_wp_popup_message('error', resp);
            }
        })
        .fail(function(e) {
            if(e.status) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e('Error renaming the form', PCUD_ML) ?>");	
            }    
        })
        .always(function() {
            is_acting = false;
            $wrap.fadeTo(300, 1);
        });
    });
    
    
    
    // delete form
    $(document).on('click', '.pcud_del_form', function() {
        if(is_acting || !confirm("<?php esc_attr_e('Do you want to remove this form?', PCUD_ML) ?>")) {
            return false    
        }
        
        const $wrap = $(this).parents('div').first(),
              form_id = parseInt($wrap.find('input').attr('value'), 10);
        
        is_acting = true;
        $wrap.fadeTo(300, 0.5);
        
        let data = {
            action  : 'pcud_del_form',
            form_id : form_id,
            section : sel_section,
            nonce   : nonce
        };
        $.post(ajaxurl, data, function(response) {
            let resp = $.trim(response); 

            if(resp == 'success') {
                // if is this one opened
                if(sel_form == form_id) {
                    $('.pcud_form_content').html(no_sel_code);
                    sel_form = 0;
                    $('#pcud_save_form_box').hide();
                }

                $wrap.remove();
            }
            else {
                lc_wp_popup_message('error', resp);
            }
        })
        .fail(function(e) {
            if(e.status) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e('Error deleting the form', PCUD_ML) ?>");	
            }    
        })
        .always(function() {
            is_acting = false;
            $wrap.fadeTo(300, 1);
        });
    });
    
    
     
    // form selection
    $(document).on('input', '#pcud_man_forms_list input[name="pcud_fb_sel"]', function(e) {
        if(is_acting) {
            e.preventDefault();
            return false;
        }
        
        sel_form = parseInt($(this).attr('value'), 10);
        $('#post-body-content').html('<div class="pc_center_spinner"><br/><br/><div class="pc_spinner pc_spinner_big"></div></div>');
        
        let data = {
            action  : 'pcud_form_builder',
            section : sel_section,
            form_id : sel_form,
            nonce   : nonce
        };
        $.post(ajaxurl, data, function(response) {
            $('#post-body-content').html(response);

            // saveform box
            $('#pcud_save_form_box').show();

            pcud_lc_select();
            pcud_live_checks();
            pcud_live_sort();

            $('#pcud_form_table textarea').each(function() {
                lcwp_sf_textAreaAdjust(this);    
            });
            
            set_involved_fields();
        })
        .fail(function(e) {
            if(e.status) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e('Error loading form data', PCUD_ML) ?>");	
                
                $('#post-body-content').html(no_sel_code);
                sel_form = false;
            }    
        });	
    });
    
    
    
    // track used field slugs (for misc operations)
    const set_involved_fields = function() {
        involved_fields = {};
        
        $('input[name="pcud_include_field[]"]').each(function() {
            let val = $(this).val();
            
            if(val == 'custom|||page') {
                return true;    
            }
            
            // tweak old "custom|||text" to the new unique-id structure
            if(val == 'custom|||text') {
                val += '|||' + new Date().getTime();
                $(this).val(val);
                $(this).parents('tr').attr('data-f-id', val);
            }

            involved_fields[val] = (val.substr(0, 13) == 'custom|||text') ? "<?php esc_attr_e('Text block', PCUD_ML) ?>" : fields[ val ];
        });
        
        // reflect on dropdown
        const $add_f_dd = $('.pcud_add_form_f_box select');
        $add_f_dd.find('option').each(function() {
            (typeof(involved_fields[ $(this).attr('value') ]) == 'undefined') ? $(this).removeAttr('disabled') : $(this).prop('disabled', 'disabled');      
        });
        
        const resyncEvent = new Event('lc-select-refresh');
        $add_f_dd[0].dispatchEvent(resyncEvent);
    };
    
    
 
    // add field to form - click handler 
    $(document).on('click', '.pcud_add_form_f_box button', function() {
        let f_val = $('.pcud_add_form_f_box select').val();
        
        if(!f_val) {
            lc_wp_popup_message('error', "<?php esc_attr_e('Field already added to the form', PCUD_ML) ?>");
            return false;	  
        }
        
        // combo field - add linked one first
        if(
            f_val != 'custom|||text' && f_val != 'custom|||page' && f_val != 'custom|||sep' && 
            fields[f_val].is_combo && typeof(involved_fields[ fields[f_val].is_combo ]) == 'undefined'
        ) {
            add_field( fields[f_val].is_combo );    
        }
        
        add_field(f_val);
    });
    
        
    // add field to form    
    const add_field = function(f_val) { 
        // be sure field is not among inserted ones
        if(f_val != 'custom|||text' && f_val != 'custom|||page' && f_val != 'custom|||sep' && typeof(involved_fields[ f_val ]) != 'undefined') {
            lc_wp_popup_message('error', "<?php esc_attr_e('Field already added to the form', PCUD_ML) ?>");
            return false;	
        }
        
        let required = '',
            disabled = '';
        
        if(f_val == 'psw' || f_val == 'category' || (f_val == 'email' && mail_is_required)) {
            required = 'checked="checked"';
            disabled = 'disabled="disabled"';
        }
        
        // conditions - base code
        const def_status_code = `
        <div class="pcud_field_cond_def pc_displaynone">
            <select name="pcud_cond_def_vis" autocomplete="off">
                <option value="hidden"><?php esc_attr_e('hidden by default', PCUD_ML) ?></option>
                <option value="shown"><?php esc_attr_e('visible by default', PCUD_ML) ?></option>
            </select>
            <select name="pcud_cond_main_cond" autocomplete="off">
                <option value="OR"><?php esc_attr_e('one condition must be satisfied', PCUD_ML) ?></option>
                <option value="AND"><?php esc_attr_e('all conditions must be satisfied', PCUD_ML) ?></option>
            </select>
        </div>
        <ul class="pcud_field_cont_ul"></ul>`;
        
        
        let code = '';
        if(f_val.substr(0, 13) == 'custom|||text') {       
            f_val += '|||' + new Date().getTime(); // text block - use unique ID
            
            code += `
            <td></td>
            <td colspan="2">
                <input type="hidden" name="pcud_include_field[]" value="${ f_val }" class="pcud_incl_f" />
                <textarea name="pcud_form_texts[]" placeholder="<?php esc_attr_e('Supports HTML and shortcodes', PCUD_ML) ?>" onkeyup="lcwp_sf_textAreaAdjust(this)"></textarea>
                ${ def_status_code }
            </td>
            <td>
                <button type="button" name="add_field_cond" title="<?php esc_attr_e('Add visibility condition', PCUD_ML) ?>" class="button-secondary">
                    <span class="dashicons dashicons-randomize"></span>
                </button>
            </td>`;
        }
        else if(f_val.substr(0, 12) == 'custom|||sep') {       
            f_val += '|||' + new Date().getTime(); // separator block - use unique ID
            
            code += `
            <td></td>
            <td colspan="2" class="pcud_separator_bar_td">
                <input type="hidden" name="pcud_include_field[]" value="${ f_val }" class="pcud_incl_f" />
                <strong><?php esc_attr_e('SEPARATOR BAR', PCUD_ML) ?></strong>
                ${ def_status_code }
            </td>
            <td>
                <button type="button" name="add_field_cond" title="<?php esc_attr_e('Add visibility condition', PCUD_ML) ?>" class="button-secondary">
                    <span class="dashicons dashicons-randomize"></span>
                </button>
            </td>`;
        }
        else if(f_val == 'custom|||page') {
            code += `
            <td></td>
            <td colspan="3" class="pcud_paginator_td">
                <input type="hidden" name="pcud_include_field[]" value="${ f_val }" class="pcud_incl_f" />
                <strong><?php esc_attr_e('PAGINATOR', PCUD_ML) ?></strong>
            </td>`;
        }
        else {
            let combo_f_icon = '';
            if(fields[f_val].is_combo) {
                combo_f_icon = '<span class="dashicons dashicons-admin-links" title="<?php echo sprintf(esc_attr__('Combo fields, showing options in relation to "%s" field', PCUD_ML), '%%F-LABEL%%') ?>" data-linked-f="'+ fields[f_val].is_combo +'"></span>';
                
                combo_f_icon = combo_f_icon.replace('%%F-LABEL%%', fields[ fields[f_val].is_combo ].label);
            }
            
            code += `
            <td>${ combo_f_icon }</td>
            <td>
                <input type="hidden" name="pcud_include_field[]" value="${ f_val }" class="pcud_incl_f" />
                ${ fields[ f_val ].label } 
                ${ def_status_code }
            </td>
            <td>
                <input type="checkbox" name="pcud_require_field[]" value="${ f_val }" ${ required } ${ disabled } class="pcud_check pcud_req_f" autocomplete="off" />
            </td>
            <td>
                <button type="button" name="add_field_cond" title="<?php esc_attr_e('Add visibility condition', PCUD_ML) ?>" class="button-secondary">
                    <span class="dashicons dashicons-randomize"></span>
                </button>
            </td>`;	
        }

        $('#pcud_form_table tbody').append(
        `<tr data-f-id="${ f_val }">
            <td><span class="pcud_del_field pc_del_field dashicons dashicons-no-alt" title="<?php esc_attr_e('remove field', PCUD_ML) ?>"></span></td>
            <td><span class="pcud_move_field pc_move_field dashicons dashicons-move" title="<?php esc_attr_e('sort field', PCUD_ML) ?>"></span></td>
            ${ code }
        </tr>`);

        pcud_live_checks();

        $('#pcud_form_table textarea').each(function() {
            lcwp_sf_textAreaAdjust(this);    
        });
        
        set_involved_fields();
    };


    
    // delete form field
    $(document).on('click', '.pcud_del_field', function() {
        const f_val = $(this).parents('tr').data('f-id');
        $(this).parents('tr').remove();
        
        // remove combo fields depending on this
        $('.dashicons[data-linked-f="'+ f_val +'"]').parents('tr').remove();
        
        set_involved_fields();
    });
    
    
    
    /////////////////////////////////////////////////
    
    
    
    // add field condition
    $(document).on('click', 'button[name="add_field_cond"]', function() {
        const $wrap         = $(this).parents('tr'),
              field_id      = $wrap.data('f-id'),
              cond_label    = ($wrap.find('select[name="pcud_cond_def_vis"]').val() == 'hidden') ? "<?php esc_attr_e('Show if', PCUD_ML) ?>" : "<?php esc_attr_e('Hide if', PCUD_ML) ?>";
        
        $wrap.find('.pcud_field_cond_def > strong').text(cond_label + ':');
        $wrap.find('.pcud_field_cond_def').show();
        
        let f_opts = '';
        
        // PCUD-FILTER - fields ID ignored in conditional field dropdown
        <?php 
        $to_ignore = apply_filters('pcud_cond_f_ignored_dd_opts', array()); 
        $to_ignore_js = (empty($to_ignore)) ? '' : ", '". implode("', '", $to_ignore) ."'";
        ?>
        let to_discard = ['psw', <?php echo $to_ignore_js ?>];
        
        $.each(grouped_fields, function(group_name, group_fields) {
            f_opts += '<optgroup label="'+ group_name +'">'; 
            
            $.each(group_fields, function(f_key, foo) {
                const f_data = fields[f_key];
                
                if(f_key != field_id && $.inArray(f_key, to_discard) === -1) {
                    f_opts += '<option value="'+ f_key +'">'+ f_data.label +'</option>';    
                }        
            });
            
            f_opts += '</optgroup>';
        });
        
        $wrap.find('.pcud_field_cont_ul').append(`
        <li>
            <div>
                <select name="pcud_cond_field" class="pcud_lc_select" autocomplete="off">
                    ${ f_opts }
                </select>
            </div>
            <select name="pcud_cond_operator" autocomplete="off">
                <option value="is_equal"><?php esc_html_e('is equal to', PCUD_ML) ?></option>
                <option value="is_different"><?php esc_html_e('is different from', PCUD_ML) ?></option>
                <option value="contains"><?php esc_html_e('contains', PCUD_ML) ?></option>
                <option value="not_contain"><?php esc_html_e("does not contain", PCUD_ML) ?></option>
                <option value="bigger"><?php esc_html_e("is bigger than", PCUD_ML) ?></option>
                <option value="smaller"><?php esc_html_e("is smaller than", PCUD_ML) ?></option>
            </select>
            <input type="text" name="pcud_cond_val" autocomplete="off" />
            <span class="pcud_del_field_cond pc_del_field dashicons dashicons-dismiss" title="<?php esc_attr_e('remove condition', PCUD_ML) ?>"></span>
        </li>`);
        
        pcud_lc_select();
    });
    
       
    
    // change condition label if main condition change
    $(document).on('change', 'select[name="pcud_cond_def_vis"]', function() {
        const $wrap = $(this).parents('tr'),
              $to_change = $wrap.find('.pcud_field_cond_def > strong');
        
        if($(this).val() == 'hidden') {
            $to_change.text("<?php esc_attr_e('Show if', PCUD_ML) ?>:");
        } else {
            $to_change.text("<?php esc_attr_e('Hide if', PCUD_ML) ?>:");
        }
    });    
    
    
    
    // delete condition
    $(document).on('click', '.pcud_del_field_cond', function() {
        const $wrap = $(this).parents('tr');
        
        $(this).parents('li').first().remove();
        if(!$wrap.find('.pcud_del_field_cond').length) {
            $wrap.find('.pcud_field_cond_def').hide();    
        }
    });
    
    
    
    // return fields condition for current form
    const get_form_field_conditions = function() {
        let to_return = {};
        
        $('#pcud_form_table tbody tr').each(function() {
            const $field = $(this),
                  field_id = $(this).data('f-id');
            
            if(!$field.find('.pcud_field_cont_ul li').length) {
                to_return[field_id] = 0;     
                return true;
            }
            
            // compose conditions
            let conds = [];
            $field.find('.pcud_field_cont_ul li').each(function() {
                const f = $(this).find('select[name="pcud_cond_field"]').val();
                
                conds.push({
                    field       : f,
                    operator    : $(this).find('select[name="pcud_cond_operator"]').val(),
                    val         : $(this).find('input[name="pcud_cond_val"]').val(),
                });
            });
              
            to_return[field_id] = {
                def_vis     : $field.find('select[name="pcud_cond_def_vis"]').val(),
                main_cond   : $field.find('select[name="pcud_cond_main_cond"]').val(),
                conds       : conds   
            }; 
        });
        return to_return;
    };
      
            
        
    /////////////////////////////////////////////////////////
        
    
    
    // save form
    $(document).on('click', '#pcud_save_form_box input', function() {
        if(is_acting) {
            return false;
        }

        // create fields + required array
        let included = [],
            required = [],
            texts 	 = [];

        $('#pcud_form_table tbody tr').each(function(i,v) {
            let f = $(this).find('.pcud_incl_f').val();
            included.push(f);

            if(f.substr(0, 13) == 'custom|||text') {
                texts.push( $(this).find('textarea').val() );	
            }
            else {
                if( $(this).find('.pcud_req_f').is(':checked') ) {
                    required.push(f);	
                }
            }
        });

        // be sure username and password are in registration forms
        if(sel_section == 'registr') {
            if($.inArray('username', included) === -1 || $.inArray('psw', included) === -1) {
                lc_wp_popup_message('error', "<?php esc_attr_e('Password and Username fields must be in the form!', PCUD_ML) ?>");    
            }
            if(mail_is_required && $.inArray('email', included) === -1) {
                lc_wp_popup_message('error', "<?php esc_attr_e('E-mail field must be in the form!', PCUD_ML) ?>");            
            }
        }
        
        is_acting = true;
        $('#pcud_save_form_box div').html('<span class="pc_spinner pc_spinner_inline"></span>');
        
        // ajax
        let data = {
            action			: 'pcud_save_form',
            section         : sel_section,
            form_id			: sel_form,
            fields_included	: included,
            fields_required	: required,
            texts			: texts,
            conditions      : JSON.stringify(get_form_field_conditions()),
            pcud_nonce		: '<?php echo wp_create_nonce('lcwp_ajax') ?>'
        };
        
        if(sel_section == 'update') {
            data.cust_mess      = $('#pcud_cust_mess').val(); 
            data.no_mail_notif  = (document.getElementById('pcud_no_mail_notif').checked) ? 1 : 0,
            data.redirect       = $('#pcud_redirect').val(); 
            data.cust_redir     = $('#pcud_cust_redir_wrap input').val(); 
        }
        
        $.post(ajaxurl, data, function(response) {
            if($.trim(response) == 'success') {
                lc_wp_popup_message('success', "<?php esc_attr_e('Form saved successfully!', PCUD_ML) ?>");	
            } 
            else {
                lc_wp_popup_message('error', response);
            }
        })
        .fail(function(e) {
            if(e.status) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e('Error saving the form', PCUD_ML) ?>");	
            }    
        })
        .always(function() {
            $('#pcud_save_form_box div').empty();
            is_acting = false;
        });	
    });



    // form redirect - custom URL switch
    $(document).on('change', 'select[name="pcud_redirect"]', function() {
        if($(this).val() == 'custom') {
            $('#pcud_cust_redir_wrap td').show();
        } else {
            $('#pcud_cust_redir_wrap td').hide();	
        }
    });

    
    
    
    /////////////////////////////////////////////////////////////////////
    
    
    

    // lc switch
    const pcud_live_checks = function() {
        lc_switch('.pcud_check', {
            on_txt      : "<?php echo strtoupper(esc_attr__('yes')) ?>",
            off_txt     : "<?php echo strtoupper(esc_attr__('no')) ?>",   
        });
    };
    

    // LC Select
    const pcud_lc_select = function() {
        new lc_select('.pcud_lc_select', {
            wrap_width : '100%',
            addit_classes : ['lcslt-lcwp'],
        });
    };


    // sort formbuilder rows
    const pcud_live_sort = function() {
        $( "#pcud_form_table tbody" ).sortable({ handle: '.pc_move_field' });
        $( "#pcud_form_table tbody td .pc_move_field" ).disableSelection();
    };


    // auto-height textarea
    window.lcwp_sf_textAreaAdjust = function(o) {
        o.style.height = "1px";

        let new_h = 4 + o.scrollHeight;
        if(new_h < 28) {
            new_h = 28;    
        }

        o.style.height = new_h + "px";
    };

})(jQuery); 
</script>
