<?php
// PRIVATECONTENT FRONT INTEGRATIONS


// combo dropdown fields and conditions - store options in JS var
function pcud_front_combo_opts($code, $form_fields, $user_id, $class_obj) {
    if(!property_exists($class_obj, 'form_term_id')) {
        return $code;    
    }
    if(!isset($GLOBALS['pcud_combo_opts'])) {
        $GLOBALS['pcud_combo_opts'] = array();    
    }
    
    $form_id    = (int)$class_obj->form_term_id;
    $all_fields = $class_obj->fields;
    $conditions = get_term_meta($form_id, 'pcud_form_conditions', true);
    
    $to_print   = array();
    $to_track   = array();
    
    foreach($form_fields['include'] as $f_id) {
        if(empty($all_fields[$f_id]['combo_link']) || !in_array($all_fields[$f_id]['combo_link'], $form_fields['include'])) {
            continue;    
        }
        $rel_field = $all_fields[$f_id]['combo_link'];
        
        if(empty($rel_field)) {
            return false;
        }
        $to_track[$f_id] = $rel_field;   
           
        if(isset($GLOBALS['pcud_combo_opts'][$f_id])) {
            continue;    
        }
        
        $term_id = $all_fields[$f_id]['pcud_term_id'];
        $to_print[$f_id] = $rel_field;
        $GLOBALS['pcud_combo_opts'][$f_id] = pcud_fields_static::get_f_opts($term_id, false, true, true);
    }
    
    
    // adjust to_track array for an easier JS usage
    $to_track_js = array();
    foreach($to_track as $f_id => $linked_f_id) {
        
        if(!isset($to_track_js[ $linked_f_id ])) {
            $to_track_js[ $linked_f_id ] = array();        
        }
        $to_track_js[ $linked_f_id ][] = $f_id;
    }
    
    
    // conditions
    $conditions = get_term_meta($form_id, 'pcud_form_conditions', true);
    
    
    if(count($to_print) || !empty($conditions)) {
        $code .= "
        <script type='text/javascript'>
        (function() {
            'use strict';  

            const intval = setInterval(() => {
                if(typeof(pcud_vars) == 'undefined' || typeof(window.pcud_live_combo_opts) == 'undefined') {
                    return true;
                }
                else {
                    clearTimeout(intval);";

                    if(count($to_print)) {
                        foreach($to_print as $f_id => $rel_f_slug) {
                            $code .= 'pcud_vars.combo_opts["'. esc_attr($f_id) .'"] = JSON.parse(`'. json_encode($GLOBALS['pcud_combo_opts'][$f_id]) .'`);';
                        }

                        $code .= "
                        window.pcud_live_combo_opts('". pc_static::encrypt_number($form_id) ."', JSON.parse(`". json_encode($to_track_js) ."`));";
                    }

                    if(!empty($conditions)) {
                        $code .= "
                        pcud_vars.form_cond['". pc_static::encrypt_number($form_id) ."'] = JSON.parse(`". json_encode($conditions) ."`);";
                    }

            $code .= "
                }
            }, 50);
        })();    
        </script>";
    }
    
    return $code;
}
add_filter('pc_inline_form_js', 'pcud_front_combo_opts', 10, 5);






// combo field - add class
function pcud_combo_front_field_classes($classes, $field_id, $form_fields, $user_id, $class_obj) { 
    $pcud_empty_combo_fields = (!isset($GLOBALS['pcud_empty_combo_fields'])) ? array() : $GLOBALS['pcud_empty_combo_fields'];
    
    $all_fields = $class_obj->fields;
    
    if(!isset($all_fields[$field_id]['combo_link']) || empty($all_fields[$field_id]['combo_link']) || !in_array($all_fields[$field_id]['combo_link'], $form_fields['include'])) {
        return $classes;    
    }
    $classes[] = 'pcud_combo_f';
    
    if(in_array($field_id, $pcud_empty_combo_fields)) {
        $classes[] = 'pcud_empty_combo_f';        
    }
    return $classes;
}
add_filter('pc_field_classes', 'pcud_combo_front_field_classes', 10, 5);



// combo dropdowns - add linked field attribute
function pcud_combo_front_field_atts($atts, $field_id, $form_fields, $user_id, $class_obj) {
    $all_fields = $class_obj->fields;
    
    if(!isset($all_fields[$field_id]['combo_link']) || empty($all_fields[$field_id]['combo_link']) || !in_array($all_fields[$field_id]['combo_link'], $form_fields['include'])) {
        return $atts;    
    }
    
    $atts['pcud-combo-link'] = $all_fields[$field_id]['combo_link'];
    return $atts;
}
add_filter('pc_field_atts', 'pcud_combo_front_field_atts', 10, 5);






// Set user select/checkbox values considering default selections
function pcud_form_field_val($f_val, $field_slug, $form_fields, $user_id, $user_data, $class_obj) {
    $pcud_fields = pcud_fields_static::get_fields();
    
    if(!isset($pcud_fields[$field_slug]) || !in_array($pcud_fields[$field_slug]->pcud_opts['type'], array('checkbox', 'select'))) {
        return $f_val;           
    }
    
    return pcud_fields_static::get_sel_opts($field_slug);
}
add_filter('pc_form_field_val', 'pcud_form_field_val', 10, 6);






// conditional fields - add class to fields controlling others and visibility class
function pcud_cond_field_front_classes($classes, $field_id, $form_fields, $user_id, $class_obj) { 
    if(!property_exists($class_obj, 'form_term_id')) {
        return $classes;    
    }
    
    $conditions = get_term_meta((int)$class_obj->form_term_id, 'pcud_form_conditions', true);
    if(empty($conditions) || !is_array($conditions)) {
        return $classes;        
    }
    
    
    // iterate through conditions and find whether field controls another one
    $added = false;
    foreach($conditions as $f_id => $f_conds_data) {
        if(!is_array($f_conds_data)) {
            continue;        
        }
        
        foreach($f_conds_data['conds'] as $conds) {
            if($conds['field'] == $field_id) {
                $classes[] = 'pcud_cond_var_f';    
                $added = true;
                break;
            }
        }
        
        if($added) {
            break;    
        }
    }
    
    
    // is this field conditionally-hidden?
    if(!pcud_forms_static::form_f_is_cond_vis($field_id, $conditions, $class_obj, $user_id)) {
        $classes[] = 'pcud_cond_f_hidden';        
    }
    
    return $classes;
}
add_filter('pc_field_classes', 'pcud_cond_field_front_classes', 10, 5);






// conditional / combo fields validation (skip if is hidden)
function pcud_cond_form_validator_indexes($indexes, $form_vals, $form_id, $form_taxonomy, $user_id, $class_obj) {
    if(!$form_id) {
        return $indexes;    
    }
    $fields_data = $class_obj->fields;
    $conditions = get_term_meta((int)$form_id, 'pcud_form_conditions', true);
    
    foreach($indexes as $key => $data) {
        $f_index = $data['index'];
        
        if(
            (
                (isset($data['required']) && $data['required']) ||
                (isset($fields_data[$f_index]['combo_link']) && $fields_data[$f_index]['combo_link'])
            )
            && $f_index != 'username'
        ) {
            $remove_required = false;
            
            if(!empty($conditions) || !is_array($conditions)) {
                if(!pcud_forms_static::form_f_is_cond_vis($f_index, $conditions, $class_obj, $user_id, $form_vals)) {
                    $remove_required = true;
                }
            }
            
            // if is combo field and got no options - skip
            if(isset($fields_data[$f_index]) && isset($fields_data[$f_index]['combo_link']) && $fields_data[$f_index]['combo_link']) {
                $linked_f_index = $fields_data[$f_index]['combo_link'];

                if(!isset($form_vals[$linked_f_index]) || !$form_vals[$linked_f_index]) {
                    $remove_required = true;    
                }
                else {
                    $avail_resulting_opts = (array)pcud_fields_static::get_f_opts_linked_to_val($fields_data[$f_index]['pcud_term_id'], $form_vals[$linked_f_index]);

                    if(empty($avail_resulting_opts)) {
                        $remove_required = true;    
                    } 
                    else {
                        // be sure validator accepts newly available options!
                        $indexes[$key]['allowed'] = array_keys($avail_resulting_opts);   
                    }
                }
            }
            
            if($remove_required && isset($data['required'])) {
                unset($indexes[$key]['required']);
            }
        }
    }
    
    return $indexes;
}
add_filter('pc_form_validator_indexes', 'pcud_cond_form_validator_indexes', 10, 6);

