/********************************
   HANDLING DATA-UPDATE FORMS
*********************************/	

(function($) {
    "use strict";

    const dike_slug = (pc_vars.dike_slug == 'pcbp') ? pc_vars.dike_slug : 'pcud';
    
    if(typeof(window.dike_plc) != 'undefined' && !window.dike_plc('lcweb', dike_slug)) {
        console.error('PvtContent User Data add-on - validate the license');
        return false;    
    }
    
    
    
    // escape option value, returning an attribute-safe string 
    const esc_str_for_attr = function(str) {
        return $.trim(str
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;')
        .replace(/'/g, '&#039;'));  
    };
    
    
    
    
    // combo opts - apply options on linked field change
    window.pcud_live_combo_opts = function(form_id, links_n_fields) {
        let $form = $('form[data-form-id="'+ form_id +'"]');
        
        $.each(links_n_fields, function(linked_f_slug, f_slugs_arr) {
            let selector = [];
            
            selector.push('select[name="'+ linked_f_slug +'"]');   
            selector.push('input[name="'+ linked_f_slug +'"]');
            
            selector.push('select[name="'+ linked_f_slug +'[]"]');   
            selector.push('input[name="'+ linked_f_slug +'[]"]');
            
            $form.off('input change', selector.join(', ')).on('input change', selector.join(', '), function() {
                let $form = $(this).parents('form').first(),
                    f_val = [];

                // get linked field value
                if($(this).is('select')) {
                    (this.hasAttribute('multiple')) ? f_val = $(this).val() : f_val.push( $(this).val());    
                }
                else {
                    $(this).parents('.pc_check_wrap').find('input[type="checkbox"]').each(function() {
                        if(this.checked) {
                            f_val.push( $(this).attr('value') );        
                        }
                    });
                }

                // compose new field options
                $.each(f_slugs_arr, function(i, f_slug) {
                    const $f_block = $form.find('.pc_form_field[data-fname="'+ f_slug +'"]');
                    
                    let opts = {},
                        code = '';
                    
                    $.each(f_val, function(i, val) {
                        if(typeof(pcud_vars.combo_opts[ f_slug ][ val ]) != 'undefined') {
                            opts = { ...pcud_vars.combo_opts[ f_slug ][ val ], ...opts }; 
                        }         
                    });
                    
                    // apply options
                    // select
                    if($f_block.find('select').length) {
                        $.each(opts, function(i, v) {
                            code += '<option value="'+ esc_str_for_attr(i) +'">'+ esc_str_for_attr(v) +'</option>';    
                        });
                        
                        $f_block.find('select').html(code);
                        
                        const resyncEvent = new Event('lc-select-refresh');
                        $f_block.find('select')[0].dispatchEvent(resyncEvent);
                    }
                    
                    // checkboxes
                    else {
                        const type = ($f_block.find('input[type="radio"]').length) ? 'radio' : 'checkbox';
                        
                        $.each(opts, function(i, v) {
                            code += 
                                '<input type="'+ type +'" name="'+ f_slug +'[]" value="'+ esc_str_for_attr(i) +'" autocomplete="off" />' +
                                '<label class="pc_check_label">'+ v +'</label>';
                        });
                        
                        $f_block.find('.pc_check_wrap').html(code);
                        pc_checkboxes_setup();
                    }
                    
                    (code) ? $f_block.removeClass('pcud_empty_combo_f') : $f_block.addClass('pcud_empty_combo_f');
                });
            });
        });
    };
    
    
    
    
    // conditional fields
    let cond_keyup_tout = false;
    window.pcud_cond_f_check = function(e) {
        if(typeof(pcud_vars) == 'undefined' || typeof(pcud_vars.form_cond) == 'undefined') {
            return false;       
        }
        if(cond_keyup_tout) {
            clearTimeout(cond_keyup_tout);    
        }
        
        const timing    = (e.type == 'keyup') ? 400 : 0,
              $form     = $(e.target).parents('.pvtcont_form'),
              form_id   = $form.data('form-id'),
              
              form_conds= pcud_vars.form_cond[form_id],
              user_vals = JSON.parse(JSON.stringify(pcud_vars.user_data));
        
        cond_keyup_tout = setTimeout(function() {
            $.each(form_conds, function(f_id, cond_data) {
                if(!cond_data) {
                    return true;    
                }
                
                let is_vis = (cond_data.def_vis == 'shown') ? true : false;
                let cond_responses = [];
                
                $.each(cond_data.conds, function(i, cond) {
                    update_form_f_val(cond.field, $form, user_vals);
                    
                    let condition_satisfied = 0;
                    
                    // multi-choices - no selection case
                    if(!user_vals[ cond.field ].length && cond.operator == 'is_equal' && cond.val === '') {
                        condition_satisfied = 1;          
                    }

                    else {
                        $.each(user_vals[ cond.field ], function(i, f_val) {
                            if(
                                (cond.operator == 'is_equal' && f_val == cond.val) || 
                                (cond.operator == 'is_different' && f_val != cond.val) ||
                                (cond.val !== '' && cond.operator == 'contains' && f_val.toLowerCase().indexOf(cond.val) !== -1) ||
                                (cond.val !== '' && cond.operator == 'not_contain' && f_val.toLowerCase().indexOf(cond.val) === -1) ||
                                (cond.val !== '' && cond.operator == 'bigger' && parseFloat(f_val) > parseFloat(cond.val)) ||
                                (cond.val !== '' && cond.operator == 'smaller' && parseFloat(f_val) < parseFloat(cond.val))
                            ) {
                                condition_satisfied = 1;    
                            }   
                        });
                    }
                    
                    cond_responses.push(condition_satisfied);
                    
                    // if satisfied and OR condition, stop here
                    if(condition_satisfied && cond_data.main_cond == 'OR') {
                        return false;    
                    }
                });
                
                
                // iterate and return the final response
                if(cond_data.main_cond == 'OR') {
                    is_vis = ($.inArray(1, cond_responses) !== -1) ? !is_vis : is_vis;   
                } else {
                    is_vis = ($.inArray(0, cond_responses) !== -1) ? is_vis : !is_vis;       
                }

                const $f_wrap = $form.find('[data-fname="'+ f_id +'"]');
                (is_vis) ? $f_wrap.removeClass('pcud_cond_f_hidden') : $f_wrap.addClass('pcud_cond_f_hidden');
                
                // empty the field if is hidden
            });
        }, timing);
    };
    
    $(document).on('input keyup', '.pcud_cond_var_f input, .pcud_cond_var_f textarea', (e) => {window.pcud_cond_f_check(e);});
    $(document).on('click', '.pcud_cond_var_f .lcs_wrap', (e) => {window.pcud_cond_f_check(e);});
    $(document).on('change', '.pcud_cond_var_f select', (e) => {window.pcud_cond_f_check(e);});
    
    
    
    // empty hidden form fields before data handle
    $(window).on('pc_pre_form_submit pcud_pre_form_submit', function(e, $form) {
        $form.find('.pcud_cond_f_hidden').each(function() {
            const $f_wrap = $(this);
            
            $f_wrap.find('input, textarea').not('[type="checkbox"]').val('');
                    
            $f_wrap.find('input[type="checkbox"]').each(function() {
                this.checked = false;
                lcs_update(this);
            });

            if($f_wrap.find('select').length) {
                $f_wrap.find('select option').removeAttr('selected');

                const resyncEvent = new Event('lc-select-refresh');
                $f_wrap.find('select')[0].dispatchEvent(resyncEvent);
            }
        });   
    });
    
    
    
        
    // get form field value (as array, also for single fields)
    const update_form_f_val = function(field_id, $form, user_vals) {
        if(typeof(user_vals[field_id]) == 'undefined') {
            user_vals[field_id] = [''];       
        }
        
        if(!$form.find('[name="'+ field_id +'"]').length && !$form.find('[name="'+ field_id +'[]"]').length) {
            if(typeof(user_vals[field_id]) != 'object') {
                user_vals[field_id] = [ user_vals[field_id] ];
            }
            return true;
        }
        const $subj = (!$form.find('[name="'+ field_id +'"]').length) ? $form.find('[name="'+ field_id +'[]"]') : $form.find('[name="'+ field_id +'"]'); 

        let val = [];
        $subj.each(function() {
            if($(this).is('input') && ($(this).attr('type') == 'checkbox' || $(this).attr('type') == 'radio')) {
                if(this.checked) {
                    val.push( $(this).attr('value') );    
                }
            }
            else {
                val.push( $(this).val() );        
            }
        });
        
        user_vals[field_id] = val;
    };
    
    
    

    
    // data-update form submit (or form page progress)
    $(document).on('submit', '.pc_custom_form', async function(e) {
        e.preventDefault();

        const $form = $(this),
              form_id = $form.data('form-id');
        
        // already acting?
        if($form.find('.pc_spinner_btn').length) {
            return false;    
        }
        
        // needs to simply go to next page?
        if($form.find('.pc_pag_next:not(.pc_pag_btn_hidden)').length) {
            $form.find('.pc_pag_next:not(.pc_pag_btn_hidden)').click();
            return false;
        }
        
        // maintain textarea line breaks
        $form.find('textarea').each(function() {
            $(this).val( $(this).val().replace(/\r\n|\r|\n/gi, "<br />") );
        });
        
        // HTML5 validate first
        if(!$form.pc_validate_form_fieldset()) {
            $("body, html").animate({
                scrollTop: ($form.find('fieldset').not('.pc_hidden_fieldset').find('.pc_field_error').first().offset().top - 50)
            }, 500);

            return false;	
        }

        // restore textarea values
        $form.find('textarea').each(function() {
            $(this).val( $(this).val().replace(/<br \/>/gi,"\n") );
        });

        
        $(window).trigger('pcud_pre_form_submit', [$form]);

        $form.find('.pc_custom_form_btn').addClass('pc_spinner_btn');
        $form.find('.pc_custom_form_message').empty();

        let f_data = new FormData($form[0]);
        f_data.append('action', 'pcud_custom_form_submit');
        f_data.append('pcud_fid', form_id);
        
        return await fetch(
            pc_vars.ajax_url,
            {
                method      : 'POST',
                credentials : 'same-origin',
                keepalive   : false,
                body        : f_data,
            }
        )
        .then(async response => {
            if(!response.ok) {
                return Promise.reject(response);
            }
            const pc_data = await response.json().catch(e => {
                e.status = 500;
                return Promise.reject(e);
            });
            
            // success
            if(pc_data.resp == 'success') {
                    
                // trigger action to allow custom events - passes target form object, form_id and the ajax response object
                $(window).trigger('pcud_data_upd_form_saved', [$form, pc_data.fid, pc_data]);

                $form.find('.pc_custom_form_message').empty().append('<span class="pc_success_mess">' + pc_data.mess + '</span>');

                // redirect
                if(typeof(pc_data.redirect) != 'undefined' && pc_data.redirect) {
                    setTimeout(function() {
                      (pc_data.redirect == 'refresh') ? window.location.reload() : window.location.href = pc_data.redirect;
                    }, 1000);		
                }

                // GA4 analytics event
                if(typeof(window.pc_ga4_event) == 'function') {
                    window.pc_ga4_event('pc_user_data_updated');
                }
            }
            
            // error
            else {
                $form.find('.pc_custom_form_message').empty().append('<span class="pc_error_mess">' + pc_data.mess + '</span>');
            }
        })
        .catch(e => {
            if(e.status) {
                console.error(e);
                $form.find('.pc_custom_form_message').empty().append('<span class="pc_error_mess">' + pc_vars.ajax_failed_mess + '</span>');
            }
            return false;
        })
        .finally(() => {
            // a bit of delay to hide the loader
            setTimeout(function() {
                $form.find('.pc_custom_form_btn').removeClass('pc_spinner_btn');
            }, 370);  
        });
    });


})(jQuery);